/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntUnaryOperator;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.ProcessorUtils;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.util.thread.ThreadPoolBudget;

@ManagedObject(value="Manager of the NIO Selectors")
public abstract class SelectorManager
extends ContainerLifeCycle
implements Dumpable {
    public static final int DEFAULT_CONNECT_TIMEOUT = 15000;
    protected static final Logger LOG = Log.getLogger(SelectorManager.class);
    private final Executor executor;
    private final Scheduler scheduler;
    private final ManagedSelector[] _selectors;
    private final AtomicInteger _selectorIndex = new AtomicInteger();
    private final IntUnaryOperator _selectorIndexUpdate;
    private final List<AcceptListener> _acceptListeners = new ArrayList<AcceptListener>();
    private long _connectTimeout = 15000L;
    private ThreadPoolBudget.Lease _lease;

    /*
     * WARNING - void declaration
     */
    private static int defaultSelectors(Executor executor) {
        if (executor instanceof ThreadPool.SizedThreadPool) {
            void var0_1;
            void var1_2;
            int threads = ((ThreadPool.SizedThreadPool)executor).getMaxThreads();
            int cpus = ProcessorUtils.availableProcessors();
            return Math.max(1, Math.min((int)(var1_2 / 2), (int)(var0_1 / 16)));
        }
        return Math.max(1, ProcessorUtils.availableProcessors() / 2);
    }

    /*
     * WARNING - void declaration
     */
    protected SelectorManager(Executor executor, Scheduler scheduler) {
        this((Executor)var1_1, (Scheduler)var2_2, -1);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SelectorManager(Executor executor, Scheduler scheduler, int selectors) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (selectors <= 0) {
            selectors = SelectorManager.defaultSelectors(executor);
        }
        this.executor = var1_1;
        this.scheduler = var2_2;
        this._selectors = new ManagedSelector[var3_3];
        this._selectorIndexUpdate = index -> (index + 1) % this._selectors.length;
    }

    @ManagedAttribute(value="The Executor")
    public Executor getExecutor() {
        return this.executor;
    }

    @ManagedAttribute(value="The Scheduler")
    public Scheduler getScheduler() {
        return this.scheduler;
    }

    @ManagedAttribute(value="The Connection timeout (ms)")
    public long getConnectTimeout() {
        return this._connectTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectTimeout(long milliseconds) {
        void var1_1;
        this._connectTimeout = var1_1;
    }

    @Deprecated
    public int getReservedThreads() {
        return -1;
    }

    @Deprecated
    public void setReservedThreads(int threads) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(Runnable task) {
        void var1_1;
        this.executor.execute((Runnable)var1_1);
    }

    @ManagedAttribute(value="The number of NIO Selectors")
    public int getSelectorCount() {
        return this._selectors.length;
    }

    private ManagedSelector chooseSelector() {
        return this._selectors[this._selectorIndex.updateAndGet(this._selectorIndexUpdate)];
    }

    /*
     * WARNING - void declaration
     */
    public void connect(SelectableChannel channel, Object attachment) {
        void var2_2;
        void var1_1;
        void var3_3;
        ManagedSelector set = this.chooseSelector();
        void v0 = var3_3;
        Objects.requireNonNull(v0);
        set.submit(new ManagedSelector.Connect((ManagedSelector)v0, (SelectableChannel)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public void accept(SelectableChannel channel) {
        void var1_1;
        this.accept((SelectableChannel)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    public void accept(SelectableChannel channel, Object attachment) {
        void var2_2;
        void var1_1;
        void var3_3;
        ManagedSelector selector = this.chooseSelector();
        void v0 = var3_3;
        Objects.requireNonNull(v0);
        selector.submit(new ManagedSelector.Accept((ManagedSelector)v0, (SelectableChannel)var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public Closeable acceptor(SelectableChannel server) {
        void var1_1;
        void var2_2;
        ManagedSelector selector;
        ManagedSelector managedSelector = selector = this.chooseSelector();
        Objects.requireNonNull(managedSelector);
        ManagedSelector.Acceptor acceptor = new ManagedSelector.Acceptor(managedSelector, server);
        var2_2.submit(acceptor);
        return var1_1;
    }

    protected void accepted(SelectableChannel channel) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        SelectorManager selectorManager = this;
        this._lease = ThreadPoolBudget.leaseFrom((Executor)this.getExecutor(), (Object)((Object)selectorManager), (int)selectorManager._selectors.length);
        for (int i = 0; i < this._selectors.length; ++i) {
            void var2_2;
            ManagedSelector selector;
            this._selectors[i] = selector = this.newSelector(i);
            this.addBean(var2_2);
        }
        super.doStart();
    }

    /*
     * WARNING - void declaration
     */
    protected ManagedSelector newSelector(int id) {
        void var1_1;
        return new ManagedSelector(this, (int)var1_1);
    }

    protected void doStop() throws Exception {
        ManagedSelector[] managedSelectorArray;
        try {
            super.doStop();
            managedSelectorArray = this._selectors;
        }
        catch (Throwable throwable) {
            ManagedSelector[] managedSelectorArray2 = this._selectors;
            int n = this._selectors.length;
            for (int i = 0; i < n; ++i) {
                ManagedSelector selector = managedSelectorArray2[i];
                if (selector == null) continue;
                this.removeBean((Object)selector);
            }
            Arrays.fill((Object[])this._selectors, null);
            if (this._lease != null) {
                this._lease.close();
            }
            throw throwable;
        }
        int n = this._selectors.length;
        for (int i = 0; i < n; ++i) {
            ManagedSelector selector = managedSelectorArray[i];
            if (selector == null) continue;
            this.removeBean((Object)selector);
        }
        Arrays.fill((Object[])this._selectors, null);
        if (this._lease != null) {
            this._lease.close();
            return;
        }
    }

    protected void endPointOpened(EndPoint endpoint) {
    }

    protected void endPointClosed(EndPoint endpoint) {
    }

    /*
     * WARNING - void declaration
     */
    public void connectionOpened(Connection connection) {
        try {
            connection.onOpen();
            return;
        }
        catch (Throwable x) {
            void var2_2;
            if (this.isRunning()) {
                LOG.warn("Exception while notifying connection " + connection, x);
            } else {
                void var1_1;
                LOG.debug("Exception while notifying connection " + var1_1, x);
            }
            throw var2_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void connectionClosed(Connection connection) {
        try {
            connection.onClose();
            return;
        }
        catch (Throwable x) {
            void var2_2;
            void var1_1;
            LOG.debug("Exception while notifying connection " + var1_1, (Throwable)var2_2);
            return;
        }
    }

    protected boolean doFinishConnect(SelectableChannel channel) throws IOException {
        return ((SocketChannel)channel).finishConnect();
    }

    protected boolean isConnectionPending(SelectableChannel channel) {
        return ((SocketChannel)channel).isConnectionPending();
    }

    protected SelectableChannel doAccept(SelectableChannel server) throws IOException {
        return ((ServerSocketChannel)server).accept();
    }

    /*
     * WARNING - void declaration
     */
    protected void connectionFailed(SelectableChannel channel, Throwable ex, Object attachment) {
        void var2_2;
        void var3_3;
        void var1_1;
        LOG.warn(String.format("%s - %s", var1_1, var3_3), (Throwable)var2_2);
    }

    protected Selector newSelector() throws IOException {
        return Selector.open();
    }

    protected abstract EndPoint newEndPoint(SelectableChannel var1, ManagedSelector var2, SelectionKey var3) throws IOException;

    public abstract Connection newConnection(SelectableChannel var1, EndPoint var2, Object var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    public void addEventListener(EventListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.toString());
        }
        if (listener instanceof AcceptListener) {
            void var1_1;
            this.addAcceptListener((AcceptListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeEventListener(EventListener listener) {
        if (this.isRunning()) {
            throw new IllegalStateException(this.toString());
        }
        if (listener instanceof AcceptListener) {
            void var1_1;
            this.removeAcceptListener((AcceptListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void addAcceptListener(AcceptListener listener) {
        if (!this._acceptListeners.contains(listener)) {
            void var1_1;
            this._acceptListeners.add((AcceptListener)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeAcceptListener(AcceptListener listener) {
        void var1_1;
        this._acceptListeners.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onAccepting(SelectableChannel channel) {
        for (AcceptListener l : this._acceptListeners) {
            try {
                l.onAccepting(channel);
            }
            catch (Throwable x) {
                void var3_4;
                LOG.warn((Throwable)var3_4);
            }
        }
    }

    protected void onAcceptFailed(SelectableChannel channel, Throwable cause) {
        for (AcceptListener l : this._acceptListeners) {
            try {
                l.onAcceptFailed(channel, cause);
            }
            catch (Throwable x) {
                LOG.warn(x);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onAccepted(SelectableChannel channel) {
        for (AcceptListener l : this._acceptListeners) {
            try {
                l.onAccepted(channel);
            }
            catch (Throwable x) {
                void var3_4;
                LOG.warn((Throwable)var3_4);
            }
        }
    }

    public static interface AcceptListener
    extends EventListener {
        default public void onAccepting(SelectableChannel channel) {
        }

        default public void onAcceptFailed(SelectableChannel channel, Throwable cause) {
        }

        default public void onAccepted(SelectableChannel channel) {
        }
    }
}

