/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Retainable;

public class RetainableByteBuffer
implements Retainable {
    private final ByteBufferPool pool;
    private final ByteBuffer buffer;
    private final AtomicInteger references;

    /*
     * WARNING - void declaration
     */
    public RetainableByteBuffer(ByteBufferPool pool, int size) {
        this((ByteBufferPool)var1_1, (int)var2_2, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RetainableByteBuffer(ByteBufferPool pool, int size, boolean direct) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.pool = pool;
        this.buffer = var1_1.acquire((int)var2_2, (boolean)var3_3);
        this.references = new AtomicInteger(1);
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }

    public int getReferences() {
        return this.references.get();
    }

    /*
     * WARNING - void declaration
     */
    public void retain() {
        void v0;
        do {
            void var1_1;
            int r;
            if ((r = this.references.get()) == 0) {
                throw new IllegalStateException("released " + this);
            }
            v0 = var1_1;
        } while (!this.references.compareAndSet((int)v0, (int)(v0 + true)));
    }

    /*
     * WARNING - void declaration
     */
    public int release() {
        void var1_1;
        int ref = this.references.decrementAndGet();
        if (ref == 0) {
            this.pool.release(this.buffer);
        } else if (ref < 0) {
            throw new IllegalStateException("already released " + this);
        }
        return (int)var1_1;
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public boolean isEmpty() {
        return !this.hasRemaining();
    }

    public void clear() {
        BufferUtil.clear((ByteBuffer)this.buffer);
    }

    public String toString() {
        return String.format("%s@%x{%s,r=%d}", this.getClass().getSimpleName(), this.hashCode(), BufferUtil.toDetailString((ByteBuffer)this.buffer), this.getReferences());
    }
}

