/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.List;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.NetworkTrafficListener;
import org.eclipse.jetty.io.SocketChannelEndPoint;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public class NetworkTrafficSocketChannelEndPoint
extends SocketChannelEndPoint {
    private static final Logger LOG = Log.getLogger(NetworkTrafficSocketChannelEndPoint.class);
    private final List<NetworkTrafficListener> listeners;

    /*
     * WARNING - void declaration
     */
    public NetworkTrafficSocketChannelEndPoint(SelectableChannel channel, ManagedSelector selectSet, SelectionKey key, Scheduler scheduler, long idleTimeout, List<NetworkTrafficListener> listeners) {
        super((SelectableChannel)var1_1, (ManagedSelector)var2_2, (SelectionKey)var3_3, scheduler);
        void var3_3;
        void var2_2;
        void var1_1;
        this.setIdleTimeout(idleTimeout);
        this.listeners = listeners;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        void var2_2;
        void var1_1;
        int read = super.fill(buffer);
        this.notifyIncoming((ByteBuffer)var1_1, read);
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        void var2_2;
        void var1_1;
        boolean flushed = true;
        for (void b : var1_1) {
            if (!b.hasRemaining()) continue;
            int position = b.position();
            ByteBuffer view = b.slice();
            flushed = super.flush(new ByteBuffer[]{b});
            int l = b.position() - position;
            ByteBuffer byteBuffer = view;
            byteBuffer.limit(byteBuffer.position() + l);
            this.notifyOutgoing(view);
            if (!flushed) break;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onOpen() {
        super.onOpen();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    listener.opened(this.getSocket());
                }
                catch (Exception x) {
                    void var2_3;
                    LOG.warn((Throwable)var2_3);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onClose() {
        super.onClose();
        if (this.listeners != null && !this.listeners.isEmpty()) {
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    listener.closed(this.getSocket());
                }
                catch (Exception x) {
                    void var2_3;
                    LOG.warn((Throwable)var2_3);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void notifyIncoming(ByteBuffer buffer, int read) {
        void var2_2;
        if (this.listeners != null && !this.listeners.isEmpty() && var2_2 > 0) {
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    void var3_4;
                    ByteBuffer view = buffer.asReadOnlyBuffer();
                    var3_4.incoming(this.getSocket(), view);
                }
                catch (Exception x) {
                    LOG.warn((Throwable)x);
                }
            }
        }
    }

    public void notifyOutgoing(ByteBuffer view) {
        if (this.listeners != null && !this.listeners.isEmpty() && view.hasRemaining()) {
            Socket socket = this.getSocket();
            for (NetworkTrafficListener listener : this.listeners) {
                try {
                    listener.outgoing(socket, view);
                }
                catch (Exception x) {
                    LOG.warn((Throwable)x);
                }
            }
        }
    }
}

