/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class NegotiatingClientConnection
extends AbstractConnection {
    private static final Logger LOG = Log.getLogger(NegotiatingClientConnection.class);
    private final SSLEngine engine;
    private final ClientConnectionFactory connectionFactory;
    private final Map<String, Object> context;
    private volatile boolean completed;

    /*
     * WARNING - void declaration
     */
    protected NegotiatingClientConnection(EndPoint endp, Executor executor, SSLEngine sslEngine, ClientConnectionFactory connectionFactory, Map<String, Object> context) {
        super((EndPoint)var1_1, (Executor)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.engine = var3_3;
        this.connectionFactory = connectionFactory;
        this.context = context;
    }

    public SSLEngine getSSLEngine() {
        return this.engine;
    }

    protected void completed() {
        this.completed = true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onOpen() {
        super.onOpen();
        try {
            this.getEndPoint().flush(BufferUtil.EMPTY_BUFFER);
            if (!this.completed) {
                this.fillInterested();
                return;
            }
            this.replaceConnection();
        }
        catch (IOException x) {
            void var1_1;
            ((AbstractConnection)this).close();
            throw new RuntimeIOException((Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onFillable() {
        void var1_1;
        do {
            int filled = this.fill();
            if (!this.completed && filled >= 0) continue;
            this.replaceConnection();
            return;
        } while (var1_1 != false);
        this.fillInterested();
    }

    /*
     * WARNING - void declaration
     */
    private int fill() {
        try {
            return this.getEndPoint().fill(BufferUtil.EMPTY_BUFFER);
        }
        catch (IOException x) {
            void var1_1;
            LOG.debug((Throwable)var1_1);
            ((AbstractConnection)this).close();
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void replaceConnection() {
        EndPoint endPoint = this.getEndPoint();
        try {
            endPoint.upgrade(this.connectionFactory.newConnection(endPoint, this.context));
            return;
        }
        catch (Throwable x) {
            void var1_2;
            LOG.debug((Throwable)var1_2);
            ((AbstractConnection)this).close();
            return;
        }
    }

    @Override
    public void close() {
        this.getEndPoint().shutdownOutput();
        super.close();
    }
}

