/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import org.eclipse.jetty.io.AbstractByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class MappedByteBufferPool
extends AbstractByteBufferPool
implements Dumpable {
    private static final Logger LOG = Log.getLogger(MappedByteBufferPool.class);
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _directBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final ConcurrentMap<Integer, ByteBufferPool.Bucket> _heapBuffers = new ConcurrentHashMap<Integer, ByteBufferPool.Bucket>();
    private final Function<Integer, ByteBufferPool.Bucket> _newBucket;
    private boolean _detailedDump = false;

    public MappedByteBufferPool() {
        this(-1);
    }

    /*
     * WARNING - void declaration
     */
    public MappedByteBufferPool(int factor) {
        this((int)var1_1, -1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MappedByteBufferPool(int factor, int maxQueueLength) {
        this((int)var1_1, (int)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MappedByteBufferPool(int factor, int maxQueueLength, Function<Integer, ByteBufferPool.Bucket> newBucket) {
        this((int)var1_1, (int)var2_2, (Function<Integer, ByteBufferPool.Bucket>)var3_3, 0L, 0L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MappedByteBufferPool(int factor, int maxQueueLength, Function<Integer, ByteBufferPool.Bucket> newBucket, long maxHeapMemory, long maxDirectMemory) {
        super((int)var1_1, (int)var2_2, maxHeapMemory, maxDirectMemory);
        void var3_3;
        void var2_2;
        void var1_1;
        this._newBucket = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private ByteBufferPool.Bucket newBucket(int key, boolean direct) {
        void var2_2;
        void var1_1;
        if (this._newBucket != null) {
            return this._newBucket.apply(key);
        }
        MappedByteBufferPool mappedByteBufferPool = this;
        return new ByteBufferPool.Bucket(mappedByteBufferPool, mappedByteBufferPool.capacityFor((int)var1_1), this.getMaxQueueLength(), this.updateMemory((boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        void var1_2;
        int b = this.bucketFor(size);
        int capacity = this.capacityFor(b);
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(direct);
        ByteBufferPool.Bucket bucket = (ByteBufferPool.Bucket)concurrentMap.get(b);
        if (bucket == null) {
            return this.newByteBuffer(capacity, direct);
        }
        ByteBuffer buffer = bucket.acquire();
        if (buffer == null) {
            void var2_3;
            void var3_4;
            return this.newByteBuffer((int)var3_4, (boolean)var2_3);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void release(ByteBuffer buffer) {
        void var2_2;
        void var1_1;
        void var3_3;
        int b;
        if (buffer == null) {
            return;
        }
        int capacity = buffer.capacity();
        if (capacity != this.capacityFor(b = this.bucketFor(capacity))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer)});
            }
            return;
        }
        boolean direct = buffer.isDirect();
        ConcurrentMap<Integer, ByteBufferPool.Bucket> concurrentMap = this.bucketsFor(direct);
        ByteBufferPool.Bucket bucket = concurrentMap.computeIfAbsent((int)var3_3, i -> {
            void var1_1;
            void var2_2;
            return this.newBucket(var2_2.intValue(), (boolean)var1_1);
        });
        bucket.release((ByteBuffer)var1_1);
        this.releaseExcessMemory((boolean)var2_2, this::releaseMemory);
    }

    @Override
    public void clear() {
        super.clear();
        this._directBuffers.values().forEach(ByteBufferPool.Bucket::clear);
        this._directBuffers.clear();
        this._heapBuffers.values().forEach(ByteBufferPool.Bucket::clear);
        this._heapBuffers.clear();
    }

    /*
     * WARNING - void declaration
     */
    protected void releaseMemory(boolean direct) {
        void var1_2;
        ByteBufferPool.Bucket bucket;
        long oldest = Long.MAX_VALUE;
        int index = -1;
        ConcurrentMap<Integer, ByteBufferPool.Bucket> buckets = this.bucketsFor(direct);
        for (Map.Entry entry : buckets.entrySet()) {
            long lastUpdate;
            ByteBufferPool.Bucket bucket2 = (ByteBufferPool.Bucket)entry.getValue();
            if (bucket2.isEmpty() || (lastUpdate = bucket2.getLastUpdate()) >= oldest) continue;
            oldest = lastUpdate;
            index = (Integer)entry.getKey();
        }
        if (index >= 0 && (bucket = (ByteBufferPool.Bucket)var1_2.remove(index)) != null) {
            bucket.clear();
        }
    }

    protected int bucketFor(int capacity) {
        return (int)Math.ceil((double)capacity / (double)this.getCapacityFactor());
    }

    protected int capacityFor(int bucket) {
        return bucket * this.getCapacityFactor();
    }

    @ManagedAttribute(value="The number of pooled direct ByteBuffers")
    public long getDirectByteBufferCount() {
        return this.getByteBufferCount(true);
    }

    @ManagedAttribute(value="The number of pooled heap ByteBuffers")
    public long getHeapByteBufferCount() {
        return this.getByteBufferCount(false);
    }

    /*
     * WARNING - void declaration
     */
    private long getByteBufferCount(boolean direct) {
        void var1_1;
        return this.bucketsFor((boolean)var1_1).values().stream().mapToLong(ByteBufferPool.Bucket::size).sum();
    }

    ConcurrentMap<Integer, ByteBufferPool.Bucket> bucketsFor(boolean direct) {
        if (direct) {
            return this._directBuffers;
        }
        return this._heapBuffers;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    /*
     * WARNING - void declaration
     */
    public void setDetailedDump(boolean detailedDump) {
        void var1_1;
        this._detailedDump = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ArrayList<String> dump = new ArrayList<String>();
        dump.add(String.format("HeapMemory: %d/%d", this.getHeapMemory(), this.getMaxHeapMemory()));
        dump.add(String.format("DirectMemory: %d/%d", this.getDirectMemory(), this.getMaxDirectMemory()));
        if (this.isDetailedDump()) {
            dump.add((String)new DumpableCollection("Indirect Buckets", this._heapBuffers.values()));
            dump.add((String)new DumpableCollection("Direct Buckets", this._directBuffers.values()));
        } else {
            dump.add("Indirect Buckets size=" + this._heapBuffers.size());
            dump.add("Direct Buckets size=" + this._directBuffers.size());
        }
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, (Object)this, (Object[])new Object[]{var3_3});
    }

    public String toString() {
        return String.format("%s@%x{maxQueueLength=%s, factor=%s}", this.getClass().getSimpleName(), this.hashCode(), this.getMaxQueueLength(), this.getCapacityFactor());
    }

    public static class Tagged
    extends MappedByteBufferPool {
        private final AtomicInteger tag = new AtomicInteger();

        /*
         * WARNING - void declaration
         */
        @Override
        public ByteBuffer newByteBuffer(int capacity, boolean direct) {
            void var1_2;
            void var2_3;
            ByteBuffer buffer = super.newByteBuffer(capacity + 4, (boolean)var2_3);
            buffer.limit(buffer.capacity());
            buffer.putInt(this.tag.incrementAndGet());
            ByteBuffer slice = buffer.slice();
            BufferUtil.clear((ByteBuffer)slice);
            return var1_2;
        }
    }
}

