/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.statistic.SampleStatistic;
import org.eclipse.jetty.util.thread.ExecutionStrategy;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.strategy.EatWhatYouKill;

public class ManagedSelector
extends ContainerLifeCycle
implements Dumpable {
    private static final Logger LOG;
    private static final boolean FORCE_SELECT_NOW;
    private final AtomicBoolean _started = new AtomicBoolean(false);
    private boolean _selecting;
    private final SelectorManager _selectorManager;
    private final int _id;
    private final ExecutionStrategy _strategy;
    private Selector _selector;
    private Deque<SelectorUpdate> _updates = new ArrayDeque<SelectorUpdate>();
    private Deque<SelectorUpdate> _updateable = new ArrayDeque<SelectorUpdate>();
    private final SampleStatistic _keyStats = new SampleStatistic();

    /*
     * WARNING - void declaration
     */
    public ManagedSelector(SelectorManager selectorManager, int id) {
        void var1_1;
        void var2_3;
        this._selectorManager = selectorManager;
        this._id = id;
        SelectorProducer producer = new SelectorProducer();
        Executor executor = selectorManager.getExecutor();
        this._strategy = new EatWhatYouKill((ExecutionStrategy.Producer)var2_3, (Executor)var1_1);
        ManagedSelector managedSelector = this;
        managedSelector.addBean(managedSelector._strategy, true);
        this.setStopTimeout(5000L);
    }

    public Selector getSelector() {
        return this._selector;
    }

    /*
     * WARNING - void declaration
     */
    protected void doStart() throws Exception {
        void var1_1;
        super.doStart();
        this._selector = this._selectorManager.newSelector();
        this._selectorManager.execute(() -> ((ExecutionStrategy)this._strategy).produce());
        Start start = new Start();
        this.submit(start);
        ((Start)var1_1)._started.await();
    }

    /*
     * WARNING - void declaration
     */
    protected void doStop() throws Exception {
        if (this._started.compareAndSet(true, false) && this._selector != null) {
            void var1_1;
            CloseConnections closeConnections = new CloseConnections();
            this.submit(closeConnections);
            closeConnections._complete.await();
            StopSelector stopSelector = new StopSelector();
            this.submit(stopSelector);
            ((StopSelector)var1_1)._stopped.await();
        }
        super.doStop();
    }

    @ManagedAttribute(value="Total number of keys", readonly=true)
    public int getTotalKeys() {
        return this._selector.keys().size();
    }

    @ManagedAttribute(value="Average number of selected keys", readonly=true)
    public double getAverageSelectedKeys() {
        return this._keyStats.getMean();
    }

    @ManagedAttribute(value="Maximum number of selected keys", readonly=true)
    public double getMaxSelectedKeys() {
        return this._keyStats.getMax();
    }

    @ManagedAttribute(value="Total number of select() calls", readonly=true)
    public long getSelectCount() {
        return this._keyStats.getCount();
    }

    @ManagedOperation(value="Resets the statistics", impact="ACTION")
    public void resetStats() {
        this._keyStats.reset();
    }

    /*
     * WARNING - void declaration
     */
    protected int nioSelect(Selector selector, boolean now) throws IOException {
        void var1_1;
        if (now) {
            return selector.selectNow();
        }
        return var1_1.select();
    }

    /*
     * WARNING - void declaration
     */
    protected int select(Selector selector) throws IOException {
        try {
            int selected = this.nioSelect(selector, false);
            if (selected == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selector {} woken with none selected", new Object[]{selector});
                }
                if (Thread.interrupted() && !this.isRunning()) {
                    throw new ClosedSelectorException();
                }
                if (FORCE_SELECT_NOW) {
                    selected = this.nioSelect(selector, true);
                }
            }
            return selected;
        }
        catch (ClosedSelectorException closedSelectorException) {
            ClosedSelectorException selected = closedSelectorException;
            throw closedSelectorException;
        }
        catch (Throwable x) {
            void var2_4;
            void var1_1;
            this.handleSelectFailure((Selector)var1_1, (Throwable)var2_4);
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void handleSelectFailure(Selector selector, Throwable failure) throws IOException {
        void var2_2;
        void var1_1;
        LOG.info("Caught select() failure, trying to recover: {}", new Object[]{failure.toString()});
        if (LOG.isDebugEnabled()) {
            LOG.debug(failure);
        }
        Selector newSelector = this._selectorManager.newSelector();
        for (SelectionKey oldKey : selector.keys()) {
            SelectableChannel channel = oldKey.channel();
            int interestOps = ManagedSelector.safeInterestOps(oldKey);
            if (interestOps >= 0) {
                try {
                    Object attachment = oldKey.attachment();
                    SelectionKey newKey = channel.register(newSelector, interestOps, attachment);
                    if (attachment instanceof Selectable) {
                        ((Selectable)attachment).replaceKey(newKey);
                    }
                    oldKey.cancel();
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("Transferred {} iOps={} att={}", new Object[]{channel, interestOps, attachment});
                }
                catch (Throwable t) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not transfer {}", new Object[]{channel, t});
                    }
                    IO.close((Closeable)channel);
                }
                continue;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invalid interestOps for {}", new Object[]{channel});
            }
            IO.close((Closeable)channel);
        }
        IO.close((Closeable)var1_1);
        this._selector = var2_2;
    }

    protected void onSelectFailed(Throwable cause) {
    }

    /*
     * WARNING - void declaration
     */
    public int size() {
        void var1_1;
        Selector s = this._selector;
        if (s == null) {
            return 0;
        }
        Set<SelectionKey> keys = s.keys();
        if (keys == null) {
            return 0;
        }
        return var1_1.size();
    }

    /*
     * WARNING - void declaration
     */
    public void submit(SelectorUpdate update) {
        void var1_1;
        this.submit((SelectorUpdate)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    private void submit(SelectorUpdate update, boolean lazy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Queued change lazy={} {} on {}", new Object[]{lazy, update, this});
        }
        Selector selector = null;
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            void var2_3;
            void var1_1;
            this._updates.offer((SelectorUpdate)var1_1);
            if (this._selecting && var2_3 == false) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            void var3_4;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Wakeup on submit {}", new Object[]{this});
            }
            var3_4.wakeup();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void wakeup() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Wakeup {}", new Object[]{this});
        }
        Selector selector = null;
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            if (this._selecting) {
                selector = this._selector;
                this._selecting = false;
            }
        }
        if (selector != null) {
            void var1_1;
            var1_1.wakeup();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void execute(Runnable task) {
        try {
            this._selectorManager.execute(task);
            return;
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (task instanceof Closeable) {
                void var1_1;
                IO.close((Closeable)((Closeable)var1_1));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void processConnect(SelectionKey key, Connect connect) {
        SelectableChannel channel = key.channel();
        try {
            void var1_1;
            key.attach(connect.attachment);
            boolean connected = this._selectorManager.doFinishConnect(channel);
            if (LOG.isDebugEnabled()) {
                void var3_3;
                LOG.debug("Connected {} {}", new Object[]{connected, var3_3});
            }
            if (connected) {
                if (!connect.timeout.cancel()) {
                    throw new SocketTimeoutException("Concurrent Connect Timeout");
                }
            } else {
                throw new ConnectException();
            }
            key.interestOps(0);
            this.execute(new CreateEndPoint(connect, (SelectionKey)var1_1));
        }
        catch (Throwable x) {
            void var2_2;
            var2_2.failed(x);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void endPointOpened(EndPoint endPoint) {
        void var1_1;
        this._selectorManager.endPointOpened((EndPoint)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void endPointClosed(EndPoint endPoint) {
        void var1_1;
        this._selectorManager.endPointClosed((EndPoint)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void createEndPoint(SelectableChannel channel, SelectionKey selectionKey) throws IOException {
        void var1_1;
        void var2_2;
        EndPoint endPoint = this._selectorManager.newEndPoint(channel, this, selectionKey);
        Connection connection = this._selectorManager.newConnection(channel, endPoint, selectionKey.attachment());
        endPoint.setConnection(connection);
        this.submit(arg_0 -> ManagedSelector.lambda$createEndPoint$0((SelectionKey)var2_2, (SelectableChannel)var1_1, endPoint, arg_0), true);
        endPoint.onOpen();
        this.endPointOpened(endPoint);
        this._selectorManager.connectionOpened(connection);
        if (LOG.isDebugEnabled()) {
            void var3_3;
            LOG.debug("Created {}", new Object[]{var3_3});
        }
    }

    /*
     * WARNING - void declaration
     */
    void destroyEndPoint(EndPoint endPoint) {
        void var1_1;
        this.wakeup();
        this.execute(new DestroyEndPoint((EndPoint)var1_1));
    }

    private int getActionSize() {
        ManagedSelector managedSelector = this;
        synchronized (managedSelector) {
            return this._updates.size();
        }
    }

    /*
     * WARNING - void declaration
     */
    static int safeReadyOps(SelectionKey selectionKey) {
        try {
            return selectionKey.readyOps();
        }
        catch (Throwable x) {
            void var0_1;
            LOG.ignore((Throwable)var0_1);
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    static int safeInterestOps(SelectionKey selectionKey) {
        try {
            return selectionKey.interestOps();
        }
        catch (Throwable x) {
            void var0_1;
            LOG.ignore((Throwable)var0_1);
            return -1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var2_3;
        void var1_1;
        Selector selector = this._selector;
        if (selector != null && selector.isOpen()) {
            void var3_4;
            ArrayList<SelectorUpdate> updates;
            DumpKeys dump = new DumpKeys();
            String updatesAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now());
            ManagedSelector managedSelector = this;
            synchronized (managedSelector) {
                updates = new ArrayList<SelectorUpdate>(this._updates);
                this._updates.addFirst(dump);
                this._selecting = false;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("wakeup on dump {}", new Object[]{this});
            }
            selector.wakeup();
            List<String> keys = dump.get(5L, TimeUnit.SECONDS);
            String keysAt = DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now());
            if (keys == null) {
                keys = Collections.singletonList("No dump keys retrieved");
            }
            this.dumpObjects(out, indent, new Object[]{new DumpableCollection("updates @ " + updatesAt, updates), new DumpableCollection("keys @ " + keysAt, (Collection)var3_4)});
            return;
        }
        this.dumpObjects((Appendable)var1_1, (String)var2_3, new Object[0]);
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        Selector selector = this._selector;
        return String.format("%s id=%s keys=%d selected=%d updates=%d", super.toString(), this._id, selector != null && selector.isOpen() ? selector.keys().size() : -1, selector != null && selector.isOpen() ? var1_1.selectedKeys().size() : -1, this.getActionSize());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$createEndPoint$0(SelectionKey selectionKey, SelectableChannel channel, EndPoint endPoint, Selector selector) {
        void var3_3;
        void var1_1;
        SelectionKey key = selectionKey;
        if (key.selector() != selector && (key = var1_1.keyFor((Selector)var3_3)) != null && endPoint instanceof Selectable) {
            ((Selectable)((Object)endPoint)).replaceKey(key);
        }
        if (key != null) {
            void var2_2;
            SelectionKey selectionKey2;
            selectionKey2.attach(var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Deque access$1102(ManagedSelector x0, Deque x1) {
        void var1_1;
        x0._updates = var1_1;
        return x0._updates;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Deque access$1202(ManagedSelector x0, Deque x1) {
        void var1_1;
        x0._updateable = var1_1;
        return x0._updateable;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1502(ManagedSelector x0, boolean x1) {
        void var1_1;
        x0._selecting = var1_1;
        return x0._selecting;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Selector access$1402(ManagedSelector x0, Selector x1) {
        void var1_1;
        x0._selector = var1_1;
        return x0._selector;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$1700(ManagedSelector x0, SelectionKey x1, Connect x2) {
        void var2_2;
        void var1_1;
        x0.processConnect((SelectionKey)var1_1, (Connect)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$2000(ManagedSelector x0, Runnable x1) {
        void var1_1;
        x0.execute((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$2100(ManagedSelector x0, SelectableChannel x1, SelectionKey x2) throws IOException {
        void var2_2;
        void var1_1;
        x0.createEndPoint((SelectableChannel)var1_1, (SelectionKey)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0;
        LOG = Log.getLogger(ManagedSelector.class);
        String property = System.getProperty("org.eclipse.jetty.io.forceSelectNow");
        FORCE_SELECT_NOW = property != null ? Boolean.parseBoolean(property) : (property = System.getProperty("os.name")) != null && var0.toLowerCase(Locale.ENGLISH).contains("windows");
    }

    private class DestroyEndPoint
    implements Closeable,
    Runnable {
        private final EndPoint endPoint;

        /*
         * WARNING - void declaration
         */
        public DestroyEndPoint(EndPoint endPoint) {
            void var2_2;
            this.endPoint = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Connection connection;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Destroyed {}", new Object[]{this.endPoint});
            }
            if ((connection = this.endPoint.getConnection()) != null) {
                void var1_1;
                ManagedSelector.this._selectorManager.connectionClosed((Connection)var1_1);
            }
            ManagedSelector.this.endPointClosed(this.endPoint);
        }

        @Override
        public void close() {
            this.run();
        }
    }

    private final class CreateEndPoint
    implements Runnable {
        private final Connect _connect;
        private final SelectionKey _key;

        /*
         * WARNING - void declaration
         */
        private CreateEndPoint(Connect connect, SelectionKey key) {
            void var3_3;
            void var2_2;
            this._connect = var2_2;
            this._key = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            try {
                ManagedSelector.access$2100(ManagedSelector.this, this._connect.channel, this._key);
                return;
            }
            catch (Throwable failure) {
                void var1_1;
                IO.close((Closeable)this._connect.channel);
                LOG.warn(String.valueOf(failure), new Object[0]);
                if (LOG.isDebugEnabled()) {
                    LOG.debug(failure);
                }
                this._connect.failed((Throwable)var1_1);
                return;
            }
        }

        public final String toString() {
            return String.format("CreateEndPoint@%x{%s}", this.hashCode(), this._connect);
        }
    }

    private class StopSelector
    implements SelectorUpdate {
        private final CountDownLatch _stopped = new CountDownLatch(1);

        private StopSelector() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(Selector selector) {
            void var1_1;
            for (SelectionKey key : selector.keys()) {
                void var3_3;
                Object attachment;
                if (key == null || !((attachment = key.attachment()) instanceof Closeable)) continue;
                IO.close((Closeable)((Closeable)var3_3));
            }
            ManagedSelector.access$1402(ManagedSelector.this, null);
            IO.close((Closeable)var1_1);
            this._stopped.countDown();
        }
    }

    private class CloseConnections
    implements SelectorUpdate {
        private final Set<Closeable> _closed;
        private final CountDownLatch _complete = new CountDownLatch(1);

        private CloseConnections() {
            this((Set<Closeable>)null);
        }

        /*
         * WARNING - void declaration
         */
        private CloseConnections(Set<Closeable> closed) {
            void var2_2;
            this._closed = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(Selector selector) {
            Iterator<SelectionKey> iterator;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Closing {} connections on {}", new Object[]{selector.keys().size(), ManagedSelector.this});
            }
            for (SelectionKey key : ((Selector)((Object)iterator)).keys()) {
                void var3_3;
                EndPoint endPoint;
                Connection connection;
                if (key == null || !key.isValid()) continue;
                Object closeable = null;
                Object attachment = key.attachment();
                if (attachment instanceof EndPoint && (connection = (endPoint = (EndPoint)attachment).getConnection()) == null) {
                    void var2_2;
                    var3_3 = var2_2;
                }
                if (var3_3 == null) continue;
                if (this._closed == null) {
                    IO.close((Closeable)var3_3);
                    continue;
                }
                if (this._closed.contains(var3_3)) continue;
                this._closed.add((Closeable)var3_3);
                IO.close((Closeable)var3_3);
            }
            this._complete.countDown();
        }
    }

    class Connect
    implements Runnable,
    SelectorUpdate {
        private final AtomicBoolean failed = new AtomicBoolean();
        private final SelectableChannel channel;
        private final Object attachment;
        private final Scheduler.Task timeout;

        /*
         * WARNING - void declaration
         */
        Connect(SelectableChannel channel, Object attachment) {
            void var3_3;
            void var2_2;
            this.channel = var2_2;
            this.attachment = var3_3;
            long timeout = ManagedSelector.this._selectorManager.getConnectTimeout();
            if (timeout > 0L) {
                void var1_1;
                this.timeout = ((ManagedSelector)var1_1)._selectorManager.getScheduler().schedule((Runnable)this, timeout, TimeUnit.MILLISECONDS);
                return;
            }
            this.timeout = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(Selector selector) {
            try {
                this.channel.register(selector, 8, this);
                return;
            }
            catch (Throwable x) {
                void var1_2;
                this.failed((Throwable)var1_2);
                return;
            }
        }

        @Override
        public void run() {
            if (ManagedSelector.this._selectorManager.isConnectionPending(this.channel)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Channel {} timed out while connecting, closing it", new Object[]{this.channel});
                }
                this.failed(new SocketTimeoutException("Connect Timeout"));
            }
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable failure) {
            if (this.failed.compareAndSet(false, true)) {
                void var1_1;
                if (this.timeout != null) {
                    this.timeout.cancel();
                }
                IO.close((Closeable)this.channel);
                ManagedSelector.this._selectorManager.connectionFailed(this.channel, (Throwable)var1_1, this.attachment);
            }
        }

        public String toString() {
            return String.format("Connect@%x{%s,%s}", this.hashCode(), this.channel, this.attachment);
        }
    }

    class Accept
    implements Closeable,
    Runnable,
    SelectorUpdate {
        private final SelectableChannel channel;
        private final Object attachment;
        private SelectionKey key;

        /*
         * WARNING - void declaration
         */
        Accept(SelectableChannel channel, Object attachment) {
            void var2_2;
            void var1_1;
            void var3_3;
            this.channel = channel;
            this.attachment = var3_3;
            ((ManagedSelector)var1_1)._selectorManager.onAccepting((SelectableChannel)var2_2);
        }

        @Override
        public void close() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("closed accept of {}", new Object[]{this.channel});
            }
            IO.close((Closeable)this.channel);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(Selector selector) {
            try {
                this.key = this.channel.register(selector, 0, this.attachment);
                ManagedSelector.access$2000(ManagedSelector.this, this);
                return;
            }
            catch (Throwable x) {
                IO.close((Closeable)this.channel);
                ManagedSelector.this._selectorManager.onAcceptFailed(this.channel, x);
                if (LOG.isDebugEnabled()) {
                    void var1_2;
                    LOG.debug((Throwable)var1_2);
                }
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            try {
                ManagedSelector.access$2100(ManagedSelector.this, this.channel, this.key);
                ManagedSelector.this._selectorManager.onAccepted(this.channel);
                return;
            }
            catch (Throwable x) {
                void var1_1;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(x);
                }
                this.failed((Throwable)var1_1);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void failed(Throwable failure) {
            void var1_1;
            IO.close((Closeable)this.channel);
            LOG.warn(String.valueOf(failure), new Object[0]);
            if (LOG.isDebugEnabled()) {
                LOG.debug(failure);
            }
            ManagedSelector.this._selectorManager.onAcceptFailed(this.channel, (Throwable)var1_1);
        }

        public String toString() {
            return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.channel);
        }
    }

    class Acceptor
    implements Closeable,
    Selectable,
    SelectorUpdate {
        private final SelectableChannel _channel;
        private SelectionKey _key;
        final /* synthetic */ ManagedSelector this$0;

        /*
         * WARNING - void declaration
         */
        Acceptor(ManagedSelector this$0, SelectableChannel channel) {
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this._channel = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(Selector selector) {
            try {
                this._key = this._channel.register(selector, 16, this);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} acceptor={}", new Object[]{this, this._channel});
                }
                return;
            }
            catch (Throwable x) {
                void var1_2;
                IO.close((Closeable)this._channel);
                LOG.warn((Throwable)var1_2);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Runnable onSelected() {
            SelectableChannel channel = null;
            try {
                while ((channel = this.this$0._selectorManager.doAccept(this._channel)) != null) {
                    this.this$0._selectorManager.accepted(channel);
                }
            }
            catch (Throwable x) {
                void var1_1;
                void var2_2;
                LOG.warn("Accept failed for channel {}", new Object[]{channel, var2_2});
                IO.close((Closeable)var1_1);
            }
            return null;
        }

        @Override
        public void updateKey() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void replaceKey(SelectionKey newKey) {
            void var1_1;
            this._key = var1_1;
        }

        @Override
        public void close() throws IOException {
            this.this$0.submit(selector -> this._key.cancel());
        }
    }

    private static class DumpKeys
    implements SelectorUpdate {
        private final CountDownLatch latch = new CountDownLatch(1);
        private List<String> keys;

        private DumpKeys() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void update(Selector selector) {
            void var2_2;
            Iterator iterator;
            Set<SelectionKey> selectionKeys = selector.keys();
            ArrayList<String> list = new ArrayList<String>(selectionKeys.size());
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                SelectionKey key = (SelectionKey)iterator.next();
                if (key == null) continue;
                list.add(String.format("SelectionKey@%x{i=%d}->%s", key.hashCode(), ManagedSelector.safeInterestOps(key), var3_3.attachment()));
            }
            this.keys = var2_2;
            this.latch.countDown();
        }

        /*
         * WARNING - void declaration
         */
        public List<String> get(long timeout, TimeUnit unit) {
            try {
                void var3_3;
                this.latch.await(timeout, (TimeUnit)var3_3);
            }
            catch (InterruptedException x) {
                void var1_2;
                LOG.ignore((Throwable)var1_2);
            }
            return this.keys;
        }
    }

    private class Start
    implements SelectorUpdate {
        private final CountDownLatch _started = new CountDownLatch(1);

        private Start() {
        }

        @Override
        public void update(Selector selector) {
            ManagedSelector.this._started.set(true);
            this._started.countDown();
        }
    }

    public static interface SelectorUpdate {
        public void update(Selector var1);
    }

    private class SelectorProducer
    implements ExecutionStrategy.Producer {
        private Set<SelectionKey> _keys = Collections.emptySet();
        private Iterator<SelectionKey> _cursor = Collections.emptyIterator();

        private SelectorProducer() {
        }

        /*
         * WARNING - void declaration
         */
        public Runnable produce() {
            do {
                Runnable task;
                if ((task = this.processSelected()) != null) {
                    void var1_1;
                    return var1_1;
                }
                this.processUpdates();
                this.updateKeys();
            } while (this.select());
            return null;
        }

        /*
         * WARNING - void declaration
         */
        private void processUpdates() {
            Selector selector;
            Object object = ManagedSelector.this;
            synchronized (object) {
                Deque updates = ManagedSelector.this._updates;
                ManagedSelector.access$1102(ManagedSelector.this, ManagedSelector.this._updateable);
                ManagedSelector.access$1202(ManagedSelector.this, updates);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("updateable {}", (long)ManagedSelector.this._updateable.size());
            }
            object = ManagedSelector.this._updateable.iterator();
            while (object.hasNext()) {
                SelectorUpdate update = (SelectorUpdate)object.next();
                if (ManagedSelector.this._selector == null) break;
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("update {}", new Object[]{update});
                    }
                    update.update(ManagedSelector.this._selector);
                }
                catch (Throwable ex) {
                    void var3_6;
                    LOG.warn((Throwable)var3_6);
                }
            }
            ManagedSelector.this._updateable.clear();
            ManagedSelector managedSelector = ManagedSelector.this;
            synchronized (managedSelector) {
                int updates = ManagedSelector.this._updates.size();
                ManagedSelector.access$1502(ManagedSelector.this, updates == 0);
                selector = ManagedSelector.this._selecting ? null : ManagedSelector.this._selector;
            }
            if (LOG.isDebugEnabled()) {
                void var2_4;
                LOG.debug("updates {}", (long)var2_4);
            }
            if (selector != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("wakeup on updates {}", new Object[]{this});
                }
                ((Selector)object).wakeup();
            }
        }

        /*
         * WARNING - void declaration
         */
        private boolean select() {
            block10: {
                try {
                    Selector selector = ManagedSelector.this._selector;
                    if (selector == null) break block10;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} waiting with {} keys", new Object[]{selector, selector.keys().size()});
                    }
                    int selected = ManagedSelector.this.select(selector);
                    selector = ManagedSelector.this._selector;
                    if (selector == null) break block10;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Selector {} woken up from select, {}/{}/{} selected", new Object[]{selector, selected, selector.selectedKeys().size(), selector.keys().size()});
                    }
                    ManagedSelector managedSelector = ManagedSelector.this;
                    synchronized (managedSelector) {
                        ManagedSelector.access$1502(ManagedSelector.this, false);
                        int updates = ManagedSelector.this._updates.size();
                    }
                    this._keys = selector.selectedKeys();
                    int selectedKeys = this._keys.size();
                    if (selectedKeys > 0) {
                        ManagedSelector.this._keyStats.record((long)selectedKeys);
                    }
                    Iterator<Object> iterator = this._cursor = selectedKeys > 0 ? this._keys.iterator() : Collections.emptyIterator();
                    if (LOG.isDebugEnabled()) {
                        void var2_4;
                        void var3_6;
                        LOG.debug("Selector {} processing {} keys, {} updates", new Object[]{selector, (int)var3_6, (int)var2_4});
                    }
                    return true;
                }
                catch (Throwable x) {
                    void var1_3;
                    IO.close((Closeable)ManagedSelector.this._selector);
                    ManagedSelector.access$1402(ManagedSelector.this, null);
                    if (ManagedSelector.this.isRunning()) {
                        LOG.warn("Fatal select() failure", x);
                        ManagedSelector.this.onSelectFailed(x);
                    }
                    LOG.warn(x.toString(), new Object[0]);
                    if (!LOG.isDebugEnabled()) break block10;
                    LOG.debug((Throwable)var1_3);
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private Runnable processSelected() {
            while (this._cursor.hasNext()) {
                void var3_4;
                void var2_3;
                SelectionKey key = this._cursor.next();
                Object attachment = key.attachment();
                SelectableChannel channel = key.channel();
                if (key.isValid()) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("selected {} {} {} ", new Object[]{ManagedSelector.safeReadyOps(key), key, attachment});
                    }
                    try {
                        Runnable task;
                        if (attachment instanceof Selectable) {
                            task = ((Selectable)attachment).onSelected();
                            if (task == null) continue;
                            return task;
                        }
                        if (((SelectionKey)((Object)task)).isConnectable()) {
                            ManagedSelector.access$1700(ManagedSelector.this, (SelectionKey)((Object)task), (Connect)attachment);
                            continue;
                        }
                        throw new IllegalStateException("key=" + task + ", att=" + attachment + ", iOps=" + ManagedSelector.safeInterestOps((SelectionKey)((Object)task)) + ", rOps=" + ManagedSelector.safeReadyOps((SelectionKey)((Object)task)));
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Ignoring cancelled key for channel {}", new Object[]{channel});
                        }
                        IO.close((Closeable)(attachment instanceof EndPoint ? (EndPoint)attachment : channel));
                        continue;
                    }
                    catch (Throwable x) {
                        void var1_2;
                        LOG.warn("Could not process key for channel {}", new Object[]{channel, var1_2});
                        IO.close((Closeable)(attachment instanceof EndPoint ? (EndPoint)attachment : channel));
                        continue;
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selector loop ignoring invalid key for channel {}", new Object[]{channel});
                }
                IO.close((Closeable)(attachment instanceof EndPoint ? (EndPoint)var2_3 : var3_4));
            }
            return null;
        }

        private void updateKeys() {
            for (SelectionKey selectionKey : this._keys) {
                Object attachment = selectionKey.attachment();
                if (!(attachment instanceof Selectable)) continue;
                ((Selectable)((Object)selectionKey)).updateKey();
            }
            this._keys.clear();
        }

        public String toString() {
            return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
        }
    }

    public static interface Selectable {
        public Runnable onSelected();

        public void updateKey();

        public void replaceKey(SelectionKey var1);
    }
}

