/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.LeakDetector;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class LeakTrackingByteBufferPool
extends ContainerLifeCycle
implements ByteBufferPool {
    private static final Logger LOG = Log.getLogger(LeakTrackingByteBufferPool.class);
    private final LeakDetector<ByteBuffer> leakDetector = new LeakDetector<ByteBuffer>(this){
        final /* synthetic */ LeakTrackingByteBufferPool this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        public String id(ByteBuffer resource) {
            return BufferUtil.toIDString((ByteBuffer)resource);
        }

        /*
         * WARNING - void declaration
         */
        protected void leaked(LeakDetector.LeakInfo leakInfo) {
            void var1_1;
            this.this$0.leaked.incrementAndGet();
            this.this$0.leaked((LeakDetector.LeakInfo)var1_1);
        }
    };
    private final AtomicLong leakedAcquires = new AtomicLong(0L);
    private final AtomicLong leakedReleases = new AtomicLong(0L);
    private final AtomicLong leakedRemoves = new AtomicLong(0L);
    private final AtomicLong leaked = new AtomicLong(0L);
    private final ByteBufferPool delegate;

    /*
     * WARNING - void declaration
     */
    public LeakTrackingByteBufferPool(ByteBufferPool delegate) {
        void var1_1;
        this.delegate = delegate;
        LeakTrackingByteBufferPool leakTrackingByteBufferPool = this;
        leakTrackingByteBufferPool.addBean(leakTrackingByteBufferPool.leakDetector);
        this.addBean(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        void var1_2;
        boolean bl;
        ByteBuffer buffer = this.delegate.acquire(size, bl);
        if (!(bl = this.leakDetector.acquired((Object)buffer))) {
            this.leakedAcquires.incrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer leaked acquire for id {}", new Object[]{this.leakDetector.id((Object)buffer), new Throwable("acquire")});
            }
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void release(ByteBuffer buffer) {
        void var1_1;
        if (buffer == null) {
            return;
        }
        boolean bl = this.leakDetector.released((Object)buffer);
        if (!bl) {
            this.leakedReleases.incrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer leaked release for id {}", new Object[]{this.leakDetector.id((Object)buffer), new Throwable("release")});
            }
        }
        this.delegate.release((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(ByteBuffer buffer) {
        void var1_1;
        if (buffer == null) {
            return;
        }
        boolean bl = this.leakDetector.released((Object)buffer);
        if (!bl) {
            this.leakedRemoves.incrementAndGet();
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer leaked remove for id {}", new Object[]{this.leakDetector.id((Object)buffer), new Throwable("remove")});
            }
        }
        this.delegate.remove((ByteBuffer)var1_1);
    }

    @ManagedAttribute(value="Clears the tracking data")
    public void clearTracking() {
        this.leakedAcquires.set(0L);
        this.leakedReleases.set(0L);
    }

    @ManagedAttribute(value="The number of acquires that produced a leak")
    public long getLeakedAcquires() {
        return this.leakedAcquires.get();
    }

    @ManagedAttribute(value="The number of releases that produced a leak")
    public long getLeakedReleases() {
        return this.leakedReleases.get();
    }

    @ManagedAttribute(value="The number of removes that produced a leak")
    public long getLeakedRemoves() {
        return this.leakedRemoves.get();
    }

    @ManagedAttribute(value="The number of resources that were leaked")
    public long getLeakedResources() {
        return this.leaked.get();
    }

    /*
     * WARNING - void declaration
     */
    protected void leaked(LeakDetector.LeakInfo leakInfo) {
        void var1_1;
        LOG.warn("ByteBuffer " + leakInfo.getResourceDescription() + " leaked at:", var1_1.getStackFrames());
    }
}

