/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class IdleTimeout {
    private static final Logger LOG = Log.getLogger(IdleTimeout.class);
    private final Scheduler _scheduler;
    private final AtomicReference<Scheduler.Task> _timeout = new AtomicReference();
    private volatile long _idleTimeout;
    private volatile long _idleTimestamp = System.nanoTime();

    /*
     * WARNING - void declaration
     */
    public IdleTimeout(Scheduler scheduler) {
        void var1_1;
        this._scheduler = var1_1;
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public long getIdleFor() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this._idleTimestamp);
    }

    public long getIdleTimeout() {
        return this._idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public void setIdleTimeout(long idleTimeout) {
        long old = this._idleTimeout;
        this._idleTimeout = idleTimeout;
        if (old > 0L) {
            void var1_1;
            void var3_2;
            if (var3_2 <= var1_1) {
                return;
            }
            this.deactivate();
        }
        if (this.isOpen()) {
            this.activate();
        }
    }

    public void notIdle() {
        this._idleTimestamp = System.nanoTime();
    }

    private void idleCheck() {
        long idleLeft = this.checkIdleTimeout();
        if (idleLeft >= 0L) {
            long l;
            this.scheduleIdleTimeout(idleLeft > 0L ? l : this.getIdleTimeout());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void scheduleIdleTimeout(long delay) {
        void var3_3;
        Scheduler.Task oldTimeout;
        Scheduler.Task newTimeout = null;
        if (this.isOpen() && delay > 0L && this._scheduler != null) {
            newTimeout = this._scheduler.schedule(this::idleCheck, delay, TimeUnit.MILLISECONDS);
        }
        if ((oldTimeout = this._timeout.getAndSet((Scheduler.Task)var3_3)) != null) {
            void var1_2;
            var1_2.cancel();
        }
    }

    public void onOpen() {
        this.activate();
    }

    private void activate() {
        if (this._idleTimeout > 0L) {
            this.idleCheck();
        }
    }

    public void onClose() {
        this.deactivate();
    }

    /*
     * WARNING - void declaration
     */
    private void deactivate() {
        Scheduler.Task oldTimeout = this._timeout.getAndSet(null);
        if (oldTimeout != null) {
            void var1_1;
            var1_1.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected long checkIdleTimeout() {
        if (this.isOpen()) {
            void var1_1;
            long idleTimestamp = this._idleTimestamp;
            long idleElapsed = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - var1_1);
            long idleTimeout = this.getIdleTimeout();
            long idleLeft = idleTimeout - idleElapsed;
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} idle timeout check, elapsed: {} ms, remaining: {} ms", new Object[]{this, idleElapsed, idleLeft});
            }
            if (idleTimeout > 0L && idleLeft <= 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} idle timeout expired", new Object[]{this});
                }
                try {
                    void var3_3;
                    this.onIdleExpired(new TimeoutException("Idle timeout expired: " + (long)var3_3 + "/" + idleTimeout + " ms"));
                }
                finally {
                    this.notIdle();
                }
            }
            if (idleLeft >= 0L) {
                return idleLeft;
            }
            return 0L;
        }
        return -1L;
    }

    protected abstract void onIdleExpired(TimeoutException var1);

    public abstract boolean isOpen();
}

