/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadPendingException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class FillInterest {
    private static final Logger LOG = Log.getLogger(FillInterest.class);
    private final AtomicReference<Callback> _interested = new AtomicReference<Object>(null);

    protected FillInterest() {
    }

    /*
     * WARNING - void declaration
     */
    public void register(Callback callback) throws ReadPendingException {
        if (!this.tryRegister(callback)) {
            void var1_1;
            LOG.warn("Read pending for {} prevented {}", new Object[]{this._interested, var1_1});
            throw new ReadPendingException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean tryRegister(Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException();
        }
        if (!this._interested.compareAndSet(null, callback)) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("interested {}", new Object[]{this});
        }
        try {
            this.needsFillInterest();
        }
        catch (Throwable e) {
            void var1_2;
            this.onFail((Throwable)var1_2);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean fillable() {
        Callback callback;
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillable {}", new Object[]{this});
        }
        if ((callback = this._interested.get()) != null && this._interested.compareAndSet(callback, null)) {
            callback.succeeded();
            return true;
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("{} lost race {}", new Object[]{this, var1_1});
        }
        return false;
    }

    public boolean isInterested() {
        return this._interested.get() != null;
    }

    public Invocable.InvocationType getCallbackInvocationType() {
        Callback callback = this._interested.get();
        return Invocable.getInvocationType((Object)callback);
    }

    /*
     * WARNING - void declaration
     */
    public boolean onFail(Throwable cause) {
        Callback callback;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onFail " + this, cause);
        }
        if ((callback = this._interested.get()) != null && this._interested.compareAndSet(callback, null)) {
            void var1_1;
            void var2_2;
            var2_2.failed((Throwable)var1_1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public void onClose() {
        Callback callback;
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", new Object[]{this});
        }
        if ((callback = this._interested.get()) != null && this._interested.compareAndSet(callback, null)) {
            void var1_1;
            var1_1.failed((Throwable)new ClosedChannelException());
        }
    }

    public String toString() {
        return String.format("FillInterest@%x{%s}", this.hashCode(), this._interested.get());
    }

    public String toStateString() {
        if (this._interested.get() == null) {
            return "-";
        }
        return "FI";
    }

    protected abstract void needsFillInterest() throws IOException;
}

