/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.io.CyclicTimeout;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class CyclicTimeouts<T extends Expirable>
implements Destroyable {
    private static final Logger LOG = Log.getLogger(CyclicTimeouts.class);
    private final AtomicLong earliestTimeout = new AtomicLong(Long.MAX_VALUE);
    private final CyclicTimeout cyclicTimeout;

    /*
     * WARNING - void declaration
     */
    public CyclicTimeouts(Scheduler scheduler) {
        void var1_1;
        this.cyclicTimeout = new Timeouts((Scheduler)var1_1);
    }

    protected abstract Iterator<T> iterator();

    protected abstract boolean onExpired(T var1);

    /*
     * WARNING - void declaration
     */
    private void onTimeoutExpired() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Timeouts check for {}", new Object[]{this});
        }
        long now = System.nanoTime();
        long earliest = Long.MAX_VALUE;
        this.earliestTimeout.set(Long.MAX_VALUE);
        Iterator<T> iterator = this.iterator();
        if (iterator == null) {
            return;
        }
        while (iterator.hasNext()) {
            void var7_5;
            Expirable expirable = (Expirable)iterator.next();
            long expiresAt = expirable.getExpireNanoTime();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Entity {} expires in {} ms for {}", new Object[]{expirable, TimeUnit.NANOSECONDS.toMillis(expiresAt - now), this});
            }
            if (expiresAt == -1L) continue;
            if (expiresAt <= now) {
                boolean remove = this.onExpired(expirable);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Entity {} expired, remove={} for {}", new Object[]{expirable, remove, this});
                }
                if (!remove) continue;
                iterator.remove();
                continue;
            }
            earliest = Math.min(earliest, (long)var7_5);
        }
        if (earliest < Long.MAX_VALUE) {
            void var3_2;
            this.schedule((long)var3_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void schedule(T expirable) {
        long expiresAt = expirable.getExpireNanoTime();
        if (expiresAt < Long.MAX_VALUE) {
            void var2_2;
            this.schedule((long)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void schedule(long expiresAt) {
        void var1_1;
        long prevEarliest = this.earliestTimeout.getAndUpdate(t -> {
            long l;
            return Math.min(t, l);
        });
        long expires = var1_1;
        while (expires < prevEarliest) {
            long delay = Math.max(0L, (long)(expires - System.nanoTime()));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Scheduling timeout in {} ms for {}", new Object[]{TimeUnit.NANOSECONDS.toMillis(delay), this});
            }
            CyclicTimeouts cyclicTimeouts = this;
            cyclicTimeouts.schedule(cyclicTimeouts.cyclicTimeout, delay, TimeUnit.NANOSECONDS);
            prevEarliest = expires;
            expires = this.earliestTimeout.get();
        }
    }

    public void destroy() {
        this.cyclicTimeout.destroy();
    }

    /*
     * WARNING - void declaration
     */
    boolean schedule(CyclicTimeout cyclicTimeout, long delay, TimeUnit unit) {
        void var2_2;
        return cyclicTimeout.schedule((long)var2_2, unit);
    }

    private class Timeouts
    extends CyclicTimeout {
        /*
         * WARNING - void declaration
         */
        private Timeouts(Scheduler scheduler) {
            void var2_2;
            super((Scheduler)var2_2);
        }

        @Override
        public void onTimeoutExpired() {
            CyclicTimeouts.this.onTimeoutExpired();
        }
    }

    public static interface Expirable {
        public long getExpireNanoTime();
    }
}

