/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.util.component.Destroyable;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class CyclicTimeout
implements Destroyable {
    private static final Logger LOG = Log.getLogger(CyclicTimeout.class);
    private static final Timeout NOT_SET = new Timeout(Long.MAX_VALUE, null);
    private static final Scheduler.Task DESTROYED = () -> false;
    private final Scheduler _scheduler;
    private final AtomicReference<Timeout> _timeout = new AtomicReference<Timeout>(NOT_SET);

    /*
     * WARNING - void declaration
     */
    public CyclicTimeout(Scheduler scheduler) {
        void var1_1;
        this._scheduler = var1_1;
    }

    public Scheduler getScheduler() {
        return this._scheduler;
    }

    public boolean schedule(long delay, TimeUnit units) {
        boolean result;
        Wakeup wakeup;
        Timeout timeout;
        long now = System.nanoTime();
        long newTimeoutAt = now + units.toNanos(delay);
        Wakeup newWakeup = null;
        do {
            result = (timeout = this._timeout.get())._at != Long.MAX_VALUE;
            wakeup = timeout._wakeup;
            if (wakeup != null && wakeup._at <= newTimeoutAt) continue;
            wakeup = newWakeup = new Wakeup(newTimeoutAt, wakeup);
        } while (!this._timeout.compareAndSet(timeout, new Timeout(newTimeoutAt, wakeup)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Installed timeout in {} ms, {} wake up in {} ms", new Object[]{units.toMillis(delay), newWakeup != null ? "new" : "existing", TimeUnit.NANOSECONDS.toMillis(wakeup._at - now)});
        }
        if (newWakeup != null) {
            Wakeup.access$500(newWakeup, now);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public boolean cancel() {
        void var1_1;
        void var3_3;
        void var2_2;
        do {
            Timeout newTimeout;
            Timeout timeout;
            boolean result = (timeout = this._timeout.get())._at != Long.MAX_VALUE;
            Wakeup wakeup = timeout._wakeup;
            Timeout timeout2 = newTimeout = wakeup == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup);
        } while (!this._timeout.compareAndSet((Timeout)var2_2, (Timeout)var3_3));
        return (boolean)var1_1;
    }

    public abstract void onTimeoutExpired();

    /*
     * WARNING - void declaration
     */
    public void destroy() {
        Wakeup wakeup;
        Timeout timeout = this._timeout.getAndSet(NOT_SET);
        Wakeup wakeup2 = wakeup = timeout == null ? null : timeout._wakeup;
        while (wakeup2 != null) {
            void var1_1;
            wakeup.destroy();
            wakeup2 = ((Wakeup)var1_1)._next;
        }
    }

    private class Wakeup
    implements Runnable {
        private final AtomicReference<Scheduler.Task> _task = new AtomicReference();
        private final long _at;
        private final Wakeup _next;

        /*
         * WARNING - void declaration
         */
        private Wakeup(long wakeupAt, Wakeup next) {
            void var2_2;
            this._at = var2_2;
            this._next = next;
        }

        /*
         * WARNING - void declaration
         */
        private void schedule(long now) {
            void var1_1;
            Wakeup wakeup = this;
            this._task.compareAndSet(null, CyclicTimeout.this._scheduler.schedule((Runnable)wakeup, wakeup._at - var1_1, TimeUnit.NANOSECONDS));
        }

        /*
         * WARNING - void declaration
         */
        private void destroy() {
            Scheduler.Task task = this._task.getAndSet(DESTROYED);
            if (task != null) {
                void var1_1;
                var1_1.cancel();
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            Object newTimeout;
            Timeout timeout;
            long now = System.nanoTime();
            Wakeup newWakeup = null;
            boolean hasExpired = false;
            do {
                Object object;
                timeout = (Timeout)CyclicTimeout.this._timeout.get();
                Wakeup wakeup = timeout._wakeup;
                while (wakeup != null && wakeup != this) {
                    wakeup = wakeup._next;
                }
                if (wakeup == null) {
                    return;
                }
                wakeup = wakeup._next;
                if (timeout._at <= now) {
                    hasExpired = true;
                    newTimeout = wakeup == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup);
                    continue;
                }
                if (timeout._at != Long.MAX_VALUE) {
                    if (newTimeout == null || ((Wakeup)newTimeout)._at >= timeout._at) {
                        newWakeup = new Wakeup(timeout._at, (Wakeup)newTimeout);
                        newTimeout = newWakeup;
                    }
                    object = new Timeout(timeout._at, (Wakeup)newTimeout);
                    continue;
                }
                object = newTimeout = newTimeout == null ? NOT_SET : new Timeout(Long.MAX_VALUE, (Wakeup)newTimeout);
            } while (!CyclicTimeout.this._timeout.compareAndSet(timeout, newTimeout));
            if (newWakeup != null) {
                void var1_1;
                void var3_2;
                super.schedule((long)var1_1);
            }
            if (hasExpired) {
                CyclicTimeout.this.onTimeoutExpired();
            }
        }

        public String toString() {
            return String.format("%s@%x:%dms->%s", this.getClass().getSimpleName(), this.hashCode(), this._at == Long.MAX_VALUE ? this._at : TimeUnit.NANOSECONDS.toMillis(this._at - System.nanoTime()), this._next);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ void access$500(Wakeup x0, long x1) {
            void var1_1;
            x0.schedule((long)var1_1);
        }
    }

    private static class Timeout {
        private final long _at;
        private final Wakeup _wakeup;

        /*
         * WARNING - void declaration
         */
        private Timeout(long timeoutAt, Wakeup wakeup) {
            void var3_2;
            void var1_1;
            this._at = var1_1;
            this._wakeup = var3_2;
        }

        public String toString() {
            return String.format("%s@%x:%dms,%s", this.getClass().getSimpleName(), this.hashCode(), TimeUnit.NANOSECONDS.toMillis(this._at - System.nanoTime()), this._wakeup);
        }
    }
}

