/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.statistic.CounterStatistic;
import org.eclipse.jetty.util.statistic.RateCounter;
import org.eclipse.jetty.util.statistic.SampleStatistic;

@ManagedObject(value="Tracks statistics on connections")
public class ConnectionStatistics
extends AbstractLifeCycle
implements Connection.Listener,
Dumpable {
    private final Stats _stats = new Stats("total");
    private final Map<String, Stats> _statsMap = new ConcurrentHashMap<String, Stats>();

    @ManagedOperation(value="Resets the statistics", impact="ACTION")
    public void reset() {
        this._stats.reset();
        this._statsMap.clear();
    }

    protected void doStart() throws Exception {
        this.reset();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onOpened(Connection connection) {
        void var1_1;
        if (!this.isStarted()) {
            return;
        }
        this.onTotalOpened(connection);
        this.onConnectionOpened((Connection)var1_1);
    }

    protected void onTotalOpened(Connection connection) {
        this._stats.incrementCount();
    }

    /*
     * WARNING - void declaration
     */
    protected void onConnectionOpened(Connection connection) {
        void var1_1;
        this._statsMap.computeIfAbsent(var1_1.getClass().getName(), Stats::new).incrementCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onClosed(Connection connection) {
        void var1_1;
        if (!this.isStarted()) {
            return;
        }
        this.onTotalClosed(connection);
        this.onConnectionClosed((Connection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onTotalClosed(Connection connection) {
        void var1_1;
        ConnectionStatistics connectionStatistics = this;
        connectionStatistics.onClosed(connectionStatistics._stats, (Connection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void onConnectionClosed(Connection connection) {
        Stats stats = this._statsMap.get(connection.getClass().getName());
        if (stats != null) {
            void var1_1;
            void var2_2;
            this.onClosed((Stats)var2_2, (Connection)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onClosed(Stats stats, Connection connection) {
        void var2_2;
        long messagesOut;
        long messagesIn;
        long bytesOut;
        stats.decrementCount();
        stats.recordDuration(System.currentTimeMillis() - connection.getCreatedTimeStamp());
        long bytesIn = connection.getBytesIn();
        if (bytesIn > 0L) {
            void var3_3;
            stats.recordBytesIn((long)var3_3);
        }
        if ((bytesOut = connection.getBytesOut()) > 0L) {
            stats.recordBytesOut(bytesOut);
        }
        if ((messagesIn = connection.getMessagesIn()) > 0L) {
            stats.recordMessagesIn(messagesIn);
        }
        if ((messagesOut = var2_2.getMessagesOut()) > 0L) {
            void var1_1;
            var1_1.recordMessagesOut(messagesOut);
        }
    }

    @ManagedAttribute(value="Total number of bytes received by tracked connections")
    public long getReceivedBytes() {
        return this._stats.getReceivedBytes();
    }

    @ManagedAttribute(value="Total number of bytes received per second since the last invocation of this method")
    public long getReceivedBytesRate() {
        return this._stats.getReceivedBytesRate();
    }

    @ManagedAttribute(value="Total number of bytes sent by tracked connections")
    public long getSentBytes() {
        return this._stats.getSentBytes();
    }

    @ManagedAttribute(value="Total number of bytes sent per second since the last invocation of this method")
    public long getSentBytesRate() {
        return this._stats.getSentBytesRate();
    }

    @ManagedAttribute(value="The max duration of a connection in ms")
    public long getConnectionDurationMax() {
        return this._stats.getConnectionDurationMax();
    }

    @ManagedAttribute(value="The mean duration of a connection in ms")
    public double getConnectionDurationMean() {
        return this._stats.getConnectionDurationMean();
    }

    @ManagedAttribute(value="The standard deviation of the duration of a connection")
    public double getConnectionDurationStdDev() {
        return this._stats.getConnectionDurationStdDev();
    }

    @ManagedAttribute(value="The total number of connections opened")
    public long getConnectionsTotal() {
        return this._stats.getConnectionsTotal();
    }

    @ManagedAttribute(value="The current number of open connections")
    public long getConnections() {
        return this._stats.getConnections();
    }

    @ManagedAttribute(value="The max number of open connections")
    public long getConnectionsMax() {
        return this._stats.getConnectionsMax();
    }

    @ManagedAttribute(value="The total number of messages received")
    public long getReceivedMessages() {
        return this._stats.getReceivedMessages();
    }

    @ManagedAttribute(value="Total number of messages received per second since the last invocation of this method")
    public long getReceivedMessagesRate() {
        return this._stats.getReceivedMessagesRate();
    }

    @ManagedAttribute(value="The total number of messages sent")
    public long getSentMessages() {
        return this._stats.getSentMessages();
    }

    @ManagedAttribute(value="Total number of messages sent per second since the last invocation of this method")
    public long getSentMessagesRate() {
        return this._stats.getSentMessagesRate();
    }

    public Map<String, Stats> getConnectionStatisticsGroups() {
        return this._statsMap;
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ArrayList<Stats> children = new ArrayList<Stats>();
        children.add(this._stats);
        children.addAll(this._statsMap.values());
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, (Object)this, (Object[])var3_3.toArray());
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }

    public static class Stats
    implements Dumpable {
        private final CounterStatistic _connections = new CounterStatistic();
        private final SampleStatistic _connectionsDuration = new SampleStatistic();
        private final LongAdder _bytesIn = new LongAdder();
        private final RateCounter _bytesInRate = new RateCounter();
        private final LongAdder _bytesOut = new LongAdder();
        private final RateCounter _bytesOutRate = new RateCounter();
        private final LongAdder _messagesIn = new LongAdder();
        private final RateCounter _messagesInRate = new RateCounter();
        private final LongAdder _messagesOut = new LongAdder();
        private final RateCounter _messagesOutRate = new RateCounter();
        private final String _name;

        /*
         * WARNING - void declaration
         */
        public Stats(String name) {
            void var1_1;
            this._name = var1_1;
        }

        public void reset() {
            this._connections.reset();
            this._connectionsDuration.reset();
            this._bytesIn.reset();
            this._bytesInRate.reset();
            this._bytesOut.reset();
            this._bytesOutRate.reset();
            this._messagesIn.reset();
            this._messagesInRate.reset();
            this._messagesOut.reset();
            this._messagesOutRate.reset();
        }

        public String getName() {
            return this._name;
        }

        public long getReceivedBytes() {
            return this._bytesIn.sum();
        }

        /*
         * WARNING - void declaration
         */
        public long getReceivedBytesRate() {
            void var1_1;
            long rate = this._bytesInRate.getRate();
            this._bytesInRate.reset();
            return (long)var1_1;
        }

        public long getSentBytes() {
            return this._bytesOut.sum();
        }

        /*
         * WARNING - void declaration
         */
        public long getSentBytesRate() {
            void var1_1;
            long rate = this._bytesOutRate.getRate();
            this._bytesOutRate.reset();
            return (long)var1_1;
        }

        public long getConnectionDurationMax() {
            return this._connectionsDuration.getMax();
        }

        public double getConnectionDurationMean() {
            return this._connectionsDuration.getMean();
        }

        public double getConnectionDurationStdDev() {
            return this._connectionsDuration.getStdDev();
        }

        public long getConnectionsTotal() {
            return this._connections.getTotal();
        }

        public long getConnections() {
            return this._connections.getCurrent();
        }

        public long getConnectionsMax() {
            return this._connections.getMax();
        }

        public long getReceivedMessages() {
            return this._messagesIn.sum();
        }

        /*
         * WARNING - void declaration
         */
        public long getReceivedMessagesRate() {
            void var1_1;
            long rate = this._messagesInRate.getRate();
            this._messagesInRate.reset();
            return (long)var1_1;
        }

        public long getSentMessages() {
            return this._messagesOut.sum();
        }

        /*
         * WARNING - void declaration
         */
        public long getSentMessagesRate() {
            void var1_1;
            long rate = this._messagesOutRate.getRate();
            this._messagesOutRate.reset();
            return (long)var1_1;
        }

        public void incrementCount() {
            this._connections.increment();
        }

        public void decrementCount() {
            this._connections.decrement();
        }

        /*
         * WARNING - void declaration
         */
        public void recordDuration(long duration) {
            void var1_1;
            this._connectionsDuration.record((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void recordBytesIn(long bytesIn) {
            void var1_1;
            this._bytesIn.add(bytesIn);
            this._bytesInRate.add((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void recordBytesOut(long bytesOut) {
            void var1_1;
            this._bytesOut.add(bytesOut);
            this._bytesOutRate.add((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void recordMessagesIn(long messagesIn) {
            void var1_1;
            this._messagesIn.add(messagesIn);
            this._messagesInRate.add((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void recordMessagesOut(long messagesOut) {
            void var1_1;
            this._messagesOut.add(messagesOut);
            this._messagesOutRate.add((long)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void dump(Appendable out, String indent) throws IOException {
            void var2_2;
            Dumpable.dumpObjects((Appendable)out, (String)var2_2, (Object)this, (Object[])new Object[]{String.format("connections=%s", this._connections), String.format("durations=%s", this._connectionsDuration), String.format("bytes in/out=%s/%s", this.getReceivedBytes(), this.getSentBytes()), String.format("messages in/out=%s/%s", this.getReceivedMessages(), this.getSentMessages())});
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this.getName());
        }
    }
}

