/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class ChannelEndPoint
extends AbstractEndPoint
implements ManagedSelector.Selectable {
    private static final Logger LOG = Log.getLogger(ChannelEndPoint.class);
    private final SocketChannel _channel;
    private final ManagedSelector _selector;
    private SelectionKey _key;
    private boolean _updatePending;
    private int _currentInterestOps;
    private int _desiredInterestOps;
    private final ManagedSelector.SelectorUpdate _updateKeyAction = this::updateKeyAction;
    private final Runnable _runFillable = new RunnableCloseable("runFillable"){
        {
            void var2_2;
            void var1_1;
            super((String)var2_2);
        }

        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };
    private final Runnable _runCompleteWrite = new RunnableCloseable("runCompleteWrite"){
        {
            void var2_2;
            void var1_1;
            super((String)var2_2);
        }

        public Invocable.InvocationType getInvocationType() {
            return ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType();
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
        }

        @Override
        public String toString() {
            return String.format("CEP:%s:%s:%s->%s", ChannelEndPoint.this, this._operation, this.getInvocationType(), ChannelEndPoint.this.getWriteFlusher());
        }
    };
    private final Runnable _runCompleteWriteFillable = new RunnableCloseable("runCompleteWriteFillable"){
        {
            void var2_2;
            void var1_1;
            super((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public Invocable.InvocationType getInvocationType() {
            void var2_2;
            void var1_1;
            Invocable.InvocationType flushT;
            Invocable.InvocationType fillT = ChannelEndPoint.this.getFillInterest().getCallbackInvocationType();
            if (fillT == (flushT = ChannelEndPoint.this.getWriteFlusher().getCallbackInvocationType())) {
                return fillT;
            }
            if (fillT == Invocable.InvocationType.EITHER && flushT == Invocable.InvocationType.NON_BLOCKING) {
                return Invocable.InvocationType.EITHER;
            }
            if (var1_1 == Invocable.InvocationType.NON_BLOCKING && var2_2 == Invocable.InvocationType.EITHER) {
                return Invocable.InvocationType.EITHER;
            }
            return Invocable.InvocationType.BLOCKING;
        }

        @Override
        public void run() {
            ChannelEndPoint.this.getWriteFlusher().completeWrite();
            ChannelEndPoint.this.getFillInterest().fillable();
        }
    };

    /*
     * WARNING - void declaration
     */
    public ChannelEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey key, Scheduler scheduler) {
        super(scheduler);
        void var3_3;
        void var2_2;
        void var1_1;
        this._channel = var1_1;
        this._selector = var2_2;
        this._key = var3_3;
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this._channel.socket().getLocalSocketAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this._channel.socket().getRemoteSocketAddress();
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._channel.isOpen();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doShutdownOutput() {
        try {
            Socket socket = this._channel.socket();
            if (!socket.isOutputShutdown()) {
                socket.shutdownOutput();
            }
            return;
        }
        catch (IOException e) {
            void var1_2;
            LOG.debug((Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("doClose {}", new Object[]{this});
        }
        try {
            this._key.cancel();
            this._channel.close();
            return;
        }
        catch (IOException e) {
            void var1_1;
            LOG.debug((Throwable)var1_1);
            return;
        }
        finally {
            super.doClose();
        }
    }

    @Override
    public void onClose() {
        try {
            super.onClose();
            if (this._selector != null) {
                this._selector.destroyEndPoint(this);
                return;
            }
        }
        catch (Throwable throwable) {
            if (this._selector != null) {
                this._selector.destroyEndPoint(this);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        void var3_3;
        int filled;
        int pos;
        block7: {
            if (this.isInputShutdown()) {
                return -1;
            }
            pos = BufferUtil.flipToFill((ByteBuffer)buffer);
            try {
                filled = this._channel.read(buffer);
                if (filled > 0) {
                    this.notIdle();
                    break block7;
                }
                if (filled != -1) break block7;
                this.shutdownInput();
            }
            catch (IOException e) {
                try {
                    LOG.debug((Throwable)e);
                    this.shutdownInput();
                    filled = -1;
                }
                catch (Throwable filled2) {
                    void var2_2;
                    BufferUtil.flipToFlush((ByteBuffer)buffer, (int)var2_2);
                    throw filled2;
                }
                BufferUtil.flipToFlush((ByteBuffer)buffer, (int)pos);
            }
        }
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)pos);
        if (LOG.isDebugEnabled()) {
            void var1_1;
            LOG.debug("filled {} {}", new Object[]{filled, BufferUtil.toDetailString((ByteBuffer)var1_1)});
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        void var1_1;
        void var2_3;
        try {
            long flushed = this._channel.write(buffers);
            if (LOG.isDebugEnabled()) {
                LOG.debug("flushed {} {}", new Object[]{flushed, this});
            }
        }
        catch (IOException e) {
            void var1_2;
            throw new EofException((Throwable)var1_2);
        }
        if (var2_3 > 0L) {
            this.notIdle();
        }
        for (void var4_6 : var1_1) {
            if (BufferUtil.isEmpty((ByteBuffer)var4_6)) continue;
            return false;
        }
        return true;
    }

    public SocketChannel getChannel() {
        return this._channel;
    }

    @Override
    public Object getTransport() {
        return this._channel;
    }

    @Override
    protected void needsFillInterest() {
        this.changeInterests(1);
    }

    @Override
    protected void onIncompleteFlush() {
        this.changeInterests(4);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Runnable onSelected() {
        void var1_3;
        Runnable task;
        boolean flushable;
        int readyOps = this._key.readyOps();
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            int newInterestOps;
            this._updatePending = true;
            int oldInterestOps = this._desiredInterestOps;
            this._desiredInterestOps = newInterestOps = oldInterestOps & ~readyOps;
        }
        boolean fillable = (readyOps & 1) != 0;
        boolean bl = flushable = (readyOps & 4) != 0;
        if (LOG.isDebugEnabled()) {
            void var3_7;
            void var2_6;
            LOG.debug("onSelected {}->{} r={} w={} for {}", new Object[]{(int)var2_6, (int)var3_7, fillable, flushable, this});
        }
        Runnable runnable = fillable ? (flushable ? this._runCompleteWriteFillable : this._runFillable) : (task = flushable ? this._runCompleteWrite : null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("task {}", new Object[]{task});
        }
        return var1_3;
    }

    private void updateKeyAction(Selector selector) {
        this.updateKey();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateKey() {
        try {
            int oldInterestOps;
            ChannelEndPoint channelEndPoint = this;
            synchronized (channelEndPoint) {
                this._updatePending = false;
                oldInterestOps = this._currentInterestOps;
                int newInterestOps = this._desiredInterestOps;
                if (oldInterestOps != newInterestOps) {
                    this._currentInterestOps = newInterestOps;
                    this._key.interestOps(newInterestOps);
                }
            }
            if (LOG.isDebugEnabled()) {
                void var2_6;
                LOG.debug("Key interests updated {} -> {} on {}", new Object[]{oldInterestOps, (int)var2_6, this});
            }
            return;
        }
        catch (CancelledKeyException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Ignoring key update for cancelled key {}", new Object[]{this, x});
            }
            this.close();
            return;
        }
        catch (Throwable x) {
            void var1_5;
            LOG.warn("Ignoring key update for {}", new Object[]{this, var1_5});
            this.close();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void replaceKey(SelectionKey newKey) {
        void var1_1;
        this._key = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void changeInterests(int operation) {
        void var3_4;
        boolean pending;
        ChannelEndPoint channelEndPoint = this;
        synchronized (channelEndPoint) {
            pending = this._updatePending;
            int oldInterestOps = this._desiredInterestOps;
            int newInterestOps = oldInterestOps | operation;
            if (newInterestOps != oldInterestOps) {
                this._desiredInterestOps = newInterestOps;
            }
        }
        if (LOG.isDebugEnabled()) {
            void var1_1;
            void var2_5;
            LOG.debug("changeInterests p={} {}->{} for {}", new Object[]{pending, (int)var2_5, (int)var1_1, this});
        }
        if (var3_4 == false && this._selector != null) {
            this._selector.submit(this._updateKeyAction);
        }
    }

    @Override
    public String toEndPointString() {
        return String.format("%s{io=%d/%d,kio=%d,kro=%d}", super.toEndPointString(), this._currentInterestOps, this._desiredInterestOps, ManagedSelector.safeInterestOps(this._key), ManagedSelector.safeReadyOps(this._key));
    }

    private abstract class RunnableCloseable
    extends RunnableTask
    implements Closeable {
        /*
         * WARNING - void declaration
         */
        protected RunnableCloseable(String op) {
            void var2_2;
            super((String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void close() {
            try {
                ChannelEndPoint.this.close();
                return;
            }
            catch (Throwable x) {
                void var1_1;
                LOG.warn((Throwable)var1_1);
                return;
            }
        }
    }

    private abstract class RunnableTask
    implements Runnable,
    Invocable {
        final String _operation;

        /*
         * WARNING - void declaration
         */
        protected RunnableTask(String op) {
            void var2_2;
            this._operation = var2_2;
        }

        public String toString() {
            return String.format("CEP:%s:%s:%s", ChannelEndPoint.this, this._operation, this.getInvocationType());
        }
    }
}

