/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntConsumer;
import org.eclipse.jetty.util.BufferUtil;

public interface ByteBufferPool {
    public ByteBuffer acquire(int var1, boolean var2);

    public void release(ByteBuffer var1);

    default public void remove(ByteBuffer buffer) {
    }

    /*
     * WARNING - void declaration
     */
    default public ByteBuffer newByteBuffer(int capacity, boolean direct) {
        void var1_1;
        if (direct) {
            return BufferUtil.allocateDirect((int)capacity);
        }
        return BufferUtil.allocate((int)var1_1);
    }

    public static class Bucket {
        private final Queue<ByteBuffer> _queue = new ConcurrentLinkedQueue<ByteBuffer>();
        private final ByteBufferPool _pool;
        private final int _capacity;
        private final int _maxSize;
        private final AtomicInteger _size;
        private final AtomicLong _lastUpdate = new AtomicLong(System.nanoTime());
        private final IntConsumer _memoryFunction;

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public Bucket(ByteBufferPool pool, int capacity, int maxSize) {
            this((ByteBufferPool)var1_1, (int)var2_2, (int)var3_3, i -> {});
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Bucket(ByteBufferPool pool, int capacity, int maxSize, IntConsumer memoryFunction) {
            void var3_3;
            void var2_2;
            void var1_1;
            this._pool = var1_1;
            this._capacity = var2_2;
            this._maxSize = maxSize;
            this._size = var3_3 > 0 ? new AtomicInteger() : null;
            this._memoryFunction = Objects.requireNonNull(memoryFunction);
        }

        /*
         * WARNING - void declaration
         */
        public ByteBuffer acquire() {
            void var1_1;
            ByteBuffer buffer = this._queue.poll();
            if (buffer != null) {
                if (this._size != null) {
                    this._size.decrementAndGet();
                }
                this._memoryFunction.accept(-buffer.capacity());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated
        public ByteBuffer acquire(boolean direct) {
            void var2_2;
            ByteBuffer buffer = this.acquire();
            if (buffer == null) {
                void var1_1;
                return this._pool.newByteBuffer(this._capacity, (boolean)var1_1);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        public void release(ByteBuffer buffer) {
            this.resetUpdateTime();
            BufferUtil.reset((ByteBuffer)buffer);
            if (this._size == null || this._size.incrementAndGet() <= this._maxSize) {
                void var1_1;
                this._queue.offer(buffer);
                this._memoryFunction.accept(var1_1.capacity());
                return;
            }
            this._size.decrementAndGet();
        }

        void resetUpdateTime() {
            this._lastUpdate.lazySet(System.nanoTime());
        }

        public void clear() {
            ByteBuffer byteBuffer;
            int size;
            int n = size = this._size == null ? 0 : this._size.get() - 1;
            while (size >= 0 && (byteBuffer = this.acquire()) != null) {
                if (this._size == null) continue;
                --size;
            }
        }

        boolean isEmpty() {
            return this._queue.isEmpty();
        }

        int size() {
            return this._queue.size();
        }

        long getLastUpdate() {
            return this._lastUpdate.get();
        }

        public String toString() {
            return String.format("%s@%x{capacity=%d, size=%d, maxSize=%d}", this.getClass().getSimpleName(), this.hashCode(), this._capacity, this.size(), this._maxSize);
        }
    }

    public static class Lease {
        private final ByteBufferPool byteBufferPool;
        private final List<ByteBuffer> buffers;
        private final List<Boolean> recycles;

        /*
         * WARNING - void declaration
         */
        public Lease(ByteBufferPool byteBufferPool) {
            void var1_1;
            this.byteBufferPool = var1_1;
            this.buffers = new ArrayList<ByteBuffer>();
            this.recycles = new ArrayList<Boolean>();
        }

        /*
         * WARNING - void declaration
         */
        public ByteBuffer acquire(int capacity, boolean direct) {
            void var1_2;
            void var2_3;
            ByteBuffer buffer = this.byteBufferPool.acquire(capacity, (boolean)var2_3);
            BufferUtil.clearToFill((ByteBuffer)buffer);
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        public void append(ByteBuffer buffer, boolean recycle) {
            void var2_2;
            void var1_1;
            this.buffers.add((ByteBuffer)var1_1);
            this.recycles.add((boolean)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public void insert(int index, ByteBuffer buffer, boolean recycle) {
            void var3_3;
            void var1_1;
            void var2_2;
            this.buffers.add(index, (ByteBuffer)var2_2);
            this.recycles.add((int)var1_1, (boolean)var3_3);
        }

        public List<ByteBuffer> getByteBuffers() {
            return this.buffers;
        }

        /*
         * WARNING - void declaration
         */
        public long getTotalLength() {
            void var1_1;
            long length = 0L;
            for (ByteBuffer buffer : this.buffers) {
                length += (long)buffer.remaining();
            }
            return (long)var1_1;
        }

        public int getSize() {
            return this.buffers.size();
        }

        /*
         * WARNING - void declaration
         */
        public void recycle() {
            for (int i = 0; i < this.buffers.size(); ++i) {
                void var2_2;
                ByteBuffer buffer = this.buffers.get(i);
                if (!this.recycles.get(i).booleanValue()) continue;
                this.release((ByteBuffer)var2_2);
            }
            this.buffers.clear();
            this.recycles.clear();
        }

        /*
         * WARNING - void declaration
         */
        public void release(ByteBuffer buffer) {
            void var1_1;
            this.byteBufferPool.release((ByteBuffer)var1_1);
        }
    }
}

