/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferAccumulator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.NullByteBufferPool;

public class ByteBufferOutputStream2
extends OutputStream {
    private final ByteBufferAccumulator _accumulator;
    private int _size = 0;

    public ByteBufferOutputStream2() {
        this(null, false);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBufferOutputStream2(ByteBufferPool bufferPool, boolean direct) {
        void var2_2;
        void var1_1;
        this._accumulator = new ByteBufferAccumulator((ByteBufferPool)(bufferPool == null ? new NullByteBufferPool() : var1_1), (boolean)var2_2);
    }

    public ByteBufferPool getByteBufferPool() {
        return this._accumulator.getByteBufferPool();
    }

    public ByteBuffer takeByteBuffer() {
        return this._accumulator.takeByteBuffer();
    }

    public ByteBuffer toByteBuffer() {
        return this._accumulator.toByteBuffer();
    }

    public byte[] toByteArray() {
        return this._accumulator.toByteArray();
    }

    public int size() {
        return this._size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(int b) {
        void var1_1;
        this.write(new byte[]{(byte)var1_1}, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(byte[] b, int off, int len) {
        void var3_3;
        void var2_2;
        void var1_1;
        this._size += len;
        this._accumulator.copyBytes((byte[])var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public void write(ByteBuffer buffer) {
        void var1_1;
        this._size += buffer.remaining();
        this._accumulator.copyBuffer((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(ByteBuffer buffer) {
        void var1_1;
        this._accumulator.writeTo((ByteBuffer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(OutputStream out) throws IOException {
        void var1_1;
        this._accumulator.writeTo((OutputStream)var1_1);
    }

    @Override
    public void close() {
        this._accumulator.close();
        this._size = 0;
    }

    public synchronized String toString() {
        return String.format("%s@%x{size=%d, byteAccumulator=%s}", this.getClass().getSimpleName(), this.hashCode(), this._size, this._accumulator);
    }
}

