/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.NullByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class ByteBufferAccumulator
implements AutoCloseable {
    private final List<ByteBuffer> _buffers = new ArrayList<ByteBuffer>();
    private final ByteBufferPool _bufferPool;
    private final boolean _direct;

    public ByteBufferAccumulator() {
        this(null, false);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBufferAccumulator(ByteBufferPool bufferPool, boolean direct) {
        void var2_2;
        void var1_1;
        this._bufferPool = bufferPool == null ? new NullByteBufferPool() : var1_1;
        this._direct = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public int getLength() {
        void var1_1;
        int length = 0;
        for (ByteBuffer buffer : this._buffers) {
            void var3_3;
            length = Math.addExact(length, var3_3.remaining());
        }
        return (int)var1_1;
    }

    public ByteBufferPool getByteBufferPool() {
        return this._bufferPool;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer ensureBuffer(int minAllocationSize) {
        void var1_1;
        return this.ensureBuffer(1, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer ensureBuffer(int minSize, int minAllocationSize) {
        void var3_3;
        void var1_1;
        ByteBuffer buffer = this._buffers.isEmpty() ? BufferUtil.EMPTY_BUFFER : this._buffers.get(this._buffers.size() - 1);
        if (BufferUtil.space((ByteBuffer)buffer) < var1_1) {
            void var2_2;
            buffer = this._bufferPool.acquire((int)var2_2, this._direct);
            this._buffers.add(buffer);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public void copyBytes(byte[] buf, int offset, int length) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.copyBuffer(BufferUtil.toBuffer((byte[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void copyBuffer(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            void var3_3;
            void var2_2;
            ByteBuffer b = this.ensureBuffer(buffer.remaining());
            int pos = BufferUtil.flipToFill((ByteBuffer)b);
            BufferUtil.put((ByteBuffer)buffer, (ByteBuffer)b);
            BufferUtil.flipToFlush((ByteBuffer)var2_2, (int)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer takeByteBuffer() {
        void var1_3;
        if (this._buffers.size() == 1) {
            ByteBuffer combinedBuffer = this._buffers.get(0);
            this._buffers.clear();
            return combinedBuffer;
        }
        int length = this.getLength();
        ByteBuffer combinedBuffer = this._bufferPool.acquire(length, this._direct);
        BufferUtil.clearToFill((ByteBuffer)combinedBuffer);
        for (ByteBuffer buffer : this._buffers) {
            void var3_5;
            combinedBuffer.put(buffer);
            this._bufferPool.release((ByteBuffer)var3_5);
        }
        BufferUtil.flipToFlush((ByteBuffer)combinedBuffer, (int)0);
        this._buffers.clear();
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer toByteBuffer() {
        void var1_1;
        ByteBuffer combinedBuffer = this.takeByteBuffer();
        this._buffers.add(combinedBuffer);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] toByteArray() {
        void var1_2;
        void var2_3;
        int length = this.getLength();
        if (length == 0) {
            return new byte[0];
        }
        byte[] bytes = new byte[length];
        ByteBuffer buffer = BufferUtil.toBuffer((byte[])bytes);
        BufferUtil.clear((ByteBuffer)buffer);
        this.writeTo((ByteBuffer)var2_3);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeTo(ByteBuffer buffer) {
        void var2_2;
        void var1_1;
        int pos = BufferUtil.flipToFill((ByteBuffer)buffer);
        for (ByteBuffer bb : this._buffers) {
            buffer.put(bb.slice());
        }
        BufferUtil.flipToFlush((ByteBuffer)var1_1, (int)var2_2);
    }

    public void writeTo(OutputStream out) throws IOException {
        for (ByteBuffer byteBuffer : this._buffers) {
            BufferUtil.writeTo((ByteBuffer)byteBuffer.slice(), (OutputStream)out);
        }
    }

    @Override
    public void close() {
        this._buffers.forEach(this._bufferPool::release);
        this._buffers.clear();
    }
}

