/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.EOFException;
import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.eclipse.jetty.io.AbstractEndPoint;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Locker;
import org.eclipse.jetty.util.thread.Scheduler;

public class ByteArrayEndPoint
extends AbstractEndPoint {
    static final Logger LOG = Log.getLogger(ByteArrayEndPoint.class);
    static final InetAddress NOIP;
    static final InetSocketAddress NOIPPORT;
    private static final int MAX_BUFFER_SIZE = 0x7FFFFBFF;
    private static final ByteBuffer EOF;
    private final Runnable _runFillable = new Runnable(this){
        final /* synthetic */ ByteArrayEndPoint this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public void run() {
            this.this$0.getFillInterest().fillable();
        }
    };
    private final Locker _locker = new Locker();
    private final Condition _hasOutput = this._locker.newCondition();
    private final Queue<ByteBuffer> _inQ = new ArrayDeque<ByteBuffer>();
    private final int _outputSize;
    private ByteBuffer _out;
    private boolean _growOutput;

    public ByteArrayEndPoint() {
        this(null, 0L, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEndPoint(byte[] input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer((byte[])var1_1) : null, BufferUtil.allocate((int)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEndPoint(String input, int outputSize) {
        this(null, 0L, input != null ? BufferUtil.toBuffer((String)var1_1) : null, BufferUtil.allocate((int)var2_2));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEndPoint(Scheduler scheduler, long idleTimeoutMs) {
        this((Scheduler)var1_1, (long)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, byte[] input, int outputSize) {
        this((Scheduler)var1_1, (long)var2_2, input != null ? BufferUtil.toBuffer((byte[])input) : null, BufferUtil.allocate((int)outputSize));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, String input, int outputSize) {
        this((Scheduler)var1_1, (long)var2_2, input != null ? BufferUtil.toBuffer((String)input) : null, BufferUtil.allocate((int)outputSize));
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ByteArrayEndPoint(Scheduler timer, long idleTimeoutMs, ByteBuffer input, ByteBuffer output) {
        super((Scheduler)var1_1);
        void var2_2;
        void var1_1;
        if (BufferUtil.hasContent((ByteBuffer)input)) {
            this.addInput(input);
        }
        this._outputSize = output == null ? 1024 : output.capacity();
        this._out = output == null ? BufferUtil.allocate((int)this._outputSize) : output;
        this.setIdleTimeout((long)var2_2);
        ((IdleTimeout)this).onOpen();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doShutdownOutput() {
        super.doShutdownOutput();
        Locker.Lock lock = this._locker.lock();
        try {
            this._hasOutput.signalAll();
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void doClose() {
        super.doClose();
        Locker.Lock lock = this._locker.lock();
        try {
            this._hasOutput.signalAll();
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return NOIPPORT;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return NOIPPORT;
    }

    @Override
    protected void onIncompleteFlush() {
    }

    /*
     * WARNING - void declaration
     */
    protected void execute(Runnable task) {
        void var1_1;
        new Thread((Runnable)var1_1, "BAEPoint-" + Integer.toHexString(this.hashCode())).start();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void needsFillInterest() throws IOException {
        Locker.Lock lock = this._locker.lock();
        try {
            void var2_3;
            if (!((IdleTimeout)this).isOpen()) {
                throw new ClosedChannelException();
            }
            ByteBuffer in = this._inQ.peek();
            if (BufferUtil.hasContent((ByteBuffer)in) || ByteArrayEndPoint.isEOF((ByteBuffer)var2_3)) {
                ByteArrayEndPoint byteArrayEndPoint = this;
                byteArrayEndPoint.execute(byteArrayEndPoint._runFillable);
            }
            if (lock == null) return;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
    }

    public void addInputEOF() {
        this.addInput((ByteBuffer)null);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addInput(ByteBuffer in) {
        void var2_3;
        block7: {
            boolean fillable = false;
            Locker.Lock lock = this._locker.lock();
            try {
                if (ByteArrayEndPoint.isEOF(this._inQ.peek())) {
                    throw new RuntimeIOException(new EOFException());
                }
                boolean wasEmpty = this._inQ.isEmpty();
                if (in == null) {
                    this._inQ.add(EOF);
                    fillable = true;
                }
                if (BufferUtil.hasContent((ByteBuffer)in)) {
                    void var1_1;
                    this._inQ.add((ByteBuffer)var1_1);
                    fillable = wasEmpty;
                }
                if (lock == null) break block7;
            }
            catch (Throwable throwable) {
                if (lock == null) throw throwable;
                try {
                    void var3_4;
                    var3_4.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            lock.close();
        }
        if (var2_3 == false) return;
        this._runFillable.run();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addInputAndExecute(ByteBuffer in) {
        void var2_3;
        block7: {
            boolean fillable = false;
            Locker.Lock lock = this._locker.lock();
            try {
                if (ByteArrayEndPoint.isEOF(this._inQ.peek())) {
                    throw new RuntimeIOException(new EOFException());
                }
                boolean wasEmpty = this._inQ.isEmpty();
                if (in == null) {
                    this._inQ.add(EOF);
                    fillable = true;
                }
                if (BufferUtil.hasContent((ByteBuffer)in)) {
                    void var1_1;
                    this._inQ.add((ByteBuffer)var1_1);
                    fillable = wasEmpty;
                }
                if (lock == null) break block7;
            }
            catch (Throwable throwable) {
                if (lock == null) throw throwable;
                try {
                    void var3_4;
                    var3_4.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            lock.close();
        }
        if (var2_3 == false) return;
        ByteArrayEndPoint byteArrayEndPoint = this;
        byteArrayEndPoint.execute(byteArrayEndPoint._runFillable);
    }

    /*
     * WARNING - void declaration
     */
    public void addInput(String s) {
        void var1_1;
        this.addInput(BufferUtil.toBuffer((String)var1_1, (Charset)StandardCharsets.UTF_8));
    }

    /*
     * WARNING - void declaration
     */
    public void addInput(String s, Charset charset) {
        void var2_2;
        void var1_1;
        this.addInput(BufferUtil.toBuffer((String)var1_1, (Charset)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer getOutput() {
        ByteBuffer byteBuffer;
        block5: {
            Locker.Lock lock = this._locker.lock();
            try {
                byteBuffer = this._out;
                if (lock == null) break block5;
            }
            catch (Throwable throwable) {
                if (lock != null) {
                    try {
                        void var1_1;
                        var1_1.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            lock.close();
        }
        return byteBuffer;
    }

    public String getOutputString() {
        return this.getOutputString(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String getOutputString(Charset charset) {
        void var1_1;
        return BufferUtil.toString((ByteBuffer)this._out, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteBuffer takeOutput() {
        void var1_3;
        block4: {
            Locker.Lock lock = this._locker.lock();
            try {
                ByteBuffer b = this._out;
                this._out = BufferUtil.allocate((int)this._outputSize);
                if (lock == null) break block4;
            }
            catch (Throwable b) {
                if (lock == null) throw b;
                try {
                    void var2_1;
                    var2_1.close();
                    throw b;
                }
                catch (Throwable throwable) {
                    b.addSuppressed(throwable);
                }
                throw b;
            }
            lock.close();
        }
        this.getWriteFlusher().completeWrite();
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer waitForOutput(long time, TimeUnit unit) throws InterruptedException {
        void var1_2;
        try (Locker.Lock lock = this._locker.lock();){
            while (BufferUtil.isEmpty((ByteBuffer)this._out) && !this.isOutputShutdown()) {
                if (this._hasOutput.await(time, unit)) continue;
                return null;
            }
            ByteBuffer b = this._out;
            this._out = BufferUtil.allocate((int)this._outputSize);
        }
        this.getWriteFlusher().completeWrite();
        return var1_2;
    }

    public String takeOutputString() {
        return this.takeOutputString(StandardCharsets.UTF_8);
    }

    /*
     * WARNING - void declaration
     */
    public String takeOutputString(Charset charset) {
        void var1_1;
        ByteBuffer byteBuffer = this.takeOutput();
        return BufferUtil.toString((ByteBuffer)byteBuffer, (Charset)var1_1);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setOutput(ByteBuffer out) {
        block4: {
            Locker.Lock lock = this._locker.lock();
            try {
                void var1_1;
                this._out = var1_1;
                if (lock == null) break block4;
            }
            catch (Throwable throwable) {
                if (lock == null) throw throwable;
                try {
                    void var2_3;
                    var2_3.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            lock.close();
        }
        this.getWriteFlusher().completeWrite();
    }

    public boolean hasMore() {
        return this.getOutput().position() > 0;
    }

    /*
     * Exception decompiling
     */
    @Override
    public int fill(ByteBuffer buffer) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean flush(ByteBuffer ... buffers) throws IOException {
        void var2_3;
        boolean flushed = true;
        Locker.Lock lock = this._locker.lock();
        try {
            void var1_1;
            if (!((IdleTimeout)this).isOpen()) {
                throw new IOException("CLOSED");
            }
            if (this.isOutputShutdown()) {
                throw new IOException("OSHUT");
            }
            boolean idle = true;
            for (void b : var1_1) {
                if (!BufferUtil.hasContent((ByteBuffer)b)) continue;
                if (this._growOutput && b.remaining() > BufferUtil.space((ByteBuffer)this._out)) {
                    BufferUtil.compact((ByteBuffer)this._out);
                    if (b.remaining() > BufferUtil.space((ByteBuffer)this._out) && this._out.capacity() < 0x7FFFFBFF) {
                        long l = Math.min((long)((double)this._out.capacity() + (double)b.remaining() * 1.5), 0x7FFFFBFFL);
                        ByteBuffer n = BufferUtil.allocate((int)Math.toIntExact(l));
                        BufferUtil.append((ByteBuffer)n, (ByteBuffer)this._out);
                        this._out = n;
                    }
                }
                if (BufferUtil.append((ByteBuffer)this._out, (ByteBuffer)b) > 0) {
                    idle = false;
                }
                if (!BufferUtil.hasContent((ByteBuffer)b)) continue;
                flushed = false;
                break;
            }
            if (!idle) {
                this.notIdle();
                this._hasOutput.signalAll();
            }
            if (lock == null) return (boolean)var2_3;
        }
        catch (Throwable throwable) {
            if (lock == null) throw throwable;
            try {
                void var3_4;
                var3_4.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        lock.close();
        return (boolean)var2_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void reset() {
        block4: {
            Locker.Lock lock = this._locker.lock();
            try {
                this._inQ.clear();
                this._hasOutput.signalAll();
                BufferUtil.clear((ByteBuffer)this._out);
                if (lock == null) break block4;
            }
            catch (Throwable throwable) {
                if (lock == null) throw throwable;
                try {
                    void var1_1;
                    var1_1.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            lock.close();
        }
        super.reset();
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public boolean isGrowOutput() {
        return this._growOutput;
    }

    /*
     * WARNING - void declaration
     */
    public void setGrowOutput(boolean growOutput) {
        void var1_1;
        this._growOutput = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        void var3_6;
        void var2_4;
        void var1_2;
        try (Locker.Lock lock = this._locker.lock();){
            int q = this._inQ.size();
            ByteBuffer b = this._inQ.peek();
            String o = BufferUtil.toDetailString((ByteBuffer)this._out);
        }
        return String.format("%s[q=%d,q[0]=%s,o=%s]", super.toString(), (int)var1_2, var2_4, var3_6);
    }

    private static boolean isEOF(ByteBuffer buffer) {
        boolean bl = buffer == EOF;
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    static {
        try {
            InetAddress noip;
            NOIP = noip = Inet4Address.getByName("0.0.0.0");
            NOIPPORT = new InetSocketAddress(NOIP, 0);
        }
        catch (UnknownHostException e) {
            void var0_1;
            LOG.warn((Throwable)var0_1);
        }
        finally {
            NOIP = null;
            NOIPPORT = new InetSocketAddress(NOIP, 0);
        }
        EOF = BufferUtil.allocate((int)0);
    }
}

