/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.jetty.io.AbstractByteBufferPool;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.component.DumpableCollection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

@ManagedObject
public class ArrayByteBufferPool
extends AbstractByteBufferPool
implements Dumpable {
    private static final Logger LOG = Log.getLogger(ArrayByteBufferPool.class);
    private final int _maxCapacity;
    private final int _minCapacity;
    private final ByteBufferPool.Bucket[] _direct;
    private final ByteBufferPool.Bucket[] _indirect;
    private boolean _detailedDump = false;

    public ArrayByteBufferPool() {
        this(-1, -1, -1);
    }

    /*
     * WARNING - void declaration
     */
    public ArrayByteBufferPool(int minCapacity, int factor, int maxCapacity) {
        this((int)var1_1, (int)var2_2, (int)var3_3, -1, 0L, 0L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayByteBufferPool(int minCapacity, int factor, int maxCapacity, int maxQueueLength) {
        this((int)var1_1, (int)var2_2, (int)var3_3, maxQueueLength, 0L, 0L);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ArrayByteBufferPool(int minCapacity, int factor, int maxCapacity, int maxQueueLength, long maxHeapMemory, long maxDirectMemory) {
        super(factor, maxQueueLength, maxHeapMemory, maxDirectMemory);
        void var3_3;
        factor = this.getCapacityFactor();
        if (minCapacity <= 0) {
            minCapacity = 0;
        }
        if (maxCapacity <= 0) {
            maxCapacity = 65536;
        }
        if (maxCapacity % factor != 0 || factor >= maxCapacity) {
            throw new IllegalArgumentException("The capacity factor must be a divisor of maxCapacity");
        }
        this._maxCapacity = maxCapacity;
        this._minCapacity = minCapacity;
        int length = this.bucketFor((int)var3_3) + 1;
        this._direct = new ByteBufferPool.Bucket[length];
        this._indirect = new ByteBufferPool.Bucket[length];
        for (int i = 0; i < length; ++i) {
            this._direct[i] = this.newBucket(i, true);
            this._indirect[i] = this.newBucket(i, false);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ByteBuffer acquire(int size, boolean direct) {
        void var1_2;
        int n;
        if (size < this._minCapacity) {
            n = size;
        } else {
            ArrayByteBufferPool arrayByteBufferPool = this;
            n = arrayByteBufferPool.capacityFor(arrayByteBufferPool.bucketFor(size));
        }
        int capacity = n;
        ByteBufferPool.Bucket bucket = this.bucketFor(size, direct);
        if (bucket == null) {
            return this.newByteBuffer(capacity, direct);
        }
        ByteBuffer buffer = bucket.acquire();
        if (buffer == null) {
            void var2_3;
            void var3_4;
            return this.newByteBuffer((int)var3_4, (boolean)var2_3);
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void release(ByteBuffer buffer) {
        if (buffer == null) {
            return;
        }
        int capacity = buffer.capacity();
        ArrayByteBufferPool arrayByteBufferPool = this;
        if (capacity != arrayByteBufferPool.capacityFor(arrayByteBufferPool.bucketFor(capacity))) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ByteBuffer {} does not belong to this pool, discarding it", new Object[]{BufferUtil.toDetailString((ByteBuffer)buffer)});
            }
            return;
        }
        if (capacity > this._maxCapacity) {
            return;
        }
        boolean direct = buffer.isDirect();
        ByteBufferPool.Bucket bucket = this.bucketFor(capacity, direct);
        if (bucket != null) {
            void var3_4;
            void var1_1;
            void var2_3;
            var2_3.release((ByteBuffer)var1_1);
            this.releaseExcessMemory((boolean)var3_4, this::releaseMemory);
        }
    }

    /*
     * WARNING - void declaration
     */
    private ByteBufferPool.Bucket newBucket(int key, boolean direct) {
        void var2_2;
        void var1_1;
        ArrayByteBufferPool arrayByteBufferPool = this;
        return new ByteBufferPool.Bucket(arrayByteBufferPool, arrayByteBufferPool.capacityFor((int)var1_1), this.getMaxQueueLength(), this.updateMemory((boolean)var2_2));
    }

    @Override
    public void clear() {
        super.clear();
        for (int i = 0; i < this._direct.length; ++i) {
            this._direct[i].clear();
            this._indirect[i].clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void releaseMemory(boolean direct) {
        long oldest = Long.MAX_VALUE;
        int index = -1;
        ByteBufferPool.Bucket[] buckets = this.bucketsFor(direct);
        for (int i = 0; i < buckets.length; ++i) {
            long lastUpdate;
            ByteBufferPool.Bucket bucket = buckets[i];
            if (bucket.isEmpty() || (lastUpdate = bucket.getLastUpdate()) >= oldest) continue;
            oldest = lastUpdate;
            index = i;
        }
        if (index >= 0) {
            void var1_2;
            void var5_6 = var1_2[index];
            var5_6.clear();
        }
    }

    protected int bucketFor(int capacity) {
        return (int)Math.ceil((double)capacity / (double)this.getCapacityFactor());
    }

    protected int capacityFor(int bucket) {
        return bucket * this.getCapacityFactor();
    }

    /*
     * WARNING - void declaration
     */
    private ByteBufferPool.Bucket bucketFor(int capacity, boolean direct) {
        void var1_1;
        void var2_2;
        if (capacity < this._minCapacity) {
            return null;
        }
        int bucket = this.bucketFor(capacity);
        if (bucket >= this._direct.length) {
            return null;
        }
        ByteBufferPool.Bucket[] bucketArray = this.bucketsFor((boolean)var2_2);
        return bucketArray[var1_1];
    }

    @ManagedAttribute(value="The number of pooled direct ByteBuffers")
    public long getDirectByteBufferCount() {
        return this.getByteBufferCount(true);
    }

    @ManagedAttribute(value="The number of pooled heap ByteBuffers")
    public long getHeapByteBufferCount() {
        return this.getByteBufferCount(false);
    }

    /*
     * WARNING - void declaration
     */
    private long getByteBufferCount(boolean direct) {
        void var1_1;
        return Arrays.stream(this.bucketsFor((boolean)var1_1)).filter(Objects::nonNull).mapToLong(ByteBufferPool.Bucket::size).sum();
    }

    ByteBufferPool.Bucket[] bucketsFor(boolean direct) {
        if (direct) {
            return this._direct;
        }
        return this._indirect;
    }

    public boolean isDetailedDump() {
        return this._detailedDump;
    }

    /*
     * WARNING - void declaration
     */
    public void setDetailedDump(boolean detailedDump) {
        void var1_1;
        this._detailedDump = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void dump(Appendable out, String indent) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        ArrayList<String> dump = new ArrayList<String>();
        dump.add(String.format("HeapMemory: %d/%d", this.getHeapMemory(), this.getMaxHeapMemory()));
        dump.add(String.format("DirectMemory: %d/%d", this.getDirectMemory(), this.getMaxDirectMemory()));
        List indirect = Arrays.stream(this._indirect).filter(b -> !b.isEmpty()).collect(Collectors.toList());
        List direct = Arrays.stream(this._direct).filter(b -> !b.isEmpty()).collect(Collectors.toList());
        if (this.isDetailedDump()) {
            dump.add((String)new DumpableCollection("Indirect Buckets", indirect));
            dump.add((String)new DumpableCollection("Direct Buckets", direct));
        } else {
            dump.add("Indirect Buckets size=" + indirect.size());
            dump.add("Direct Buckets size=" + direct.size());
        }
        Dumpable.dumpObjects((Appendable)var1_1, (String)var2_2, (Object)this, (Object[])new Object[]{var3_3});
    }

    public String toString() {
        return String.format("%s@%x{minBufferCapacity=%s, maxBufferCapacity=%s, maxQueueLength=%s, factor=%s}", this.getClass().getSimpleName(), this.hashCode(), this._minCapacity, this._maxCapacity, this.getMaxQueueLength(), this.getCapacityFactor());
    }
}

