/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.IdleTimeout;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Scheduler;

public abstract class AbstractEndPoint
extends IdleTimeout
implements EndPoint {
    private static final Logger LOG = Log.getLogger(AbstractEndPoint.class);
    private final AtomicReference<State> _state = new AtomicReference<State>(State.OPEN);
    private final long _created = System.currentTimeMillis();
    private volatile Connection _connection;
    private final FillInterest _fillInterest = new FillInterest(this){
        final /* synthetic */ AbstractEndPoint this$0;
        {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        protected void needsFillInterest() throws IOException {
            this.this$0.needsFillInterest();
        }
    };
    private final WriteFlusher _writeFlusher;

    /*
     * WARNING - void declaration
     */
    protected AbstractEndPoint(Scheduler scheduler) {
        super((Scheduler)var1_1);
        void var1_1;
        AbstractEndPoint abstractEndPoint = this;
        this._writeFlusher = new WriteFlusher(abstractEndPoint, abstractEndPoint){
            final /* synthetic */ AbstractEndPoint this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((EndPoint)var2_2);
            }

            @Override
            protected void onIncompleteFlush() {
                this.this$0.onIncompleteFlush();
            }
        };
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void shutdownInput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutdownInput {}", new Object[]{this});
        }
        block9: while (true) {
            State s2 = this._state.get();
            switch (s2) {
                case OPEN: {
                    if (!this._state.compareAndSet(s2, State.ISHUTTING)) continue block9;
                    try {
                        this.doShutdownInput();
                        if (this._state.compareAndSet(State.ISHUTTING, State.ISHUT)) return;
                        if (this._state.get() != State.CLOSED) throw new IllegalStateException();
                        this.doOnClose(null);
                        return;
                    }
                    catch (Throwable s2) {
                        if (this._state.compareAndSet(State.ISHUTTING, State.ISHUT)) throw s2;
                        if (this._state.get() != State.CLOSED) throw new IllegalStateException();
                        this.doOnClose(null);
                        throw s2;
                    }
                }
                case ISHUTTING: 
                case ISHUT: {
                    return;
                }
                case OSHUTTING: {
                    if (!this._state.compareAndSet(s2, State.CLOSED)) continue block9;
                    return;
                }
                case OSHUT: {
                    void var1_1;
                    if (!this._state.compareAndSet((State)var1_1, State.CLOSED)) continue block9;
                    this.doOnClose(null);
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void shutdownOutput() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("shutdownOutput {}", new Object[]{this});
        }
        block9: while (true) {
            State s2 = this._state.get();
            switch (s2) {
                case OPEN: {
                    if (!this._state.compareAndSet(s2, State.OSHUTTING)) continue block9;
                    try {
                        this.doShutdownOutput();
                        if (this._state.compareAndSet(State.OSHUTTING, State.OSHUT)) return;
                        if (this._state.get() != State.CLOSED) throw new IllegalStateException();
                        this.doOnClose(null);
                        return;
                    }
                    catch (Throwable s2) {
                        if (this._state.compareAndSet(State.OSHUTTING, State.OSHUT)) throw s2;
                        if (this._state.get() != State.CLOSED) throw new IllegalStateException();
                        this.doOnClose(null);
                        throw s2;
                    }
                }
                case ISHUTTING: {
                    if (!this._state.compareAndSet(s2, State.CLOSED)) continue block9;
                    return;
                }
                case ISHUT: {
                    void var1_1;
                    if (!this._state.compareAndSet((State)var1_1, State.CLOSED)) continue block9;
                    this.doOnClose(null);
                    return;
                }
                case OSHUTTING: 
                case OSHUT: {
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
        }
    }

    @Override
    public final void close() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close {}", new Object[]{this});
        }
        this.close(null);
    }

    /*
     * WARNING - void declaration
     */
    protected final void close(Throwable failure) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("close({}) {}", new Object[]{failure, this});
        }
        block5: while (true) {
            State s = this._state.get();
            switch (s) {
                case OPEN: 
                case ISHUT: 
                case OSHUT: {
                    if (!this._state.compareAndSet(s, State.CLOSED)) continue block5;
                    this.doOnClose(failure);
                    return;
                }
                case ISHUTTING: 
                case OSHUTTING: {
                    void var2_2;
                    if (!this._state.compareAndSet((State)var2_2, State.CLOSED)) continue block5;
                    return;
                }
                case CLOSED: {
                    return;
                }
            }
        }
    }

    protected void doShutdownInput() {
    }

    protected void doShutdownOutput() {
    }

    /*
     * WARNING - void declaration
     */
    private void doOnClose(Throwable failure) {
        try {
            this.doClose();
            if (failure == null) {
                ((IdleTimeout)this).onClose();
                return;
            }
            this.onClose(failure);
            return;
        }
        catch (Throwable throwable) {
            if (failure == null) {
                ((IdleTimeout)this).onClose();
            } else {
                void var1_1;
                this.onClose((Throwable)var1_1);
            }
            throw throwable;
        }
    }

    protected void doClose() {
    }

    /*
     * WARNING - void declaration
     */
    protected void onClose(Throwable failure) {
        void var1_1;
        super.onClose();
        this._writeFlusher.onFail(failure);
        this._fillInterest.onFail((Throwable)var1_1);
    }

    @Override
    public boolean isOutputShutdown() {
        switch (this._state.get()) {
            case OSHUTTING: 
            case OSHUT: 
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isInputShutdown() {
        switch (this._state.get()) {
            case ISHUTTING: 
            case ISHUT: 
            case CLOSED: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isOpen() {
        switch (this._state.get()) {
            case CLOSED: {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void checkFlush() throws IOException {
        State s = this._state.get();
        switch (s) {
            case OSHUTTING: 
            case OSHUT: 
            case CLOSED: {
                void var1_1;
                throw new IOException(var1_1.toString());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void checkFill() throws IOException {
        State s = this._state.get();
        switch (s) {
            case ISHUTTING: 
            case ISHUT: 
            case CLOSED: {
                void var1_1;
                throw new IOException(var1_1.toString());
            }
        }
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    @Override
    public Connection getConnection() {
        return this._connection;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setConnection(Connection connection) {
        void var1_1;
        this._connection = var1_1;
    }

    @Override
    public boolean isOptimizedForDirectBuffers() {
        return false;
    }

    protected void reset() {
        this._state.set(State.OPEN);
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", new Object[]{this});
        }
        if (this._state.get() != State.OPEN) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void onClose() {
        super.onClose();
        this._writeFlusher.onClose();
        this._fillInterest.onClose();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void fillInterested(Callback callback) {
        void var1_1;
        this.notIdle();
        this._fillInterest.register((Callback)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean tryFillInterested(Callback callback) {
        void var1_1;
        this.notIdle();
        return this._fillInterest.tryRegister((Callback)var1_1);
    }

    @Override
    public boolean isFillInterested() {
        return this._fillInterest.isInterested();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void write(Callback callback, ByteBuffer ... buffers) throws IllegalStateException {
        void var2_2;
        void var1_1;
        this._writeFlusher.write((Callback)var1_1, (ByteBuffer[])var2_2);
    }

    protected abstract void onIncompleteFlush();

    protected abstract void needsFillInterest() throws IOException;

    public FillInterest getFillInterest() {
        return this._fillInterest;
    }

    public WriteFlusher getWriteFlusher() {
        return this._writeFlusher;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void onIdleExpired(TimeoutException timeout) {
        void var1_2;
        void var3_5;
        void var2_4;
        Connection connection = this._connection;
        if (connection != null && !connection.onIdleExpired()) {
            return;
        }
        boolean outputShutdown = this.isOutputShutdown();
        boolean inputShutdown = this.isInputShutdown();
        boolean fillFailed = this._fillInterest.onFail(timeout);
        boolean writeFailed = this._writeFlusher.onFail(timeout);
        if (((IdleTimeout)this).isOpen() && (var2_4 != false || var3_5 != false) && !fillFailed && var1_2 == false) {
            this.close();
            return;
        }
        LOG.debug("Ignored idle endpoint {}", new Object[]{this});
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void upgrade(Connection newConnection) {
        void var1_1;
        void var2_2;
        Connection oldConnection = this.getConnection();
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} upgrading from {} to {}", new Object[]{this, oldConnection, newConnection});
        }
        ByteBuffer buffer = oldConnection instanceof Connection.UpgradeFrom ? ((Connection.UpgradeFrom)((Object)oldConnection)).onUpgradeFrom() : null;
        oldConnection.onClose();
        var2_2.getEndPoint().setConnection(newConnection);
        if (BufferUtil.hasContent((ByteBuffer)buffer)) {
            if (newConnection instanceof Connection.UpgradeTo) {
                void var3_3;
                ((Connection.UpgradeTo)((Object)newConnection)).onUpgradeTo((ByteBuffer)var3_3);
            } else {
                throw new IllegalStateException("Cannot upgrade: " + newConnection + " does not implement " + Connection.UpgradeTo.class.getName());
            }
        }
        var1_1.onOpen();
    }

    public String toString() {
        return String.format("%s->%s", this.toEndPointString(), this.toConnectionString());
    }

    /*
     * WARNING - void declaration
     */
    public String toEndPointString() {
        void var2_2;
        Class<?> c = this.getClass();
        String name = c.getSimpleName();
        while (name.length() == 0 && c.getSuperclass() != null) {
            c = c.getSuperclass();
            name = c.getSimpleName();
        }
        return String.format("%s@%h{l=%s,r=%s,%s,fill=%s,flush=%s,to=%d/%d}", new Object[]{var2_2, this, this.getLocalAddress(), this.getRemoteAddress(), this._state.get(), this._fillInterest.toStateString(), this._writeFlusher.toStateString(), this.getIdleFor(), this.getIdleTimeout()});
    }

    /*
     * WARNING - void declaration
     */
    public String toConnectionString() {
        void var1_1;
        Connection connection = this.getConnection();
        if (connection == null) {
            return "<null>";
        }
        if (connection instanceof AbstractConnection) {
            return ((AbstractConnection)connection).toConnectionString();
        }
        return String.format("%s@%x", connection.getClass().getSimpleName(), var1_1.hashCode());
    }

    private static enum State {
        OPEN,
        ISHUTTING,
        ISHUT,
        OSHUTTING,
        OSHUT,
        CLOSED;

    }
}

