/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.Invocable;

public abstract class AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(AbstractConnection.class);
    private final List<Connection.Listener> _listeners = new CopyOnWriteArrayList<Connection.Listener>();
    private final long _created = System.currentTimeMillis();
    private final EndPoint _endPoint;
    private final Executor _executor;
    private final Callback _readCallback;
    private int _inputBufferSize = 2048;

    /*
     * WARNING - void declaration
     */
    protected AbstractConnection(EndPoint endp, Executor executor) {
        void var2_2;
        void var1_1;
        if (executor == null) {
            throw new IllegalArgumentException("Executor must not be null!");
        }
        this._endPoint = var1_1;
        this._executor = var2_2;
        this._readCallback = new ReadCallback();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addListener(Connection.Listener listener) {
        void var1_1;
        this._listeners.add((Connection.Listener)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeListener(Connection.Listener listener) {
        void var1_1;
        this._listeners.remove(var1_1);
    }

    public int getInputBufferSize() {
        return this._inputBufferSize;
    }

    /*
     * WARNING - void declaration
     */
    public void setInputBufferSize(int inputBufferSize) {
        void var1_1;
        this._inputBufferSize = var1_1;
    }

    protected Executor getExecutor() {
        return this._executor;
    }

    /*
     * WARNING - void declaration
     */
    protected void failedCallback(Callback callback, Throwable x) {
        Runnable failCallback = () -> {
            try {
                void var1_2;
                callback.failed((Throwable)var1_2);
                return;
            }
            catch (Exception e) {
                void var0_1;
                LOG.warn((Throwable)var0_1);
                return;
            }
        };
        switch (Invocable.getInvocationType((Object)callback)) {
            case BLOCKING: {
                try {
                    this.getExecutor().execute(failCallback);
                    return;
                }
                catch (RejectedExecutionException e) {
                    void var2_2;
                    void var1_1;
                    void var3_4;
                    LOG.debug((Throwable)var3_4);
                    var1_1.failed((Throwable)var2_2);
                    return;
                }
            }
            case NON_BLOCKING: {
                void var3_3;
                var3_3.run();
                return;
            }
            case EITHER: {
                void var3_3;
                Invocable.invokeNonBlocking((Runnable)var3_3);
            }
        }
    }

    public void fillInterested() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("fillInterested {}", new Object[]{this});
        }
        this.getEndPoint().fillInterested(this._readCallback);
    }

    public void tryFillInterested() {
        AbstractConnection abstractConnection = this;
        abstractConnection.tryFillInterested(abstractConnection._readCallback);
    }

    /*
     * WARNING - void declaration
     */
    public void tryFillInterested(Callback callback) {
        void var1_1;
        this.getEndPoint().tryFillInterested((Callback)var1_1);
    }

    public boolean isFillInterested() {
        return this.getEndPoint().isFillInterested();
    }

    public abstract void onFillable();

    /*
     * WARNING - void declaration
     */
    protected void onFillInterestedFailed(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} onFillInterestedFailed {}", new Object[]{this, cause});
        }
        if (this._endPoint.isOpen()) {
            void var2_2;
            boolean close = true;
            if (cause instanceof TimeoutException) {
                void var1_1;
                close = this.onReadTimeout((Throwable)var1_1);
            }
            if (var2_2 != false) {
                if (this._endPoint.isOutputShutdown()) {
                    this._endPoint.close();
                    return;
                }
                this._endPoint.shutdownOutput();
                this.fillInterested();
            }
        }
    }

    protected boolean onReadTimeout(Throwable timeout) {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", new Object[]{this});
        }
        for (Connection.Listener listener : this._listeners) {
            void var2_2;
            this.onOpened((Connection.Listener)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onOpened(Connection.Listener listener) {
        try {
            listener.onOpened(this);
            return;
        }
        catch (Throwable x) {
            void var2_2;
            void var1_1;
            LOG.info("Failure while notifying listener " + var1_1, (Throwable)var2_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onClose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", new Object[]{this});
        }
        for (Connection.Listener listener : this._listeners) {
            void var2_2;
            this.onClosed((Connection.Listener)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void onClosed(Connection.Listener listener) {
        try {
            listener.onClosed(this);
            return;
        }
        catch (Throwable x) {
            void var2_2;
            void var1_1;
            LOG.info("Failure while notifying listener " + var1_1, (Throwable)var2_2);
            return;
        }
    }

    @Override
    public EndPoint getEndPoint() {
        return this._endPoint;
    }

    @Override
    public void close() {
        this.getEndPoint().close();
    }

    @Override
    public boolean onIdleExpired() {
        return true;
    }

    @Override
    public long getMessagesIn() {
        return -1L;
    }

    @Override
    public long getMessagesOut() {
        return -1L;
    }

    @Override
    public long getBytesIn() {
        return -1L;
    }

    @Override
    public long getBytesOut() {
        return -1L;
    }

    @Override
    public long getCreatedTimeStamp() {
        return this._created;
    }

    public final String toString() {
        return String.format("%s@%h::%s", this.getClass().getSimpleName(), this, this.getEndPoint());
    }

    public String toConnectionString() {
        return String.format("%s@%h", this.getClass().getSimpleName(), this);
    }

    private class ReadCallback
    implements Callback {
        private ReadCallback() {
        }

        public void succeeded() {
            AbstractConnection.this.onFillable();
        }

        /*
         * WARNING - void declaration
         */
        public void failed(Throwable x) {
            void var1_1;
            AbstractConnection.this.onFillInterestedFailed((Throwable)var1_1);
        }

        public String toString() {
            return String.format("AC.ReadCB@%h{%s}", AbstractConnection.this, AbstractConnection.this);
        }
    }
}

