/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io;

import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.annotation.ManagedOperation;

@ManagedObject
abstract class AbstractByteBufferPool
implements ByteBufferPool {
    private final int _factor;
    private final int _maxQueueLength;
    private final long _maxHeapMemory;
    private final long _maxDirectMemory;
    private final AtomicLong _heapMemory = new AtomicLong();
    private final AtomicLong _directMemory = new AtomicLong();

    /*
     * WARNING - void declaration
     */
    protected AbstractByteBufferPool(int factor, int maxQueueLength, long maxHeapMemory, long maxDirectMemory) {
        long l;
        void var2_2;
        void var1_1;
        this._factor = factor <= 0 ? 1024 : var1_1;
        this._maxQueueLength = var2_2;
        this._maxHeapMemory = maxHeapMemory != 0L ? l : Runtime.getRuntime().maxMemory() / 4L;
        this._maxDirectMemory = maxDirectMemory != 0L ? maxDirectMemory : Runtime.getRuntime().maxMemory() / 4L;
    }

    protected int getCapacityFactor() {
        return this._factor;
    }

    protected int getMaxQueueLength() {
        return this._maxQueueLength;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected void decrementMemory(ByteBuffer buffer) {
        void var1_1;
        this.updateMemory((ByteBuffer)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected void incrementMemory(ByteBuffer buffer) {
        void var1_1;
        this.updateMemory((ByteBuffer)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private void updateMemory(ByteBuffer buffer, boolean addOrSub) {
        void var1_2;
        void var2_3;
        void var3_4;
        AtomicLong memory = buffer.isDirect() ? this._directMemory : this._heapMemory;
        int capacity = buffer.capacity();
        var3_4.addAndGet(var2_3 != false ? (long)capacity : (long)(-var1_2));
    }

    protected void releaseExcessMemory(boolean direct, Consumer<Boolean> clearFn) {
        long maxMemory = direct ? this._maxDirectMemory : this._maxHeapMemory;
        if (maxMemory > 0L) {
            while (this.getMemory(direct) > maxMemory) {
                clearFn.accept(direct);
            }
        }
    }

    @ManagedAttribute(value="The bytes retained by direct ByteBuffers")
    public long getDirectMemory() {
        return this.getMemory(true);
    }

    @ManagedAttribute(value="The bytes retained by heap ByteBuffers")
    public long getHeapMemory() {
        return this.getMemory(false);
    }

    @ManagedAttribute(value="The max num of bytes that can be retained from direct ByteBuffers")
    public long getMaxDirectMemory() {
        return this._maxDirectMemory;
    }

    @ManagedAttribute(value="The max num of bytes that can be retained from heap ByteBuffers")
    public long getMaxHeapMemory() {
        return this._maxHeapMemory;
    }

    public long getMemory(boolean direct) {
        AtomicLong atomicLong = direct ? this._directMemory : this._heapMemory;
        return atomicLong.get();
    }

    IntConsumer updateMemory(boolean direct) {
        if (direct) {
            return this._directMemory::addAndGet;
        }
        return this._heapMemory::addAndGet;
    }

    @ManagedOperation(value="Clears this ByteBufferPool", impact="ACTION")
    public void clear() {
        this._heapMemory.set(0L);
        this._directMemory.set(0L);
    }
}

