/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.ws;

import java.io.Closeable;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.SocketTimeoutException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.ws.WebSocketExtensions;
import okhttp3.internal.ws.WebSocketProtocol;
import okhttp3.internal.ws.WebSocketReader;
import okhttp3.internal.ws.WebSocketWriter;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u001e\u0018\u0000 c2\u00020\u00012\u00020\u0002:\u0005bcdefBG\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0011J\b\u00107\u001a\u000208H\u0016J\u001f\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;2\b\u0010<\u001a\u0004\u0018\u00010=H\u0000\u00a2\u0006\u0002\b>J\u001a\u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020*2\b\u0010A\u001a\u0004\u0018\u00010\u001dH\u0016J \u0010?\u001a\u00020\u00132\u0006\u0010@\u001a\u00020*2\b\u0010A\u001a\u0004\u0018\u00010\u001d2\u0006\u0010B\u001a\u00020\fJ\u000e\u0010C\u001a\u0002082\u0006\u0010D\u001a\u00020EJ(\u0010F\u001a\u0002082\n\u0010G\u001a\u00060Hj\u0002`I2\n\b\u0002\u0010:\u001a\u0004\u0018\u00010;2\b\b\u0002\u0010J\u001a\u00020\u0013J\u0006\u0010K\u001a\u000208J\u0016\u0010L\u001a\u0002082\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010/\u001a\u000200J\u000e\u0010M\u001a\u0002082\u0006\u0010:\u001a\u00020;J\u0018\u0010N\u001a\u0002082\u0006\u0010@\u001a\u00020*2\u0006\u0010A\u001a\u00020\u001dH\u0016J\u0010\u0010O\u001a\u0002082\u0006\u0010P\u001a\u00020\u001dH\u0016J\u0010\u0010O\u001a\u0002082\u0006\u0010Q\u001a\u00020%H\u0016J\u0010\u0010R\u001a\u0002082\u0006\u0010S\u001a\u00020%H\u0016J\u0010\u0010T\u001a\u0002082\u0006\u0010S\u001a\u00020%H\u0016J\u000e\u0010U\u001a\u00020\u00132\u0006\u0010S\u001a\u00020%J\u0006\u0010V\u001a\u00020\u0013J\b\u0010&\u001a\u00020\fH\u0016J\u0006\u0010,\u001a\u00020*J\u0006\u0010-\u001a\u00020*J\b\u0010W\u001a\u00020\u0006H\u0016J\b\u0010X\u001a\u000208H\u0002J\u0010\u0010Y\u001a\u00020\u00132\u0006\u0010P\u001a\u00020\u001dH\u0016J\u0010\u0010Y\u001a\u00020\u00132\u0006\u0010Q\u001a\u00020%H\u0016J\u0018\u0010Y\u001a\u00020\u00132\u0006\u0010Z\u001a\u00020%2\u0006\u0010[\u001a\u00020*H\u0002J\u0006\u0010.\u001a\u00020*J\u0006\u0010\\\u001a\u000208J\r\u0010]\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b^J\r\u0010_\u001a\u000208H\u0000\u00a2\u0006\u0002\b`J\f\u0010a\u001a\u00020\u0013*\u00020\u000eH\u0002R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020%0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010+\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u0004\u0018\u000100X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000202X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00103\u001a\u0004\u0018\u000104X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u00105\u001a\u0004\u0018\u000106X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006g"}, d2={"Lokhttp3/internal/ws/RealWebSocket;", "Lokhttp3/WebSocket;", "Lokhttp3/internal/ws/WebSocketReader$FrameCallback;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "originalRequest", "Lokhttp3/Request;", "listener", "Lokhttp3/WebSocketListener;", "random", "Ljava/util/Random;", "pingIntervalMillis", "", "extensions", "Lokhttp3/internal/ws/WebSocketExtensions;", "minimumDeflateSize", "webSocketCloseTimeout", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/Request;Lokhttp3/WebSocketListener;Ljava/util/Random;JLokhttp3/internal/ws/WebSocketExtensions;JJ)V", "awaitingPong", "", "call", "Lokhttp3/Call;", "getCall$okhttp", "()Lokhttp3/Call;", "setCall$okhttp", "(Lokhttp3/Call;)V", "enqueuedClose", "failed", "key", "", "getListener$okhttp", "()Lokhttp3/WebSocketListener;", "messageAndCloseQueue", "Ljava/util/ArrayDeque;", "", "name", "pongQueue", "Lokio/ByteString;", "queueSize", "reader", "Lokhttp3/internal/ws/WebSocketReader;", "receivedCloseCode", "", "receivedCloseReason", "receivedPingCount", "receivedPongCount", "sentPingCount", "streams", "Lokhttp3/internal/ws/RealWebSocket$Streams;", "taskQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "writer", "Lokhttp3/internal/ws/WebSocketWriter;", "writerTask", "Lokhttp3/internal/concurrent/Task;", "cancel", "", "checkUpgradeSuccess", "response", "Lokhttp3/Response;", "exchange", "Lokhttp3/internal/connection/Exchange;", "checkUpgradeSuccess$okhttp", "close", "code", "reason", "cancelAfterCloseMillis", "connect", "client", "Lokhttp3/OkHttpClient;", "failWebSocket", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "isWriter", "finishReader", "initReaderAndWriter", "loopReader", "onReadClose", "onReadMessage", "text", "bytes", "onReadPing", "payload", "onReadPong", "pong", "processNextFrame", "request", "runWriter", "send", "data", "formatOpcode", "tearDown", "writeOneFrame", "writeOneFrame$okhttp", "writePingFrame", "writePingFrame$okhttp", "isValid", "Close", "Companion", "Message", "Streams", "WriterTask", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealWebSocket.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,729:1\n1#2:730\n353#3,4:731\n*S KotlinDebug\n*F\n+ 1 RealWebSocket.kt\nokhttp3/internal/ws/RealWebSocket\n*L\n503#1:731,4\n*E\n"})
public final class RealWebSocket
implements WebSocket,
WebSocketReader.FrameCallback {
    public static final Companion Companion = new Companion(null);
    private final Request originalRequest;
    private final WebSocketListener listener;
    private final Random random;
    private final long pingIntervalMillis;
    private WebSocketExtensions extensions;
    private long minimumDeflateSize;
    private final long webSocketCloseTimeout;
    private final String key;
    private Call call;
    private Task writerTask;
    private WebSocketReader reader;
    private WebSocketWriter writer;
    private TaskQueue taskQueue;
    private String name;
    private Streams streams;
    private final ArrayDeque<ByteString> pongQueue;
    private final ArrayDeque<Object> messageAndCloseQueue;
    private long queueSize;
    private boolean enqueuedClose;
    private int receivedCloseCode;
    private String receivedCloseReason;
    private boolean failed;
    private int sentPingCount;
    private int receivedPingCount;
    private int receivedPongCount;
    private boolean awaitingPong;
    private static final List<Protocol> ONLY_HTTP1 = CollectionsKt.listOf((Object)((Object)Protocol.HTTP_1_1));
    private static final long MAX_QUEUE_SIZE = 0x1000000L;
    public static final long CANCEL_AFTER_CLOSE_MILLIS = 60000L;
    public static final long DEFAULT_MINIMUM_DEFLATE_SIZE = 1024L;

    /*
     * WARNING - void declaration
     */
    public RealWebSocket(TaskRunner taskRunner, Request originalRequest, WebSocketListener listener, Random random, long pingIntervalMillis, WebSocketExtensions extensions, long minimumDeflateSize, long webSocketCloseTimeout) {
        void var2_2;
        byte[] byArray;
        RealWebSocket realWebSocket;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        this.originalRequest = originalRequest;
        this.listener = realWebSocket;
        this.random = random;
        this.pingIntervalMillis = pingIntervalMillis;
        this.extensions = extensions;
        this.minimumDeflateSize = minimumDeflateSize;
        this.webSocketCloseTimeout = webSocketCloseTimeout;
        this.taskQueue = byArray.newQueue();
        this.pongQueue = new ArrayDeque();
        this.messageAndCloseQueue = new ArrayDeque();
        this.receivedCloseCode = -1;
        if (!Intrinsics.areEqual((Object)"GET", (Object)this.originalRequest.method())) {
            originalRequest = "Request must be GET: " + this.originalRequest.method();
            throw new IllegalArgumentException(originalRequest.toString());
        }
        byArray = new byte[16];
        originalRequest = byArray;
        ByteString.Companion companion = ByteString.Companion;
        realWebSocket = this;
        this.random.nextBytes((byte[])var2_2);
        realWebSocket.key = ByteString.Companion.of$default((ByteString.Companion)companion, (byte[])byArray, (int)0, (int)0, (int)3, null).base64();
    }

    public final WebSocketListener getListener$okhttp() {
        return this.listener;
    }

    public final Call getCall$okhttp() {
        return this.call;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCall$okhttp(Call call) {
        void var1_1;
        this.call = var1_1;
    }

    @Override
    public final Request request() {
        return this.originalRequest;
    }

    @Override
    public final synchronized long queueSize() {
        return this.queueSize;
    }

    @Override
    public final void cancel() {
        Call call = this.call;
        Intrinsics.checkNotNull((Object)call);
        call.cancel();
    }

    /*
     * WARNING - void declaration
     */
    public final void connect(OkHttpClient client) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        if (this.originalRequest.header("Sec-WebSocket-Extensions") != null) {
            RealWebSocket.failWebSocket$default(this, new ProtocolException("Request header not permitted: 'Sec-WebSocket-Extensions'"), null, false, 6, null);
            return;
        }
        OkHttpClient webSocketClient = client.newBuilder().eventListener(EventListener.NONE).protocols(ONLY_HTTP1).build();
        Request request = this.originalRequest.newBuilder().header("Upgrade", "websocket").header("Connection", "Upgrade").header("Sec-WebSocket-Key", this.key).header("Sec-WebSocket-Version", "13").header("Sec-WebSocket-Extensions", "permessage-deflate").build();
        Call call = this.call = (Call)new RealCall((OkHttpClient)var1_1, request, true);
        Intrinsics.checkNotNull((Object)call);
        call.enqueue(new Callback(this, (Request)var2_2){
            final /* synthetic */ RealWebSocket this$0;
            final /* synthetic */ Request $request;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$request = var2_2;
            }

            /*
             * WARNING - void declaration
             */
            public final void onResponse(Call call, Response response) {
                void var2_2;
                void var3_4;
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                Object exchange = response.exchange();
                try {
                    this.this$0.checkUpgradeSuccess$okhttp(response, (Exchange)exchange);
                    Exchange exchange2 = exchange;
                    Intrinsics.checkNotNull((Object)exchange2);
                    Streams streams = exchange2.newWebSocketStreams();
                }
                catch (IOException e) {
                    RealWebSocket.failWebSocket$default(this.this$0, e, response, false, 4, null);
                    _UtilCommonKt.closeQuietly(response);
                    Exchange exchange3 = exchange;
                    if (exchange3 != null) {
                        exchange3.webSocketUpgradeFailed();
                        return;
                    }
                    return;
                }
                WebSocketExtensions extensions = WebSocketExtensions.Companion.parse(response.headers());
                RealWebSocket.access$setExtensions$p(this.this$0, extensions);
                if (!RealWebSocket.access$isValid(this.this$0, extensions)) {
                    exchange = this.this$0;
                    RealWebSocket realWebSocket = this.this$0;
                    synchronized (exchange) {
                        RealWebSocket.access$getMessageAndCloseQueue$p(realWebSocket).clear();
                        realWebSocket.close(1010, "unexpected Sec-WebSocket-Extensions in response header");
                    }
                }
                String name = _UtilJvmKt.okHttpName + " WebSocket " + this.$request.url().redact();
                this.this$0.initReaderAndWriter((String)var1_1, (Streams)var3_4);
                this.this$0.loopReader((Response)var2_2);
            }

            /*
             * WARNING - void declaration
             */
            public final void onFailure(Call call, IOException e) {
                void var2_2;
                Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                RealWebSocket.failWebSocket$default(this.this$0, (Exception)var2_2, null, false, 6, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isValid(WebSocketExtensions $this$isValid) {
        void var1_1;
        if ($this$isValid.unknownValues) {
            return false;
        }
        if ($this$isValid.clientMaxWindowBits != null) {
            return false;
        }
        return $this$isValid.serverMaxWindowBits == null || new IntRange(8, 15).contains(var1_1.serverMaxWindowBits.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public final void checkUpgradeSuccess$okhttp(Response response, Exchange exchange) throws IOException {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (response.code() != 101) {
            throw new ProtocolException("Expected HTTP 101 response but was '" + response.code() + ' ' + response.message() + '\'');
        }
        String headerConnection = Response.header$default(response, "Connection", null, 2, null);
        if (!StringsKt.equals((String)"Upgrade", (String)headerConnection, (boolean)true)) {
            throw new ProtocolException("Expected 'Connection' header value 'Upgrade' but was '" + headerConnection + '\'');
        }
        String headerUpgrade = Response.header$default(response, "Upgrade", null, 2, null);
        if (!StringsKt.equals((String)"websocket", (String)headerUpgrade, (boolean)true)) {
            throw new ProtocolException("Expected 'Upgrade' header value 'websocket' but was '" + headerUpgrade + '\'');
        }
        String headerAccept = Response.header$default(response, "Sec-WebSocket-Accept", null, 2, null);
        String acceptExpected = ByteString.Companion.encodeUtf8(this.key + "258EAFA5-E914-47DA-95CA-C5AB0DC85B11").sha1().base64();
        if (!Intrinsics.areEqual((Object)acceptExpected, (Object)headerAccept)) {
            void var1_1;
            void var3_3;
            throw new ProtocolException("Expected 'Sec-WebSocket-Accept' header value '" + (String)var3_3 + "' but was '" + (String)var1_1 + '\'');
        }
        if (var2_2 == null) {
            throw new ProtocolException("Web Socket exchange missing: bad interceptor?");
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void initReaderAndWriter(String name, Streams streams) {
        void var2_3;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)streams, (String)"streams");
        WebSocketExtensions webSocketExtensions = this.extensions;
        Intrinsics.checkNotNull((Object)webSocketExtensions);
        WebSocketExtensions extensions = webSocketExtensions;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            this.name = name;
            this.streams = streams;
            this.writer = new WebSocketWriter(streams.getClient(), streams.getSink(), this.random, extensions.perMessageDeflate, extensions.noContextTakeover(streams.getClient()), this.minimumDeflateSize);
            this.writerTask = new WriterTask();
            if (this.pingIntervalMillis != 0L) {
                void var1_1;
                long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(this.pingIntervalMillis);
                this.taskQueue.schedule((String)var1_1 + " ping", pingIntervalNanos, (Function0<Long>)((Function0)new Function0<Long>(this, pingIntervalNanos){
                    final /* synthetic */ RealWebSocket this$0;
                    final /* synthetic */ long $pingIntervalNanos;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.$pingIntervalNanos = var2_2;
                        super(0);
                    }

                    public final Long invoke() {
                        this.this$0.writePingFrame$okhttp();
                        return this.$pingIntervalNanos;
                    }
                }));
            }
            if (!((Collection)this.messageAndCloseQueue).isEmpty()) {
                this.runWriter();
            }
        }
        this.reader = new WebSocketReader(streams.getClient(), streams.getSource(), this, extensions.perMessageDeflate, var3_4.noContextTakeover(!var2_3.getClient()));
    }

    /*
     * WARNING - void declaration
     */
    public final void loopReader(Response response) throws IOException {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        try {
            this.listener.onOpen(this, response);
            while (this.receivedCloseCode == -1) {
                WebSocketReader webSocketReader = this.reader;
                Intrinsics.checkNotNull((Object)webSocketReader);
                webSocketReader.processNextFrame();
            }
            return;
        }
        catch (Exception e) {
            void var1_2;
            RealWebSocket.failWebSocket$default(this, (Exception)var1_2, null, false, 6, null);
            return;
        }
        finally {
            this.finishReader();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean processNextFrame() throws IOException {
        boolean bl;
        try {
            WebSocketReader webSocketReader = this.reader;
            Intrinsics.checkNotNull((Object)webSocketReader);
            webSocketReader.processNextFrame();
            bl = this.receivedCloseCode == -1;
        }
        catch (Exception e) {
            void var1_2;
            RealWebSocket.failWebSocket$default(this, (Exception)var1_2, null, false, 6, null);
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void finishReader() {
        void var1_2;
        Streams streamsToClose;
        WebSocketReader readerToClose;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            boolean failed = this.failed;
            int code = this.receivedCloseCode;
            String reason = this.receivedCloseReason;
            readerToClose = this.reader;
            this.reader = null;
            if (this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
                WebSocketWriter writerToClose = this.writer;
                if (writerToClose != null) {
                    this.writer = null;
                    TaskQueue.execute$default(this.taskQueue, this.name + " writer close", 0L, false, (Function0)new Function0<Unit>(writerToClose){
                        final /* synthetic */ WebSocketWriter $writerToClose;
                        {
                            void var1_1;
                            this.$writerToClose = var1_1;
                            super(0);
                        }

                        public final void invoke() {
                            _UtilCommonKt.closeQuietly(this.$writerToClose);
                        }
                    }, 2, null);
                }
                this.taskQueue.shutdown();
            }
            streamsToClose = this.writer == null ? this.streams : null;
        }
        if (var1_2 == false && streamsToClose != null && this.receivedCloseCode != -1) {
            void var2_4;
            void var3_5;
            WebSocket webSocket = this;
            void v1 = var3_5;
            Intrinsics.checkNotNull((Object)v1);
            this.listener.onClosed(webSocket, (int)var2_4, (String)v1);
        }
        WebSocketReader webSocketReader = readerToClose;
        if (webSocketReader != null) {
            _UtilCommonKt.closeQuietly(webSocketReader);
        }
        Streams streams = streamsToClose;
        if (streams != null) {
            _UtilCommonKt.closeQuietly(streams);
            return;
        }
    }

    public final void tearDown() throws InterruptedException {
        this.taskQueue.shutdown();
        this.taskQueue.idleLatch().await(10L, TimeUnit.SECONDS);
    }

    public final synchronized int sentPingCount() {
        return this.sentPingCount;
    }

    public final synchronized int receivedPingCount() {
        return this.receivedPingCount;
    }

    public final synchronized int receivedPongCount() {
        return this.receivedPongCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadMessage(String text) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        this.listener.onMessage((WebSocket)this, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadMessage(ByteString bytes) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.listener.onMessage((WebSocket)this, (ByteString)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final synchronized void onReadPing(ByteString payload) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return;
        }
        this.pongQueue.add((ByteString)var1_1);
        this.runWriter();
        int n = this.receivedPingCount;
        this.receivedPingCount = n + 1;
    }

    @Override
    public final synchronized void onReadPong(ByteString payload) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        int n = this.receivedPongCount;
        this.receivedPongCount = n + 1;
        this.awaitingPong = false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void onReadClose(int code22, String reason) {
        void var2_5;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (!(code22 != -1)) {
            String code22 = "Failed requirement.";
            throw new IllegalArgumentException(code22.toString());
        }
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            int code22;
            if (!(this.receivedCloseCode == -1)) {
                String code22 = "already closed";
                throw new IllegalStateException(code22.toString());
            }
            this.receivedCloseCode = code22;
            this.receivedCloseReason = reason;
        }
        this.listener.onClosing(this, (int)var1_1, (String)var2_5);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean send(String text) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return this.send(ByteString.Companion.encodeUtf8((String)var1_1), 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean send(ByteString bytes) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        return this.send((ByteString)var1_1, 2);
    }

    /*
     * WARNING - void declaration
     */
    private final synchronized boolean send(ByteString data, int formatOpcode) {
        void var1_1;
        void var2_2;
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        if (this.queueSize + (long)data.size() > 0x1000000L) {
            this.close(1001, null);
            return false;
        }
        this.queueSize += (long)data.size();
        this.messageAndCloseQueue.add(new Message((int)var2_2, (ByteString)var1_1));
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean pong(ByteString payload) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        if (this.failed || this.enqueuedClose && this.messageAndCloseQueue.isEmpty()) {
            return false;
        }
        this.pongQueue.add((ByteString)var1_1);
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean close(int code, String reason) {
        void var2_2;
        void var1_1;
        return this.close((int)var1_1, (String)var2_2, this.webSocketCloseTimeout);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean close(int code2, String reason, long cancelAfterCloseMillis) {
        void var3_4;
        void var1_1;
        WebSocketProtocol.INSTANCE.validateCloseCode(code2);
        ByteString reasonBytes = null;
        if (reason != null && !((long)(reasonBytes = ByteString.Companion.encodeUtf8(reason)).size() <= 123L)) {
            void var2_3;
            String code2 = "reason.size() > 123: " + (String)var2_3;
            throw new IllegalArgumentException(code2.toString());
        }
        if (this.failed || this.enqueuedClose) {
            return false;
        }
        this.enqueuedClose = true;
        this.messageAndCloseQueue.add(new Close((int)var1_1, reasonBytes, (long)var3_4));
        this.runWriter();
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void runWriter() {
        RealWebSocket $this$assertThreadHoldsLock$iv = this;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        Task writerTask = this.writerTask;
        if (writerTask != null) {
            void var1_1;
            TaskQueue.schedule$default(this.taskQueue, (Task)var1_1, 0L, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean writeOneFrame$okhttp() throws IOException {
        WebSocketWriter webSocketWriter;
        ByteString pong;
        Object writer;
        Object messageOrClose = null;
        int receivedCloseCode = 0;
        String receivedCloseReason = null;
        Streams streamsToClose = null;
        WebSocketWriter writerToClose = null;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            block24: {
                block23: {
                    if (!this.failed) break block23;
                    return false;
                }
                writer = this.writer;
                pong = this.pongQueue.poll();
                if (pong != null) break block24;
                messageOrClose = this.messageAndCloseQueue.poll();
                if (messageOrClose instanceof Close) {
                    receivedCloseCode = this.receivedCloseCode;
                    receivedCloseReason = this.receivedCloseReason;
                    if (receivedCloseCode != -1) {
                        writerToClose = this.writer;
                        this.writer = null;
                        streamsToClose = writerToClose != null && this.reader == null ? this.streams : null;
                        this.taskQueue.shutdown();
                    } else {
                        long cancelAfterCloseMillis = ((Close)messageOrClose).getCancelAfterCloseMillis();
                        TaskQueue.execute$default(this.taskQueue, this.name + " cancel", TimeUnit.MILLISECONDS.toNanos(cancelAfterCloseMillis), false, (Function0)new Function0<Unit>(this){
                            final /* synthetic */ RealWebSocket this$0;
                            {
                                void var1_1;
                                this.this$0 = var1_1;
                                super(0);
                            }

                            public final void invoke() {
                                this.this$0.cancel();
                            }
                        }, 4, null);
                    }
                    break block24;
                }
                if (messageOrClose != null) break block24;
                return false;
            }
        }
        try {
            if (pong != null) {
                void var2_10;
                WebSocketWriter webSocketWriter2 = writer;
                Intrinsics.checkNotNull((Object)webSocketWriter2);
                webSocketWriter2.writePong((ByteString)var2_10);
            } else if (messageOrClose instanceof Message) {
                Message message = (Message)messageOrClose;
                WebSocketWriter webSocketWriter3 = writer;
                Intrinsics.checkNotNull((Object)webSocketWriter3);
                webSocketWriter3.writeMessageFrame(message.getFormatOpcode(), message.getData());
                writer = this;
                synchronized (writer) {
                    this.queueSize -= (long)message.getData().size();
                }
            } else if (messageOrClose instanceof Close) {
                void var1_8;
                void var3_1;
                Close close = (Close)var3_1;
                void v2 = var1_8;
                Intrinsics.checkNotNull((Object)v2);
                v2.writeClose(close.getCode(), close.getReason());
                if (streamsToClose != null) {
                    WebSocket webSocket = this;
                    String string = receivedCloseReason;
                    Intrinsics.checkNotNull((Object)string);
                    this.listener.onClosed(webSocket, receivedCloseCode, string);
                }
            } else {
                throw new AssertionError();
            }
            webSocketWriter = writerToClose;
        }
        catch (Throwable throwable) {
            block25: {
                WebSocketWriter webSocketWriter4 = writerToClose;
                if (webSocketWriter4 != null) {
                    _UtilCommonKt.closeQuietly(webSocketWriter4);
                }
                Streams streams = streamsToClose;
                if (streams == null) break block25;
                _UtilCommonKt.closeQuietly(streams);
            }
            throw throwable;
        }
        if (webSocketWriter != null) {
            _UtilCommonKt.closeQuietly(webSocketWriter);
        }
        Streams streams = streamsToClose;
        if (streams != null) {
            _UtilCommonKt.closeQuietly(streams);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final void writePingFrame$okhttp() {
        int failedPing;
        RealWebSocket realWebSocket = this;
        synchronized (realWebSocket) {
            if (this.failed) {
                return;
            }
            WebSocketWriter webSocketWriter = this.writer;
            if (webSocketWriter == null) {
                return;
            }
            WebSocketWriter writer = webSocketWriter;
            failedPing = this.awaitingPong ? this.sentPingCount : -1;
            int n = this.sentPingCount;
            this.sentPingCount = n + 1;
            this.awaitingPong = true;
        }
        if (failedPing != -1) {
            void var2_5;
            RealWebSocket.failWebSocket$default(this, new SocketTimeoutException("sent ping but didn't receive pong within " + this.pingIntervalMillis + "ms (after " + (int)(var2_5 - true) + " successful ping/pongs)"), null, true, 2, null);
            return;
        }
        try {
            void var1_3;
            var1_3.writePing(ByteString.EMPTY);
            return;
        }
        catch (IOException e) {
            void var3_2;
            RealWebSocket.failWebSocket$default(this, (Exception)var3_2, null, true, 2, null);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void failWebSocket(Exception e, Response response, boolean isWriter) {
        Streams streams;
        block16: {
            block15: {
                Streams streams2;
                Streams streamsToCancel;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Ref.ObjectRef streamsToClose = new Ref.ObjectRef();
                Ref.ObjectRef writerToClose = new Ref.ObjectRef();
                RealWebSocket realWebSocket = this;
                synchronized (realWebSocket) {
                    if (this.failed) {
                        return;
                    }
                    this.failed = true;
                    streamsToCancel = this.streams;
                    writerToClose.element = this.writer;
                    this.writer = null;
                    Object object = streamsToClose.element = writerToClose.element != null && this.reader == null ? this.streams : null;
                    if (!isWriter && writerToClose.element != null) {
                        TaskQueue.execute$default(this.taskQueue, this.name + " writer close", 0L, false, (Function0)new Function0<Unit>((Ref.ObjectRef<WebSocketWriter>)writerToClose, (Ref.ObjectRef<Streams>)streamsToClose){
                            final /* synthetic */ Ref.ObjectRef<WebSocketWriter> $writerToClose;
                            final /* synthetic */ Ref.ObjectRef<Streams> $streamsToClose;
                            {
                                void var2_2;
                                void var1_1;
                                this.$writerToClose = var1_1;
                                this.$streamsToClose = var2_2;
                                super(0);
                            }

                            public final void invoke() {
                                _UtilCommonKt.closeQuietly((Closeable)this.$writerToClose.element);
                                Streams streams = (Streams)this.$streamsToClose.element;
                                if (streams != null) {
                                    _UtilCommonKt.closeQuietly(streams);
                                    return;
                                }
                            }
                        }, 2, null);
                    }
                    this.taskQueue.shutdown();
                }
                try {
                    void var2_3;
                    void var1_1;
                    this.listener.onFailure(this, (Throwable)var1_1, (Response)var2_3);
                    streams2 = streamsToCancel;
                }
                catch (Throwable throwable) {
                    void var3_4;
                    Streams streams3 = streamsToCancel;
                    if (streams3 != null) {
                        streams3.cancel();
                    }
                    if (var3_4 != false) {
                        WebSocketWriter webSocketWriter = (WebSocketWriter)writerToClose.element;
                        if (webSocketWriter != null) {
                            _UtilCommonKt.closeQuietly(webSocketWriter);
                        }
                        Streams streams4 = (Streams)streamsToClose.element;
                        if (streams4 != null) {
                            _UtilCommonKt.closeQuietly(streams4);
                        }
                    }
                    throw throwable;
                }
                if (streams2 != null) {
                    streams2.cancel();
                }
                if (!isWriter) break block15;
                WebSocketWriter webSocketWriter = (WebSocketWriter)writerToClose.element;
                if (webSocketWriter != null) {
                    _UtilCommonKt.closeQuietly(webSocketWriter);
                }
                streams = (Streams)streamsToClose.element;
                if (streams != null) break block16;
            }
            return;
        }
        _UtilCommonKt.closeQuietly(streams);
    }

    public static /* synthetic */ void failWebSocket$default(RealWebSocket realWebSocket, Exception exception, Response response, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            response = null;
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        realWebSocket.failWebSocket(exception, response, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setExtensions$p(RealWebSocket $this, WebSocketExtensions webSocketExtensions) {
        void var1_1;
        $this.extensions = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ boolean access$isValid(RealWebSocket $this, WebSocketExtensions $receiver) {
        void var1_1;
        return $this.isValid((WebSocketExtensions)var1_1);
    }

    public static final /* synthetic */ ArrayDeque access$getMessageAndCloseQueue$p(RealWebSocket $this) {
        return $this.messageAndCloseQueue;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Close;", "", "code", "", "reason", "Lokio/ByteString;", "cancelAfterCloseMillis", "", "(ILokio/ByteString;J)V", "getCancelAfterCloseMillis", "()J", "getCode", "()I", "getReason", "()Lokio/ByteString;", "okhttp"})
    public static final class Close {
        private final int code;
        private final ByteString reason;
        private final long cancelAfterCloseMillis;

        /*
         * WARNING - void declaration
         */
        public Close(int code, ByteString reason, long cancelAfterCloseMillis) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.code = var1_1;
            this.reason = var2_2;
            this.cancelAfterCloseMillis = var3_3;
        }

        public final int getCode() {
            return this.code;
        }

        public final ByteString getReason() {
            return this.reason;
        }

        public final long getCancelAfterCloseMillis() {
            return this.cancelAfterCloseMillis;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Companion;", "", "()V", "CANCEL_AFTER_CLOSE_MILLIS", "", "DEFAULT_MINIMUM_DEFLATE_SIZE", "MAX_QUEUE_SIZE", "ONLY_HTTP1", "", "Lokhttp3/Protocol;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Message;", "", "formatOpcode", "", "data", "Lokio/ByteString;", "(ILokio/ByteString;)V", "getData", "()Lokio/ByteString;", "getFormatOpcode", "()I", "okhttp"})
    public static final class Message {
        private final int formatOpcode;
        private final ByteString data;

        /*
         * WARNING - void declaration
         */
        public Message(int formatOpcode, ByteString data) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.formatOpcode = var1_1;
            this.data = var2_2;
        }

        public final int getFormatOpcode() {
            return this.formatOpcode;
        }

        public final ByteString getData() {
            return this.data;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/ws/RealWebSocket$Streams;", "Ljava/io/Closeable;", "client", "", "source", "Lokio/BufferedSource;", "sink", "Lokio/BufferedSink;", "(ZLokio/BufferedSource;Lokio/BufferedSink;)V", "getClient", "()Z", "getSink", "()Lokio/BufferedSink;", "getSource", "()Lokio/BufferedSource;", "cancel", "", "okhttp"})
    public static abstract class Streams
    implements Closeable {
        private final boolean client;
        private final BufferedSource source;
        private final BufferedSink sink;

        /*
         * WARNING - void declaration
         */
        public Streams(boolean client, BufferedSource source, BufferedSink sink) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            this.client = var1_1;
            this.source = var2_2;
            this.sink = var3_3;
        }

        public final boolean getClient() {
            return this.client;
        }

        public final BufferedSource getSource() {
            return this.source;
        }

        public final BufferedSink getSink() {
            return this.sink;
        }

        public abstract void cancel();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/ws/RealWebSocket$WriterTask;", "Lokhttp3/internal/concurrent/Task;", "(Lokhttp3/internal/ws/RealWebSocket;)V", "runOnce", "", "okhttp"})
    private final class WriterTask
    extends Task {
        /*
         * WARNING - void declaration
         */
        public WriterTask() {
            void var1_1;
            super(((RealWebSocket)var1_1).name + " writer", false, 2, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final long runOnce() {
            try {
                if (RealWebSocket.this.writeOneFrame$okhttp()) {
                    return 0L;
                }
            }
            catch (IOException e) {
                void var1_1;
                RealWebSocket.failWebSocket$default(RealWebSocket.this, (Exception)var1_1, null, true, 2, null);
            }
            return -1L;
        }
    }
}

