/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.publicsuffix;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.IDN;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.platform.Platform;
import okio.BufferedSource;
import okio.FileSystem;
import okio.GzipSource;
import okio.Okio;
import okio.Path;
import okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001b\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u0016\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u0014H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "", "path", "Lokio/Path;", "fileSystem", "Lokio/FileSystem;", "(Lokio/Path;Lokio/FileSystem;)V", "getFileSystem", "()Lokio/FileSystem;", "listRead", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getPath", "()Lokio/Path;", "publicSuffixExceptionListBytes", "", "publicSuffixListBytes", "readCompleteLatch", "Ljava/util/concurrent/CountDownLatch;", "findMatchingRule", "", "", "domainLabels", "getEffectiveTldPlusOne", "domain", "readTheList", "", "readTheListUninterruptibly", "setListBytes", "splitDomain", "Companion", "okhttp"})
public final class PublicSuffixDatabase {
    public static final Companion Companion = new Companion(null);
    private final Path path;
    private final FileSystem fileSystem;
    private final AtomicBoolean listRead;
    private final CountDownLatch readCompleteLatch;
    private byte[] publicSuffixListBytes;
    private byte[] publicSuffixExceptionListBytes;
    @JvmField
    public static final Path PUBLIC_SUFFIX_RESOURCE = Path.Companion.get$default((Path.Companion)Path.Companion, (String)("/okhttp3/internal/publicsuffix/" + PublicSuffixDatabase.class.getSimpleName() + ".gz"), (boolean)false, (int)1, null);
    private static final byte[] WILDCARD_LABEL;
    private static final List<String> PREVAILING_RULE;
    private static final char EXCEPTION_MARKER = '!';
    private static final PublicSuffixDatabase instance;

    /*
     * WARNING - void declaration
     */
    public PublicSuffixDatabase(Path path, FileSystem fileSystem2) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        this.path = var1_1;
        this.fileSystem = var2_2;
        this.listRead = new AtomicBoolean(false);
        this.readCompleteLatch = new CountDownLatch(1);
    }

    public /* synthetic */ PublicSuffixDatabase(Path path, FileSystem fileSystem2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            path = PUBLIC_SUFFIX_RESOURCE;
        }
        if ((n & 2) != 0) {
            fileSystem2 = FileSystem.RESOURCES;
        }
        this(path, fileSystem2);
    }

    public final Path getPath() {
        return this.path;
    }

    public final FileSystem getFileSystem() {
        return this.fileSystem;
    }

    /*
     * WARNING - void declaration
     */
    public final String getEffectiveTldPlusOne(String domain) {
        void var2_3;
        void var1_1;
        void var3_4;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        String unicodeDomain = IDN.toUnicode(domain);
        Intrinsics.checkNotNull((Object)unicodeDomain);
        List<String> domainLabels = this.splitDomain(unicodeDomain);
        List<String> rule = this.findMatchingRule(domainLabels);
        if (domainLabels.size() == rule.size() && rule.get(0).charAt(0) != '!') {
            return null;
        }
        int firstLabelOffset = rule.get(0).charAt(0) == '!' ? domainLabels.size() - rule.size() : domainLabels.size() - (var3_4.size() + 1);
        return SequencesKt.joinToString$default((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)this.splitDomain((String)var1_1)), (int)var2_3), (CharSequence)".", null, null, (int)0, null, null, (int)62, null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitDomain(String domain) {
        void var1_1;
        CharSequence charSequence = (CharSequence)domain;
        char[] cArray = new char[1];
        domain = cArray;
        cArray[0] = 46;
        List domainLabels = StringsKt.split$default((CharSequence)charSequence, (char[])domain, (boolean)false, (int)0, (int)6, null);
        if (Intrinsics.areEqual((Object)CollectionsKt.last((List)domainLabels), (Object)"")) {
            return CollectionsKt.dropLast((List)domainLabels, (int)1);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> findMatchingRule(List<String> domainLabels) {
        List wildcardRuleLabels;
        List exactRuleLabels;
        block28: {
            List list;
            block27: {
                void var3_6;
                char[] cArray;
                block26: {
                    List list2;
                    block25: {
                        void var2_4;
                        String rule;
                        if (!this.listRead.get() && this.listRead.compareAndSet(false, true)) {
                            this.readTheListUninterruptibly();
                        } else {
                            try {
                                this.readCompleteLatch.await();
                            }
                            catch (InterruptedException interruptedException) {
                                Thread.currentThread().interrupt();
                            }
                        }
                        if (!(this.publicSuffixListBytes != null)) {
                            String string = "Unable to load " + PUBLIC_SUFFIX_RESOURCE + " resource from the classpath.";
                            throw new IllegalStateException(string.toString());
                        }
                        int n = 0;
                        int n2 = domainLabels.size();
                        byte[][] byArrayArray = new byte[n2][];
                        while (n < n2) {
                            int n3 = n++;
                            String string = domainLabels.get(n3);
                            Intrinsics.checkNotNullExpressionValue((Object)string.getBytes(Charsets.UTF_8), (String)"getBytes(...)");
                        }
                        byte[][] domainLabelsUtf8Bytes = byArrayArray;
                        String exactMatch = null;
                        int n4 = ((Object[])domainLabelsUtf8Bytes).length;
                        for (int i = 0; i < n4; ++i) {
                            String rule2;
                            byte[] byArray = this.publicSuffixListBytes;
                            if (this.publicSuffixListBytes == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                                byArray = null;
                            }
                            if ((rule2 = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, i)) == null) continue;
                            exactMatch = rule2;
                            break;
                        }
                        String wildcardMatch = null;
                        if (((Object[])domainLabelsUtf8Bytes).length > 1) {
                            byte[][] labelsWithWildcard = (byte[][])((Object[])domainLabelsUtf8Bytes).clone();
                            int n5 = ((Object[])labelsWithWildcard).length - 1;
                            for (int labelIndex = 0; labelIndex < n5; ++labelIndex) {
                                labelsWithWildcard[labelIndex] = WILDCARD_LABEL;
                                byte[] byArray = this.publicSuffixListBytes;
                                if (this.publicSuffixListBytes == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixListBytes");
                                    byArray = null;
                                }
                                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, labelsWithWildcard, labelIndex)) == null) continue;
                                wildcardMatch = rule;
                                break;
                            }
                        }
                        String exception = null;
                        if (wildcardMatch != null) {
                            int n6 = ((Object[])domainLabelsUtf8Bytes).length - 1;
                            for (int labelIndex = 0; labelIndex < n6; ++labelIndex) {
                                byte[] byArray = this.publicSuffixExceptionListBytes;
                                if (this.publicSuffixExceptionListBytes == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"publicSuffixExceptionListBytes");
                                    byArray = null;
                                }
                                if ((rule = okhttp3.internal.publicsuffix.PublicSuffixDatabase$Companion.access$binarySearch(Companion, byArray, domainLabelsUtf8Bytes, labelIndex)) == null) continue;
                                exception = rule;
                                break;
                            }
                        }
                        if (exception != null) {
                            String string = "!" + exception;
                            char[] cArray2 = new char[1];
                            char[] labelIndex = cArray2;
                            cArray2[0] = 46;
                            return StringsKt.split$default((CharSequence)string, (char[])labelIndex, (boolean)false, (int)0, (int)6, null);
                        }
                        if (exactMatch == null && wildcardMatch == null) {
                            return PREVAILING_RULE;
                        }
                        list2 = var2_4;
                        if (list2 == null) break block25;
                        char[] cArray3 = new char[1];
                        cArray = cArray3;
                        cArray3[0] = 46;
                        if ((list2 = StringsKt.split$default((CharSequence)((CharSequence)((Object)list2)), (char[])cArray, (boolean)false, (int)0, (int)6, null)) != null) break block26;
                    }
                    list2 = exactRuleLabels = CollectionsKt.emptyList();
                }
                if ((list = var3_6) == null) break block27;
                char[] cArray4 = new char[1];
                cArray = cArray4;
                cArray4[0] = 46;
                if ((list = StringsKt.split$default((CharSequence)((CharSequence)((Object)list)), (char[])cArray, (boolean)false, (int)0, (int)6, null)) != null) break block28;
            }
            list = wildcardRuleLabels = CollectionsKt.emptyList();
        }
        if (exactRuleLabels.size() > wildcardRuleLabels.size()) {
            return exactRuleLabels;
        }
        return wildcardRuleLabels;
    }

    /*
     * WARNING - void declaration
     */
    private final void readTheListUninterruptibly() {
        boolean interrupted = false;
        while (true) {
            try {
                this.readTheList();
                return;
            }
            catch (InterruptedIOException interruptedIOException) {
                Thread.interrupted();
                interrupted = true;
                continue;
            }
            catch (IOException e) {
                void var2_2;
                Platform.Companion.get().log("Failed to read public suffix list", 5, (Throwable)var2_2);
                return;
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void readTheList() throws IOException {
        try {
            Object object = (Closeable)Okio.buffer((Source)((Source)new GzipSource(this.fileSystem.source(this.path))));
            Throwable throwable = null;
            try {
                BufferedSource bufferedSource = (BufferedSource)object;
                int totalBytes = bufferedSource.readInt();
                byte[] publicSuffixListBytes = bufferedSource.readByteArray((long)totalBytes);
                int totalExceptionBytes = bufferedSource.readInt();
                byte[] publicSuffixExceptionListBytes = bufferedSource.readByteArray((long)totalExceptionBytes);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable publicSuffixExceptionListBytes = throwable2;
                    throwable = throwable2;
                    throw publicSuffixExceptionListBytes;
                }
                catch (Throwable publicSuffixExceptionListBytes) {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                    throw publicSuffixExceptionListBytes;
                }
            }
            CloseableKt.closeFinally((Closeable)object, null);
            object = this;
            synchronized (object) {
                void var2_5;
                void var1_9;
                void v1 = var1_9;
                Intrinsics.checkNotNull((Object)v1);
                this.publicSuffixListBytes = v1;
                void v2 = var2_5;
                Intrinsics.checkNotNull((Object)v2);
                this.publicSuffixExceptionListBytes = v2;
            }
            return;
        }
        finally {
            this.readCompleteLatch.countDown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setListBytes(byte[] publicSuffixListBytes, byte[] publicSuffixExceptionListBytes) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)publicSuffixListBytes, (String)"publicSuffixListBytes");
        Intrinsics.checkNotNullParameter((Object)publicSuffixExceptionListBytes, (String)"publicSuffixExceptionListBytes");
        this.publicSuffixListBytes = var1_1;
        this.publicSuffixExceptionListBytes = var2_2;
        this.listRead.set(true);
        this.readCompleteLatch.countDown();
    }

    public PublicSuffixDatabase() {
        this(null, null, 3, null);
    }

    static {
        byte[] byArray = new byte[1];
        byte[] byArray2 = byArray;
        byArray[0] = 42;
        WILDCARD_LABEL = byArray2;
        PREVAILING_RULE = CollectionsKt.listOf((Object)"*");
        instance = new PublicSuffixDatabase(null, null, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u000e\u001a\u00020\rJ)\u0010\u000f\u001a\u0004\u0018\u00010\u0007*\u00020\u000b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/publicsuffix/PublicSuffixDatabase$Companion;", "", "()V", "EXCEPTION_MARKER", "", "PREVAILING_RULE", "", "", "PUBLIC_SUFFIX_RESOURCE", "Lokio/Path;", "WILDCARD_LABEL", "", "instance", "Lokhttp3/internal/publicsuffix/PublicSuffixDatabase;", "get", "binarySearch", "labels", "", "labelIndex", "", "([B[[BI)Ljava/lang/String;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public final PublicSuffixDatabase get() {
            return instance;
        }

        /*
         * WARNING - void declaration
         */
        private final String binarySearch(byte[] $this$binarySearch, byte[][] labels, int labelIndex) {
            int low = 0;
            int high = $this$binarySearch.length;
            String match = null;
            while (low < high) {
                void var1_1;
                int compareResult;
                int mid;
                for (mid = (low + high) / 2; mid >= 0 && $this$binarySearch[mid] != 10; --mid) {
                }
                ++mid;
                int end = 1;
                while ($this$binarySearch[mid + end] != 10) {
                    ++end;
                }
                int publicSuffixLength = mid + end - mid;
                int currentLabelIndex = labelIndex;
                int currentLabelByteIndex = 0;
                int publicSuffixByteIndex = 0;
                boolean expectDot = false;
                while (true) {
                    int byte0;
                    if (expectDot) {
                        byte0 = 46;
                        expectDot = false;
                    } else {
                        byte0 = _UtilCommonKt.and(labels[currentLabelIndex][currentLabelByteIndex], 255);
                    }
                    int byte1 = _UtilCommonKt.and($this$binarySearch[mid + publicSuffixByteIndex], 255);
                    compareResult = byte0 - byte1;
                    if (compareResult != 0) break;
                    ++currentLabelByteIndex;
                    if (++publicSuffixByteIndex == publicSuffixLength) break;
                    if (labels[currentLabelIndex].length != currentLabelByteIndex) continue;
                    if (currentLabelIndex == ((Object[])labels).length - 1) break;
                    ++currentLabelIndex;
                    currentLabelByteIndex = -1;
                    expectDot = true;
                }
                if (compareResult < 0) {
                    high = mid - 1;
                    continue;
                }
                if (compareResult > 0) {
                    low = mid + end + 1;
                    continue;
                }
                int publicSuffixBytesLeft = publicSuffixLength - publicSuffixByteIndex;
                int labelBytesLeft = labels[currentLabelIndex].length - currentLabelByteIndex;
                int n = ((Object[])labels).length;
                for (int i = currentLabelIndex + 1; i < n; ++i) {
                    labelBytesLeft += labels[i].length;
                }
                if (labelBytesLeft < publicSuffixBytesLeft) {
                    high = mid - 1;
                    continue;
                }
                if (labelBytesLeft > publicSuffixBytesLeft) {
                    low = mid + end + 1;
                    continue;
                }
                match = new String((byte[])var1_1, mid, publicSuffixLength, Charsets.UTF_8);
                break;
            }
            return match;
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ String access$binarySearch(Companion $this, byte[] $receiver, byte[][] labels, int labelIndex) {
            void var3_3;
            void var2_2;
            void var1_1;
            return $this.binarySearch((byte[])var1_1, (byte[][])var2_2, (int)var3_3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

