/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.platform;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Protocol;
import okhttp3.internal.platform.Platform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0002\u0015\u0016B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J(\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\f\u001a\u00020\rH\u0016R\u0012\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lokhttp3/internal/platform/Jdk8WithJettyBootPlatform;", "Lokhttp3/internal/platform/Platform;", "putMethod", "Ljava/lang/reflect/Method;", "getMethod", "removeMethod", "clientProviderClass", "Ljava/lang/Class;", "serverProviderClass", "(Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/reflect/Method;Ljava/lang/Class;Ljava/lang/Class;)V", "afterHandshake", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "configureTlsExtensions", "hostname", "", "protocols", "", "Lokhttp3/Protocol;", "getSelectedProtocol", "AlpnProvider", "Companion", "okhttp"})
public final class Jdk8WithJettyBootPlatform
extends Platform {
    public static final Companion Companion = new Companion(null);
    private final Method putMethod;
    private final Method getMethod;
    private final Method removeMethod;
    private final Class<?> clientProviderClass;
    private final Class<?> serverProviderClass;

    /*
     * WARNING - void declaration
     */
    public Jdk8WithJettyBootPlatform(Method putMethod, Method getMethod, Method removeMethod, Class<?> clientProviderClass, Class<?> serverProviderClass) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)putMethod, (String)"putMethod");
        Intrinsics.checkNotNullParameter((Object)getMethod, (String)"getMethod");
        Intrinsics.checkNotNullParameter((Object)removeMethod, (String)"removeMethod");
        Intrinsics.checkNotNullParameter(clientProviderClass, (String)"clientProviderClass");
        Intrinsics.checkNotNullParameter(serverProviderClass, (String)"serverProviderClass");
        this.putMethod = var1_1;
        this.getMethod = var2_2;
        this.removeMethod = var3_3;
        this.clientProviderClass = clientProviderClass;
        this.serverProviderClass = serverProviderClass;
    }

    /*
     * WARNING - void declaration
     */
    public final void configureTlsExtensions(SSLSocket sslSocket, String hostname, List<? extends Protocol> protocols) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
        List<String> names = Platform.Companion.alpnProtocolNames((List<? extends Protocol>)objectArray);
        try {
            void var1_1;
            Class[] classArray = new Class[2];
            objectArray = classArray;
            classArray[0] = this.clientProviderClass;
            objectArray[1] = this.serverProviderClass;
            Object alpnProvider = Proxy.newProxyInstance(Platform.class.getClassLoader(), objectArray, (InvocationHandler)new AlpnProvider(names));
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray2[0] = var1_1;
            objectArray[1] = alpnProvider;
            this.putMethod.invoke(null, objectArray);
            return;
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to set ALPN", e);
        }
        catch (IllegalAccessException e) {
            void var2_4;
            throw new AssertionError("failed to set ALPN", (Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void afterHandshake(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        try {
            void var1_1;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = var1_1;
            this.removeMethod.invoke(null, objectArray2);
            return;
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("failed to remove ALPN", e);
        }
        catch (InvocationTargetException e) {
            void var2_4;
            throw new AssertionError("failed to remove ALPN", (Throwable)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getSelectedProtocol(SSLSocket sslSocket) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        try {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = sslSocket;
            InvocationHandler invocationHandler = Proxy.getInvocationHandler(this.getMethod.invoke(null, objectArray2));
            Intrinsics.checkNotNull((Object)invocationHandler, (String)"null cannot be cast to non-null type okhttp3.internal.platform.Jdk8WithJettyBootPlatform.AlpnProvider");
            AlpnProvider provider = (AlpnProvider)invocationHandler;
            if (!provider.getUnsupported() && provider.getSelected() == null) {
                Platform.log$default(this, "ALPN callback dropped: HTTP/2 is disabled. Is alpn-boot on the boot class path?", 0, null, 6, null);
                return null;
            }
            if (provider.getUnsupported()) {
                return null;
            }
            return provider.getSelected();
        }
        catch (InvocationTargetException e) {
            throw new AssertionError("failed to get ALPN selected protocol", e);
        }
        catch (IllegalAccessException e) {
            void var1_3;
            throw new AssertionError("failed to get ALPN selected protocol", (Throwable)var1_3);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J0\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0017H\u0096\u0002\u00a2\u0006\u0002\u0010\u0018R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/platform/Jdk8WithJettyBootPlatform$AlpnProvider;", "Ljava/lang/reflect/InvocationHandler;", "protocols", "", "", "(Ljava/util/List;)V", "selected", "getSelected", "()Ljava/lang/String;", "setSelected", "(Ljava/lang/String;)V", "unsupported", "", "getUnsupported", "()Z", "setUnsupported", "(Z)V", "invoke", "", "proxy", "method", "Ljava/lang/reflect/Method;", "args", "", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;", "okhttp"})
    private static final class AlpnProvider
    implements InvocationHandler {
        private final List<String> protocols;
        private boolean unsupported;
        private String selected;

        /*
         * WARNING - void declaration
         */
        public AlpnProvider(List<String> protocols) {
            void var1_1;
            Intrinsics.checkNotNullParameter(protocols, (String)"protocols");
            this.protocols = var1_1;
        }

        public final boolean getUnsupported() {
            return this.unsupported;
        }

        /*
         * WARNING - void declaration
         */
        public final void setUnsupported(boolean bl) {
            void var1_1;
            this.unsupported = var1_1;
        }

        public final String getSelected() {
            return this.selected;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSelected(String string) {
            void var1_1;
            this.selected = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            void var2_2;
            void var1_1;
            void var3_4;
            Intrinsics.checkNotNullParameter((Object)proxy, (String)"proxy");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Object[] objectArray = args;
            if (args == null) {
                objectArray = new Object[]{};
            }
            Object[] callArgs = objectArray;
            String methodName2 = method.getName();
            Class<?> returnType = method.getReturnType();
            if (Intrinsics.areEqual((Object)methodName2, (Object)"supports") && Intrinsics.areEqual(Boolean.TYPE, returnType)) {
                return Boolean.TRUE;
            }
            if (Intrinsics.areEqual((Object)methodName2, (Object)"unsupported") && Intrinsics.areEqual(Void.TYPE, returnType)) {
                this.unsupported = true;
                return null;
            }
            if (Intrinsics.areEqual((Object)methodName2, (Object)"protocols") && callArgs.length == 0) {
                return this.protocols;
            }
            if ((Intrinsics.areEqual((Object)methodName2, (Object)"selectProtocol") || Intrinsics.areEqual((Object)methodName2, (Object)"select")) && Intrinsics.areEqual(String.class, returnType) && callArgs.length == 1 && callArgs[0] instanceof List) {
                Object object = callArgs[0];
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.List<*>");
                List peerProtocols = (List)object;
                int i = 0;
                int methodName2 = peerProtocols.size();
                if (methodName2 >= 0) {
                    while (true) {
                        Object e = peerProtocols.get(i);
                        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type kotlin.String");
                        String protocol = (String)e;
                        if (this.protocols.contains(protocol)) {
                            this.selected = protocol;
                            return this.selected;
                        }
                        if (i == methodName2) break;
                        ++i;
                    }
                }
                this.selected = this.protocols.get(0);
                return this.selected;
            }
            if ((Intrinsics.areEqual((Object)methodName2, (Object)"protocolSelected") || Intrinsics.areEqual((Object)var3_4, (Object)"selected")) && ((void)var1_1).length == 1) {
                void v3 = var1_1[0];
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type kotlin.String");
                this.selected = (String)v3;
                return null;
            }
            void v4 = var1_1;
            return var2_2.invoke((Object)this, (Object[])Arrays.copyOf(v4, ((void)v4).length));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/platform/Jdk8WithJettyBootPlatform$Companion;", "", "()V", "buildIfSupported", "Lokhttp3/internal/platform/Platform;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final Platform buildIfSupported() {
            String jvmVersion2 = System.getProperty("java.specification.version", "unknown");
            try {
                Intrinsics.checkNotNull((Object)jvmVersion2);
                int jvmVersion2 = Integer.parseInt(jvmVersion2);
                if (jvmVersion2 >= 9) {
                    return null;
                }
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                void var1_3;
                void var3_5;
                Class[] classArray;
                String alpnClassName = "org.eclipse.jetty.alpn.ALPN";
                Class<?> alpnClass = Class.forName("org.eclipse.jetty.alpn.ALPN", true, null);
                Class<?> providerClass = Class.forName(alpnClassName + "$Provider", true, null);
                Class<?> clientProviderClass = Class.forName(alpnClassName + "$ClientProvider", true, null);
                Class<?> serverProviderClass = Class.forName(alpnClassName + "$ServerProvider", true, null);
                Class[] classArray2 = new Class[2];
                Class[] classArray3 = classArray2;
                classArray2[0] = SSLSocket.class;
                classArray3[1] = providerClass;
                Method putMethod = alpnClass.getMethod("put", classArray3);
                Class[] classArray4 = new Class[1];
                Class[] classArray5 = classArray4;
                classArray4[0] = SSLSocket.class;
                Method getMethod = alpnClass.getMethod("get", classArray5);
                void v3 = classArray;
                Class[] classArray6 = new Class[1];
                classArray = classArray6;
                classArray6[0] = SSLSocket.class;
                Method removeMethod = v3.getMethod("remove", classArray);
                Intrinsics.checkNotNull((Object)putMethod);
                Intrinsics.checkNotNull((Object)getMethod);
                Intrinsics.checkNotNull((Object)removeMethod);
                Intrinsics.checkNotNull(clientProviderClass);
                Intrinsics.checkNotNull(serverProviderClass);
                return new Jdk8WithJettyBootPlatform((Method)var3_5, getMethod, removeMethod, clientProviderClass, (Class<?>)var1_3);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

