/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.idn;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import okio.Buffer;
import okio.ByteString;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\rJ(\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00020\rJ(\u0010#\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!H\u0002J\"\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00040%*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002J\u001c\u0010&\u001a\u00020\u001a*\u00020\r2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0013\u001a\u00020\u0004*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006'"}, d2={"Lokhttp3/internal/idn/Punycode;", "", "()V", "BASE", "", "DAMP", "INITIAL_BIAS", "INITIAL_N", "PREFIX", "Lokio/ByteString;", "getPREFIX", "()Lokio/ByteString;", "PREFIX_STRING", "", "getPREFIX_STRING", "()Ljava/lang/String;", "SKEW", "TMAX", "TMIN", "punycodeDigit", "getPunycodeDigit", "(I)I", "adapt", "delta", "numpoints", "first", "", "decode", "string", "decodeLabel", "pos", "limit", "result", "Lokio/Buffer;", "encode", "encodeLabel", "codePoints", "", "requiresEncode", "okhttp"})
@SourceDebugExtension(value={"SMAP\nPunycode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Punycode.kt\nokhttp3/internal/idn/Punycode\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,329:1\n2310#2,14:330\n*S KotlinDebug\n*F\n+ 1 Punycode.kt\nokhttp3/internal/idn/Punycode\n*L\n108#1:330,14\n*E\n"})
public final class Punycode {
    public static final Punycode INSTANCE = new Punycode();
    private static final String PREFIX_STRING = "xn--";
    private static final ByteString PREFIX = ByteString.Companion.encodeUtf8(PREFIX_STRING);
    private static final int BASE = 36;
    private static final int TMIN = 1;
    private static final int TMAX = 26;
    private static final int SKEW = 38;
    private static final int DAMP = 700;
    private static final int INITIAL_BIAS = 72;
    private static final int INITIAL_N = 128;

    private Punycode() {
    }

    public final String getPREFIX_STRING() {
        return PREFIX_STRING;
    }

    public final ByteString getPREFIX() {
        return PREFIX;
    }

    public final String encode(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int pos = 0;
        int limit = string.length();
        Buffer result = new Buffer();
        while (pos < limit) {
            int dot = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)pos, (boolean)false, (int)4, null);
            if (dot == -1) {
                dot = limit;
            }
            if (!this.encodeLabel(string, pos, dot, result)) {
                return null;
            }
            if (dot >= limit) break;
            result.writeByte(46);
            pos = dot + 1;
        }
        return result.readUtf8();
    }

    private final boolean encodeLabel(String string, int pos, int limit2, Buffer result) {
        if (!this.requiresEncode(string, pos, limit2)) {
            result.writeUtf8(string, pos, limit2);
            return true;
        }
        result.write(PREFIX);
        List<Integer> input = this.codePoints(string, pos, limit2);
        int b = 0;
        Iterator<Integer> limit2 = input.iterator();
        while (limit2.hasNext()) {
            int codePoint = ((Number)limit2.next()).intValue();
            if (codePoint >= 128) continue;
            result.writeByte(codePoint);
            ++b;
        }
        if (b > 0) {
            result.writeByte(45);
        }
        int n = 128;
        int delta = 0;
        int bias = 72;
        int h = b;
        while (h < input.size()) {
            Object t;
            Iterable iterable = input;
            Iterator iterator$iv = iterable.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = minElem$iv;
            } else {
                int it = ((Number)minElem$iv).intValue();
                int minValue$iv = it >= n ? it : Integer.MAX_VALUE;
                do {
                    Object e$iv;
                    int it2;
                    int v$iv;
                    int n2 = v$iv = (it2 = ((Number)(e$iv = iterator$iv.next())).intValue()) >= n ? it2 : Integer.MAX_VALUE;
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = minElem$iv;
            }
            int m = ((Number)t).intValue();
            int increment = (m - n) * (h + 1);
            if (delta > Integer.MAX_VALUE - increment) {
                return false;
            }
            delta += increment;
            n = m;
            Iterator<Integer> iterator = input.iterator();
            while (iterator.hasNext()) {
                int c = ((Number)iterator.next()).intValue();
                if (c < n) {
                    if (delta == Integer.MAX_VALUE) {
                        return false;
                    }
                    ++delta;
                    continue;
                }
                if (c != n) continue;
                int q = delta;
                IntProgression minValue$iv = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)36, (int)Integer.MAX_VALUE)), (int)36);
                int k = minValue$iv.getFirst();
                int n3 = minValue$iv.getLast();
                int n4 = minValue$iv.getStep();
                if (n4 > 0 && k <= n3 || n4 < 0 && n3 <= k) {
                    while (true) {
                        int t2;
                        int n5 = k <= bias ? 1 : (t2 = k >= bias + 26 ? 26 : k - bias);
                        if (q < t2) break;
                        result.writeByte(this.getPunycodeDigit(t2 + (q - t2) % (36 - t2)));
                        q = (q - t2) / (36 - t2);
                        if (k == n3) break;
                        k += n4;
                    }
                }
                result.writeByte(this.getPunycodeDigit(q));
                bias = this.adapt(delta, h + 1, h == b);
                delta = 0;
                ++h;
            }
            ++delta;
            int n6 = n;
            n = n6 + 1;
        }
        return true;
    }

    public final String decode(String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        int pos = 0;
        int limit = string.length();
        Buffer result = new Buffer();
        while (pos < limit) {
            int dot = StringsKt.indexOf$default((CharSequence)string, (char)'.', (int)pos, (boolean)false, (int)4, null);
            if (dot == -1) {
                dot = limit;
            }
            if (!this.decodeLabel(string, pos, dot, result)) {
                return null;
            }
            if (dot >= limit) break;
            result.writeByte(46);
            pos = dot + 1;
        }
        return result.readUtf8();
    }

    private final boolean decodeLabel(String string, int pos, int limit, Buffer result) {
        if (!StringsKt.regionMatches((String)string, (int)pos, (String)PREFIX_STRING, (int)0, (int)4, (boolean)true)) {
            result.writeUtf8(string, pos, limit);
            return true;
        }
        List codePoints = new ArrayList();
        int lastDelimiter = StringsKt.lastIndexOf$default((CharSequence)string, (char)'-', (int)limit, (boolean)false, (int)4, null);
        if (lastDelimiter >= (pos += 4)) {
            while (pos < lastDelimiter) {
                char codePoint;
                boolean bl = (('a' <= (codePoint = string.charAt(pos++)) ? codePoint < '{' : false) ? true : ('A' <= codePoint ? codePoint < '[' : false)) ? true : ('0' <= codePoint ? codePoint < ':' : false);
                if (bl ? true : codePoint == '-') {
                    ((Collection)codePoints).add(Integer.valueOf(codePoint));
                    continue;
                }
                return false;
            }
            ++pos;
        }
        int n = 128;
        int i = 0;
        int bias = 72;
        while (pos < limit) {
            int oldi = i;
            int w = 1;
            IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)36, (int)Integer.MAX_VALUE)), (int)36);
            int k = intProgression.getFirst();
            int n2 = intProgression.getLast();
            int n3 = intProgression.getStep();
            if (n3 > 0 && k <= n2 || n3 < 0 && n2 <= k) {
                while (true) {
                    int t;
                    int n4;
                    char c;
                    char c2;
                    if (pos == limit) {
                        return false;
                    }
                    boolean bl = 'a' <= (c2 = (c = string.charAt(pos++))) ? c2 < '{' : false;
                    if (bl) {
                        n4 = c - 97;
                    } else {
                        boolean bl2 = 'A' <= c2 ? c2 < '[' : false;
                        if (bl2) {
                            n4 = c - 65;
                        } else {
                            boolean bl3 = '0' <= c2 ? c2 < ':' : false;
                            if (bl3) {
                                n4 = c - 48 + 26;
                            } else {
                                return false;
                            }
                        }
                    }
                    int digit = n4;
                    int deltaI = n4 * w;
                    if (i > Integer.MAX_VALUE - deltaI) {
                        return false;
                    }
                    i += deltaI;
                    int n5 = k <= bias ? 1 : (t = k >= bias + 26 ? 26 : k - bias);
                    if (digit < t) break;
                    int scaleW = 36 - t;
                    if (w > Integer.MAX_VALUE / scaleW) {
                        return false;
                    }
                    w *= scaleW;
                    if (k == n2) break;
                    k += n3;
                }
            }
            bias = this.adapt(i - oldi, codePoints.size() + 1, oldi == 0);
            int deltaN = i / (codePoints.size() + 1);
            if (n > Integer.MAX_VALUE - deltaN) {
                return false;
            }
            i %= codePoints.size() + 1;
            if ((n += deltaN) > 0x10FFFF) {
                return false;
            }
            codePoints.add(i, n);
            ++i;
        }
        Iterator iterator = codePoints.iterator();
        while (iterator.hasNext()) {
            int codePoint = ((Number)iterator.next()).intValue();
            result.writeUtf8CodePoint(codePoint);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int adapt(int delta, int numpoints, boolean first) {
        void var1_1;
        void var2_2;
        delta = first ? delta / 700 : delta / 2;
        delta = delta + delta / numpoints;
        int k = 0;
        while (delta > 455) {
            delta /= 35;
            k += 36;
        }
        return (int)(var2_2 + delta * 36 / (var1_1 + 38));
    }

    private final boolean requiresEncode(String $this$requiresEncode, int pos, int limit) {
        for (int i = pos; i < limit; ++i) {
            if ($this$requiresEncode.charAt(i) < '\u0080') continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> codePoints(String $this$codePoints, int pos, int limit) {
        void i;
        List result = new ArrayList();
        while (i < limit) {
            int n;
            int c = $this$codePoints.charAt((int)i);
            Collection collection = result;
            if (CharsKt.isSurrogate((char)c)) {
                char low;
                char c2 = low = i + true < limit ? $this$codePoints.charAt((int)(i + true)) : (char)'\u0000';
                if (Character.isLowSurrogate((char)c) || !Character.isLowSurrogate(low)) {
                    n = 63;
                } else {
                    ++i;
                    n = 65536 + ((c & 0x3FF) << 10 | low & 0x3FF);
                }
            } else {
                n = c;
            }
            Integer n2 = n;
            collection.add(n2);
            ++i;
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final int getPunycodeDigit(int $this$punycodeDigit) {
        void var1_1;
        if ($this$punycodeDigit < 26) {
            return $this$punycodeDigit + 97;
        }
        if ($this$punycodeDigit < 36) {
            return $this$punycodeDigit - 26 + 48;
        }
        throw new IllegalStateException(("unexpected digit: " + (int)var1_1).toString());
    }
}

