/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.idn;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal.idn.IdnaMappingTableKt;
import okio.BufferedSink;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/idn/IdnaMappingTable;", "", "sections", "", "ranges", "mappings", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getMappings", "()Ljava/lang/String;", "getRanges", "getSections", "findRangesOffset", "", "codePoint", "position", "limit", "findSectionsIndex", "map", "", "sink", "Lokio/BufferedSink;", "okhttp"})
@SourceDebugExtension(value={"SMAP\nIdnaMappingTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTable\n+ 2 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTableKt\n*L\n1#1,286:1\n272#2,13:287\n272#2,13:300\n*S KotlinDebug\n*F\n+ 1 IdnaMappingTable.kt\nokhttp3/internal/idn/IdnaMappingTable\n*L\n209#1:287,13\n237#1:300,13\n*E\n"})
public final class IdnaMappingTable {
    private final String sections;
    private final String ranges;
    private final String mappings;

    /*
     * WARNING - void declaration
     */
    public IdnaMappingTable(String sections, String ranges, String mappings) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)sections, (String)"sections");
        Intrinsics.checkNotNullParameter((Object)ranges, (String)"ranges");
        Intrinsics.checkNotNullParameter((Object)mappings, (String)"mappings");
        this.sections = var1_1;
        this.ranges = var2_2;
        this.mappings = var3_3;
    }

    public final String getSections() {
        return this.sections;
    }

    public final String getRanges() {
        return this.ranges;
    }

    public final String getMappings() {
        return this.mappings;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean map(int codePoint, BufferedSink sink) {
        Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
        int sectionsIndex = this.findSectionsIndex(codePoint);
        int rangesPosition = IdnaMappingTableKt.read14BitInt(this.sections, sectionsIndex + 2);
        int rangesLimit = sectionsIndex + 4 < this.sections.length() ? IdnaMappingTableKt.read14BitInt(this.sections, sectionsIndex + 6) : this.ranges.length() / 4;
        int rangesIndex = this.findRangesOffset(codePoint, rangesPosition, rangesLimit);
        char b1 = this.ranges.charAt(rangesIndex + 1);
        boolean bl = b1 >= '\u0000' ? b1 < '@' : false;
        if (bl) {
            int beginIndex;
            int n = beginIndex = IdnaMappingTableKt.read14BitInt(this.ranges, rangesIndex + 2);
            sink.writeUtf8(this.mappings, n, n + b1);
        } else {
            int codepointDelta;
            char b3;
            boolean bl2 = '@' <= b1 ? b1 < 'P' : false;
            if (bl2) {
                char b2 = this.ranges.charAt(rangesIndex + 2);
                b3 = this.ranges.charAt(rangesIndex + 3);
                codepointDelta = (b1 & 0xF) << 14 | b2 << 7 | b3;
                sink.writeUtf8CodePoint(codePoint - codepointDelta);
            } else {
                void var3_3;
                boolean bl3 = 'P' <= b1 ? b1 < '`' : false;
                if (bl3) {
                    char b2 = this.ranges.charAt((int)(codepointDelta + 2));
                    b3 = this.ranges.charAt((int)(codepointDelta + 3));
                    codepointDelta = (b1 & 0xF) << 14 | b2 << 7 | b3;
                    sink.writeUtf8CodePoint(codePoint + var3_3);
                } else if (b1 != 'w') {
                    if (b1 == 'x') {
                        sink.writeUtf8CodePoint(codePoint);
                    } else {
                        if (b1 == 'y') {
                            sink.writeUtf8CodePoint(codePoint);
                            return false;
                        }
                        if (b1 == 'z') {
                            sink.writeByte((int)this.ranges.charAt((int)(var3_3 + 2)));
                        } else if (b1 == '{') {
                            sink.writeByte(this.ranges.charAt((int)(var3_3 + 2)) | 0x80);
                        } else if (b1 == '|') {
                            sink.writeByte((int)this.ranges.charAt((int)(var3_3 + 2)));
                            sink.writeByte((int)this.ranges.charAt((int)(var3_3 + 3)));
                        } else if (b1 == '}') {
                            sink.writeByte(this.ranges.charAt((int)(var3_3 + 2)) | 0x80);
                            sink.writeByte((int)this.ranges.charAt((int)(var3_3 + 3)));
                        } else if (b1 == '~') {
                            sink.writeByte((int)this.ranges.charAt((int)(var3_3 + 2)));
                            sink.writeByte(this.ranges.charAt((int)(var3_3 + 3)) | 0x80);
                        } else if (b1 == '\u007f') {
                            void var2_2;
                            sink.writeByte(this.ranges.charAt((int)(var3_3 + 2)) | 0x80);
                            var2_2.writeByte(this.ranges.charAt((int)(var3_3 + 3)) | 0x80);
                        } else {
                            void var1_1;
                            throw new IllegalStateException(("unexpected rangesIndex for " + (int)var1_1).toString());
                        }
                    }
                }
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final int findSectionsIndex(int codePoint) {
        void var1_1;
        void offset;
        int n;
        block4: {
            void var3_3;
            int target = (codePoint & 0x1FFF80) >> 7;
            int limit$iv = this.sections.length() / 4;
            int low$iv = 0;
            int high$iv = limit$iv - 1;
            while (low$iv <= high$iv) {
                int mid$iv;
                int n2 = mid$iv = (low$iv + high$iv) / 2;
                int entryIndex = mid$iv << 2;
                int b0b1 = IdnaMappingTableKt.read14BitInt(this.sections, entryIndex);
                int compareResult$iv = Intrinsics.compare((int)target, (int)b0b1);
                if (compareResult$iv < 0) {
                    high$iv = mid$iv - 1;
                    continue;
                }
                if (compareResult$iv > 0) {
                    low$iv = mid$iv + 1;
                    continue;
                }
                n = mid$iv;
                break block4;
            }
            n = offset = -var3_3 - true;
        }
        if (n >= 0) {
            return (int)(offset << 2);
        }
        return (int)(-var1_1 - 2 << 2);
    }

    /*
     * WARNING - void declaration
     */
    private final int findRangesOffset(int codePoint, int position, int limit) {
        void var1_1;
        void offset;
        void v0;
        block4: {
            void var2_2;
            void low$iv;
            int target = codePoint & 0x7F;
            int high$iv = limit - 1;
            while (low$iv <= high$iv) {
                void mid$iv;
                void var5_5 = mid$iv = (low$iv + high$iv) / 2;
                void entryIndex = mid$iv << 2;
                char b0 = this.ranges.charAt((int)entryIndex);
                int compareResult$iv = Intrinsics.compare((int)target, (int)b0);
                if (compareResult$iv < 0) {
                    high$iv = mid$iv - true;
                    continue;
                }
                if (compareResult$iv > 0) {
                    low$iv = mid$iv + true;
                    continue;
                }
                v0 = mid$iv;
                break block4;
            }
            v0 = offset = -var2_2 - true;
        }
        if (v0 >= 0) {
            return (int)(offset << 2);
        }
        return (int)(-var1_1 - 2 << 2);
    }
}

