/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.IOException;
import java.net.ProtocolException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RequestLine;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Connection;
import okhttp3.internal.http2.Http2ExchangeCodec;
import okhttp3.internal.http2.Http2Stream;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 (2\u00020\u0001:\u0001(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\fH\u0016J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0016J\b\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lokhttp3/internal/http2/Http2ExchangeCodec;", "Lokhttp3/internal/http/ExchangeCodec;", "client", "Lokhttp3/OkHttpClient;", "carrier", "Lokhttp3/internal/http/ExchangeCodec$Carrier;", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "http2Connection", "Lokhttp3/internal/http2/Http2Connection;", "(Lokhttp3/OkHttpClient;Lokhttp3/internal/http/ExchangeCodec$Carrier;Lokhttp3/internal/http/RealInterceptorChain;Lokhttp3/internal/http2/Http2Connection;)V", "canceled", "", "getCarrier", "()Lokhttp3/internal/http/ExchangeCodec$Carrier;", "protocol", "Lokhttp3/Protocol;", "stream", "Lokhttp3/internal/http2/Http2Stream;", "cancel", "", "createRequestBody", "Lokio/Sink;", "request", "Lokhttp3/Request;", "contentLength", "", "finishRequest", "flushRequest", "openResponseBodySource", "Lokio/Source;", "response", "Lokhttp3/Response;", "readResponseHeaders", "Lokhttp3/Response$Builder;", "expectContinue", "reportedContentLength", "trailers", "Lokhttp3/Headers;", "writeRequestHeaders", "Companion", "okhttp"})
public final class Http2ExchangeCodec
implements ExchangeCodec {
    public static final Companion Companion = new Companion(null);
    private final ExchangeCodec.Carrier carrier;
    private final RealInterceptorChain chain;
    private final Http2Connection http2Connection;
    private volatile Http2Stream stream;
    private final Protocol protocol;
    private volatile boolean canceled;
    private static final String CONNECTION = "connection";
    private static final String HOST = "host";
    private static final String KEEP_ALIVE = "keep-alive";
    private static final String PROXY_CONNECTION = "proxy-connection";
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String TE = "te";
    private static final String ENCODING = "encoding";
    private static final String UPGRADE = "upgrade";
    private static final List<String> HTTP_2_SKIPPED_REQUEST_HEADERS;
    private static final List<String> HTTP_2_SKIPPED_RESPONSE_HEADERS;

    /*
     * WARNING - void declaration
     */
    public Http2ExchangeCodec(OkHttpClient client, ExchangeCodec.Carrier carrier, RealInterceptorChain chain, Http2Connection http2Connection) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)carrier, (String)"carrier");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        Intrinsics.checkNotNullParameter((Object)http2Connection, (String)"http2Connection");
        this.carrier = var2_2;
        this.chain = var3_3;
        this.http2Connection = http2Connection;
        this.protocol = var1_1.protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE) ? Protocol.H2_PRIOR_KNOWLEDGE : Protocol.HTTP_2;
    }

    @Override
    public final ExchangeCodec.Carrier getCarrier() {
        return this.carrier;
    }

    @Override
    public final Sink createRequestBody(Request request, long contentLength) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSink();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void writeRequestHeaders(Request request) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (this.stream != null) {
            return;
        }
        boolean hasRequestBody = request.body() != null;
        List<Header> requestHeaders = Companion.http2HeadersList(request);
        this.stream = this.http2Connection.newStream((List<Header>)var1_1, (boolean)var2_2);
        if (this.canceled) {
            Http2Stream http2Stream = this.stream;
            Intrinsics.checkNotNull((Object)http2Stream);
            http2Stream.closeLater(ErrorCode.CANCEL);
            throw new IOException("Canceled");
        }
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.readTimeout().timeout((long)this.chain.getReadTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
        Http2Stream http2Stream2 = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream2);
        http2Stream2.writeTimeout().timeout((long)this.chain.getWriteTimeoutMillis$okhttp(), TimeUnit.MILLISECONDS);
    }

    @Override
    public final void flushRequest() {
        this.http2Connection.flush();
    }

    @Override
    public final void finishRequest() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        http2Stream.getSink().close();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Response.Builder readResponseHeaders(boolean expectContinue) {
        void var1_1;
        Http2Stream http2Stream = this.stream;
        if (http2Stream == null) {
            throw new IOException("stream wasn't created");
        }
        Http2Stream http2Stream2 = http2Stream;
        Headers headers2 = http2Stream.takeHeaders(expectContinue);
        Response.Builder responseBuilder2 = Companion.readHttp2HeadersList(headers2, this.protocol);
        if (var1_1 != false && responseBuilder2.getCode$okhttp() == 100) {
            return null;
        }
        return http2Stream2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final long reportedContentLength(Response response) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (!HttpHeaders.promisesBody(response)) {
            return 0L;
        }
        return _UtilJvmKt.headersContentLength((Response)var1_1);
    }

    @Override
    public final Source openResponseBodySource(Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.getSource$okhttp();
    }

    @Override
    public final Headers trailers() {
        Http2Stream http2Stream = this.stream;
        Intrinsics.checkNotNull((Object)http2Stream);
        return http2Stream.trailers();
    }

    @Override
    public final void cancel() {
        this.canceled = true;
        Http2Stream http2Stream = this.stream;
        if (http2Stream != null) {
            http2Stream.closeLater(ErrorCode.CANCEL);
            return;
        }
    }

    static {
        String[] stringArray = new String[12];
        String[] stringArray2 = stringArray;
        stringArray[0] = CONNECTION;
        stringArray2[1] = HOST;
        stringArray2[2] = KEEP_ALIVE;
        stringArray2[3] = PROXY_CONNECTION;
        stringArray2[4] = TE;
        stringArray2[5] = TRANSFER_ENCODING;
        stringArray2[6] = ENCODING;
        stringArray2[7] = UPGRADE;
        stringArray2[8] = ":method";
        stringArray2[9] = ":path";
        stringArray2[10] = ":scheme";
        stringArray2[11] = ":authority";
        HTTP_2_SKIPPED_REQUEST_HEADERS = _UtilJvmKt.immutableListOf(stringArray2);
        String[] stringArray3 = new String[8];
        stringArray2 = stringArray3;
        stringArray3[0] = CONNECTION;
        stringArray2[1] = HOST;
        stringArray2[2] = KEEP_ALIVE;
        stringArray2[3] = PROXY_CONNECTION;
        stringArray2[4] = TE;
        stringArray2[5] = TRANSFER_ENCODING;
        stringArray2[6] = ENCODING;
        stringArray2[7] = UPGRADE;
        HTTP_2_SKIPPED_RESPONSE_HEADERS = _UtilJvmKt.immutableListOf(stringArray2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/http2/Http2ExchangeCodec$Companion;", "", "()V", "CONNECTION", "", "ENCODING", "HOST", "HTTP_2_SKIPPED_REQUEST_HEADERS", "", "HTTP_2_SKIPPED_RESPONSE_HEADERS", "KEEP_ALIVE", "PROXY_CONNECTION", "TE", "TRANSFER_ENCODING", "UPGRADE", "http2HeadersList", "Lokhttp3/internal/http2/Header;", "request", "Lokhttp3/Request;", "readHttp2HeadersList", "Lokhttp3/Response$Builder;", "headerBlock", "Lokhttp3/Headers;", "protocol", "Lokhttp3/Protocol;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final List<Header> http2HeadersList(Request request) {
            void var3_4;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Headers headers2 = request.headers();
            ArrayList<Header> result = new ArrayList<Header>(headers2.size() + 4);
            result.add(new Header(Header.TARGET_METHOD, request.method()));
            result.add(new Header(Header.TARGET_PATH, RequestLine.INSTANCE.requestPath(request.url())));
            String host = request.header("Host");
            if (host != null) {
                result.add(new Header(Header.TARGET_AUTHORITY, host));
            }
            result.add(new Header(Header.TARGET_SCHEME, request.url().scheme()));
            int n = headers2.size();
            for (int i = 0; i < n; ++i) {
                String name;
                String string = headers2.name(i);
                Locale locale = Locale.US;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(locale), (String)"toLowerCase(...)");
                if (HTTP_2_SKIPPED_REQUEST_HEADERS.contains(name) && (!Intrinsics.areEqual((Object)name, (Object)Http2ExchangeCodec.TE) || !Intrinsics.areEqual((Object)headers2.value(i), (Object)"trailers"))) continue;
                result.add(new Header(name, headers2.value(i)));
            }
            return (List)var3_4;
        }

        /*
         * WARNING - void declaration
         */
        public final Response.Builder readHttp2HeadersList(Headers headerBlock, Protocol protocol) {
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)headerBlock, (String)"headerBlock");
            Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
            StatusLine statusLine = null;
            Headers.Builder headersBuilder = new Headers.Builder();
            int n = headerBlock.size();
            for (int i = 0; i < n; ++i) {
                String name = headerBlock.name(i);
                String value = headerBlock.value(i);
                if (Intrinsics.areEqual((Object)name, (Object)":status")) {
                    statusLine = StatusLine.Companion.parse("HTTP/1.1 " + value);
                    continue;
                }
                if (HTTP_2_SKIPPED_RESPONSE_HEADERS.contains(name)) continue;
                headersBuilder.addLenient$okhttp(name, value);
            }
            if (statusLine == null) {
                throw new ProtocolException("Expected ':status' header not present");
            }
            return new Response.Builder().protocol((Protocol)var2_2).code(statusLine.code).message(var3_3.message).headers(headersBuilder.build()).trailers((Function0<Headers>)((Function0)readHttp2HeadersList.1.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

