/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http2;

import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Headers;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http2.ConnectionShutdownException;
import okhttp3.internal.http2.ErrorCode;
import okhttp3.internal.http2.FlowControlListener;
import okhttp3.internal.http2.Header;
import okhttp3.internal.http2.Http2Reader;
import okhttp3.internal.http2.Http2Stream;
import okhttp3.internal.http2.Http2Writer;
import okhttp3.internal.http2.PushObserver;
import okhttp3.internal.http2.Settings;
import okhttp3.internal.http2.flowcontrol.WindowCounter;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00c2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 \u009d\u00012\u00020\u0001:\b\u009c\u0001\u009d\u0001\u009e\u0001\u009f\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010T\u001a\u00020UJ\b\u0010V\u001a\u00020UH\u0016J'\u0010V\u001a\u00020U2\u0006\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020X2\b\u0010Z\u001a\u0004\u0018\u00010[H\u0000\u00a2\u0006\u0002\b\\J\u0012\u0010]\u001a\u00020U2\b\u0010^\u001a\u0004\u0018\u00010[H\u0002J\u0006\u0010_\u001a\u00020UJ\u0010\u0010`\u001a\u0004\u0018\u00010D2\u0006\u0010a\u001a\u00020\u0012J\u000e\u0010b\u001a\u00020\t2\u0006\u0010c\u001a\u00020\u0006J&\u0010d\u001a\u00020D2\u0006\u0010e\u001a\u00020\u00122\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0g2\u0006\u0010i\u001a\u00020\tH\u0002J\u001c\u0010d\u001a\u00020D2\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0g2\u0006\u0010i\u001a\u00020\tJ\u0006\u0010j\u001a\u00020\u0012J-\u0010k\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\u0006\u0010m\u001a\u00020n2\u0006\u0010o\u001a\u00020\u00122\u0006\u0010p\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bqJ+\u0010r\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0g2\u0006\u0010p\u001a\u00020\tH\u0000\u00a2\u0006\u0002\bsJ#\u0010t\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0gH\u0000\u00a2\u0006\u0002\buJ\u001d\u0010v\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\u0006\u0010w\u001a\u00020XH\u0000\u00a2\u0006\u0002\bxJ$\u0010y\u001a\u00020D2\u0006\u0010e\u001a\u00020\u00122\f\u0010f\u001a\b\u0012\u0004\u0012\u00020h0g2\u0006\u0010i\u001a\u00020\tJ\u0015\u0010z\u001a\u00020\t2\u0006\u0010l\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b{J\u0017\u0010|\u001a\u0004\u0018\u00010D2\u0006\u0010l\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b}J\r\u0010~\u001a\u00020UH\u0000\u00a2\u0006\u0002\b\u007fJ\u0010\u0010\u0080\u0001\u001a\u00020U2\u0007\u0010\u0081\u0001\u001a\u00020*J\u0010\u0010\u0082\u0001\u001a\u00020U2\u0007\u0010\u0083\u0001\u001a\u00020XJ\u0014\u0010\u0084\u0001\u001a\u00020U2\t\b\u0002\u0010\u0085\u0001\u001a\u00020\tH\u0007J\u0018\u0010\u0086\u0001\u001a\u00020U2\u0007\u0010\u0087\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u0088\u0001J,\u0010\u0089\u0001\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\u0007\u0010\u008a\u0001\u001a\u00020\t2\n\u0010\u008b\u0001\u001a\u0005\u0018\u00010\u008c\u00012\u0006\u0010o\u001a\u00020\u0006J/\u0010\u008d\u0001\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\u0007\u0010\u008a\u0001\u001a\u00020\t2\r\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020h0gH\u0000\u00a2\u0006\u0003\b\u008f\u0001J\u0007\u0010\u0090\u0001\u001a\u00020UJ\"\u0010\u0090\u0001\u001a\u00020U2\u0007\u0010\u0091\u0001\u001a\u00020\t2\u0007\u0010\u0092\u0001\u001a\u00020\u00122\u0007\u0010\u0093\u0001\u001a\u00020\u0012J\u0007\u0010\u0094\u0001\u001a\u00020UJ \u0010\u0095\u0001\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\u0007\u0010\u0083\u0001\u001a\u00020XH\u0000\u00a2\u0006\u0003\b\u0096\u0001J\u001f\u0010\u0097\u0001\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\u0006\u0010w\u001a\u00020XH\u0000\u00a2\u0006\u0003\b\u0098\u0001J \u0010\u0099\u0001\u001a\u00020U2\u0006\u0010l\u001a\u00020\u00122\u0007\u0010\u009a\u0001\u001a\u00020\u0006H\u0000\u00a2\u0006\u0003\b\u009b\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0014\u0010\"\u001a\u00020#X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u001f\"\u0004\b(\u0010!R\u0011\u0010)\u001a\u00020*\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001a\u0010-\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010,\"\u0004\b/\u00100R\u000e\u00101\u001a\u000202X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00105\u001a\u000206\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0015\u00109\u001a\u00060:R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u000e\u0010=\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010>\u001a\u00020?X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR \u0010B\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020D0CX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010FR\u000e\u0010G\u001a\u00020HX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010J\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bK\u0010LR\u001e\u0010M\u001a\u00020\u00062\u0006\u0010I\u001a\u00020\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\bN\u0010LR\u0011\u0010O\u001a\u00020P\u00a2\u0006\b\n\u0000\u001a\u0004\bQ\u0010RR\u000e\u0010S\u001a\u000204X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a0\u0001"}, d2={"Lokhttp3/internal/http2/Http2Connection;", "Ljava/io/Closeable;", "builder", "Lokhttp3/internal/http2/Http2Connection$Builder;", "(Lokhttp3/internal/http2/Http2Connection$Builder;)V", "awaitPingsSent", "", "awaitPongsReceived", "client", "", "getClient$okhttp", "()Z", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "currentPushRequests", "", "", "degradedPingsSent", "degradedPongDeadlineNs", "degradedPongsReceived", "flowControlListener", "Lokhttp3/internal/http2/FlowControlListener;", "getFlowControlListener$okhttp", "()Lokhttp3/internal/http2/FlowControlListener;", "intervalPingsSent", "intervalPongsReceived", "isShutdown", "lastGoodStreamId", "getLastGoodStreamId$okhttp", "()I", "setLastGoodStreamId$okhttp", "(I)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "nextStreamId", "getNextStreamId$okhttp", "setNextStreamId$okhttp", "okHttpSettings", "Lokhttp3/internal/http2/Settings;", "getOkHttpSettings", "()Lokhttp3/internal/http2/Settings;", "peerSettings", "getPeerSettings", "setPeerSettings", "(Lokhttp3/internal/http2/Settings;)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "pushQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "readBytes", "Lokhttp3/internal/http2/flowcontrol/WindowCounter;", "getReadBytes", "()Lokhttp3/internal/http2/flowcontrol/WindowCounter;", "readerRunnable", "Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "getReaderRunnable", "()Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "settingsListenerQueue", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "streams", "", "Lokhttp3/internal/http2/Http2Stream;", "getStreams$okhttp", "()Ljava/util/Map;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "<set-?>", "writeBytesMaximum", "getWriteBytesMaximum", "()J", "writeBytesTotal", "getWriteBytesTotal", "writer", "Lokhttp3/internal/http2/Http2Writer;", "getWriter", "()Lokhttp3/internal/http2/Http2Writer;", "writerQueue", "awaitPong", "", "close", "connectionCode", "Lokhttp3/internal/http2/ErrorCode;", "streamCode", "cause", "Ljava/io/IOException;", "close$okhttp", "failConnection", "e", "flush", "getStream", "id", "isHealthy", "nowNs", "newStream", "associatedStreamId", "requestHeaders", "", "Lokhttp3/internal/http2/Header;", "out", "openStreamCount", "pushDataLater", "streamId", "source", "Lokio/BufferedSource;", "byteCount", "inFinished", "pushDataLater$okhttp", "pushHeadersLater", "pushHeadersLater$okhttp", "pushRequestLater", "pushRequestLater$okhttp", "pushResetLater", "errorCode", "pushResetLater$okhttp", "pushStream", "pushedStream", "pushedStream$okhttp", "removeStream", "removeStream$okhttp", "sendDegradedPingLater", "sendDegradedPingLater$okhttp", "setSettings", "settings", "shutdown", "statusCode", "start", "sendConnectionPreface", "updateConnectionFlowControl", "read", "updateConnectionFlowControl$okhttp", "writeData", "outFinished", "buffer", "Lokio/Buffer;", "writeHeaders", "alternating", "writeHeaders$okhttp", "writePing", "reply", "payload1", "payload2", "writePingAndAwaitPong", "writeSynReset", "writeSynReset$okhttp", "writeSynResetLater", "writeSynResetLater$okhttp", "writeWindowUpdateLater", "unacknowledgedBytesRead", "writeWindowUpdateLater$okhttp", "Builder", "Companion", "Listener", "ReaderRunnable", "okhttp"})
@SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n+ 2 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 -UtilCommon.kt\nokhttp3/internal/_UtilCommonKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1049:1\n301#2:1050\n295#2:1052\n295#2:1053\n367#2,4:1054\n1#3:1051\n245#4,5:1058\n245#4,5:1066\n245#4,5:1072\n245#4,5:1077\n37#5,2:1063\n13309#6:1065\n13310#6:1071\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection\n*L\n185#1:1050\n322#1:1052\n408#1:1053\n452#1:1054,4\n454#1:1058,5\n467#1:1066,5\n473#1:1072,5\n478#1:1077,5\n461#1:1063,2\n466#1:1065\n466#1:1071\n*E\n"})
public final class Http2Connection
implements Closeable {
    public static final Companion Companion;
    private final boolean client;
    private final Listener listener;
    private final Map<Integer, Http2Stream> streams;
    private final String connectionName;
    private int lastGoodStreamId;
    private int nextStreamId;
    private boolean isShutdown;
    private final TaskRunner taskRunner;
    private final TaskQueue writerQueue;
    private final TaskQueue pushQueue;
    private final TaskQueue settingsListenerQueue;
    private final PushObserver pushObserver;
    private long intervalPingsSent;
    private long intervalPongsReceived;
    private long degradedPingsSent;
    private long degradedPongsReceived;
    private long awaitPingsSent;
    private long awaitPongsReceived;
    private long degradedPongDeadlineNs;
    private final FlowControlListener flowControlListener;
    private final Settings okHttpSettings;
    private Settings peerSettings;
    private final WindowCounter readBytes;
    private long writeBytesTotal;
    private long writeBytesMaximum;
    private final Socket socket;
    private final Http2Writer writer;
    private final ReaderRunnable readerRunnable;
    private final Set<Integer> currentPushRequests;
    public static final int OKHTTP_CLIENT_WINDOW_SIZE = 0x1000000;
    private static final Settings DEFAULT_SETTINGS;
    public static final int INTERVAL_PING = 1;
    public static final int DEGRADED_PING = 2;
    public static final int AWAIT_PING = 3;
    public static final int DEGRADED_PONG_TIMEOUT_NS = 1000000000;

    /*
     * WARNING - void declaration
     */
    public Http2Connection(Builder builder) {
        Settings settings2;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.client = builder.getClient$okhttp();
        this.listener = builder.getListener$okhttp();
        this.streams = new LinkedHashMap();
        this.connectionName = builder.getConnectionName$okhttp();
        this.nextStreamId = builder.getClient$okhttp() ? 3 : 2;
        this.taskRunner = builder.getTaskRunner$okhttp();
        this.writerQueue = this.taskRunner.newQueue();
        this.pushQueue = this.taskRunner.newQueue();
        this.settingsListenerQueue = this.taskRunner.newQueue();
        this.pushObserver = builder.getPushObserver$okhttp();
        this.flowControlListener = builder.getFlowControlListener$okhttp();
        Settings settings3 = settings2 = new Settings();
        Http2Connection http2Connection = this;
        if (builder.getClient$okhttp()) {
            settings3.set(7, 0x1000000);
        }
        http2Connection.okHttpSettings = settings2;
        this.peerSettings = DEFAULT_SETTINGS;
        this.readBytes = new WindowCounter(0);
        this.writeBytesMaximum = this.peerSettings.getInitialWindowSize();
        this.socket = builder.getSocket$okhttp();
        this.writer = new Http2Writer(builder.getSink$okhttp(), this.client);
        this.readerRunnable = new ReaderRunnable(this, new Http2Reader(builder.getSource$okhttp(), this.client));
        this.currentPushRequests = new LinkedHashSet();
        if (builder.getPingIntervalMillis$okhttp() != 0) {
            void var2_3;
            void var1_1;
            long pingIntervalNanos = TimeUnit.MILLISECONDS.toNanos(var1_1.getPingIntervalMillis$okhttp());
            this.writerQueue.schedule(this.connectionName + " ping", pingIntervalNanos, (Function0<Long>)((Function0)new Function0<Long>(this, (long)var2_3){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ long $pingIntervalNanos;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$pingIntervalNanos = var2_2;
                    super(0);
                }

                public final Long invoke() {
                    boolean bl;
                    Http2Connection http2Connection = this.this$0;
                    Http2Connection http2Connection2 = this.this$0;
                    synchronized (http2Connection) {
                        boolean bl2;
                        if (http2Connection2.intervalPongsReceived < http2Connection2.intervalPingsSent) {
                            bl2 = true;
                        } else {
                            long l = http2Connection2.intervalPingsSent;
                            Http2Connection.access$setIntervalPingsSent$p(http2Connection2, l + 1L);
                            bl2 = false;
                        }
                        bl = bl2;
                    }
                    boolean bl3 = bl;
                    if (bl3) {
                        Http2Connection.access$failConnection(this.this$0, null);
                        return -1L;
                    }
                    this.this$0.writePing(false, 1, 0);
                    return this.$pingIntervalNanos;
                }
            }));
        }
    }

    public final boolean getClient$okhttp() {
        return this.client;
    }

    public final Listener getListener$okhttp() {
        return this.listener;
    }

    public final Map<Integer, Http2Stream> getStreams$okhttp() {
        return this.streams;
    }

    public final String getConnectionName$okhttp() {
        return this.connectionName;
    }

    public final int getLastGoodStreamId$okhttp() {
        return this.lastGoodStreamId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLastGoodStreamId$okhttp(int n) {
        void var1_1;
        this.lastGoodStreamId = var1_1;
    }

    public final int getNextStreamId$okhttp() {
        return this.nextStreamId;
    }

    /*
     * WARNING - void declaration
     */
    public final void setNextStreamId$okhttp(int n) {
        void var1_1;
        this.nextStreamId = var1_1;
    }

    public final FlowControlListener getFlowControlListener$okhttp() {
        return this.flowControlListener;
    }

    public final Settings getOkHttpSettings() {
        return this.okHttpSettings;
    }

    public final Settings getPeerSettings() {
        return this.peerSettings;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPeerSettings(Settings settings2) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"<set-?>");
        this.peerSettings = var1_1;
    }

    public final WindowCounter getReadBytes() {
        return this.readBytes;
    }

    public final long getWriteBytesTotal() {
        return this.writeBytesTotal;
    }

    public final long getWriteBytesMaximum() {
        return this.writeBytesMaximum;
    }

    public final Socket getSocket$okhttp() {
        return this.socket;
    }

    public final Http2Writer getWriter() {
        return this.writer;
    }

    public final ReaderRunnable getReaderRunnable() {
        return this.readerRunnable;
    }

    public final synchronized int openStreamCount() {
        return this.streams.size();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream getStream(int id) {
        void var1_1;
        return this.streams.get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Http2Stream removeStream$okhttp(int streamId) {
        void var1_2;
        void var2_3;
        Http2Stream stream = this.streams.remove(streamId);
        Http2Connection $this$notifyAll$iv = this;
        Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
        ((Object)var2_3).notifyAll();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void updateConnectionFlowControl$okhttp(long read) {
        void var1_1;
        WindowCounter.update$default(this.readBytes, (long)var1_1, 0L, 2, null);
        long readBytesToAcknowledge = this.readBytes.getUnacknowledged();
        if (readBytesToAcknowledge >= (long)(this.okHttpSettings.getInitialWindowSize() / 2)) {
            void var3_2;
            this.writeWindowUpdateLater$okhttp(0, readBytesToAcknowledge);
            WindowCounter.update$default(this.readBytes, 0L, (long)var3_2, 1, null);
        }
        this.flowControlListener.receivingConnectionWindowChanged(this.readBytes);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Stream pushStream(int associatedStreamId2, List<Header> requestHeaders, boolean out) throws IOException {
        void var3_4;
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        if (!(!this.client)) {
            String associatedStreamId2 = "Client cannot push requests.";
            throw new IllegalStateException(associatedStreamId2.toString());
        }
        return this.newStream((int)var1_1, (List<Header>)var2_3, (boolean)var3_4);
    }

    /*
     * WARNING - void declaration
     */
    public final Http2Stream newStream(List<Header> requestHeaders, boolean out) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        return this.newStream(0, (List<Header>)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final Http2Stream newStream(int associatedStreamId2, List<Header> requestHeaders, boolean out) throws IOException {
        void var3_6;
        Http2Stream stream;
        boolean outFinished = !out;
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            int streamId;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                boolean flushHeaders;
                if (this.nextStreamId > 0x3FFFFFFF) {
                    this.shutdown(ErrorCode.REFUSED_STREAM);
                }
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                streamId = this.nextStreamId;
                this.nextStreamId += 2;
                stream = new Http2Stream(streamId, this, outFinished, false, null);
                boolean bl = flushHeaders = !out || this.writeBytesTotal >= this.writeBytesMaximum || stream.getWriteBytesTotal() >= stream.getWriteBytesMaximum();
                if (stream.isOpen()) {
                    this.streams.put(streamId, stream);
                }
            }
            if (associatedStreamId2 == 0) {
                this.writer.headers(outFinished, streamId, requestHeaders);
            } else {
                void var2_5;
                void var1_1;
                if (!(!this.client)) {
                    String associatedStreamId2 = "client streams shouldn't have associated stream IDs";
                    throw new IllegalArgumentException(associatedStreamId2.toString());
                }
                this.writer.pushPromise((int)var1_1, streamId, (List<Header>)var2_5);
            }
        }
        if (var3_6 != false) {
            this.writer.flush();
        }
        return stream;
    }

    /*
     * WARNING - void declaration
     */
    public final void writeHeaders$okhttp(int streamId, boolean outFinished, List<Header> alternating) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(alternating, (String)"alternating");
        this.writer.headers((boolean)var2_2, (int)var1_1, (List<Header>)var3_3);
    }

    public final void writeData(int streamId, boolean outFinished, Buffer buffer, long byteCount) throws IOException {
        if (byteCount == 0L) {
            this.writer.data(outFinished, streamId, buffer, 0);
            return;
        }
        long byteCount2 = byteCount;
        while (byteCount2 > 0L) {
            int toWrite;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                try {
                    while (this.writeBytesTotal >= this.writeBytesMaximum) {
                        if (!this.streams.containsKey(streamId)) {
                            throw new IOException("stream closed");
                        }
                        Http2Connection $this$wait$iv = this;
                        Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                        ((Object)$this$wait$iv).wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new InterruptedIOException();
                }
                int $this$wait$iv = (int)Math.min(byteCount2, this.writeBytesMaximum - this.writeBytesTotal);
                toWrite = Math.min($this$wait$iv, this.writer.maxDataLength());
                this.writeBytesTotal += (long)toWrite;
            }
            this.writer.data(outFinished && (byteCount2 -= (long)toWrite) == 0L, streamId, buffer, toWrite);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue.execute$default(this.writerQueue, this.connectionName + '[' + streamId + "] writeSynReset", 0L, false, (Function0)new Function0<Unit>(this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId;
            final /* synthetic */ ErrorCode $errorCode;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$streamId = var2_2;
                this.$errorCode = var3_3;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    this.this$0.writeSynReset$okhttp(this.$streamId, this.$errorCode);
                    return;
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                    return;
                }
            }
        }, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeSynReset$okhttp(int streamId, ErrorCode statusCode) throws IOException {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        this.writer.rstStream((int)var1_1, (ErrorCode)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void writeWindowUpdateLater$okhttp(int streamId, long unacknowledgedBytesRead) {
        void var2_2;
        void var1_1;
        TaskQueue.execute$default(this.writerQueue, this.connectionName + '[' + streamId + "] windowUpdate", 0L, false, (Function0)new Function0<Unit>(this, (int)var1_1, (long)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId;
            final /* synthetic */ long $unacknowledgedBytesRead;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$streamId = var2_2;
                this.$unacknowledgedBytesRead = var3_3;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                try {
                    this.this$0.getWriter().windowUpdate(this.$streamId, this.$unacknowledgedBytesRead);
                    return;
                }
                catch (IOException e) {
                    void var1_1;
                    Http2Connection.access$failConnection(this.this$0, (IOException)var1_1);
                    return;
                }
            }
        }, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void writePing(boolean reply, int payload1, int payload2) {
        try {
            void var3_4;
            void var2_3;
            this.writer.ping(reply, (int)var2_3, (int)var3_4);
            return;
        }
        catch (IOException e) {
            void var1_2;
            this.failConnection((IOException)var1_2);
            return;
        }
    }

    public final void writePingAndAwaitPong() throws InterruptedException {
        this.writePing();
        this.awaitPong();
    }

    public final void writePing() throws InterruptedException {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            long l = this.awaitPingsSent;
            this.awaitPingsSent = l + 1L;
        }
        this.writePing(false, 3, 1330343787);
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void awaitPong() throws InterruptedException {
        while (this.awaitPongsReceived < this.awaitPingsSent) {
            void var1_1;
            Http2Connection $this$wait$iv = this;
            Intrinsics.checkNotNull((Object)$this$wait$iv, (String)"null cannot be cast to non-null type java.lang.Object");
            ((Object)var1_1).wait();
        }
    }

    public final void flush() throws IOException {
        this.writer.flush();
    }

    /*
     * WARNING - void declaration
     */
    public final void shutdown(ErrorCode statusCode) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)statusCode), (String)"statusCode");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var1_1;
            void var3_5;
            Ref.IntRef lastGoodStreamId = new Ref.IntRef();
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.isShutdown) {
                    return;
                }
                this.isShutdown = true;
                lastGoodStreamId.element = this.lastGoodStreamId;
            }
            this.writer.goAway(var3_5.element, (ErrorCode)var1_1, _UtilCommonKt.EMPTY_BYTE_ARRAY);
            return;
        }
    }

    @Override
    public final void close() {
        this.close$okhttp(ErrorCode.NO_ERROR, ErrorCode.CANCEL, null);
    }

    public final void close$okhttp(ErrorCode connectionCode, ErrorCode streamCode, IOException cause) {
        Http2Connection http2Connection;
        Intrinsics.checkNotNullParameter((Object)((Object)connectionCode), (String)"connectionCode");
        Intrinsics.checkNotNullParameter((Object)((Object)streamCode), (String)"streamCode");
        Http2Connection $this$assertThreadDoesntHoldLock$iv = this;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        try {
            this.shutdown((ErrorCode)((Object)http2Connection));
        }
        catch (IOException iOException) {}
        Http2Stream[] streamsToClose = null;
        http2Connection = this;
        synchronized (http2Connection) {
            if (!this.streams.isEmpty()) {
                Http2Stream[] http2StreamArray = streamsToClose = this.streams.values();
                streamsToClose = streamsToClose.toArray(new Http2Stream[0]);
                this.streams.clear();
            }
        }
        Http2Stream[] http2StreamArray = streamsToClose;
        if (http2StreamArray != null) {
            Http2Stream[] $this$forEach$iv = http2StreamArray;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Http2Stream http2Stream;
                Http2Stream stream = http2Stream = $this$forEach$iv[i];
                try {
                    stream.close(streamCode, cause);
                    continue;
                }
                catch (IOException iOException) {}
            }
        }
        try {
            this.writer.close();
        }
        catch (IOException iOException) {}
        try {
            this.socket.close();
        }
        catch (IOException iOException) {}
        this.writerQueue.shutdown();
        this.pushQueue.shutdown();
        this.settingsListenerQueue.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private final void failConnection(IOException e) {
        void var1_1;
        ErrorCode errorCode = ErrorCode.PROTOCOL_ERROR;
        this.close$okhttp(errorCode, errorCode, (IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final void start(boolean sendConnectionPreface) throws IOException {
        if (sendConnectionPreface) {
            this.writer.connectionPreface();
            this.writer.settings(this.okHttpSettings);
            int windowSize = this.okHttpSettings.getInitialWindowSize();
            if (windowSize != 65535) {
                void var1_1;
                this.writer.windowUpdate(0, (long)(var1_1 - 65535));
            }
        }
        TaskQueue.execute$default(this.taskRunner.newQueue(), this.connectionName, 0L, false, this.readerRunnable, 6, null);
    }

    public static /* synthetic */ void start$default(Http2Connection http2Connection, boolean bl, int n, Object object) throws IOException {
        if ((n & 1) != 0) {
            bl = true;
        }
        http2Connection.start(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void setSettings(Settings settings2) throws IOException {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        Http2Writer http2Writer = this.writer;
        synchronized (http2Writer) {
            void var1_1;
            Http2Connection http2Connection = this;
            synchronized (http2Connection) {
                if (this.isShutdown) {
                    throw new ConnectionShutdownException();
                }
                this.okHttpSettings.merge(settings2);
            }
            this.writer.settings((Settings)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean isHealthy(long nowNs) {
        void var1_1;
        if (this.isShutdown) {
            return false;
        }
        return this.degradedPongsReceived >= this.degradedPingsSent || var1_1 < this.degradedPongDeadlineNs;
    }

    public final void sendDegradedPingLater$okhttp() {
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.degradedPongsReceived < this.degradedPingsSent) {
                return;
            }
            long l = this.degradedPingsSent;
            this.degradedPingsSent = l + 1L;
            this.degradedPongDeadlineNs = System.nanoTime() + 1000000000L;
        }
        TaskQueue.execute$default(this.writerQueue, this.connectionName + " ping", 0L, false, (Function0)new Function0<Unit>(this){
            final /* synthetic */ Http2Connection this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(0);
            }

            public final void invoke() {
                this.this$0.writePing(false, 2, 0);
            }
        }, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean pushedStream$okhttp(int streamId) {
        void var1_1;
        return streamId != 0 && (var1_1 & 1) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final void pushRequestLater$okhttp(int streamId, List<Header> requestHeaders) {
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        Http2Connection http2Connection = this;
        synchronized (http2Connection) {
            if (this.currentPushRequests.contains(streamId)) {
                this.writeSynResetLater$okhttp(streamId, ErrorCode.PROTOCOL_ERROR);
                return;
            }
            this.currentPushRequests.add(streamId);
        }
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onRequest", 0L, false, (Function0)new Function0<Unit>(this, (int)var1_1, (List<Header>)var2_3){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId;
            final /* synthetic */ List<Header> $requestHeaders;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$streamId = var2_2;
                this.$requestHeaders = var3_3;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                block6: {
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onRequest(this.$streamId, this.$requestHeaders);
                    Http2Connection http2Connection = this.this$0;
                    int n = this.$streamId;
                    try {
                        void var1_1;
                        if (var1_1 != false) {
                            http2Connection.getWriter().rstStream(n, ErrorCode.CANCEL);
                            Http2Connection http2Connection2 = http2Connection;
                            synchronized (http2Connection2) {
                                Http2Connection.access$getCurrentPushRequests$p(http2Connection).remove(n);
                                break block6;
                            }
                        }
                        return;
                    }
                    catch (IOException iOException) {}
                }
            }
        }, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushHeadersLater$okhttp(int streamId, List<Header> requestHeaders, boolean inFinished) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onHeaders", 0L, false, (Function0)new Function0<Unit>(this, (int)var1_1, (List<Header>)var2_2, (boolean)var3_3){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId;
            final /* synthetic */ List<Header> $requestHeaders;
            final /* synthetic */ boolean $inFinished;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$streamId = var2_2;
                this.$requestHeaders = var3_3;
                this.$inFinished = $inFinished;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                block7: {
                    boolean cancel = Http2Connection.access$getPushObserver$p(this.this$0).onHeaders(this.$streamId, this.$requestHeaders, this.$inFinished);
                    Http2Connection http2Connection = this.this$0;
                    int n = this.$streamId;
                    boolean bl = this.$inFinished;
                    try {
                        void var1_1;
                        if (cancel) {
                            http2Connection.getWriter().rstStream(n, ErrorCode.CANCEL);
                        }
                        if (var1_1 != false || bl) {
                            Http2Connection http2Connection2 = http2Connection;
                            synchronized (http2Connection2) {
                                Http2Connection.access$getCurrentPushRequests$p(http2Connection).remove(n);
                                break block7;
                            }
                        }
                        return;
                    }
                    catch (IOException iOException) {}
                }
            }
        }, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushDataLater$okhttp(int streamId, BufferedSource source, int byteCount, boolean inFinished) throws IOException {
        void var3_3;
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Buffer buffer = new Buffer();
        source.require((long)byteCount);
        var2_2.read(buffer, (long)byteCount);
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onData", 0L, false, (Function0)new Function0<Unit>(this, (int)var1_1, buffer, (int)var3_3, inFinished){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId;
            final /* synthetic */ Buffer $buffer;
            final /* synthetic */ int $byteCount;
            final /* synthetic */ boolean $inFinished;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$streamId = var2_2;
                this.$buffer = var3_3;
                this.$byteCount = $byteCount;
                this.$inFinished = $inFinished;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                block7: {
                    Http2Connection http2Connection = this.this$0;
                    int n = this.$streamId;
                    Buffer buffer = this.$buffer;
                    int n2 = this.$byteCount;
                    boolean bl = this.$inFinished;
                    try {
                        void var3_5;
                        boolean cancel = Http2Connection.access$getPushObserver$p(http2Connection).onData(n, (BufferedSource)buffer, n2, bl);
                        if (cancel) {
                            http2Connection.getWriter().rstStream(n, ErrorCode.CANCEL);
                        }
                        if (var3_5 != false || bl) {
                            Http2Connection http2Connection2 = http2Connection;
                            synchronized (http2Connection2) {
                                Http2Connection.access$getCurrentPushRequests$p(http2Connection).remove(n);
                                break block7;
                            }
                        }
                        return;
                    }
                    catch (IOException iOException) {}
                }
            }
        }, 6, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void pushResetLater$okhttp(int streamId, ErrorCode errorCode) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
        TaskQueue.execute$default(this.pushQueue, this.connectionName + '[' + streamId + "] onReset", 0L, false, (Function0)new Function0<Unit>(this, (int)var1_1, (ErrorCode)var2_2){
            final /* synthetic */ Http2Connection this$0;
            final /* synthetic */ int $streamId;
            final /* synthetic */ ErrorCode $errorCode;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$streamId = var2_2;
                this.$errorCode = var3_3;
                super(0);
            }

            public final void invoke() {
                Http2Connection.access$getPushObserver$p(this.this$0).onReset(this.$streamId, this.$errorCode);
                Http2Connection http2Connection = this.this$0;
                Http2Connection http2Connection2 = this.this$0;
                int n = this.$streamId;
                synchronized (http2Connection) {
                    Http2Connection.access$getCurrentPushRequests$p(http2Connection2).remove(n);
                    return;
                }
            }
        }, 6, null);
    }

    @JvmOverloads
    public final void start() throws IOException {
        Http2Connection.start$default(this, false, 1, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$failConnection(Http2Connection $this, IOException e) {
        void var1_1;
        $this.failConnection((IOException)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setDegradedPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.degradedPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setAwaitPongsReceived$p(Http2Connection $this, long l) {
        void var1_1;
        $this.awaitPongsReceived = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setShutdown$p(Http2Connection $this, boolean bl) {
        void var1_1;
        $this.isShutdown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setWriteBytesMaximum$p(Http2Connection $this, long l) {
        void var1_1;
        $this.writeBytesMaximum = var1_1;
    }

    public static final /* synthetic */ PushObserver access$getPushObserver$p(Http2Connection $this) {
        return $this.pushObserver;
    }

    public static final /* synthetic */ Set access$getCurrentPushRequests$p(Http2Connection $this) {
        return $this.currentPushRequests;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setIntervalPingsSent$p(Http2Connection $this, long l) {
        void var1_1;
        $this.intervalPingsSent = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_1;
        Settings settings2;
        Companion = new Companion(null);
        Settings $this$DEFAULT_SETTINGS_u24lambda_u2419 = settings2 = new Settings();
        settings2.set(7, 65535);
        var1_1.set(5, 16384);
        DEFAULT_SETTINGS = settings2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010=\u001a\u00020>J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u0010#\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$J.\u0010/\u001a\u00020\u00002\u0006\u0010/\u001a\u0002002\b\b\u0002\u0010?\u001a\u00020\f2\b\b\u0002\u00105\u001a\u0002062\b\b\u0002\u0010)\u001a\u00020*H\u0007R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u001eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000200X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u000206X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u00a8\u0006@"}, d2={"Lokhttp3/internal/http2/Http2Connection$Builder;", "", "client", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(ZLokhttp3/internal/concurrent/TaskRunner;)V", "getClient$okhttp", "()Z", "setClient$okhttp", "(Z)V", "connectionName", "", "getConnectionName$okhttp", "()Ljava/lang/String;", "setConnectionName$okhttp", "(Ljava/lang/String;)V", "flowControlListener", "Lokhttp3/internal/http2/FlowControlListener;", "getFlowControlListener$okhttp", "()Lokhttp3/internal/http2/FlowControlListener;", "setFlowControlListener$okhttp", "(Lokhttp3/internal/http2/FlowControlListener;)V", "listener", "Lokhttp3/internal/http2/Http2Connection$Listener;", "getListener$okhttp", "()Lokhttp3/internal/http2/Http2Connection$Listener;", "setListener$okhttp", "(Lokhttp3/internal/http2/Http2Connection$Listener;)V", "pingIntervalMillis", "", "getPingIntervalMillis$okhttp", "()I", "setPingIntervalMillis$okhttp", "(I)V", "pushObserver", "Lokhttp3/internal/http2/PushObserver;", "getPushObserver$okhttp", "()Lokhttp3/internal/http2/PushObserver;", "setPushObserver$okhttp", "(Lokhttp3/internal/http2/PushObserver;)V", "sink", "Lokio/BufferedSink;", "getSink$okhttp", "()Lokio/BufferedSink;", "setSink$okhttp", "(Lokio/BufferedSink;)V", "socket", "Ljava/net/Socket;", "getSocket$okhttp", "()Ljava/net/Socket;", "setSocket$okhttp", "(Ljava/net/Socket;)V", "source", "Lokio/BufferedSource;", "getSource$okhttp", "()Lokio/BufferedSource;", "setSource$okhttp", "(Lokio/BufferedSource;)V", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "build", "Lokhttp3/internal/http2/Http2Connection;", "peerName", "okhttp"})
    public static final class Builder {
        private boolean client;
        private final TaskRunner taskRunner;
        public Socket socket;
        public String connectionName;
        public BufferedSource source;
        public BufferedSink sink;
        private Listener listener;
        private PushObserver pushObserver;
        private int pingIntervalMillis;
        private FlowControlListener flowControlListener;

        /*
         * WARNING - void declaration
         */
        public Builder(boolean client, TaskRunner taskRunner) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            this.client = var1_1;
            this.taskRunner = var2_2;
            this.listener = Listener.REFUSE_INCOMING_STREAMS;
            this.pushObserver = PushObserver.CANCEL;
            this.flowControlListener = FlowControlListener.None.INSTANCE;
        }

        public final boolean getClient$okhttp() {
            return this.client;
        }

        /*
         * WARNING - void declaration
         */
        public final void setClient$okhttp(boolean bl) {
            void var1_1;
            this.client = var1_1;
        }

        public final TaskRunner getTaskRunner$okhttp() {
            return this.taskRunner;
        }

        public final Socket getSocket$okhttp() {
            Socket socket = this.socket;
            if (socket != null) {
                return socket;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"socket");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSocket$okhttp(Socket socket) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"<set-?>");
            this.socket = var1_1;
        }

        public final String getConnectionName$okhttp() {
            String string = this.connectionName;
            if (string != null) {
                return string;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"connectionName");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setConnectionName$okhttp(String string) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.connectionName = var1_1;
        }

        public final BufferedSource getSource$okhttp() {
            BufferedSource bufferedSource = this.source;
            if (bufferedSource != null) {
                return bufferedSource;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"source");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSource$okhttp(BufferedSource bufferedSource) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)bufferedSource, (String)"<set-?>");
            this.source = var1_1;
        }

        public final BufferedSink getSink$okhttp() {
            BufferedSink bufferedSink = this.sink;
            if (bufferedSink != null) {
                return bufferedSink;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"sink");
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSink$okhttp(BufferedSink bufferedSink) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)bufferedSink, (String)"<set-?>");
            this.sink = var1_1;
        }

        public final Listener getListener$okhttp() {
            return this.listener;
        }

        /*
         * WARNING - void declaration
         */
        public final void setListener$okhttp(Listener listener) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"<set-?>");
            this.listener = var1_1;
        }

        public final PushObserver getPushObserver$okhttp() {
            return this.pushObserver;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPushObserver$okhttp(PushObserver pushObserver) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)pushObserver, (String)"<set-?>");
            this.pushObserver = var1_1;
        }

        public final int getPingIntervalMillis$okhttp() {
            return this.pingIntervalMillis;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPingIntervalMillis$okhttp(int n) {
            void var1_1;
            this.pingIntervalMillis = var1_1;
        }

        public final FlowControlListener getFlowControlListener$okhttp() {
            return this.flowControlListener;
        }

        /*
         * WARNING - void declaration
         */
        public final void setFlowControlListener$okhttp(FlowControlListener flowControlListener) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)flowControlListener, (String)"<set-?>");
            this.flowControlListener = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final Builder socket(Socket socket, String peerName, BufferedSource source, BufferedSink sink) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
            Builder $this$socket_u24lambda_u240 = builder = this;
            builder.setSocket$okhttp((Socket)var1_1);
            Builder builder2 = $this$socket_u24lambda_u240;
            builder2.setConnectionName$okhttp(builder2.client ? _UtilJvmKt.okHttpName + ' ' + peerName : "MockWebServer " + (String)var2_2);
            $this$socket_u24lambda_u240.setSource$okhttp((BufferedSource)var3_3);
            $this$socket_u24lambda_u240.setSink$okhttp(sink);
            return builder;
        }

        public static /* synthetic */ Builder socket$default(Builder builder, Socket socket, String string, BufferedSource bufferedSource, BufferedSink bufferedSink, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = _UtilJvmKt.peerName(socket);
            }
            if ((n & 4) != 0) {
                bufferedSource = Okio.buffer((Source)Okio.source((Socket)socket));
            }
            if ((n & 8) != 0) {
                bufferedSink = Okio.buffer((Sink)Okio.sink((Socket)socket));
            }
            return builder.socket(socket, string, bufferedSource, bufferedSink);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder listener(Listener listener) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            Builder builder2 = builder = this;
            builder.listener = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder pushObserver(PushObserver pushObserver) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)pushObserver, (String)"pushObserver");
            Builder builder2 = builder = this;
            builder.pushObserver = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder pingIntervalMillis(int pingIntervalMillis) {
            void var1_1;
            Builder builder;
            Builder builder2 = builder = this;
            builder.pingIntervalMillis = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder flowControlListener(FlowControlListener flowControlListener) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)flowControlListener, (String)"flowControlListener");
            Builder builder2 = builder = this;
            builder.flowControlListener = var1_1;
            return builder;
        }

        public final Http2Connection build() {
            return new Http2Connection(this);
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final Builder socket(Socket socket, String peerName, BufferedSource source) throws IOException {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            return Builder.socket$default(this, (Socket)var1_1, (String)var2_2, (BufferedSource)var3_3, null, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final Builder socket(Socket socket, String peerName) throws IOException {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            Intrinsics.checkNotNullParameter((Object)peerName, (String)"peerName");
            return Builder.socket$default(this, (Socket)var1_1, (String)var2_2, null, null, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmOverloads
        public final Builder socket(Socket socket) throws IOException {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
            return Builder.socket$default(this, (Socket)var1_1, null, null, null, 14, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Companion;", "", "()V", "AWAIT_PING", "", "DEFAULT_SETTINGS", "Lokhttp3/internal/http2/Settings;", "getDEFAULT_SETTINGS", "()Lokhttp3/internal/http2/Settings;", "DEGRADED_PING", "DEGRADED_PONG_TIMEOUT_NS", "INTERVAL_PING", "OKHTTP_CLIENT_WINDOW_SIZE", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public final Settings getDEFAULT_SETTINGS() {
            return DEFAULT_SETTINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\r"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener;", "", "()V", "onSettings", "", "connection", "Lokhttp3/internal/http2/Http2Connection;", "settings", "Lokhttp3/internal/http2/Settings;", "onStream", "stream", "Lokhttp3/internal/http2/Http2Stream;", "Companion", "okhttp"})
    public static abstract class Listener {
        public static final Companion Companion = new Companion(null);
        @JvmField
        public static final Listener REFUSE_INCOMING_STREAMS = new Listener(){

            /*
             * WARNING - void declaration
             */
            public final void onStream(Http2Stream stream) throws IOException {
                void var1_1;
                Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
                var1_1.close(ErrorCode.REFUSED_STREAM, null);
            }
        };

        public abstract void onStream(Http2Stream var1) throws IOException;

        /*
         * WARNING - void declaration
         */
        public void onSettings(Http2Connection connection, Settings settings2) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
            Intrinsics.checkNotNullParameter((Object)var2_2, (String)"settings");
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http2/Http2Connection$Listener$Companion;", "", "()V", "REFUSE_INCOMING_STREAMS", "Lokhttp3/internal/http2/Http2Connection$Listener;", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0086\u0004\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\b\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\u0003H\u0016J8\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J(\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\fH\u0016J \u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0010H\u0016J.\u0010$\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010%\u001a\u00020\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\t\u0010)\u001a\u00020\u0003H\u0096\u0002J \u0010*\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u00172\u0006\u0010,\u001a\u00020\f2\u0006\u0010-\u001a\u00020\fH\u0016J(\u0010.\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010/\u001a\u00020\f2\u0006\u00100\u001a\u00020\f2\u0006\u00101\u001a\u00020\u0017H\u0016J&\u00102\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00103\u001a\u00020\f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020(0'H\u0016J\u0018\u00105\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u00106\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00107\u001a\u00020\u0014H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u00068"}, d2={"Lokhttp3/internal/http2/Http2Connection$ReaderRunnable;", "Lokhttp3/internal/http2/Http2Reader$Handler;", "Lkotlin/Function0;", "", "reader", "Lokhttp3/internal/http2/Http2Reader;", "(Lokhttp3/internal/http2/Http2Connection;Lokhttp3/internal/http2/Http2Reader;)V", "getReader$okhttp", "()Lokhttp3/internal/http2/Http2Reader;", "ackSettings", "alternateService", "streamId", "", "origin", "", "protocol", "Lokio/ByteString;", "host", "port", "maxAge", "", "applyAndAckSettings", "clearPrevious", "", "settings", "Lokhttp3/internal/http2/Settings;", "data", "inFinished", "source", "Lokio/BufferedSource;", "length", "goAway", "lastGoodStreamId", "errorCode", "Lokhttp3/internal/http2/ErrorCode;", "debugData", "headers", "associatedStreamId", "headerBlock", "", "Lokhttp3/internal/http2/Header;", "invoke", "ping", "ack", "payload1", "payload2", "priority", "streamDependency", "weight", "exclusive", "pushPromise", "promisedStreamId", "requestHeaders", "rstStream", "windowUpdate", "windowSizeIncrement", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nHttp2Connection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,1049:1\n37#2,2:1050\n37#2,2:1053\n301#3:1052\n301#3:1055\n*S KotlinDebug\n*F\n+ 1 Http2Connection.kt\nokhttp3/internal/http2/Http2Connection$ReaderRunnable\n*L\n782#1:1050,2\n853#1:1053,2\n826#1:1052\n873#1:1055\n*E\n"})
    public final class ReaderRunnable
    implements Function0<Unit>,
    Http2Reader.Handler {
        private final Http2Reader reader;
        final /* synthetic */ Http2Connection this$0;

        /*
         * WARNING - void declaration
         */
        public ReaderRunnable(Http2Connection this$0, Http2Reader reader) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            this.this$0 = var1_1;
            this.reader = var2_2;
        }

        public final Http2Reader getReader$okhttp() {
            return this.reader;
        }

        /*
         * WARNING - void declaration
         */
        public final void invoke() {
            ErrorCode connectionErrorCode = ErrorCode.INTERNAL_ERROR;
            ErrorCode streamErrorCode = ErrorCode.INTERNAL_ERROR;
            IOException errorException = null;
            try {
                this.reader.readConnectionPreface(this);
                while (this.reader.nextFrame(false, this)) {
                }
                connectionErrorCode = ErrorCode.NO_ERROR;
                streamErrorCode = ErrorCode.CANCEL;
                this.this$0.close$okhttp(connectionErrorCode, streamErrorCode, null);
            }
            catch (IOException iOException) {
                try {
                    IOException iOException2 = iOException;
                    errorException = iOException;
                    connectionErrorCode = ErrorCode.PROTOCOL_ERROR;
                    streamErrorCode = ErrorCode.PROTOCOL_ERROR;
                    this.this$0.close$okhttp(connectionErrorCode, streamErrorCode, errorException);
                }
                catch (Throwable throwable) {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0.close$okhttp((ErrorCode)var1_1, (ErrorCode)var2_2, (IOException)var3_3);
                    _UtilCommonKt.closeQuietly(this.reader);
                    throw throwable;
                }
                _UtilCommonKt.closeQuietly(this.reader);
                return;
            }
            _UtilCommonKt.closeQuietly(this.reader);
            return;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void data(boolean inFinished, int streamId, BufferedSource source, int length) throws IOException {
            void var1_1;
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushDataLater$okhttp(streamId, source, length, inFinished);
                return;
            }
            Http2Stream dataStream = this.this$0.getStream(streamId);
            if (dataStream == null) {
                void var2_2;
                this.this$0.writeSynResetLater$okhttp((int)var2_2, ErrorCode.PROTOCOL_ERROR);
                this.this$0.updateConnectionFlowControl$okhttp(length);
                source.skip((long)length);
                return;
            }
            dataStream.receiveData((BufferedSource)var3_3, length);
            if (var1_1 != false) {
                dataStream.receiveHeaders(_UtilJvmKt.EMPTY_HEADERS, true);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void headers(boolean inFinished, int streamId, int associatedStreamId2, List<Header> headerBlock) {
            void var1_1;
            Integer n;
            Intrinsics.checkNotNullParameter(headerBlock, (String)"headerBlock");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushHeadersLater$okhttp(streamId, headerBlock, inFinished);
                return;
            }
            Http2Connection associatedStreamId2 = this.this$0;
            Http2Connection http2Connection = this.this$0;
            Http2Connection http2Connection2 = associatedStreamId2;
            synchronized (http2Connection2) {
                Http2Stream stream = http2Connection.getStream(streamId);
                if (stream == null) {
                    void var1_2;
                    void var2_4;
                    if (http2Connection.isShutdown) {
                        return;
                    }
                    if (streamId <= http2Connection.getLastGoodStreamId$okhttp()) {
                        return;
                    }
                    if (streamId % 2 == http2Connection.getNextStreamId$okhttp() % 2) {
                        return;
                    }
                    Headers headers2 = _UtilJvmKt.toHeaders(headerBlock);
                    Http2Stream newStream = new Http2Stream(streamId, http2Connection, false, inFinished, (Headers)((Object)n));
                    http2Connection.setLastGoodStreamId$okhttp(streamId);
                    n = streamId;
                    http2Connection.getStreams$okhttp().put(n, newStream);
                    TaskQueue.execute$default(http2Connection.taskRunner.newQueue(), http2Connection.getConnectionName$okhttp() + '[' + (int)var2_4 + "] onStream", 0L, false, (Function0)new Function0<Unit>(http2Connection, (Http2Stream)var1_2){
                        final /* synthetic */ Http2Connection this$0;
                        final /* synthetic */ Http2Stream $newStream;
                        {
                            void var2_2;
                            void var1_1;
                            this.this$0 = var1_1;
                            this.$newStream = var2_2;
                            super(0);
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke() {
                            try {
                                this.this$0.getListener$okhttp().onStream(this.$newStream);
                                return;
                            }
                            catch (IOException e) {
                                Platform.Companion.get().log("Http2Connection.Listener failure for " + this.this$0.getConnectionName$okhttp(), 4, e);
                                Http2Stream http2Stream = this.$newStream;
                                try {
                                    void var1_1;
                                    http2Stream.close(ErrorCode.PROTOCOL_ERROR, (IOException)var1_1);
                                    return;
                                }
                                catch (IOException iOException) {
                                    return;
                                }
                            }
                        }
                    }, 6, null);
                    return;
                }
            }
            ((Http2Stream)((Object)n)).receiveHeaders(_UtilJvmKt.toHeaders(headerBlock), (boolean)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void rstStream(int streamId, ErrorCode errorCode) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)((Object)errorCode), (String)"errorCode");
            if (this.this$0.pushedStream$okhttp(streamId)) {
                this.this$0.pushResetLater$okhttp(streamId, errorCode);
                return;
            }
            Http2Stream http2Stream = this.this$0.removeStream$okhttp((int)var1_1);
            if (http2Stream != null) {
                void var2_3;
                http2Stream.receiveRstStream((ErrorCode)var2_3);
                return;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void settings(boolean clearPrevious, Settings settings2) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            TaskQueue.execute$default(this.this$0.writerQueue, this.this$0.getConnectionName$okhttp() + " applyAndAckSettings", 0L, false, (Function0)new Function0<Unit>(this, (boolean)var1_1, (Settings)var2_2){
                final /* synthetic */ ReaderRunnable this$0;
                final /* synthetic */ boolean $clearPrevious;
                final /* synthetic */ Settings $settings;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$clearPrevious = var2_2;
                    this.$settings = var3_3;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.applyAndAckSettings(this.$clearPrevious, this.$settings);
                }
            }, 6, null);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public final void applyAndAckSettings(boolean clearPrevious2, Settings settings2) {
            Http2Stream[] http2StreamArray;
            Settings settings3;
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            Ref.ObjectRef newPeerSettings = new Ref.ObjectRef();
            Http2Stream[] http2StreamArray2 = this.this$0.getWriter();
            Http2Connection http2Connection = this.this$0;
            Http2Stream[] http2StreamArray3 = http2StreamArray2;
            // MONITORENTER : http2StreamArray2
            Object object = http2Connection;
            // MONITORENTER : object
            Settings previousPeerSettings = http2Connection.getPeerSettings();
            Ref.ObjectRef objectRef = newPeerSettings;
            if (clearPrevious2) {
                settings3 = settings2;
            } else {
                void var2_4;
                void $this$applyAndAckSettings_u24lambda_u243_u24lambda_u242_u24lambda_u241;
                Settings settings4 = clearPrevious2 = new Settings();
                Ref.ObjectRef objectRef2 = objectRef;
                $this$applyAndAckSettings_u24lambda_u243_u24lambda_u242_u24lambda_u241.merge(previousPeerSettings);
                $this$applyAndAckSettings_u24lambda_u243_u24lambda_u242_u24lambda_u241.merge((Settings)var2_4);
                objectRef = objectRef2;
                settings3 = clearPrevious2;
            }
            objectRef.element = settings3;
            long l = ((Settings)newPeerSettings.element).getInitialWindowSize();
            long delta = l - (long)previousPeerSettings.getInitialWindowSize();
            if (delta == 0L || http2Connection.getStreams$okhttp().isEmpty()) {
                http2StreamArray = null;
            } else {
                Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
                Collection<Http2Stream> clearPrevious2 = collection;
                clearPrevious2 = collection;
                http2StreamArray = collection.toArray(new Http2Stream[0]);
            }
            Http2Stream[] streamsToNotify = http2StreamArray;
            http2Connection.setPeerSettings((Settings)newPeerSettings.element);
            TaskQueue.execute$default(http2Connection.settingsListenerQueue, http2Connection.getConnectionName$okhttp() + " onSettings", 0L, false, (Function0)new Function0<Unit>(http2Connection, (Ref.ObjectRef<Settings>)newPeerSettings){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ Ref.ObjectRef<Settings> $newPeerSettings;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$newPeerSettings = var2_2;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.getListener$okhttp().onSettings(this.this$0, (Settings)this.$newPeerSettings.element);
                }
            }, 6, null);
            // MONITOREXIT : object
            try {
                void var3_5;
                http2Connection.getWriter().applyAndAckSettings((Settings)var3_5.element);
            }
            catch (IOException e) {
                Http2Connection.access$failConnection(http2Connection, e);
            }
            // MONITOREXIT : http2StreamArray3
            if (streamsToNotify == null) return;
            http2StreamArray2 = streamsToNotify;
            int n = 0;
            int n2 = http2StreamArray2.length;
            while (n < n2) {
                void var1_3;
                Http2Stream stream = http2StreamArray2[n];
                object = stream;
                // MONITORENTER : stream
                var1_3.addBytesToWriteWindow(delta);
                // MONITOREXIT : object
                ++n;
            }
        }

        @Override
        public final void ackSettings() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void ping(boolean ack, int payload1, int payload22) {
            void var3_6;
            void var2_3;
            if (ack) {
                Http2Connection http2Connection = this.this$0;
                Http2Connection payload22 = this.this$0;
                synchronized (http2Connection) {
                    switch (payload1) {
                        case 1: {
                            long l = payload22.intervalPongsReceived;
                            Http2Connection.access$setIntervalPongsReceived$p(payload22, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 2: {
                            long l = payload22.degradedPongsReceived;
                            Http2Connection.access$setDegradedPongsReceived$p(payload22, l + 1L);
                            Long.valueOf(l);
                            break;
                        }
                        case 3: {
                            void var2_4;
                            long l = payload22.awaitPongsReceived;
                            Http2Connection.access$setAwaitPongsReceived$p(payload22, l + 1L);
                            Http2Connection $this$notifyAll$iv = payload22;
                            Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                            ((Object)var2_4).notifyAll();
                            break;
                        }
                    }
                    return;
                }
            }
            TaskQueue.execute$default(this.this$0.writerQueue, this.this$0.getConnectionName$okhttp() + " ping", 0L, false, (Function0)new Function0<Unit>(this.this$0, (int)var2_3, (int)var3_6){
                final /* synthetic */ Http2Connection this$0;
                final /* synthetic */ int $payload1;
                final /* synthetic */ int $payload2;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.$payload1 = var2_2;
                    this.$payload2 = var3_3;
                    super(0);
                }

                public final void invoke() {
                    this.this$0.writePing(true, this.$payload1, this.$payload2);
                }
            }, 6, null);
        }

        @Override
        public final void goAway(int lastGoodStreamId, ErrorCode errorCode, ByteString debugData) {
            Http2Stream[] http2StreamArray;
            Http2Connection http2Connection;
            Intrinsics.checkNotNullParameter((Object)errorCode, (String)"errorCode");
            Intrinsics.checkNotNullParameter((Object)debugData, (String)"debugData");
            http2Connection.size();
            errorCode = this.this$0;
            http2Connection = this.this$0;
            Object object = errorCode;
            synchronized (object) {
                Collection<Http2Stream> collection = http2Connection.getStreams$okhttp().values();
                errorCode = collection;
                errorCode = collection;
                Http2Stream[] streamsCopy = collection.toArray(new Http2Stream[0]);
                Http2Connection.access$setShutdown$p(http2Connection, true);
            }
            for (Http2Stream http2Stream : (Http2Stream[])http2StreamArray) {
                if (http2Stream.getId() <= lastGoodStreamId || !http2Stream.isLocallyInitiated()) continue;
                http2Stream.receiveRstStream(ErrorCode.REFUSED_STREAM);
                this.this$0.removeStream$okhttp(http2Stream.getId());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void windowUpdate(int streamId22, long windowSizeIncrement) {
            int streamId22;
            if (streamId22 == 0) {
                Http2Connection streamId22 = this.this$0;
                Http2Connection http2Connection = this.this$0;
                synchronized (streamId22) {
                    void var2_6;
                    Http2Connection http2Connection2 = http2Connection;
                    Http2Connection.access$setWriteBytesMaximum$p(http2Connection2, http2Connection2.getWriteBytesMaximum() + windowSizeIncrement);
                    Http2Connection $this$notifyAll$iv = http2Connection;
                    Intrinsics.checkNotNull((Object)$this$notifyAll$iv, (String)"null cannot be cast to non-null type java.lang.Object");
                    ((Object)var2_6).notifyAll();
                    return;
                }
            }
            Http2Stream stream = this.this$0.getStream(streamId22);
            if (stream != null) {
                Http2Stream http2Stream = stream;
                synchronized (http2Stream) {
                    void var2_5;
                    void var1_3;
                    var1_3.addBytesToWriteWindow((long)var2_5);
                    return;
                }
            }
        }

        @Override
        public final void priority(int streamId, int streamDependency, int weight, boolean exclusive) {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void pushPromise(int streamId, int promisedStreamId, List<Header> requestHeaders) {
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter(requestHeaders, (String)"requestHeaders");
            this.this$0.pushRequestLater$okhttp((int)var2_2, (List<Header>)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void alternateService(int streamId, String origin, ByteString protocol, String host, int port, long maxAge) {
            void var3_3;
            Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
            Intrinsics.checkNotNullParameter((Object)var3_3, (String)"protocol");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        }
    }
}

