/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.List;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal._ResponseCommonKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http2.ConnectionShutdownException;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u0010\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J(\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0006H\u0002J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lokhttp3/internal/http/RetryAndFollowUpInterceptor;", "Lokhttp3/Interceptor;", "client", "Lokhttp3/OkHttpClient;", "(Lokhttp3/OkHttpClient;)V", "buildRedirectRequest", "Lokhttp3/Request;", "userResponse", "Lokhttp3/Response;", "method", "", "followUpRequest", "exchange", "Lokhttp3/internal/connection/Exchange;", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "isRecoverable", "", "e", "Ljava/io/IOException;", "requestSendStarted", "recover", "call", "Lokhttp3/internal/connection/RealCall;", "userRequest", "requestIsOneShot", "retryAfter", "", "defaultDelay", "Companion", "okhttp"})
public final class RetryAndFollowUpInterceptor
implements Interceptor {
    public static final Companion Companion = new Companion(null);
    private final OkHttpClient client;
    private static final int MAX_FOLLOW_UPS = 20;

    /*
     * WARNING - void declaration
     */
    public RetryAndFollowUpInterceptor(OkHttpClient client) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.client = var1_1;
    }

    /*
     * Loose catch block
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        Response response;
        boolean closeActiveExchange;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealInterceptorChain realChain = (RealInterceptorChain)chain;
        Request request = ((RealInterceptorChain)chain).getRequest$okhttp();
        RealCall call = realChain.getCall$okhttp();
        int followUpCount = 0;
        Response priorResponse = null;
        boolean newRoutePlanner = true;
        List recoveredFailures = CollectionsKt.emptyList();
        while (true) {
            call.enterNetworkInterceptorExchange(request, newRoutePlanner, (RealInterceptorChain)chain);
            closeActiveExchange = true;
            if (call.isCanceled()) {
                throw new IOException("Canceled");
            }
            try {
                response = realChain.proceed(request);
                newRoutePlanner = true;
            }
            catch (IOException e) {
                if (!this.recover(e, call, request, !(e instanceof ConnectionShutdownException))) {
                    throw _UtilCommonKt.withSuppressed(e, recoveredFailures);
                }
                recoveredFailures = CollectionsKt.plus((Collection)recoveredFailures, (Object)e);
                newRoutePlanner = false;
                call.exitNetworkInterceptorExchange$okhttp(true);
                continue;
            }
            break;
        }
        catch (Throwable throwable) {
            call.exitNetworkInterceptorExchange$okhttp(closeActiveExchange);
            throw throwable;
        }
        {
            block13: {
                Request followUp;
                block12: {
                    Response response2 = priorResponse;
                    response = response.newBuilder().request(request).priorResponse(response2 != null ? _ResponseCommonKt.stripBody(response2) : null).build();
                    Exchange exchange = call.getInterceptorScopedExchange$okhttp();
                    followUp = this.followUpRequest(response, exchange);
                    if (followUp != null) break block12;
                    if (exchange != null && exchange.isDuplex$okhttp()) {
                        call.timeoutEarlyExit();
                    }
                    closeActiveExchange = false;
                    priorResponse = response;
                    call.exitNetworkInterceptorExchange$okhttp(false);
                    return priorResponse;
                }
                RequestBody followUpBody = followUp.body();
                if (followUpBody == null || !followUpBody.isOneShot()) break block13;
                closeActiveExchange = false;
                chain = response;
                call.exitNetworkInterceptorExchange$okhttp(false);
                return chain;
            }
            _UtilCommonKt.closeQuietly(response.body());
            if (++followUpCount > 20) {
                throw new ProtocolException("Too many follow-up requests: " + followUpCount);
            }
            Response response3 = response;
            call.exitNetworkInterceptorExchange$okhttp(true);
            continue;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean recover(IOException e, RealCall call, Request userRequest, boolean requestSendStarted) {
        void var2_2;
        void var1_1;
        void var3_3;
        if (!this.client.retryOnConnectionFailure()) {
            return false;
        }
        if (requestSendStarted && this.requestIsOneShot(e, (Request)var3_3)) {
            return false;
        }
        if (!this.isRecoverable((IOException)var1_1, requestSendStarted)) {
            return false;
        }
        return var2_2.retryAfterFailure();
    }

    /*
     * WARNING - void declaration
     */
    private final boolean requestIsOneShot(IOException e, Request userRequest) {
        void var1_1;
        void var2_2;
        RequestBody requestBody = userRequest.body();
        return requestBody != null && var2_2.isOneShot() || var1_1 instanceof FileNotFoundException;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isRecoverable(IOException e, boolean requestSendStarted) {
        void var1_1;
        if (e instanceof ProtocolException) {
            return false;
        }
        if (e instanceof InterruptedIOException) {
            void var2_2;
            return e instanceof SocketTimeoutException && var2_2 == false;
        }
        if (e instanceof SSLHandshakeException && e.getCause() instanceof CertificateException) {
            return false;
        }
        return !(var1_1 instanceof SSLPeerUnverifiedException);
    }

    /*
     * WARNING - void declaration
     */
    private final Request followUpRequest(Response userResponse, Exchange exchange) throws IOException {
        Object object = exchange;
        Route route = object != null && (object = ((Exchange)object).getConnection$okhttp()) != null ? ((RealConnection)object).route() : null;
        int responseCode2 = userResponse.code();
        String method = userResponse.request().method();
        switch (responseCode2) {
            case 407: {
                Route route2 = route;
                Intrinsics.checkNotNull((Object)route2);
                Proxy responseCode2 = route2.proxy();
                if (responseCode2.type() != Proxy.Type.HTTP) {
                    throw new ProtocolException("Received HTTP_PROXY_AUTH (407) code while not using proxy");
                }
                return this.client.proxyAuthenticator().authenticate(route, userResponse);
            }
            case 401: {
                void var3_3;
                return this.client.authenticator().authenticate((Route)var3_3, userResponse);
            }
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return this.buildRedirectRequest(userResponse, method);
            }
            case 408: {
                void var2_2;
                if (!this.client.retryOnConnectionFailure()) {
                    return null;
                }
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && var2_2.code() == 408) {
                    return null;
                }
                if (this.retryAfter(userResponse, 0) > 0) {
                    return null;
                }
                return userResponse.request();
            }
            case 503: {
                Response priorResponse = userResponse.priorResponse();
                if (priorResponse != null && priorResponse.code() == 503) {
                    return null;
                }
                if (this.retryAfter(userResponse, Integer.MAX_VALUE) == 0) {
                    return userResponse.request();
                }
                return null;
            }
            case 421: {
                void var1_1;
                void var2_2;
                RequestBody requestBody = userResponse.request().body();
                if (requestBody != null && requestBody.isOneShot()) {
                    return null;
                }
                if (var2_2 == null || !var2_2.isCoalescedConnection$okhttp()) {
                    return null;
                }
                var2_2.getConnection$okhttp().noCoalescedConnections$okhttp();
                return var1_1.request();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Request buildRedirectRequest(Response userResponse, String method) {
        void var3_3;
        void var1_1;
        if (!this.client.followRedirects()) {
            return null;
        }
        String string = Response.header$default(userResponse, "Location", null, 2, null);
        if (string == null) {
            return null;
        }
        String location = string;
        HttpUrl httpUrl = userResponse.request().url().resolve(location);
        if (httpUrl == null) {
            return null;
        }
        HttpUrl url = httpUrl;
        boolean bl = Intrinsics.areEqual((Object)httpUrl.scheme(), (Object)userResponse.request().url().scheme());
        if (!bl && !this.client.followSslRedirects()) {
            return null;
        }
        Request.Builder requestBuilder = userResponse.request().newBuilder();
        if (HttpMethod.permitsRequestBody(method)) {
            boolean maintainBody;
            int responseCode = userResponse.code();
            boolean bl2 = maintainBody = HttpMethod.INSTANCE.redirectsWithBody(method) || responseCode == 308 || responseCode == 307;
            if (HttpMethod.INSTANCE.redirectsToGet(method) && responseCode != 308 && responseCode != 307) {
                requestBuilder.method("GET", null);
            } else {
                void var2_2;
                RequestBody requestBody = maintainBody ? userResponse.request().body() : null;
                requestBuilder.method((String)var2_2, requestBody);
            }
            if (!maintainBody) {
                requestBuilder.removeHeader("Transfer-Encoding");
                requestBuilder.removeHeader("Content-Length");
                requestBuilder.removeHeader("Content-Type");
            }
        }
        if (!_UtilJvmKt.canReuseConnectionFor(var1_1.request().url(), url)) {
            requestBuilder.removeHeader("Authorization");
        }
        return requestBuilder.url((HttpUrl)var3_3).build();
    }

    /*
     * WARNING - void declaration
     */
    private final int retryAfter(Response userResponse, int defaultDelay) {
        String string = Response.header$default(userResponse, "Retry-After", null, 2, null);
        if (string == null) {
            void var2_2;
            return (int)var2_2;
        }
        String header = string;
        CharSequence charSequence = string;
        if (new Regex("\\d+").matches(charSequence)) {
            void var1_1;
            Integer n = Integer.valueOf((String)var1_1);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"valueOf(...)");
            return ((Number)n).intValue();
        }
        return Integer.MAX_VALUE;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lokhttp3/internal/http/RetryAndFollowUpInterceptor$Companion;", "", "()V", "MAX_FOLLOW_UPS", "", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

