/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.net.Socket;
import java.net.UnknownServiceException;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.Address;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.ConnectPlan;
import okhttp3.internal.connection.ConnectionUser;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.ReusePlan;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.RoutePlanner;
import okhttp3.internal.connection.RouteSelector;
import okhttp3.internal.platform.Platform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Be\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u001eH\u0002J\u0012\u0010&\u001a\u00020\r2\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\b\u0010)\u001a\u00020\rH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016J\r\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J'\u0010.\u001a\u00020,2\u0006\u0010%\u001a\u00020\u001e2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u000100H\u0000\u00a2\u0006\u0002\b1J\n\u00102\u001a\u0004\u0018\u000103H\u0002J-\u00104\u001a\u0004\u0018\u0001032\n\b\u0002\u00105\u001a\u0004\u0018\u00010,2\u0010\b\u0002\u0010/\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u000100H\u0000\u00a2\u0006\u0002\b6J\u0012\u00107\u001a\u0004\u0018\u00010\u001e2\u0006\u00108\u001a\u00020(H\u0002J\u0010\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020;H\u0016R\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lokhttp3/internal/connection/RealRoutePlanner;", "Lokhttp3/internal/connection/RoutePlanner;", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "readTimeoutMillis", "", "writeTimeoutMillis", "socketConnectTimeoutMillis", "socketReadTimeoutMillis", "pingIntervalMillis", "retryOnConnectionFailure", "", "fastFallback", "address", "Lokhttp3/Address;", "routeDatabase", "Lokhttp3/internal/connection/RouteDatabase;", "connectionUser", "Lokhttp3/internal/connection/ConnectionUser;", "(Lokhttp3/internal/concurrent/TaskRunner;Lokhttp3/internal/connection/RealConnectionPool;IIIIIZZLokhttp3/Address;Lokhttp3/internal/connection/RouteDatabase;Lokhttp3/internal/connection/ConnectionUser;)V", "getAddress", "()Lokhttp3/Address;", "deferredPlans", "Lkotlin/collections/ArrayDeque;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "getDeferredPlans", "()Lkotlin/collections/ArrayDeque;", "nextRouteToTry", "Lokhttp3/Route;", "routeSelection", "Lokhttp3/internal/connection/RouteSelector$Selection;", "routeSelector", "Lokhttp3/internal/connection/RouteSelector;", "createTunnelRequest", "Lokhttp3/Request;", "route", "hasNext", "failedConnection", "Lokhttp3/internal/connection/RealConnection;", "isCanceled", "plan", "planConnect", "Lokhttp3/internal/connection/ConnectPlan;", "planConnect$okhttp", "planConnectToRoute", "routes", "", "planConnectToRoute$okhttp", "planReuseCallConnection", "Lokhttp3/internal/connection/ReusePlan;", "planReusePooledConnection", "planToReplace", "planReusePooledConnection$okhttp", "retryRoute", "connection", "sameHostAndPort", "url", "Lokhttp3/HttpUrl;", "okhttp"})
public final class RealRoutePlanner
implements RoutePlanner {
    private final TaskRunner taskRunner;
    private final RealConnectionPool connectionPool;
    private final int readTimeoutMillis;
    private final int writeTimeoutMillis;
    private final int socketConnectTimeoutMillis;
    private final int socketReadTimeoutMillis;
    private final int pingIntervalMillis;
    private final boolean retryOnConnectionFailure;
    private final boolean fastFallback;
    private final Address address;
    private final RouteDatabase routeDatabase;
    private final ConnectionUser connectionUser;
    private RouteSelector.Selection routeSelection;
    private RouteSelector routeSelector;
    private Route nextRouteToTry;
    private final ArrayDeque<RoutePlanner.Plan> deferredPlans;

    /*
     * WARNING - void declaration
     */
    public RealRoutePlanner(TaskRunner taskRunner, RealConnectionPool connectionPool, int readTimeoutMillis, int writeTimeoutMillis, int socketConnectTimeoutMillis, int socketReadTimeoutMillis, int pingIntervalMillis, boolean retryOnConnectionFailure, boolean fastFallback, Address address, RouteDatabase routeDatabase, ConnectionUser connectionUser) {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)routeDatabase, (String)"routeDatabase");
        Intrinsics.checkNotNullParameter((Object)connectionUser, (String)"connectionUser");
        this.taskRunner = var1_1;
        this.connectionPool = var2_2;
        this.readTimeoutMillis = var3_3;
        this.writeTimeoutMillis = writeTimeoutMillis;
        this.socketConnectTimeoutMillis = socketConnectTimeoutMillis;
        this.socketReadTimeoutMillis = socketReadTimeoutMillis;
        this.pingIntervalMillis = pingIntervalMillis;
        this.retryOnConnectionFailure = retryOnConnectionFailure;
        this.fastFallback = fastFallback;
        this.address = address;
        this.routeDatabase = routeDatabase;
        this.connectionUser = connectionUser;
        this.deferredPlans = new ArrayDeque();
    }

    @Override
    public final Address getAddress() {
        return this.address;
    }

    @Override
    public final ArrayDeque<RoutePlanner.Plan> getDeferredPlans() {
        return this.deferredPlans;
    }

    @Override
    public final boolean isCanceled() {
        return this.connectionUser.isCanceled();
    }

    @Override
    public final RoutePlanner.Plan plan() throws IOException {
        ConnectPlan connect2;
        ReusePlan reusePlan = this.planReuseCallConnection();
        if (reusePlan != null) {
            return reusePlan;
        }
        reusePlan = RealRoutePlanner.planReusePooledConnection$okhttp$default(this, null, null, 3, null);
        if (reusePlan != null) {
            return reusePlan;
        }
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return (RoutePlanner.Plan)this.getDeferredPlans().removeFirst();
        }
        ConnectPlan connectPlan = connect2 = this.planConnect$okhttp();
        ReusePlan reusePlan2 = this.planReusePooledConnection$okhttp(connectPlan, connectPlan.getRoutes$okhttp());
        if (reusePlan2 != null) {
            return reusePlan2;
        }
        return reusePlan;
    }

    /*
     * WARNING - void declaration
     */
    private final ReusePlan planReuseCallConnection() {
        void var3_5;
        void var2_3;
        Socket healthy2;
        RealConnection realConnection = this.connectionUser.candidateConnection();
        if (realConnection == null) {
            return null;
        }
        RealConnection candidate = realConnection;
        boolean healthy2 = realConnection.isHealthy(this.connectionUser.doExtensiveHealthChecks());
        boolean noNewExchangesEvent = false;
        RealConnection realConnection2 = candidate;
        synchronized (realConnection2) {
            Socket socket;
            if (!healthy2) {
                noNewExchangesEvent = !candidate.getNoNewExchanges();
                candidate.setNoNewExchanges(true);
                socket = this.connectionUser.releaseConnectionNoEvents();
            } else {
                socket = candidate.getNoNewExchanges() || !this.sameHostAndPort(candidate.route().address().url()) ? this.connectionUser.releaseConnectionNoEvents() : null;
            }
            healthy2 = socket;
        }
        Object toClose = healthy2;
        if (this.connectionUser.candidateConnection() != null) {
            if (!(toClose == null)) {
                toClose = "Check failed.";
                throw new IllegalStateException(toClose.toString());
            }
            return new ReusePlan(candidate);
        }
        Socket socket = toClose;
        if (socket != null) {
            _UtilJvmKt.closeQuietly(socket);
        }
        this.connectionUser.connectionReleased(candidate);
        this.connectionUser.connectionConnectionReleased(candidate);
        if (var2_3 != null) {
            this.connectionUser.connectionConnectionClosed(candidate);
        } else if (var3_5 != false) {
            void var1_1;
            this.connectionUser.noNewExchanges((RealConnection)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final ConnectPlan planConnect$okhttp() throws IOException {
        void var1_1;
        RouteSelector.Selection newRouteSelection;
        Route localNextRouteToTry = this.nextRouteToTry;
        if (localNextRouteToTry != null) {
            this.nextRouteToTry = null;
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, localNextRouteToTry, null, 2, null);
        }
        RouteSelector.Selection existingRouteSelection = this.routeSelection;
        if (existingRouteSelection != null && existingRouteSelection.hasNext()) {
            return RealRoutePlanner.planConnectToRoute$okhttp$default(this, existingRouteSelection.next(), null, 2, null);
        }
        RouteSelector newRouteSelector = this.routeSelector;
        if (newRouteSelector == null) {
            this.routeSelector = newRouteSelector = new RouteSelector(this.getAddress(), this.routeDatabase, this.connectionUser, this.fastFallback);
        }
        if (!newRouteSelector.hasNext()) {
            throw new IOException("exhausted all routes");
        }
        this.routeSelection = newRouteSelection = newRouteSelector.next();
        if (this.isCanceled()) {
            throw new IOException("Canceled");
        }
        return this.planConnectToRoute$okhttp(newRouteSelection.next(), var1_1.getRoutes());
    }

    /*
     * WARNING - void declaration
     */
    public final ReusePlan planReusePooledConnection$okhttp(ConnectPlan planToReplace, List<Route> routes) {
        void var2_2;
        RealConnection realConnection = this.connectionPool.callAcquirePooledConnection(this.connectionUser.doExtensiveHealthChecks(), this.getAddress(), this.connectionUser, routes, planToReplace != null && planToReplace.isReady());
        if (realConnection == null) {
            return null;
        }
        RealConnection result = realConnection;
        if (planToReplace != null) {
            void var1_1;
            this.nextRouteToTry = planToReplace.getRoute();
            var1_1.closeQuietly();
        }
        this.connectionUser.connectionAcquired(result);
        this.connectionUser.connectionConnectionAcquired(result);
        return new ReusePlan((RealConnection)var2_2);
    }

    public static /* synthetic */ ReusePlan planReusePooledConnection$okhttp$default(RealRoutePlanner realRoutePlanner, ConnectPlan connectPlan, List list, int n, Object object) {
        if ((n & 1) != 0) {
            connectPlan = null;
        }
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planReusePooledConnection$okhttp(connectPlan, list);
    }

    /*
     * WARNING - void declaration
     */
    public final ConnectPlan planConnectToRoute$okhttp(Route route, List<Route> routes) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        if (route.address().sslSocketFactory() == null) {
            if (!route.address().connectionSpecs().contains(ConnectionSpec.CLEARTEXT)) {
                throw new UnknownServiceException("CLEARTEXT communication not enabled for client");
            }
            String host = route.address().url().host();
            if (!Platform.Companion.get().isCleartextTrafficPermitted(host)) {
                throw new UnknownServiceException("CLEARTEXT communication to " + host + " not permitted by network security policy");
            }
        } else if (route.address().protocols().contains((Object)Protocol.H2_PRIOR_KNOWLEDGE)) {
            throw new UnknownServiceException("H2_PRIOR_KNOWLEDGE cannot be used with HTTPS");
        }
        Request tunnelRequest = route.requiresTunnel() ? this.createTunnelRequest(route) : null;
        return new ConnectPlan(this.taskRunner, this.connectionPool, this.readTimeoutMillis, this.writeTimeoutMillis, this.socketConnectTimeoutMillis, this.socketReadTimeoutMillis, this.pingIntervalMillis, this.retryOnConnectionFailure, this.connectionUser, this, (Route)var1_1, (List<Route>)var2_2, 0, (Request)var3_3, -1, false);
    }

    public static /* synthetic */ ConnectPlan planConnectToRoute$okhttp$default(RealRoutePlanner realRoutePlanner, Route route, List list, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            list = null;
        }
        return realRoutePlanner.planConnectToRoute$okhttp(route, list);
    }

    /*
     * WARNING - void declaration
     */
    private final Request createTunnelRequest(Route route) throws IOException {
        void var3_3;
        Request request;
        Request proxyConnectRequest = new Request.Builder().url(route.address().url()).method("CONNECT", null).header("Host", _UtilJvmKt.toHostHeader(route.address().url(), true)).header("Proxy-Connection", "Keep-Alive").header("User-Agent", "okhttp/5.0.0-alpha.14").build();
        Response fakeAuthChallengeResponse = new Response.Builder().request(proxyConnectRequest).protocol(Protocol.HTTP_1_1).code(407).message("Preemptive Authenticate").sentRequestAtMillis(-1L).receivedResponseAtMillis(-1L).header("Proxy-Authenticate", "OkHttp-Preemptive").build();
        Request request2 = request = route.address().proxyAuthenticator().authenticate((Route)((Object)request), (Response)var3_3);
        if (request == null) {
            void var2_2;
            request2 = var2_2;
        }
        return request2;
    }

    @Override
    public final boolean hasNext(RealConnection failedConnection) {
        RouteSelector routeSelector;
        Route retryRoute;
        if (!((Collection)this.getDeferredPlans()).isEmpty()) {
            return true;
        }
        if (this.nextRouteToTry != null) {
            return true;
        }
        if (failedConnection != null && (retryRoute = this.retryRoute(failedConnection)) != null) {
            this.nextRouteToTry = routeSelector;
            return true;
        }
        RouteSelector.Selection selection = this.routeSelection;
        boolean bl = selection != null ? selection.hasNext() : false;
        if (bl) {
            return true;
        }
        RouteSelector routeSelector2 = this.routeSelector;
        if (routeSelector2 == null) {
            return true;
        }
        routeSelector = routeSelector2;
        return routeSelector2.hasNext();
    }

    private final Route retryRoute(RealConnection connection) {
        RealConnection realConnection = connection;
        synchronized (realConnection) {
            RealConnection realConnection2;
            realConnection2 = connection.getRouteFailureCount$okhttp() != 0 ? null : (!connection.getNoNewExchanges() ? null : (!_UtilJvmKt.canReuseConnectionFor(connection.route().address().url(), this.getAddress().url()) ? null : realConnection2.route()));
            return realConnection2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean sameHostAndPort(HttpUrl url) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        HttpUrl routeUrl = this.getAddress().url();
        return url.port() == routeUrl.port() && Intrinsics.areEqual((Object)var1_1.host(), (Object)var2_2.host());
    }
}

