/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.lang.ref.Reference;
import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Address;
import okhttp3.Connection;
import okhttp3.ConnectionListener;
import okhttp3.ConnectionPool;
import okhttp3.Route;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.ConnectionUser;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.PoolConnectionUser;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.platform.Platform;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0083\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u0018\u0018\u0000 @2\u00020\u0001:\u0002?@BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u001e\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\r\u00a2\u0006\u0002\u0010\u0011J8\u0010\"\u001a\u0004\u0018\u00010\u001e2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020\u000f2\u000e\u0010'\u001a\n\u0012\u0004\u0012\u00020)\u0018\u00010(2\u0006\u0010*\u001a\u00020$J\u000e\u0010+\u001a\u00020\u00072\u0006\u0010,\u001a\u00020\u0007J\u000e\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u001eJ\u0006\u0010/\u001a\u00020\u0005J\u0006\u00100\u001a\u000201J\u0006\u00102\u001a\u00020\u0005J$\u00103\u001a\u00020$2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010.\u001a\u00020\u001eH\u0002J\u0010\u00104\u001a\u00020\u00072\u0006\u00105\u001a\u00020\u0014H\u0002J\u0018\u00106\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\u0007H\u0002J\u000e\u00107\u001a\u0002012\u0006\u0010.\u001a\u00020\u001eJ\u0006\u00108\u001a\u000201J\u000e\u00109\u001a\u0002012\u0006\u0010%\u001a\u00020\u000eJ\u0016\u0010:\u001a\u0002012\u0006\u0010%\u001a\u00020\u000e2\u0006\u0010;\u001a\u00020<J\u0014\u0010=\u001a\u00020\u0007*\u00020\u00072\u0006\u0010>\u001a\u00020\u0005H\u0002J\f\u00109\u001a\u000201*\u00020\u0014H\u0002R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\f\u001a\u001a\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\u00020\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lokhttp3/internal/connection/RealConnectionPool;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "maxIdleConnections", "", "keepAliveDuration", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "connectionListener", "Lokhttp3/ConnectionListener;", "exchangeFinderFactory", "Lkotlin/Function3;", "Lokhttp3/Address;", "Lokhttp3/internal/connection/ConnectionUser;", "Lokhttp3/internal/connection/ExchangeFinder;", "(Lokhttp3/internal/concurrent/TaskRunner;IJLjava/util/concurrent/TimeUnit;Lokhttp3/ConnectionListener;Lkotlin/jvm/functions/Function3;)V", "addressStates", "", "Lokhttp3/internal/connection/RealConnectionPool$AddressState;", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/connection/RealConnectionPool$cleanupTask$1", "Lokhttp3/internal/connection/RealConnectionPool$cleanupTask$1;", "getConnectionListener$okhttp", "()Lokhttp3/ConnectionListener;", "connections", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lokhttp3/internal/connection/RealConnection;", "keepAliveDurationNs", "getKeepAliveDurationNs$okhttp", "()J", "callAcquirePooledConnection", "doExtensiveHealthChecks", "", "address", "connectionUser", "routes", "", "Lokhttp3/Route;", "requireMultiplexed", "closeConnections", "now", "connectionBecameIdle", "connection", "connectionCount", "evictAll", "", "idleConnectionCount", "isEvictable", "openConnections", "state", "pruneAndGetAllocationCount", "put", "scheduleCloser", "scheduleOpener", "setPolicy", "policy", "Lokhttp3/ConnectionPool$AddressPolicy;", "jitterBy", "amount", "AddressState", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealConnectionPool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,470:1\n1#2:471\n1774#3,4:472\n353#4,4:476\n353#4,4:480\n353#4,4:484\n*S KotlinDebug\n*F\n+ 1 RealConnectionPool.kt\nokhttp3/internal/connection/RealConnectionPool\n*L\n82#1:472,4\n148#1:476,4\n160#1:480,4\n339#1:484,4\n*E\n"})
public final class RealConnectionPool {
    public static final Companion Companion = new Companion(null);
    private final TaskRunner taskRunner;
    private final int maxIdleConnections;
    private final ConnectionListener connectionListener;
    private final Function3<RealConnectionPool, Address, ConnectionUser, ExchangeFinder> exchangeFinderFactory;
    private final long keepAliveDurationNs;
    private volatile Map<Address, AddressState> addressStates;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    private final ConcurrentLinkedQueue<RealConnection> connections;
    private static AtomicReferenceFieldUpdater<RealConnectionPool, Map<?, ?>> addressStatesUpdater = AtomicReferenceFieldUpdater.newUpdater(RealConnectionPool.class, Map.class, "addressStates");

    /*
     * WARNING - void declaration
     */
    public RealConnectionPool(TaskRunner taskRunner, int maxIdleConnections, long keepAliveDuration, TimeUnit timeUnit, ConnectionListener connectionListener, Function3<? super RealConnectionPool, ? super Address, ? super ConnectionUser, ? extends ExchangeFinder> exchangeFinderFactory) {
        void var2_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkNotNullParameter((Object)connectionListener, (String)"connectionListener");
        Intrinsics.checkNotNullParameter(exchangeFinderFactory, (String)"exchangeFinderFactory");
        this.taskRunner = string;
        this.maxIdleConnections = var2_2;
        this.connectionListener = connectionListener;
        this.exchangeFinderFactory = exchangeFinderFactory;
        this.keepAliveDurationNs = timeUnit.toNanos(keepAliveDuration);
        this.addressStates = MapsKt.emptyMap();
        this.cleanupQueue = this.taskRunner.newQueue();
        string = _UtilJvmKt.okHttpName + " ConnectionPool connection closer";
        this.cleanupTask = new Task(this, string){
            final /* synthetic */ RealConnectionPool this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2, false, 2, null);
            }

            public final long runOnce() {
                return this.this$0.closeConnections(System.nanoTime());
            }
        };
        this.connections = new ConcurrentLinkedQueue();
        if (!(keepAliveDuration > 0L)) {
            void var3_3;
            string = "keepAliveDuration <= 0: " + (long)var3_3;
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final ConnectionListener getConnectionListener$okhttp() {
        return this.connectionListener;
    }

    public final long getKeepAliveDurationNs$okhttp() {
        return this.keepAliveDurationNs;
    }

    /*
     * WARNING - void declaration
     */
    private final void scheduleOpener(AddressState $this$scheduleOpener) {
        void var1_1;
        String string = _UtilJvmKt.okHttpName + " ConnectionPool connection opener";
        TaskQueue.schedule$default($this$scheduleOpener.getQueue(), new Task(this, (AddressState)var1_1, string){
            final /* synthetic */ RealConnectionPool this$0;
            final /* synthetic */ AddressState $this_scheduleOpener;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.$this_scheduleOpener = var2_2;
                super((String)var3_3, false, 2, null);
            }

            public final long runOnce() {
                return RealConnectionPool.access$openConnections(this.this$0, this.$this_scheduleOpener);
            }
        }, 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final int idleConnectionCount() {
        void var2_2;
        Iterator iterator;
        Iterable $this$count$iv = this.connections;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            return 0;
        }
        int count$iv = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            boolean bl;
            Object t = iterator.next();
            RealConnection it = (RealConnection)t;
            Intrinsics.checkNotNull((Object)it);
            RealConnection realConnection = it;
            synchronized (realConnection) {
                bl = ((RealConnection)t).getCalls().isEmpty();
            }
            if (!bl || ++count$iv >= 0) continue;
            CollectionsKt.throwCountOverflow();
        }
        return (int)var2_2;
    }

    public final int connectionCount() {
        return this.connections.size();
    }

    public final RealConnection callAcquirePooledConnection(boolean doExtensiveHealthChecks, Address address, ConnectionUser connectionUser, List<Route> routes, boolean requireMultiplexed) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)connectionUser, (String)"connectionUser");
        for (RealConnection connection : this.connections) {
            Socket socket;
            boolean noNewExchangesEvent;
            boolean bl;
            Intrinsics.checkNotNull((Object)connection);
            RealConnection realConnection = connection;
            synchronized (realConnection) {
                boolean bl2;
                if (requireMultiplexed && !connection.isMultiplexed$okhttp()) {
                    bl2 = false;
                } else if (!connection.isEligible$okhttp(address, routes)) {
                    bl2 = false;
                } else {
                    connectionUser.acquireConnectionNoEvents(connection);
                    bl2 = true;
                }
                bl = bl2;
            }
            if (!bl) continue;
            if (connection.isHealthy(doExtensiveHealthChecks)) {
                return connection;
            }
            realConnection = connection;
            synchronized (realConnection) {
                noNewExchangesEvent = !connection.getNoNewExchanges();
                connection.setNoNewExchanges(true);
                socket = connectionUser.releaseConnectionNoEvents();
            }
            Socket toClose = socket;
            if (toClose != null) {
                _UtilJvmKt.closeQuietly(toClose);
                this.connectionListener.connectionClosed(connection);
                continue;
            }
            if (!noNewExchangesEvent) continue;
            this.connectionListener.noNewExchanges(connection);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void put(RealConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        this.connections.add((RealConnection)var1_1);
        this.scheduleCloser();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean connectionBecameIdle(RealConnection connection) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (connection.getNoNewExchanges() || this.maxIdleConnections == 0) {
            void var1_1;
            connection.setNoNewExchanges(true);
            this.connections.remove(connection);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            this.scheduleOpener(var1_1.getRoute().address());
            return true;
        }
        this.scheduleCloser();
        return false;
    }

    public final void evictAll() {
        RealConnection realConnection;
        Iterator<RealConnection> iterator = this.connections.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<RealConnection> i = iterator;
        while (i.hasNext()) {
            Iterator<AddressState> iterator2;
            Socket socket;
            RealConnection connection = i.next();
            Intrinsics.checkNotNull((Object)connection);
            realConnection = connection;
            synchronized (realConnection) {
                Socket socket2;
                if (connection.getCalls().isEmpty()) {
                    i.remove();
                    connection.setNoNewExchanges(true);
                    socket2 = connection.socket();
                } else {
                    socket2 = null;
                }
                socket = socket2;
            }
            Socket socketToClose = socket;
            if (socketToClose == null) continue;
            _UtilJvmKt.closeQuietly(socketToClose);
            this.connectionListener.connectionClosed((Connection)((Object)iterator2));
        }
        if (this.connections.isEmpty()) {
            this.cleanupQueue.cancelAll();
        }
        for (AddressState policy : this.addressStates.values()) {
            this.scheduleOpener((AddressState)((Object)realConnection));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final long closeConnections(long now) {
        long toEvictIdleAtNs;
        RealConnection toEvict;
        RealConnection realConnection;
        Map<Address, AddressState> addressStates = this.addressStates;
        for (AddressState addressState : addressStates.values()) {
            addressState.setConcurrentCallCapacity(0);
        }
        for (RealConnection connection : this.connections) {
            if (addressStates.get(connection.getRoute().address()) == null) continue;
            Intrinsics.checkNotNull((Object)connection);
            RealConnection realConnection2 = connection;
            synchronized (realConnection2) {
                AddressState addressState;
                AddressState addressState2 = addressState;
                addressState2.setConcurrentCallCapacity(addressState2.getConcurrentCallCapacity() + connection.getAllocationLimit$okhttp());
            }
        }
        long earliestOldIdleAtNs = now - this.keepAliveDurationNs + 1L;
        RealConnection earliestOldConnection = null;
        long earliestEvictableIdleAtNs = Long.MAX_VALUE;
        RealConnection earliestEvictableConnection = null;
        int inUseConnectionCount = 0;
        int evictableConnectionCount = 0;
        for (RealConnection connection : this.connections) {
            Intrinsics.checkNotNull((Object)connection);
            realConnection = connection;
            synchronized (realConnection) {
                if (this.pruneAndGetAllocationCount(connection, now) > 0) {
                    ++inUseConnectionCount;
                } else {
                    long idleAtNs = connection.getIdleAtNs();
                    if (idleAtNs < earliestOldIdleAtNs) {
                        earliestOldIdleAtNs = idleAtNs;
                        earliestOldConnection = connection;
                    }
                    if (this.isEvictable(addressStates, connection)) {
                        ++evictableConnectionCount;
                        if (idleAtNs < earliestEvictableIdleAtNs) {
                            earliestEvictableIdleAtNs = idleAtNs;
                            earliestEvictableConnection = connection;
                        }
                    }
                }
            }
        }
        if (earliestOldConnection != null) {
            toEvict = earliestOldConnection;
            toEvictIdleAtNs = earliestOldIdleAtNs;
        } else if (evictableConnectionCount > this.maxIdleConnections) {
            toEvict = earliestEvictableConnection;
            toEvictIdleAtNs = earliestEvictableIdleAtNs;
        } else {
            toEvict = null;
            toEvictIdleAtNs = -1L;
        }
        if (toEvict != null) {
            void var3_4;
            realConnection = toEvict;
            synchronized (realConnection) {
                block29: {
                    block28: {
                        if (!(!((Collection)toEvict.getCalls()).isEmpty())) break block28;
                        return 0L;
                    }
                    if (toEvict.getIdleAtNs() == toEvictIdleAtNs) break block29;
                    return 0L;
                }
                toEvict.setNoNewExchanges(true);
                this.connections.remove(toEvict);
            }
            AddressState addressState = (AddressState)var3_4.get(toEvict.getRoute().address());
            if (addressState != null) {
                this.scheduleOpener(addressState);
            }
            _UtilJvmKt.closeQuietly(toEvict.socket());
            this.connectionListener.connectionClosed(toEvict);
            if (this.connections.isEmpty()) {
                this.cleanupQueue.cancelAll();
            }
            return 0L;
        }
        if (earliestEvictableConnection != null) {
            void var1_1;
            return earliestEvictableIdleAtNs + this.keepAliveDurationNs - var1_1;
        }
        if (inUseConnectionCount > 0) {
            return this.keepAliveDurationNs;
        }
        return -1L;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isEvictable(Map<Address, AddressState> addressStates, RealConnection connection) {
        void var1_1;
        void var2_2;
        AddressState addressState = addressStates.get(connection.getRoute().address());
        if (addressState == null) {
            return true;
        }
        AddressState addressState2 = addressState;
        int n = addressState.getConcurrentCallCapacity() - var2_2.getAllocationLimit$okhttp();
        return n >= var1_1.getPolicy().minimumConcurrentCalls;
    }

    /*
     * WARNING - void declaration
     */
    private final int pruneAndGetAllocationCount(RealConnection connection, long now) {
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        List<Reference<RealCall>> references = connection.getCalls();
        int i = 0;
        while (i < references.size()) {
            void var2_2;
            void var1_1;
            Reference<RealCall> reference = references.get(i);
            if (reference.get() != null) {
                ++i;
                continue;
            }
            Intrinsics.checkNotNull(reference, (String)"null cannot be cast to non-null type okhttp3.internal.connection.RealCall.CallReference");
            RealCall.CallReference callReference = (RealCall.CallReference)reference;
            String message = "A connection to " + connection.route().address().url() + " was leaked. Did you forget to close a response body?";
            Platform.Companion.get().logCloseableLeak(message, callReference.getCallStackTrace());
            references.remove(i);
            if (!references.isEmpty()) continue;
            var1_1.setIdleAtNs((long)(var2_2 - this.keepAliveDurationNs));
            return 0;
        }
        return references.size();
    }

    /*
     * WARNING - void declaration
     */
    public final void setPolicy(Address address, ConnectionPool.AddressPolicy policy) {
        void var1_2;
        void var2_3;
        Map newMap;
        Map<Address, AddressState> oldMap;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        AddressState state = new AddressState(address, this.taskRunner.newQueue(), policy);
        while (!addressStatesUpdater.compareAndSet(this, oldMap = this.addressStates, newMap = MapsKt.plus(oldMap, (Pair)TuplesKt.to((Object)address, (Object)state)))) {
        }
        Object object = oldMap.get(address);
        int oldPolicyMinimumConcurrentCalls = object != null && (object = ((AddressState)object).getPolicy()) != null ? ((ConnectionPool.AddressPolicy)object).minimumConcurrentCalls : 0;
        int newConnectionsNeeded = var2_3.minimumConcurrentCalls - oldPolicyMinimumConcurrentCalls;
        if (newConnectionsNeeded > 0) {
            void var3_4;
            this.scheduleOpener((AddressState)var3_4);
            return;
        }
        if (var1_2 < 0) {
            this.scheduleCloser();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void scheduleOpener(Address address) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        AddressState addressState = this.addressStates.get(var1_1);
        if (addressState != null) {
            this.scheduleOpener(addressState);
            return;
        }
    }

    public final void scheduleCloser() {
        TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final long openConnections(AddressState state) {
        if (state.getPolicy().minimumConcurrentCalls == 0) {
            return -1L;
        }
        int concurrentCallCapacity = 0;
        Iterator<RealConnection> iterator = this.connections.iterator();
        while (iterator.hasNext()) {
            RealConnection connection = iterator.next();
            if (!Intrinsics.areEqual((Object)state.getAddress(), (Object)connection.getRoute().address())) continue;
            Intrinsics.checkNotNull((Object)connection);
            RealConnection realConnection = connection;
            synchronized (realConnection) {
            }
            if ((concurrentCallCapacity += connection.getAllocationLimit$okhttp()) < state.getPolicy().minimumConcurrentCalls) continue;
            return -1L;
        }
        try {
            RealConnection connection = ((ExchangeFinder)this.exchangeFinderFactory.invoke((Object)this, (Object)state.getAddress(), (Object)PoolConnectionUser.INSTANCE)).find();
            if (!this.connections.contains(connection)) {
                RealConnection realConnection = connection;
                synchronized (realConnection) {
                    this.put((RealConnection)((Object)iterator));
                }
            }
            return 0L;
        }
        catch (IOException iOException) {
            void var1_1;
            return this.jitterBy(state.getPolicy().backoffDelayMillis, var1_1.getPolicy().backoffJitterMillis) * 1000000L;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final long jitterBy(long $this$jitterBy, int amount) {
        void var3_2;
        return $this$jitterBy + (long)ThreadLocalRandom.current().nextInt(-amount, (int)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ long access$openConnections(RealConnectionPool $this, AddressState state) {
        void var1_1;
        return $this.openConnections((AddressState)var1_1);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lokhttp3/internal/connection/RealConnectionPool$AddressState;", "", "address", "Lokhttp3/Address;", "queue", "Lokhttp3/internal/concurrent/TaskQueue;", "policy", "Lokhttp3/ConnectionPool$AddressPolicy;", "(Lokhttp3/Address;Lokhttp3/internal/concurrent/TaskQueue;Lokhttp3/ConnectionPool$AddressPolicy;)V", "getAddress", "()Lokhttp3/Address;", "concurrentCallCapacity", "", "getConcurrentCallCapacity", "()I", "setConcurrentCallCapacity", "(I)V", "getPolicy", "()Lokhttp3/ConnectionPool$AddressPolicy;", "setPolicy", "(Lokhttp3/ConnectionPool$AddressPolicy;)V", "getQueue", "()Lokhttp3/internal/concurrent/TaskQueue;", "okhttp"})
    public static final class AddressState {
        private final Address address;
        private final TaskQueue queue;
        private ConnectionPool.AddressPolicy policy;
        private int concurrentCallCapacity;

        /*
         * WARNING - void declaration
         */
        public AddressState(Address address, TaskQueue queue, ConnectionPool.AddressPolicy policy) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
            Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
            this.address = var1_1;
            this.queue = var2_2;
            this.policy = var3_3;
        }

        public final Address getAddress() {
            return this.address;
        }

        public final TaskQueue getQueue() {
            return this.queue;
        }

        public final ConnectionPool.AddressPolicy getPolicy() {
            return this.policy;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPolicy(ConnectionPool.AddressPolicy addressPolicy) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)addressPolicy, (String)"<set-?>");
            this.policy = var1_1;
        }

        public final int getConcurrentCallCapacity() {
            return this.concurrentCallCapacity;
        }

        /*
         * WARNING - void declaration
         */
        public final void setConcurrentCallCapacity(int n) {
            void var1_1;
            this.concurrentCallCapacity = var1_1;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nRn\u0010\u0003\u001ab\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007 \u0006*0\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0012\u001c\u0012\u001a\u0012\u0002\b\u0003\u0012\u0002\b\u0003 \u0006*\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00070\u0007\u0018\u00010\u00040\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lokhttp3/internal/connection/RealConnectionPool$Companion;", "", "()V", "addressStatesUpdater", "Ljava/util/concurrent/atomic/AtomicReferenceFieldUpdater;", "Lokhttp3/internal/connection/RealConnectionPool;", "kotlin.jvm.PlatformType", "", "get", "connectionPool", "Lokhttp3/ConnectionPool;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final RealConnectionPool get(ConnectionPool connectionPool) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)connectionPool, (String)"connectionPool");
            return var1_1.getDelegate$okhttp();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

