/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.connection;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Address;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Connection;
import okhttp3.Dispatcher;
import okhttp3.EventListener;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.cache.CacheInterceptor;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.connection.CallConnectionUser;
import okhttp3.internal.connection.ConnectInterceptor;
import okhttp3.internal.connection.Exchange;
import okhttp3.internal.connection.ExchangeFinder;
import okhttp3.internal.connection.FastFallbackExchangeFinder;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.connection.RealConnection;
import okhttp3.internal.connection.RealConnectionPool;
import okhttp3.internal.connection.RealRoutePlanner;
import okhttp3.internal.connection.RouteDatabase;
import okhttp3.internal.connection.RoutePlanner;
import okhttp3.internal.connection.SequentialExchangeFinder;
import okhttp3.internal.http.BridgeInterceptor;
import okhttp3.internal.http.CallServerInterceptor;
import okhttp3.internal.http.ExchangeCodec;
import okhttp3.internal.http.RealInterceptorChain;
import okhttp3.internal.http.RetryAndFollowUpInterceptor;
import okhttp3.internal.platform.Platform;
import okio.AsyncTimeout;
import okio.Timeout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006*\u00010\u0018\u00002\u00020\u00012\u00020\u0002:\u0002bcB\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u00103\u001a\u0002042\u0006\u0010\u0011\u001a\u00020\u0010J!\u00105\u001a\u0002H6\"\n\b\u0000\u00106*\u0004\u0018\u0001072\u0006\u00108\u001a\u0002H6H\u0002\u00a2\u0006\u0002\u00109J\b\u0010:\u001a\u000204H\u0002J\b\u0010;\u001a\u000204H\u0016J\b\u0010<\u001a\u00020\u0001H\u0016J\u0010\u0010=\u001a\u0002042\u0006\u0010>\u001a\u00020?H\u0016J\u001e\u0010@\u001a\u0002042\u0006\u0010A\u001a\u00020\u00062\u0006\u0010B\u001a\u00020\b2\u0006\u0010C\u001a\u00020DJ\b\u0010E\u001a\u00020FH\u0016J\u0015\u0010G\u001a\u0002042\u0006\u0010H\u001a\u00020\bH\u0000\u00a2\u0006\u0002\bIJ\r\u0010J\u001a\u00020FH\u0000\u00a2\u0006\u0002\bKJ\u0015\u0010L\u001a\u00020\u001b2\u0006\u0010C\u001a\u00020DH\u0000\u00a2\u0006\u0002\bMJ\b\u0010N\u001a\u00020\bH\u0016J\b\u0010O\u001a\u00020\bH\u0016J;\u0010P\u001a\u0002H6\"\n\b\u0000\u00106*\u0004\u0018\u0001072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020\b2\u0006\u00108\u001a\u0002H6H\u0000\u00a2\u0006\u0004\bS\u0010TJ\u0019\u0010U\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u000107H\u0000\u00a2\u0006\u0002\bVJ\r\u0010W\u001a\u00020XH\u0000\u00a2\u0006\u0002\bYJ\u000f\u0010Z\u001a\u0004\u0018\u00010[H\u0000\u00a2\u0006\u0002\b\\J\b\u0010A\u001a\u00020\u0006H\u0016J\u0006\u0010]\u001a\u00020\bJ\b\u0010/\u001a\u00020^H\u0016J\u0006\u00102\u001a\u000204J!\u0010_\u001a\u0002H6\"\n\b\u0000\u00106*\u0004\u0018\u0001072\u0006\u0010`\u001a\u0002H6H\u0002\u00a2\u0006\u0002\u00109J\b\u0010a\u001a\u00020XH\u0002R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\"\u0010#\u001a\u0004\u0018\u00010\u001b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u001b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u001a\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u00101R\u000e\u00102\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lokhttp3/internal/connection/RealCall;", "Lokhttp3/Call;", "", "client", "Lokhttp3/OkHttpClient;", "originalRequest", "Lokhttp3/Request;", "forWebSocket", "", "(Lokhttp3/OkHttpClient;Lokhttp3/Request;Z)V", "callStackTrace", "", "canceled", "getClient", "()Lokhttp3/OkHttpClient;", "<set-?>", "Lokhttp3/internal/connection/RealConnection;", "connection", "getConnection", "()Lokhttp3/internal/connection/RealConnection;", "connectionPool", "Lokhttp3/internal/connection/RealConnectionPool;", "eventListener", "Lokhttp3/EventListener;", "getEventListener$okhttp", "()Lokhttp3/EventListener;", "exchange", "Lokhttp3/internal/connection/Exchange;", "exchangeFinder", "Lokhttp3/internal/connection/ExchangeFinder;", "executed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "expectMoreExchanges", "getForWebSocket", "()Z", "interceptorScopedExchange", "getInterceptorScopedExchange$okhttp", "()Lokhttp3/internal/connection/Exchange;", "getOriginalRequest", "()Lokhttp3/Request;", "plansToCancel", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lokhttp3/internal/connection/RoutePlanner$Plan;", "getPlansToCancel$okhttp", "()Ljava/util/concurrent/CopyOnWriteArrayList;", "requestBodyOpen", "responseBodyOpen", "timeout", "okhttp3/internal/connection/RealCall$timeout$1", "Lokhttp3/internal/connection/RealCall$timeout$1;", "timeoutEarlyExit", "acquireConnectionNoEvents", "", "callDone", "E", "Ljava/io/IOException;", "e", "(Ljava/io/IOException;)Ljava/io/IOException;", "callStart", "cancel", "clone", "enqueue", "responseCallback", "Lokhttp3/Callback;", "enterNetworkInterceptorExchange", "request", "newRoutePlanner", "chain", "Lokhttp3/internal/http/RealInterceptorChain;", "execute", "Lokhttp3/Response;", "exitNetworkInterceptorExchange", "closeExchange", "exitNetworkInterceptorExchange$okhttp", "getResponseWithInterceptorChain", "getResponseWithInterceptorChain$okhttp", "initExchange", "initExchange$okhttp", "isCanceled", "isExecuted", "messageDone", "requestDone", "responseDone", "messageDone$okhttp", "(Lokhttp3/internal/connection/Exchange;ZZLjava/io/IOException;)Ljava/io/IOException;", "noMoreExchanges", "noMoreExchanges$okhttp", "redactedUrl", "", "redactedUrl$okhttp", "releaseConnectionNoEvents", "Ljava/net/Socket;", "releaseConnectionNoEvents$okhttp", "retryAfterFailure", "Lokio/Timeout;", "timeoutExit", "cause", "toLoggableString", "AsyncCall", "CallReference", "okhttp"})
@SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,561:1\n1#2:562\n353#3,4:563\n367#3,4:567\n367#3,4:571\n353#3,4:575\n350#4,7:579\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall\n*L\n290#1:563,4\n365#1:567,4\n369#1:571,4\n402#1:575,4\n405#1:579,7\n*E\n"})
public final class RealCall
implements Cloneable,
Call {
    private final OkHttpClient client;
    private final Request originalRequest;
    private final boolean forWebSocket;
    private final RealConnectionPool connectionPool;
    private final EventListener eventListener;
    private final timeout.1 timeout;
    private final AtomicBoolean executed;
    private Object callStackTrace;
    private ExchangeFinder exchangeFinder;
    private RealConnection connection;
    private boolean timeoutEarlyExit;
    private Exchange interceptorScopedExchange;
    private boolean requestBodyOpen;
    private boolean responseBodyOpen;
    private boolean expectMoreExchanges;
    private volatile boolean canceled;
    private volatile Exchange exchange;
    private final CopyOnWriteArrayList<RoutePlanner.Plan> plansToCancel;

    /*
     * WARNING - void declaration
     */
    public RealCall(OkHttpClient client, Request originalRequest, boolean forWebSocket) {
        void var2_2;
        void var3_3;
        AsyncTimeout asyncTimeout;
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)originalRequest, (String)"originalRequest");
        this.client = asyncTimeout;
        this.originalRequest = originalRequest;
        this.forWebSocket = var3_3;
        this.connectionPool = this.client.connectionPool().getDelegate$okhttp();
        this.eventListener = this.client.eventListenerFactory().create(this);
        AsyncTimeout $this$timeout_u24lambda_u240 = asyncTimeout = new AsyncTimeout(this){
            final /* synthetic */ RealCall this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            protected final void timedOut() {
                this.this$0.cancel();
            }
        };
        RealCall realCall = this;
        var2_2.timeout((long)this.client.callTimeoutMillis(), TimeUnit.MILLISECONDS);
        realCall.timeout = asyncTimeout;
        this.executed = new AtomicBoolean();
        this.expectMoreExchanges = true;
        this.plansToCancel = new CopyOnWriteArrayList();
    }

    public final OkHttpClient getClient() {
        return this.client;
    }

    public final Request getOriginalRequest() {
        return this.originalRequest;
    }

    public final boolean getForWebSocket() {
        return this.forWebSocket;
    }

    public final EventListener getEventListener$okhttp() {
        return this.eventListener;
    }

    public final RealConnection getConnection() {
        return this.connection;
    }

    public final Exchange getInterceptorScopedExchange$okhttp() {
        return this.interceptorScopedExchange;
    }

    public final CopyOnWriteArrayList<RoutePlanner.Plan> getPlansToCancel$okhttp() {
        return this.plansToCancel;
    }

    @Override
    public final Timeout timeout() {
        return (Timeout)this.timeout;
    }

    @Override
    public final Call clone() {
        return new RealCall(this.client, this.originalRequest, this.forWebSocket);
    }

    @Override
    public final Request request() {
        return this.originalRequest;
    }

    @Override
    public final void cancel() {
        if (this.canceled) {
            return;
        }
        this.canceled = true;
        Exchange exchange = this.exchange;
        if (exchange != null) {
            exchange.cancel();
        }
        for (RoutePlanner.Plan plan : this.plansToCancel) {
            plan.cancel();
        }
        this.eventListener.canceled(this);
    }

    @Override
    public final boolean isCanceled() {
        return this.canceled;
    }

    @Override
    public final Response execute() {
        if (!this.executed.compareAndSet(false, true)) {
            String string = "Already Executed";
            throw new IllegalStateException(string.toString());
        }
        this.timeout.enter();
        this.callStart();
        try {
            this.client.dispatcher().executed$okhttp(this);
            Response response = this.getResponseWithInterceptorChain$okhttp();
            return response;
        }
        finally {
            this.client.dispatcher().finished$okhttp(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void enqueue(Callback responseCallback) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
        if (!this.executed.compareAndSet(false, true)) {
            responseCallback = "Already Executed";
            throw new IllegalStateException(responseCallback.toString());
        }
        this.callStart();
        this.client.dispatcher().enqueue$okhttp(new AsyncCall(this, (Callback)var1_1));
    }

    @Override
    public final boolean isExecuted() {
        return this.executed.get();
    }

    private final void callStart() {
        this.callStackTrace = Platform.Companion.get().getStackTraceForCloseable("response.body().close()");
        this.eventListener.callStart(this);
    }

    /*
     * WARNING - void declaration
     */
    public final Response getResponseWithInterceptorChain$okhttp() throws IOException {
        Response response;
        List interceptors = new ArrayList();
        CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.interceptors());
        ((Collection)interceptors).add(new RetryAndFollowUpInterceptor(this.client));
        ((Collection)interceptors).add(new BridgeInterceptor(this.client.cookieJar()));
        ((Collection)interceptors).add(new CacheInterceptor(this.client.cache()));
        ((Collection)interceptors).add(ConnectInterceptor.INSTANCE);
        if (!this.forWebSocket) {
            CollectionsKt.addAll((Collection)interceptors, (Iterable)this.client.networkInterceptors());
        }
        ((Collection)interceptors).add(new CallServerInterceptor(this.forWebSocket));
        RealInterceptorChain chain = new RealInterceptorChain(this, interceptors, 0, null, this.originalRequest, this.client.connectTimeoutMillis(), this.client.readTimeoutMillis(), this.client.writeTimeoutMillis());
        boolean calledNoMoreExchanges = false;
        try {
            response = chain.proceed(this.originalRequest);
            if (this.isCanceled()) {
                _UtilCommonKt.closeQuietly(response);
                throw new IOException("Canceled");
            }
            this.noMoreExchanges$okhttp(null);
        }
        catch (IOException e) {
            try {
                void var1_2;
                calledNoMoreExchanges = true;
                IOException iOException = this.noMoreExchanges$okhttp((IOException)var1_2);
                Intrinsics.checkNotNull((Object)iOException, (String)"null cannot be cast to non-null type kotlin.Throwable");
                throw (Throwable)iOException;
            }
            catch (Throwable throwable) {
                void var2_4;
                if (var2_4 == false) {
                    this.noMoreExchanges$okhttp(null);
                }
                throw throwable;
            }
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public final void enterNetworkInterceptorExchange(Request request, boolean newRoutePlanner2, RealInterceptorChain chain) {
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        if (!(this.interceptorScopedExchange == null)) {
            String newRoutePlanner2 = "Check failed.";
            throw new IllegalStateException(newRoutePlanner2.toString());
        }
        RealCall realCall = this;
        synchronized (realCall) {
            if (!(!this.responseBodyOpen)) {
                String string = "cannot make a new request because the previous response is still open: please call response.close()";
                throw new IllegalStateException(string.toString());
            }
            if (!(!this.requestBodyOpen)) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
        }
        if (var2_2 != false) {
            CallConnectionUser callConnectionUser;
            Address address;
            TaskRunner taskRunner = this.client.getTaskRunner$okhttp();
            RealConnectionPool realConnectionPool = this.connectionPool;
            int n = this.client.readTimeoutMillis();
            int n2 = this.client.writeTimeoutMillis();
            int n3 = chain.getConnectTimeoutMillis$okhttp();
            int n4 = chain.getReadTimeoutMillis$okhttp();
            int n5 = this.client.pingIntervalMillis();
            boolean bl = this.client.retryOnConnectionFailure();
            boolean bl2 = this.client.fastFallback();
            address = this.client.address(((Request)((Object)address)).url());
            RealCall realCall2 = this;
            callConnectionUser = new CallConnectionUser(realCall2, realCall2.connectionPool.getConnectionListener$okhttp(), (RealInterceptorChain)((Object)callConnectionUser));
            RouteDatabase routeDatabase = this.client.getRouteDatabase$okhttp();
            RealRoutePlanner routePlanner = new RealRoutePlanner(taskRunner, realConnectionPool, n, n2, n3, n4, n5, bl, bl2, address, routeDatabase, callConnectionUser);
            this.exchangeFinder = this.client.fastFallback() ? (ExchangeFinder)new FastFallbackExchangeFinder(routePlanner, this.client.getTaskRunner$okhttp()) : (ExchangeFinder)new SequentialExchangeFinder(routePlanner);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Exchange initExchange$okhttp(RealInterceptorChain chain) {
        void var1_1;
        Exchange result;
        Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
        RealCall realCall = this;
        synchronized (realCall) {
            if (!this.expectMoreExchanges) {
                chain = "released";
                throw new IllegalStateException(chain.toString());
            }
            if (!(!this.responseBodyOpen)) {
                chain = "Check failed.";
                throw new IllegalStateException(chain.toString());
            }
            if (!(!this.requestBodyOpen)) {
                chain = "Check failed.";
                throw new IllegalStateException(chain.toString());
            }
        }
        ExchangeFinder exchangeFinder = this.exchangeFinder;
        Intrinsics.checkNotNull((Object)exchangeFinder);
        ExchangeFinder exchangeFinder2 = exchangeFinder;
        RealConnection realConnection = exchangeFinder.find();
        ExchangeCodec codec = realConnection.newCodec$okhttp(this.client, (RealInterceptorChain)chain);
        RealCall realCall2 = this;
        this.interceptorScopedExchange = result = new Exchange(realCall2, realCall2.eventListener, (ExchangeFinder)((Object)realCall), codec);
        this.exchange = result;
        realCall = this;
        synchronized (realCall) {
            this.requestBodyOpen = true;
            this.responseBodyOpen = true;
        }
        if (this.canceled) {
            throw new IOException("Canceled");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void acquireConnectionNoEvents(RealConnection connection) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        RealConnection $this$assertThreadHoldsLock$iv = connection;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (!(this.connection == null)) {
            connection = "Check failed.";
            throw new IllegalStateException(connection.toString());
        }
        this.connection = connection;
        RealCall realCall = this;
        var1_1.getCalls().add(new CallReference(realCall, realCall.callStackTrace));
    }

    /*
     * WARNING - void declaration
     */
    public final <E extends IOException> E messageDone$okhttp(Exchange exchange, boolean requestDone, boolean responseDone, E e) {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        if (!Intrinsics.areEqual((Object)exchange, (Object)this.exchange)) {
            return e;
        }
        boolean bothStreamsDone = false;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            if (requestDone && this.requestBodyOpen || responseDone && this.responseBodyOpen) {
                void var3_5;
                void var2_4;
                if (var2_4 != false) {
                    this.requestBodyOpen = false;
                }
                if (var3_5 != false) {
                    this.responseBodyOpen = false;
                }
                bothStreamsDone = !this.requestBodyOpen && !this.responseBodyOpen;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen && !this.expectMoreExchanges;
            }
        }
        if (var1_2 != false) {
            this.exchange = null;
            RealConnection realConnection = this.connection;
            if (realConnection != null) {
                realConnection.incrementSuccessCount$okhttp();
            }
        }
        if (callDone) {
            return this.callDone(e);
        }
        return e;
    }

    /*
     * WARNING - void declaration
     */
    public final IOException noMoreExchanges$okhttp(IOException e) {
        void var1_1;
        void var2_3;
        boolean callDone = false;
        RealCall realCall = this;
        synchronized (realCall) {
            if (this.expectMoreExchanges) {
                this.expectMoreExchanges = false;
                callDone = !this.requestBodyOpen && !this.responseBodyOpen;
            }
        }
        if (var2_3 != false) {
            return this.callDone(e);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends IOException> E callDone(E e) {
        void var3_3;
        void var1_1;
        RealCall $this$assertThreadDoesntHoldLock$iv = this;
        if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv));
        }
        RealConnection connection = this.connection;
        if (connection != null) {
            Object object;
            RealConnection $this$assertThreadDoesntHoldLock$iv2 = connection;
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv2)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + $this$assertThreadDoesntHoldLock$iv2));
            }
            $this$assertThreadDoesntHoldLock$iv2 = connection;
            synchronized ($this$assertThreadDoesntHoldLock$iv2) {
                object = this.releaseConnectionNoEvents$okhttp();
            }
            Socket toClose = object;
            if (this.connection == null) {
                Socket socket = toClose;
                if (socket != null) {
                    _UtilJvmKt.closeQuietly(socket);
                }
                this.eventListener.connectionReleased(this, connection);
                connection.getConnectionListener$okhttp().connectionReleased(connection, this);
                if (toClose != null) {
                    void var2_2;
                    connection.getConnectionListener$okhttp().connectionClosed((Connection)var2_2);
                }
            } else if (!(toClose == null)) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
        }
        E result = this.timeoutExit(e);
        if (var1_1 != null) {
            Call call = this;
            E e2 = result;
            Intrinsics.checkNotNull(e2);
            this.eventListener.callFailed(call, e2);
        } else {
            this.eventListener.callEnd(this);
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final Socket releaseConnectionNoEvents$okhttp() {
        void var2_2;
        void var3_4;
        int n;
        List<Reference<RealCall>> calls;
        Object connection;
        block6: {
            int index;
            RealConnection realConnection = this.connection;
            Intrinsics.checkNotNull((Object)realConnection);
            connection = realConnection;
            RealConnection $this$assertThreadHoldsLock$iv = realConnection;
            if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            calls = ((RealConnection)connection).getCalls();
            Object $this$indexOfFirst$iv = calls;
            int index$iv = 0;
            $this$indexOfFirst$iv = $this$indexOfFirst$iv.iterator();
            while ($this$indexOfFirst$iv.hasNext()) {
                Object object = $this$indexOfFirst$iv.next();
                if (Intrinsics.areEqual(((Reference)(object = (Reference)object)).get(), (Object)this)) {
                    n = index$iv;
                    break block6;
                }
                ++index$iv;
            }
            n = index = -1;
        }
        if (!(n != -1)) {
            connection = "Check failed.";
            throw new IllegalStateException(connection.toString());
        }
        calls.remove((int)var3_4);
        this.connection = null;
        if (var2_2.isEmpty()) {
            ((RealConnection)connection).setIdleAtNs(System.nanoTime());
            if (this.connectionPool.connectionBecameIdle((RealConnection)connection)) {
                void var1_1;
                return var1_1.socket();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends IOException> E timeoutExit(E cause) {
        void var2_2;
        if (this.timeoutEarlyExit) {
            return cause;
        }
        if (!this.timeout.exit()) {
            return cause;
        }
        InterruptedIOException e = new InterruptedIOException("timeout");
        if (cause != null) {
            void var1_1;
            e.initCause((Throwable)var1_1);
        }
        return (E)((IOException)var2_2);
    }

    public final void timeoutEarlyExit() {
        if (!(!this.timeoutEarlyExit)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        this.timeoutEarlyExit = true;
        this.timeout.exit();
    }

    /*
     * WARNING - void declaration
     */
    public final void exitNetworkInterceptorExchange$okhttp(boolean closeExchange2) {
        void var1_1;
        RealCall realCall = this;
        synchronized (realCall) {
            if (!this.expectMoreExchanges) {
                String closeExchange2 = "released";
                throw new IllegalStateException(closeExchange2.toString());
            }
        }
        if (var1_1 != false) {
            Exchange exchange = this.exchange;
            if (exchange != null) {
                exchange.detachWithViolence();
            }
        }
        this.interceptorScopedExchange = null;
    }

    public final boolean retryAfterFailure() {
        Exchange exchange = this.exchange;
        boolean bl = exchange != null ? exchange.getHasFailure$okhttp() : false;
        if (bl) {
            ExchangeFinder exchangeFinder = this.exchangeFinder;
            Intrinsics.checkNotNull((Object)exchangeFinder);
            Exchange exchange2 = this.exchange;
            if (exchangeFinder.getRoutePlanner().hasNext(exchange2 != null ? exchange2.getConnection$okhttp() : null)) {
                return true;
            }
        }
        return false;
    }

    private final String toLoggableString() {
        return (this.isCanceled() ? "canceled " : "") + (this.forWebSocket ? "web socket" : "call") + " to " + this.redactedUrl$okhttp();
    }

    public final String redactedUrl$okhttp() {
        return this.originalRequest.url().redact();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u0019\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u0012\u0010\u001e\u001a\u00020\u00172\n\u0010\u001f\u001a\u00060\u0000R\u00020\u0006J\b\u0010 \u001a\u00020\u0017H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lokhttp3/internal/connection/RealCall$AsyncCall;", "Ljava/lang/Runnable;", "responseCallback", "Lokhttp3/Callback;", "(Lokhttp3/internal/connection/RealCall;Lokhttp3/Callback;)V", "call", "Lokhttp3/internal/connection/RealCall;", "getCall", "()Lokhttp3/internal/connection/RealCall;", "<set-?>", "Ljava/util/concurrent/atomic/AtomicInteger;", "callsPerHost", "getCallsPerHost", "()Ljava/util/concurrent/atomic/AtomicInteger;", "host", "", "getHost", "()Ljava/lang/String;", "request", "Lokhttp3/Request;", "getRequest", "()Lokhttp3/Request;", "executeOn", "", "executorService", "Ljava/util/concurrent/ExecutorService;", "failRejected", "e", "Ljava/util/concurrent/RejectedExecutionException;", "failRejected$okhttp", "reuseCallsPerHostFrom", "other", "run", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nRealCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n+ 2 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,561:1\n367#2,4:562\n237#2,9:566\n*S KotlinDebug\n*F\n+ 1 RealCall.kt\nokhttp3/internal/connection/RealCall$AsyncCall\n*L\n500#1:562,4\n523#1:566,9\n*E\n"})
    public final class AsyncCall
    implements Runnable {
        private final Callback responseCallback;
        private volatile AtomicInteger callsPerHost;
        final /* synthetic */ RealCall this$0;

        /*
         * WARNING - void declaration
         */
        public AsyncCall(RealCall this$0, Callback responseCallback) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)responseCallback, (String)"responseCallback");
            this.this$0 = var1_1;
            this.responseCallback = var2_2;
            this.callsPerHost = new AtomicInteger(0);
        }

        public final AtomicInteger getCallsPerHost() {
            return this.callsPerHost;
        }

        /*
         * WARNING - void declaration
         */
        public final void reuseCallsPerHostFrom(AsyncCall other) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            this.callsPerHost = var1_1.callsPerHost;
        }

        public final String getHost() {
            return this.this$0.getOriginalRequest().url().host();
        }

        public final Request getRequest() {
            return this.this$0.getOriginalRequest();
        }

        public final RealCall getCall() {
            return this.this$0;
        }

        /*
         * WARNING - void declaration
         */
        public final void executeOn(ExecutorService executorService) {
            Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
            Dispatcher $this$assertThreadDoesntHoldLock$iv = this.this$0.getClient().dispatcher();
            if (_UtilJvmKt.assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock$iv)) {
                void var2_4;
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + var2_4));
            }
            try {
                try {
                    executorService.execute(this);
                    return;
                }
                catch (RejectedExecutionException e) {
                    void var1_2;
                    this.failRejected$okhttp((RejectedExecutionException)var1_2);
                    return;
                }
            }
            finally {
                this.this$0.getClient().dispatcher().finished$okhttp(this);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void failRejected$okhttp(RejectedExecutionException e) {
            void var2_2;
            void var1_1;
            InterruptedIOException ioException = new InterruptedIOException("executor rejected");
            ioException.initCause((Throwable)var1_1);
            this.this$0.noMoreExchanges$okhttp(ioException);
            this.responseCallback.onFailure(this.this$0, (IOException)var2_2);
        }

        public static /* synthetic */ void failRejected$okhttp$default(AsyncCall asyncCall, RejectedExecutionException rejectedExecutionException, int n, Object object) {
            if ((n & 1) != 0) {
                rejectedExecutionException = null;
            }
            asyncCall.failRejected$okhttp(rejectedExecutionException);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void run() {
            void name$iv;
            String string = "OkHttp " + this.this$0.redactedUrl$okhttp();
            RealCall realCall = this.this$0;
            Thread currentThread$iv = Thread.currentThread();
            String oldName$iv = currentThread$iv.getName();
            currentThread$iv.setName((String)name$iv);
            try {
                boolean signalledCallback = false;
                realCall.timeout.enter();
                try {
                    Response response = realCall.getResponseWithInterceptorChain$okhttp();
                    signalledCallback = true;
                    this.responseCallback.onResponse(realCall, response);
                }
                catch (IOException e) {
                    if (signalledCallback) {
                        Platform.Companion.get().log("Callback failure for " + realCall.toLoggableString(), 4, e);
                    } else {
                        this.responseCallback.onFailure(realCall, e);
                    }
                }
                catch (Throwable t) {
                    realCall.cancel();
                    if (!signalledCallback) {
                        void var1_3;
                        IOException canceledException = new IOException("canceled due to " + t);
                        ExceptionsKt.addSuppressed((Throwable)canceledException, (Throwable)t);
                        this.responseCallback.onFailure(realCall, (IOException)var1_3);
                    }
                    throw t;
                }
                finally {
                    realCall.getClient().dispatcher().finished$okhttp(this);
                }
                currentThread$iv.setName(oldName$iv);
                return;
            }
            catch (Throwable throwable) {
                void var3_6;
                var3_6.setName(oldName$iv);
                throw throwable;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/connection/RealCall$CallReference;", "Ljava/lang/ref/WeakReference;", "Lokhttp3/internal/connection/RealCall;", "referent", "callStackTrace", "", "(Lokhttp3/internal/connection/RealCall;Ljava/lang/Object;)V", "getCallStackTrace", "()Ljava/lang/Object;", "okhttp"})
    public static final class CallReference
    extends WeakReference<RealCall> {
        private final Object callStackTrace;

        /*
         * WARNING - void declaration
         */
        public CallReference(RealCall referent, Object callStackTrace) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)referent, (String)"referent");
            super(var1_1);
            this.callStackTrace = var2_2;
        }

        public final Object getCallStackTrace() {
            return this.callStackTrace;
        }
    }
}

