/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskLoggerKt;
import okhttp3.internal.concurrent.TaskQueue;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 02\u00020\u0001:\u0003/01B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!J\u0018\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u0004\u0018\u00010%J\u0010\u0010(\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010)\u001a\u00020#J\u0015\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b,J\u0006\u0010-\u001a\u00020\u000bJ\u0010\u0010.\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0016\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\n\n\u0002\b\u001a\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lokhttp3/internal/concurrent/TaskRunner;", "", "backend", "Lokhttp3/internal/concurrent/TaskRunner$Backend;", "logger", "Ljava/util/logging/Logger;", "(Lokhttp3/internal/concurrent/TaskRunner$Backend;Ljava/util/logging/Logger;)V", "getBackend", "()Lokhttp3/internal/concurrent/TaskRunner$Backend;", "busyQueues", "", "Lokhttp3/internal/concurrent/TaskQueue;", "condition", "Ljava/util/concurrent/locks/Condition;", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "coordinatorWaiting", "", "coordinatorWakeUpAt", "", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getLogger$okhttp", "()Ljava/util/logging/Logger;", "logger$1", "nextQueueName", "", "readyQueues", "runnable", "Ljava/lang/Runnable;", "activeQueues", "", "afterRun", "", "task", "Lokhttp3/internal/concurrent/Task;", "delayNanos", "awaitTaskToRun", "beforeRun", "cancelAll", "kickCoordinator", "taskQueue", "kickCoordinator$okhttp", "newQueue", "runTask", "Backend", "Companion", "RealBackend", "okhttp"})
@SourceDebugExtension(value={"SMAP\nTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner\n+ 2 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,345:1\n346#2,4:346\n346#2,4:350\n346#2,4:354\n346#2,4:358\n346#2,4:363\n1#3:362\n*S KotlinDebug\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner\n*L\n89#1:346,4\n107#1:350,4\n137#1:354,4\n163#1:358,4\n257#1:363,4\n*E\n"})
public final class TaskRunner {
    public static final Companion Companion = new Companion(null);
    private final Backend backend;
    private final Logger logger$1;
    private final ReentrantLock lock;
    private final Condition condition;
    private int nextQueueName;
    private boolean coordinatorWaiting;
    private long coordinatorWakeUpAt;
    private final List<TaskQueue> busyQueues;
    private final List<TaskQueue> readyQueues;
    private final Runnable runnable;
    private static final Logger logger;
    @JvmField
    public static final TaskRunner INSTANCE;

    /*
     * WARNING - void declaration
     */
    public TaskRunner(Backend backend, Logger logger) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)backend, (String)"backend");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.backend = var1_1;
        this.logger$1 = var2_2;
        this.lock = new ReentrantLock();
        Condition condition = this.lock.newCondition();
        Intrinsics.checkNotNullExpressionValue((Object)condition, (String)"newCondition(...)");
        this.condition = condition;
        this.nextQueueName = 10000;
        this.busyQueues = new ArrayList();
        this.readyQueues = new ArrayList();
        this.runnable = new Runnable(this){
            final /* synthetic */ TaskRunner this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final void run() {
                while (true) {
                    long elapsedNs$iv;
                    void queue$iv;
                    void $this$logElapsed$iv;
                    Task task;
                    Task task2;
                    Object object = this.this$0.getLock();
                    TaskRunner taskRunner = this.this$0;
                    object.lock();
                    try {
                        task2 = taskRunner.awaitTaskToRun();
                    }
                    finally {
                        object.unlock();
                    }
                    if (task2 == null) {
                        return;
                    }
                    Logger logger = this.this$0.getLogger$okhttp();
                    TaskQueue taskQueue = task.getQueue$okhttp();
                    Intrinsics.checkNotNull((Object)taskQueue);
                    object = taskQueue;
                    taskRunner = this.this$0;
                    long startNs$iv = -1L;
                    boolean loggingEnabled$iv = $this$logElapsed$iv.isLoggable(Level.FINE);
                    if (loggingEnabled$iv) {
                        startNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime();
                        TaskLoggerKt.access$log((Logger)$this$logElapsed$iv, task, (TaskQueue)queue$iv, "starting");
                    }
                    boolean completedNormally$iv = false;
                    try {
                        try {
                            TaskRunner.access$runTask(taskRunner, task);
                        }
                        catch (Throwable throwable) {
                            Lock lock = taskRunner.getLock();
                            lock.lock();
                            try {
                                taskRunner.getBackend().execute(taskRunner, this);
                                throw throwable;
                            }
                            finally {
                                lock.unlock();
                            }
                        }
                        completedNormally$iv = true;
                        if (!loggingEnabled$iv) continue;
                        elapsedNs$iv = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                    }
                    catch (Throwable throwable) {
                        if (!loggingEnabled$iv) throw throwable;
                        long elapsedNs$iv2 = queue$iv.getTaskRunner$okhttp().getBackend().nanoTime() - startNs$iv;
                        if (completedNormally$iv) {
                            TaskLoggerKt.access$log((Logger)$this$logElapsed$iv, task, (TaskQueue)queue$iv, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs$iv2));
                            throw throwable;
                        }
                        TaskLoggerKt.access$log(logger, task2, (TaskQueue)object, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs$iv2));
                        throw throwable;
                    }
                    TaskLoggerKt.access$log((Logger)$this$logElapsed$iv, task, (TaskQueue)queue$iv, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs$iv));
                }
            }
        };
    }

    public /* synthetic */ TaskRunner(Backend backend, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = TaskRunner.logger;
        }
        this(backend, logger);
    }

    public final Backend getBackend() {
        return this.backend;
    }

    public final Logger getLogger$okhttp() {
        return this.logger$1;
    }

    public final ReentrantLock getLock() {
        return this.lock;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    /*
     * WARNING - void declaration
     */
    public final void kickCoordinator$okhttp(TaskQueue taskQueue) {
        Intrinsics.checkNotNullParameter((Object)taskQueue, (String)"taskQueue");
        ReentrantLock $this$assertHeld$iv = this.lock;
        if (_UtilJvmKt.assertionsEnabled && !$this$assertHeld$iv.isHeldByCurrentThread()) {
            void var2_2;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var2_2));
        }
        if (taskQueue.getActiveTask$okhttp() == null) {
            if (!((Collection)taskQueue.getFutureTasks$okhttp()).isEmpty()) {
                _UtilCommonKt.addIfAbsent(this.readyQueues, taskQueue);
            } else {
                void var1_1;
                this.readyQueues.remove(var1_1);
            }
        }
        if (this.coordinatorWaiting) {
            this.backend.coordinatorNotify(this);
            return;
        }
        TaskRunner taskRunner = this;
        this.backend.execute(taskRunner, taskRunner.runnable);
    }

    /*
     * WARNING - void declaration
     */
    private final void beforeRun(Task task) {
        void var2_2;
        void var1_1;
        ReentrantLock $this$assertHeld$iv = this.lock;
        if (_UtilJvmKt.assertionsEnabled && !$this$assertHeld$iv.isHeldByCurrentThread()) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertHeld$iv));
        }
        task.setNextExecuteNanoTime$okhttp(-1L);
        TaskQueue taskQueue = task.getQueue$okhttp();
        Intrinsics.checkNotNull((Object)taskQueue);
        TaskQueue queue = taskQueue;
        taskQueue.getFutureTasks$okhttp().remove(task);
        this.readyQueues.remove(queue);
        queue.setActiveTask$okhttp((Task)var1_1);
        this.busyQueues.add((TaskQueue)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private final void runTask(Task task) {
        long delayNanos;
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName(task.getName());
        try {
            delayNanos = task.runOnce();
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            Lock lock = this.lock;
            lock.lock();
            try {
                void var1_1;
                this.afterRun((Task)var1_1, -1L);
            }
            finally {
                lock.unlock();
            }
            var2_3.setName((String)var3_4);
            throw throwable;
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            this.afterRun(task, delayNanos);
        }
        finally {
            lock.unlock();
        }
        currentThread.setName(oldName);
    }

    /*
     * WARNING - void declaration
     */
    private final void afterRun(Task task, long delayNanos) {
        ReentrantLock $this$assertHeld$iv = this.lock;
        if (_UtilJvmKt.assertionsEnabled && !$this$assertHeld$iv.isHeldByCurrentThread()) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertHeld$iv));
        }
        TaskQueue taskQueue = ((Task)task).getQueue$okhttp();
        Intrinsics.checkNotNull((Object)taskQueue);
        TaskQueue queue = taskQueue;
        if (!(taskQueue.getActiveTask$okhttp() == task)) {
            task = "Check failed.";
            throw new IllegalStateException(task.toString());
        }
        boolean cancelActiveTask = queue.getCancelActiveTask$okhttp();
        queue.setCancelActiveTask$okhttp(false);
        queue.setActiveTask$okhttp(null);
        this.busyQueues.remove(queue);
        if (delayNanos != -1L && !cancelActiveTask && !queue.getShutdown$okhttp()) {
            void var2_2;
            void var1_1;
            queue.scheduleAndDecide$okhttp((Task)var1_1, (long)var2_2, true);
        }
        if (!((Collection)queue.getFutureTasks$okhttp()).isEmpty()) {
            this.readyQueues.add(queue);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Task awaitTaskToRun() {
        ReentrantLock $this$assertHeld$iv = this.lock;
        if (_UtilJvmKt.assertionsEnabled && !$this$assertHeld$iv.isHeldByCurrentThread()) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertHeld$iv));
        }
        while (!this.readyQueues.isEmpty()) {
            void var1_2;
            long now = this.backend.nanoTime();
            long minDelayNanos = Long.MAX_VALUE;
            Task readyTask = null;
            boolean multipleReadyTasks = false;
            for (TaskQueue taskQueue : this.readyQueues) {
                Task candidate = taskQueue.getFutureTasks$okhttp().get(0);
                long candidateDelay = Math.max(0L, candidate.getNextExecuteNanoTime$okhttp() - now);
                if (candidateDelay > 0L) {
                    minDelayNanos = Math.min(candidateDelay, minDelayNanos);
                    continue;
                }
                if (readyTask != null) {
                    multipleReadyTasks = true;
                    break;
                }
                readyTask = candidate;
            }
            if (readyTask != null) {
                this.beforeRun(readyTask);
                if (multipleReadyTasks || !this.coordinatorWaiting && !((Collection)this.readyQueues).isEmpty()) {
                    TaskRunner taskRunner = this;
                    this.backend.execute(taskRunner, taskRunner.runnable);
                }
                return readyTask;
            }
            if (this.coordinatorWaiting) {
                if (minDelayNanos < this.coordinatorWakeUpAt - now) {
                    this.backend.coordinatorNotify(this);
                }
                return null;
            }
            this.coordinatorWaiting = true;
            this.coordinatorWakeUpAt = var1_2 + minDelayNanos;
            try {
                void var3_3;
                this.backend.coordinatorWait(this, (long)var3_3);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.cancelAll();
                continue;
            }
            finally {
                this.coordinatorWaiting = false;
                continue;
            }
            break;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final TaskQueue newQueue() {
        void var1_2;
        int n;
        Lock lock = this.lock;
        lock.lock();
        try {
            n = this.nextQueueName;
            this.nextQueueName = n + 1;
        }
        finally {
            lock.unlock();
        }
        int name = n;
        return new TaskQueue(this, "Q" + (int)var1_2);
    }

    public final List<TaskQueue> activeQueues() {
        Lock lock = this.lock;
        lock.lock();
        try {
            List list = CollectionsKt.plus((Collection)this.busyQueues, (Iterable)this.readyQueues);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void cancelAll() {
        int i;
        ReentrantLock $this$assertHeld$iv = this.lock;
        if (_UtilJvmKt.assertionsEnabled && !$this$assertHeld$iv.isHeldByCurrentThread()) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertHeld$iv));
        }
        for (i = this.busyQueues.size() - 1; i >= 0; --i) {
            this.busyQueues.get(i).cancelAllAndDecide$okhttp();
        }
        for (i = this.readyQueues.size() - 1; i >= 0; --i) {
            void var2_3;
            TaskQueue queue = this.readyQueues.get(i);
            queue.cancelAllAndDecide$okhttp();
            if (!var2_3.getFutureTasks$okhttp().isEmpty()) continue;
            this.readyQueues.remove(i);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$runTask(TaskRunner $this, Task task) {
        void var1_1;
        $this.runTask((Task)var1_1);
    }

    static {
        Logger logger = Logger.getLogger(TaskRunner.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        TaskRunner.logger = logger;
        INSTANCE = new TaskRunner(new RealBackend(_UtilJvmKt.threadFactory(_UtilJvmKt.okHttpName + " TaskRunner", true)), null, 2, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\"\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u000b0\n\"\u0004\b\u0000\u0010\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\nH&J\u0018\u0010\r\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH&J\b\u0010\u0010\u001a\u00020\bH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$Backend;", "", "coordinatorNotify", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "coordinatorWait", "nanos", "", "decorate", "Ljava/util/concurrent/BlockingQueue;", "T", "queue", "execute", "runnable", "Ljava/lang/Runnable;", "nanoTime", "okhttp"})
    public static interface Backend {
        public long nanoTime();

        public void coordinatorNotify(TaskRunner var1);

        public void coordinatorWait(TaskRunner var1, long var2);

        public <T> BlockingQueue<T> decorate(BlockingQueue<T> var1);

        public void execute(TaskRunner var1, Runnable var2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$Companion;", "", "()V", "INSTANCE", "Lokhttp3/internal/concurrent/TaskRunner;", "logger", "Ljava/util/logging/Logger;", "getLogger", "()Ljava/util/logging/Logger;", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011\"\u0004\b\u0000\u0010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\u00120\u0011H\u0016J\u0018\u0010\u0014\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\u0006\u0010\u0018\u001a\u00020\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/concurrent/TaskRunner$RealBackend;", "Lokhttp3/internal/concurrent/TaskRunner$Backend;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "(Ljava/util/concurrent/ThreadFactory;)V", "executor", "Ljava/util/concurrent/ThreadPoolExecutor;", "getExecutor", "()Ljava/util/concurrent/ThreadPoolExecutor;", "coordinatorNotify", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "coordinatorWait", "nanos", "", "decorate", "Ljava/util/concurrent/BlockingQueue;", "T", "queue", "execute", "runnable", "Ljava/lang/Runnable;", "nanoTime", "shutdown", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nTaskRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner$RealBackend\n+ 2 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,345:1\n346#2,4:346\n*S KotlinDebug\n*F\n+ 1 TaskRunner.kt\nokhttp3/internal/concurrent/TaskRunner$RealBackend\n*L\n318#1:346,4\n*E\n"})
    public static final class RealBackend
    implements Backend {
        private final ThreadPoolExecutor executor;

        /*
         * WARNING - void declaration
         */
        public RealBackend(ThreadFactory threadFactory) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)threadFactory, (String)"threadFactory");
            this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, (BlockingQueue<Runnable>)new SynchronousQueue(), (ThreadFactory)var1_1);
        }

        public final ThreadPoolExecutor getExecutor() {
            return this.executor;
        }

        @Override
        public final long nanoTime() {
            return System.nanoTime();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void coordinatorNotify(TaskRunner taskRunner) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            var1_1.getCondition().signal();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void coordinatorWait(TaskRunner taskRunner, long nanos) throws InterruptedException {
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            ReentrantLock $this$assertHeld$iv = taskRunner.getLock();
            if (_UtilJvmKt.assertionsEnabled && !$this$assertHeld$iv.isHeldByCurrentThread()) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertHeld$iv));
            }
            if (nanos > 0L) {
                void var2_2;
                void var1_1;
                var1_1.getCondition().awaitNanos((long)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> BlockingQueue<T> decorate(BlockingQueue<T> queue) {
            void var1_1;
            Intrinsics.checkNotNullParameter(queue, (String)"queue");
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void execute(TaskRunner taskRunner, Runnable runnable2) {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
            Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
            this.executor.execute((Runnable)var2_2);
        }

        public final void shutdown() {
            this.executor.shutdown();
        }
    }
}

