/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskLoggerKt;
import okhttp3.internal.concurrent.TaskRunner;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u00017B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010%\u001a\u00020&J\r\u0010'\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b(J0\u0010)\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020+2\b\b\u0002\u0010,\u001a\u00020\u000e2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020&0.J\u0006\u0010/\u001a\u000200J&\u00101\u001a\u00020&2\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010*\u001a\u00020+2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020+0.J\u0018\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\b2\b\b\u0002\u0010*\u001a\u00020+J%\u00103\u001a\u00020\u000e2\u0006\u00102\u001a\u00020\b2\u0006\u0010*\u001a\u00020+2\u0006\u00104\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b5J\u0006\u0010 \u001a\u00020&J\b\u00106\u001a\u00020\u0005H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\b0\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016R\u001a\u0010 \u001a\u00020\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0010\"\u0004\b\"\u0010\u0012R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00068"}, d2={"Lokhttp3/internal/concurrent/TaskQueue;", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "name", "", "(Lokhttp3/internal/concurrent/TaskRunner;Ljava/lang/String;)V", "activeTask", "Lokhttp3/internal/concurrent/Task;", "getActiveTask$okhttp", "()Lokhttp3/internal/concurrent/Task;", "setActiveTask$okhttp", "(Lokhttp3/internal/concurrent/Task;)V", "cancelActiveTask", "", "getCancelActiveTask$okhttp", "()Z", "setCancelActiveTask$okhttp", "(Z)V", "futureTasks", "", "getFutureTasks$okhttp", "()Ljava/util/List;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getName$okhttp", "()Ljava/lang/String;", "scheduledTasks", "", "getScheduledTasks", "shutdown", "getShutdown$okhttp", "setShutdown$okhttp", "getTaskRunner$okhttp", "()Lokhttp3/internal/concurrent/TaskRunner;", "cancelAll", "", "cancelAllAndDecide", "cancelAllAndDecide$okhttp", "execute", "delayNanos", "", "cancelable", "block", "Lkotlin/Function0;", "idleLatch", "Ljava/util/concurrent/CountDownLatch;", "schedule", "task", "scheduleAndDecide", "recurrence", "scheduleAndDecide$okhttp", "toString", "AwaitIdleTask", "okhttp"})
@SourceDebugExtension(value={"SMAP\nTaskQueue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 TaskLogger.kt\nokhttp3/internal/concurrent/TaskLoggerKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,248:1\n1#2:249\n26#3,4:250\n26#3,4:254\n26#3,4:258\n26#3,4:262\n26#3,4:281\n350#4,7:266\n360#5,4:273\n360#5,4:277\n*S KotlinDebug\n*F\n+ 1 TaskQueue.kt\nokhttp3/internal/concurrent/TaskQueue\n*L\n72#1:250,4\n75#1:254,4\n180#1:258,4\n186#1:262,4\n238#1:281,4\n195#1:266,7\n209#1:273,4\n219#1:277,4\n*E\n"})
public final class TaskQueue {
    private final TaskRunner taskRunner;
    private final String name;
    private final ReentrantLock lock;
    private boolean shutdown;
    private Task activeTask;
    private final List<Task> futureTasks;
    private boolean cancelActiveTask;

    /*
     * WARNING - void declaration
     */
    public TaskQueue(TaskRunner taskRunner, String name) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.taskRunner = var1_1;
        this.name = var2_2;
        this.lock = new ReentrantLock();
        this.futureTasks = new ArrayList();
    }

    public final TaskRunner getTaskRunner$okhttp() {
        return this.taskRunner;
    }

    public final String getName$okhttp() {
        return this.name;
    }

    public final ReentrantLock getLock() {
        return this.lock;
    }

    public final boolean getShutdown$okhttp() {
        return this.shutdown;
    }

    /*
     * WARNING - void declaration
     */
    public final void setShutdown$okhttp(boolean bl) {
        void var1_1;
        this.shutdown = var1_1;
    }

    public final Task getActiveTask$okhttp() {
        return this.activeTask;
    }

    /*
     * WARNING - void declaration
     */
    public final void setActiveTask$okhttp(Task task) {
        void var1_1;
        this.activeTask = var1_1;
    }

    public final List<Task> getFutureTasks$okhttp() {
        return this.futureTasks;
    }

    public final boolean getCancelActiveTask$okhttp() {
        return this.cancelActiveTask;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCancelActiveTask$okhttp(boolean bl) {
        void var1_1;
        this.cancelActiveTask = var1_1;
    }

    public final List<Task> getScheduledTasks() {
        Lock lock = this.taskRunner.getLock();
        lock.lock();
        try {
            List list = CollectionsKt.toList((Iterable)this.futureTasks);
            return list;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void schedule(Task task, long delayNanos) {
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Lock lock = this.taskRunner.getLock();
        lock.lock();
        try {
            void var2_3;
            void var1_1;
            if (this.shutdown) {
                if (((Task)task).getCancelable()) {
                    Object $this$taskLog$iv = this.taskRunner.getLogger$okhttp();
                    if (((Logger)$this$taskLog$iv).isLoggable(Level.FINE)) {
                        Logger logger = $this$taskLog$iv;
                        Task task2 = task;
                        task = this;
                        $this$taskLog$iv = task2;
                        Logger logger2 = logger;
                        String string = "schedule canceled (queue is shutdown)";
                        TaskLoggerKt.access$log(logger2, (Task)$this$taskLog$iv, (TaskQueue)task, string);
                    }
                    return;
                }
                Logger $this$taskLog$iv = this.taskRunner.getLogger$okhttp();
                if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                    Task task3;
                    void v2 = task3;
                    Task task4 = task;
                    task = this;
                    task3 = task4;
                    void var3_8 = v2;
                    String string = "schedule failed (queue is shutdown)";
                    TaskLoggerKt.access$log((Logger)var3_8, task3, (TaskQueue)task, string);
                }
                throw new RejectedExecutionException();
            }
            if (this.scheduleAndDecide$okhttp((Task)var1_1, (long)var2_3, false)) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
        finally {
            lock.unlock();
        }
    }

    public static /* synthetic */ void schedule$default(TaskQueue taskQueue, Task task, long l, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        taskQueue.schedule(task, l);
    }

    /*
     * WARNING - void declaration
     */
    public final void schedule(String name, long delayNanos, Function0<Long> block) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.schedule(new Task((String)var1_1, block){
            final /* synthetic */ Function0<Long> $block;
            {
                void var1_1;
                void var2_2;
                this.$block = var2_2;
                super((String)var1_1, false, 2, null);
            }

            public final long runOnce() {
                return ((Number)this.$block.invoke()).longValue();
            }
        }, (long)var2_2);
    }

    public static /* synthetic */ void schedule$default(TaskQueue taskQueue, String string, long l, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        taskQueue.schedule(string, l, (Function0<Long>)function0);
    }

    /*
     * WARNING - void declaration
     */
    public final void execute(String name, long delayNanos, boolean cancelable, Function0<Unit> block) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.schedule(new Task((String)var1_1, cancelable, block){
            final /* synthetic */ Function0<Unit> $block;
            {
                void var2_2;
                void var1_1;
                void var3_3;
                this.$block = var3_3;
                super((String)var1_1, (boolean)var2_2);
            }

            public final long runOnce() {
                this.$block.invoke();
                return -1L;
            }
        }, (long)var2_2);
    }

    public static /* synthetic */ void execute$default(TaskQueue taskQueue, String string, long l, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            l = 0L;
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        taskQueue.execute(string, l, bl, (Function0<Unit>)function0);
    }

    /*
     * WARNING - void declaration
     */
    public final CountDownLatch idleLatch() {
        Lock lock = this.taskRunner.getLock();
        lock.lock();
        try {
            CountDownLatch countDownLatch;
            if (this.activeTask == null && this.futureTasks.isEmpty()) {
                CountDownLatch countDownLatch2 = new CountDownLatch(0);
                return countDownLatch2;
            }
            Object existingTask = this.activeTask;
            if (existingTask instanceof AwaitIdleTask) {
                existingTask = ((AwaitIdleTask)existingTask).getLatch();
                return existingTask;
            }
            existingTask = this.futureTasks.iterator();
            while (existingTask.hasNext()) {
                void var3_5;
                Task futureTask = existingTask.next();
                if (!(futureTask instanceof AwaitIdleTask)) continue;
                existingTask = ((AwaitIdleTask)var3_5).getLatch();
                return existingTask;
            }
            AwaitIdleTask newTask = new AwaitIdleTask();
            if (this.scheduleAndDecide$okhttp(newTask, 0L, false)) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            countDownLatch = ((AwaitIdleTask)((Object)countDownLatch)).getLatch();
            return countDownLatch;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean scheduleAndDecide$okhttp(Task task, long delayNanos, boolean recurrence222) {
        void var1_1;
        int insertAt;
        int n;
        block7: {
            Intrinsics.checkNotNullParameter((Object)task, (String)"task");
            task.initQueue$okhttp(this);
            long now = this.taskRunner.getBackend().nanoTime();
            long executeNanoTime = now + delayNanos;
            int existingIndex = this.futureTasks.indexOf(task);
            if (existingIndex != -1) {
                void $this$taskLog$iv2;
                if (task.getNextExecuteNanoTime$okhttp() <= executeNanoTime) {
                    Logger $this$taskLog$iv2 = this.taskRunner.getLogger$okhttp();
                    if ($this$taskLog$iv2.isLoggable(Level.FINE)) {
                        TaskQueue taskQueue = this;
                        Task task2 = task;
                        String recurrence222 = "already scheduled";
                        TaskLoggerKt.access$log($this$taskLog$iv2, task2, taskQueue, recurrence222);
                    }
                    return false;
                }
                this.futureTasks.remove((int)$this$taskLog$iv2);
            }
            task.setNextExecuteNanoTime$okhttp(executeNanoTime);
            Logger $this$taskLog$iv = this.taskRunner.getLogger$okhttp();
            if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                boolean recurrence222;
                TaskQueue taskQueue = this;
                Task task3 = task;
                String recurrence222 = recurrence222 ? "run again after " + TaskLoggerKt.formatDuration(executeNanoTime - now) : "scheduled after " + TaskLoggerKt.formatDuration(executeNanoTime - now);
                TaskLoggerKt.access$log($this$taskLog$iv, task3, taskQueue, recurrence222);
            }
            List<Task> $this$indexOfFirst$iv = this.futureTasks;
            int index$iv = 0;
            for (Task task4 : $this$indexOfFirst$iv) {
                Task task5;
                task4 = task4;
                if (task5.getNextExecuteNanoTime$okhttp() - now > delayNanos) {
                    n = index$iv;
                    break block7;
                }
                ++index$iv;
            }
            n = insertAt = -1;
        }
        if (n == -1) {
            insertAt = this.futureTasks.size();
        }
        this.futureTasks.add(insertAt, (Task)var1_1);
        return insertAt == 0;
    }

    public final void cancelAll() {
        Lock lock;
        ReentrantLock $this$assertNotHeld$iv = this.lock;
        if (_UtilJvmKt.assertionsEnabled && $this$assertNotHeld$iv.isHeldByCurrentThread()) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + lock));
        }
        lock = this.taskRunner.getLock();
        lock.lock();
        try {
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
        finally {
            lock.unlock();
        }
    }

    public final void shutdown() {
        Lock lock;
        ReentrantLock $this$assertNotHeld$iv = this.lock;
        if (_UtilJvmKt.assertionsEnabled && $this$assertNotHeld$iv.isHeldByCurrentThread()) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + lock));
        }
        lock = this.taskRunner.getLock();
        lock.lock();
        try {
            this.shutdown = true;
            if (this.cancelAllAndDecide$okhttp()) {
                this.taskRunner.kickCoordinator$okhttp(this);
            }
            return;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean cancelAllAndDecide$okhttp() {
        boolean bl;
        if (this.activeTask != null) {
            Task task = this.activeTask;
            Intrinsics.checkNotNull((Object)task);
            if (task.getCancelable()) {
                this.cancelActiveTask = true;
            }
        }
        boolean tasksCanceled2 = false;
        for (int i = this.futureTasks.size() - 1; i >= 0; --i) {
            void $this$taskLog$iv;
            if (!this.futureTasks.get(i).getCancelable()) continue;
            Logger tasksCanceled2 = this.taskRunner.getLogger$okhttp();
            Task task$iv = this.futureTasks.get(i);
            if ($this$taskLog$iv.isLoggable(Level.FINE)) {
                void var3_4;
                void var1_2;
                TaskQueue taskQueue = this;
                String string = "canceled";
                TaskLoggerKt.access$log((Logger)var1_2, (Task)var3_4, taskQueue, string);
            }
            bl = true;
            this.futureTasks.remove(i);
        }
        return bl;
    }

    public final String toString() {
        return this.name;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0007\u001a\u00020\bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lokhttp3/internal/concurrent/TaskQueue$AwaitIdleTask;", "Lokhttp3/internal/concurrent/Task;", "()V", "latch", "Ljava/util/concurrent/CountDownLatch;", "getLatch", "()Ljava/util/concurrent/CountDownLatch;", "runOnce", "", "okhttp"})
    private static final class AwaitIdleTask
    extends Task {
        private final CountDownLatch latch = new CountDownLatch(1);

        public AwaitIdleTask() {
            super(_UtilJvmKt.okHttpName + " awaitIdle", false);
        }

        public final CountDownLatch getLatch() {
            return this.latch;
        }

        @Override
        public final long runOnce() {
            this.latch.countDown();
            return -1L;
        }
    }
}

