/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.concurrent;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a$\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001H\u0002\u001a9\u0010\f\u001a\u0002H\r\"\u0004\b\u0000\u0010\r*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\r0\u000fH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a.\u0010\u0011\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u000fH\u0080\b\u00f8\u0001\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0013"}, d2={"formatDuration", "", "ns", "", "log", "", "Ljava/util/logging/Logger;", "task", "Lokhttp3/internal/concurrent/Task;", "queue", "Lokhttp3/internal/concurrent/TaskQueue;", "message", "logElapsed", "T", "block", "Lkotlin/Function0;", "(Ljava/util/logging/Logger;Lokhttp3/internal/concurrent/Task;Lokhttp3/internal/concurrent/TaskQueue;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "taskLog", "messageBlock", "okhttp"})
public final class TaskLoggerKt {
    /*
     * WARNING - void declaration
     */
    public static final void taskLog(Logger $this$taskLog, Task task, TaskQueue queue, Function0<String> messageBlock) {
        Intrinsics.checkNotNullParameter((Object)$this$taskLog, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter(messageBlock, (String)"messageBlock");
        if ($this$taskLog.isLoggable(Level.FINE)) {
            void var3_3;
            void var2_2;
            void var1_1;
            Logger logger;
            TaskLoggerKt.access$log(logger, (Task)var1_1, (TaskQueue)var2_2, (String)var3_3.invoke());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> T logElapsed(Logger $this$logElapsed, Task task, TaskQueue queue, Function0<? extends T> block) {
        void var9_8;
        Intrinsics.checkNotNullParameter((Object)$this$logElapsed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
        Intrinsics.checkNotNullParameter((Object)queue, (String)"queue");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        long startNs = -1L;
        boolean loggingEnabled = $this$logElapsed.isLoggable(Level.FINE);
        if (loggingEnabled) {
            startNs = queue.getTaskRunner$okhttp().getBackend().nanoTime();
            TaskLoggerKt.access$log($this$logElapsed, task, queue, "starting");
        }
        boolean completedNormally = false;
        try {
            void var3_3;
            Object result = block.invoke();
            completedNormally = true;
            var9_8 = var3_3;
        }
        catch (Throwable throwable) {
            InlineMarker.finallyStart((int)1);
            if (loggingEnabled) {
                long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
                if (completedNormally) {
                    TaskLoggerKt.access$log($this$logElapsed, task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
                } else {
                    void var2_2;
                    void var1_1;
                    Logger logger;
                    TaskLoggerKt.access$log(logger, (Task)var1_1, (TaskQueue)var2_2, "failed a run in " + TaskLoggerKt.formatDuration(elapsedNs));
                }
            }
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        if (loggingEnabled) {
            long elapsedNs = queue.getTaskRunner$okhttp().getBackend().nanoTime() - startNs;
            TaskLoggerKt.access$log($this$logElapsed, task, queue, "finished run in " + TaskLoggerKt.formatDuration(elapsedNs));
        }
        InlineMarker.finallyEnd((int)1);
        return var9_8;
    }

    /*
     * WARNING - void declaration
     */
    private static final void log(Logger $this$log, Task task, TaskQueue queue, String message) {
        void var1_1;
        void var3_3;
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder().append(objectArray.getName$okhttp()).append(' ');
        String string = "%-22s";
        Object[] objectArray2 = new Object[1];
        objectArray = objectArray2;
        objectArray2[0] = var3_3;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        $this$log.fine(stringBuilder.append(string2).append(": ").append(var1_1.getName()).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static final String formatDuration(long ns) {
        void var0_1;
        String s = ns <= -999500000L ? (ns - 500000000L) / 1000000000L + " s " : (ns <= -999500L ? (ns - 500000L) / 1000000L + " ms" : (ns <= 0L ? (ns - 500L) / 1000L + " \u00b5s" : (ns < 999500L ? (ns + 500L) / 1000L + " \u00b5s" : (ns < 999500000L ? (ns + 500000L) / 1000000L + " ms" : (ns + 500000000L) / 1000000000L + " s "))));
        String string = "%6s";
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = var0_1;
        String string2 = String.format(string, Arrays.copyOf(objectArray2, objectArray2.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$log(Logger $receiver, Task task, TaskQueue queue, String message) {
        void var3_3;
        void var2_2;
        void var1_1;
        TaskLoggerKt.log($receiver, (Task)var1_1, (TaskQueue)var2_2, (String)var3_3);
    }
}

