/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.Flushable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.cache.FaultHidingSink;
import okhttp3.internal.concurrent.Task;
import okhttp3.internal.concurrent.TaskQueue;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.platform.Platform;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.FileSystem;
import okio.ForwardingFileSystem;
import okio.ForwardingSource;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010)\n\u0002\b\u0007*\u0001\u0014\u0018\u0000 \\2\u00020\u00012\u00020\u0002:\u0004\\]^_B5\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020:H\u0016J!\u0010<\u001a\u00020:2\n\u0010=\u001a\u00060>R\u00020\u00002\u0006\u0010?\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b@J\u0006\u0010A\u001a\u00020:J \u0010B\u001a\b\u0018\u00010>R\u00020\u00002\u0006\u0010C\u001a\u00020(2\b\b\u0002\u0010D\u001a\u00020\u000bH\u0007J\u0006\u0010E\u001a\u00020:J\b\u0010F\u001a\u00020:H\u0016J\u0017\u0010G\u001a\b\u0018\u00010HR\u00020\u00002\u0006\u0010C\u001a\u00020(H\u0086\u0002J\u0006\u0010I\u001a\u00020:J\u0006\u0010J\u001a\u00020\u0010J\b\u0010K\u001a\u00020\u0010H\u0002J\b\u0010L\u001a\u00020%H\u0002J\b\u0010M\u001a\u00020:H\u0002J\b\u0010N\u001a\u00020:H\u0002J\u0010\u0010O\u001a\u00020:2\u0006\u0010P\u001a\u00020(H\u0002J\r\u0010Q\u001a\u00020:H\u0000\u00a2\u0006\u0002\bRJ\u000e\u0010S\u001a\u00020\u00102\u0006\u0010C\u001a\u00020(J\u0019\u0010T\u001a\u00020\u00102\n\u0010U\u001a\u00060)R\u00020\u0000H\u0000\u00a2\u0006\u0002\bVJ\b\u0010W\u001a\u00020\u0010H\u0002J\u0006\u00106\u001a\u00020\u000bJ\u0010\u0010X\u001a\f\u0012\b\u0012\u00060HR\u00020\u00000YJ\u0006\u0010Z\u001a\u00020:J\u0010\u0010[\u001a\u00020:2\u0006\u0010C\u001a\u00020(H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\u001f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R8\u0010&\u001a&\u0012\u0004\u0012\u00020(\u0012\b\u0012\u00060)R\u00020\u00000'j\u0012\u0012\u0004\u0012\u00020(\u0012\b\u0012\u00060)R\u00020\u0000`*X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R&\u0010\n\u001a\u00020\u000b2\u0006\u0010-\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00102\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006`"}, d2={"Lokhttp3/internal/cache/DiskLruCache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "appVersion", "", "valueCount", "maxSize", "", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(Lokio/FileSystem;Lokio/Path;IIJLokhttp3/internal/concurrent/TaskRunner;)V", "civilizedFileSystem", "", "cleanupQueue", "Lokhttp3/internal/concurrent/TaskQueue;", "cleanupTask", "okhttp3/internal/cache/DiskLruCache$cleanupTask$1", "Lokhttp3/internal/cache/DiskLruCache$cleanupTask$1;", "closed", "getClosed$okhttp", "()Z", "setClosed$okhttp", "(Z)V", "getDirectory", "()Lokio/Path;", "getFileSystem$okhttp", "()Lokio/FileSystem;", "hasJournalErrors", "initialized", "journalFile", "journalFileBackup", "journalFileTmp", "journalWriter", "Lokio/BufferedSink;", "lruEntries", "Ljava/util/LinkedHashMap;", "", "Lokhttp3/internal/cache/DiskLruCache$Entry;", "Lkotlin/collections/LinkedHashMap;", "getLruEntries$okhttp", "()Ljava/util/LinkedHashMap;", "value", "getMaxSize", "()J", "setMaxSize", "(J)V", "mostRecentRebuildFailed", "mostRecentTrimFailed", "nextSequenceNumber", "redundantOpCount", "size", "getValueCount$okhttp", "()I", "checkNotClosed", "", "close", "completeEdit", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "success", "completeEdit$okhttp", "delete", "edit", "key", "expectedSequenceNumber", "evictAll", "flush", "get", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "initialize", "isClosed", "journalRebuildRequired", "newJournalWriter", "processJournal", "readJournal", "readJournalLine", "line", "rebuildJournal", "rebuildJournal$okhttp", "remove", "removeEntry", "entry", "removeEntry$okhttp", "removeOldestEntry", "snapshots", "", "trimToSize", "validateKey", "Companion", "Editor", "Entry", "Snapshot", "okhttp"})
@SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n+ 4 Okio.kt\nokio/Okio__OkioKt\n+ 5 FileSystem.kt\nokio/FileSystem\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,1114:1\n1#2:1115\n353#3,4:1116\n66#4:1120\n52#4,4:1122\n60#4,10:1127\n56#4,3:1137\n71#4,3:1140\n52#4,4:1146\n60#4,10:1151\n56#4,18:1161\n67#5:1121\n68#5:1126\n80#5:1143\n165#5:1144\n81#5:1145\n82#5:1150\n37#6,2:1179\n37#6,2:1181\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache\n*L\n227#1:1116,4\n276#1:1120\n276#1:1122,4\n276#1:1127,10\n276#1:1137,3\n276#1:1140,3\n407#1:1146,4\n407#1:1151,10\n407#1:1161,18\n276#1:1121\n276#1:1126\n407#1:1143\n407#1:1144\n407#1:1145\n407#1:1150\n709#1:1179,2\n759#1:1181,2\n*E\n"})
public final class DiskLruCache
implements Closeable,
Flushable {
    public static final Companion Companion = new Companion(null);
    private final Path directory;
    private final int appVersion;
    private final int valueCount;
    private final FileSystem fileSystem;
    private long maxSize;
    private final Path journalFile;
    private final Path journalFileTmp;
    private final Path journalFileBackup;
    private long size;
    private BufferedSink journalWriter;
    private final LinkedHashMap<String, Entry> lruEntries;
    private int redundantOpCount;
    private boolean hasJournalErrors;
    private boolean civilizedFileSystem;
    private boolean initialized;
    private boolean closed;
    private boolean mostRecentTrimFailed;
    private boolean mostRecentRebuildFailed;
    private long nextSequenceNumber;
    private final TaskQueue cleanupQueue;
    private final cleanupTask.1 cleanupTask;
    @JvmField
    public static final String JOURNAL_FILE = "journal";
    @JvmField
    public static final String JOURNAL_FILE_TEMP = "journal.tmp";
    @JvmField
    public static final String JOURNAL_FILE_BACKUP = "journal.bkp";
    @JvmField
    public static final String MAGIC = "libcore.io.DiskLruCache";
    @JvmField
    public static final String VERSION_1 = "1";
    @JvmField
    public static final long ANY_SEQUENCE_NUMBER = -1L;
    @JvmField
    public static final Regex LEGAL_KEY_PATTERN = new Regex("[a-z0-9_-]{1,120}");
    @JvmField
    public static final String CLEAN = "CLEAN";
    @JvmField
    public static final String DIRTY = "DIRTY";
    @JvmField
    public static final String REMOVE = "REMOVE";
    @JvmField
    public static final String READ = "READ";

    /*
     * WARNING - void declaration
     */
    public DiskLruCache(FileSystem fileSystem2, Path directory, int appVersion, int valueCount, long maxSize, TaskRunner taskRunner) {
        String string;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        this.directory = var2_2;
        this.appVersion = var3_3;
        this.valueCount = valueCount;
        this.fileSystem = (FileSystem)new ForwardingFileSystem((FileSystem)string){
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            public final Sink sink(Path file, boolean mustCreate) {
                void var2_2;
                void var1_1;
                block0: {
                    void var3_3;
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    Path path = file.parent();
                    if (path == null) break block0;
                    Path it = path;
                    this.createDirectories((Path)var3_3);
                }
                return super.sink((Path)var1_1, (boolean)var2_2);
            }
        };
        this.maxSize = maxSize;
        this.lruEntries = new LinkedHashMap(0, 0.75f, true);
        this.cleanupQueue = taskRunner.newQueue();
        string = _UtilJvmKt.okHttpName + " Cache";
        this.cleanupTask = new Task(this, string){
            final /* synthetic */ DiskLruCache this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((String)var2_2, false, 2, null);
            }

            public final long runOnce() {
                DiskLruCache diskLruCache = this.this$0;
                DiskLruCache diskLruCache2 = this.this$0;
                synchronized (diskLruCache) {
                    block10: {
                        if (DiskLruCache.access$getInitialized$p(diskLruCache2) && !diskLruCache2.getClosed$okhttp()) break block10;
                        return -1L;
                    }
                    try {
                        diskLruCache2.trimToSize();
                    }
                    catch (IOException iOException) {
                        DiskLruCache.access$setMostRecentTrimFailed$p(diskLruCache2, true);
                    }
                    try {
                        if (DiskLruCache.access$journalRebuildRequired(diskLruCache2)) {
                            diskLruCache2.rebuildJournal$okhttp();
                            DiskLruCache.access$setRedundantOpCount$p(diskLruCache2, 0);
                        }
                    }
                    catch (IOException iOException) {
                        DiskLruCache.access$setMostRecentRebuildFailed$p(diskLruCache2, true);
                        BufferedSink bufferedSink = DiskLruCache.access$getJournalWriter$p(diskLruCache2);
                        if (bufferedSink != null) {
                            _UtilCommonKt.closeQuietly((Closeable)bufferedSink);
                        }
                        DiskLruCache.access$setJournalWriter$p(diskLruCache2, Okio.buffer((Sink)Okio.blackhole()));
                    }
                    return -1L;
                }
            }
        };
        if (!(maxSize > 0L)) {
            string = "maxSize <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        if (!(this.valueCount > 0)) {
            string = "valueCount <= 0";
            throw new IllegalArgumentException(string.toString());
        }
        this.journalFile = this.directory.resolve(JOURNAL_FILE);
        this.journalFileTmp = this.directory.resolve(JOURNAL_FILE_TEMP);
        this.journalFileBackup = this.directory.resolve(JOURNAL_FILE_BACKUP);
    }

    public final Path getDirectory() {
        return this.directory;
    }

    public final int getValueCount$okhttp() {
        return this.valueCount;
    }

    public final FileSystem getFileSystem$okhttp() {
        return this.fileSystem;
    }

    public final synchronized long getMaxSize() {
        return this.maxSize;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void setMaxSize(long value) {
        void var1_1;
        this.maxSize = var1_1;
        if (this.initialized) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
    }

    public final LinkedHashMap<String, Entry> getLruEntries$okhttp() {
        return this.lruEntries;
    }

    public final boolean getClosed$okhttp() {
        return this.closed;
    }

    /*
     * WARNING - void declaration
     */
    public final void setClosed$okhttp(boolean bl) {
        void var1_1;
        this.closed = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void initialize() throws IOException {
        DiskLruCache $this$assertThreadHoldsLock$iv = this;
        if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
        }
        if (this.initialized) {
            return;
        }
        if (this.fileSystem.exists(this.journalFileBackup)) {
            if (this.fileSystem.exists(this.journalFile)) {
                this.fileSystem.delete(this.journalFileBackup);
            } else {
                this.fileSystem.atomicMove(this.journalFileBackup, this.journalFile);
            }
        }
        this.civilizedFileSystem = _UtilCommonKt.isCivilized(this.fileSystem, this.journalFileBackup);
        if (this.fileSystem.exists(this.journalFile)) {
            try {
                this.readJournal();
                this.processJournal();
                this.initialized = true;
                return;
            }
            catch (IOException journalIsCorrupt) {
                void var1_2;
                Platform.Companion.get().log("DiskLruCache " + this.directory + " is corrupt: " + journalIsCorrupt.getMessage() + ", removing", 5, (Throwable)var1_2);
                try {
                    this.delete();
                }
                finally {
                    this.closed = false;
                }
            }
        }
        this.rebuildJournal$okhttp();
        this.initialized = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void readJournal() throws IOException {
        void var2_2;
        void this_$iv;
        FileSystem fileSystem2 = this.fileSystem;
        Path file$iv = this.journalFile;
        Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Source)this_$iv.source(file$iv));
        Throwable thrown$iv$iv = null;
        try {
            BufferedSource bufferedSource;
            Object $this$readJournal_u24lambda_u242 = bufferedSource = (BufferedSource)$this$use$iv$iv;
            String magic = bufferedSource.readUtf8LineStrict();
            String version = $this$readJournal_u24lambda_u242.readUtf8LineStrict();
            String appVersionString = $this$readJournal_u24lambda_u242.readUtf8LineStrict();
            String valueCountString = $this$readJournal_u24lambda_u242.readUtf8LineStrict();
            String blank = $this$readJournal_u24lambda_u242.readUtf8LineStrict();
            if (!(Intrinsics.areEqual((Object)MAGIC, (Object)magic) && Intrinsics.areEqual((Object)VERSION_1, (Object)version) && Intrinsics.areEqual((Object)String.valueOf(this.appVersion), (Object)appVersionString) && Intrinsics.areEqual((Object)String.valueOf(this.valueCount), (Object)valueCountString) && !(((CharSequence)blank).length() > 0))) {
                throw new IOException("unexpected journal header: [" + magic + ", " + version + ", " + valueCountString + ", " + blank + ']');
            }
            int lineCount = 0;
            try {
                while (true) {
                    this.readJournalLine($this$readJournal_u24lambda_u242.readUtf8LineStrict());
                    ++lineCount;
                }
            }
            catch (EOFException eOFException) {
                this.redundantOpCount = lineCount - this.lruEntries.size();
                if (!$this$readJournal_u24lambda_u242.exhausted()) {
                    this.rebuildJournal$okhttp();
                } else {
                    BufferedSink bufferedSink = this.journalWriter;
                    if (bufferedSink != null) {
                        _UtilCommonKt.closeQuietly((Closeable)bufferedSink);
                    }
                    this.journalWriter = this.newJournalWriter();
                }
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                }
                catch (Throwable throwable) {
                    $this$readJournal_u24lambda_u242 = throwable;
                    thrown$iv$iv = throwable;
                }
            }
        }
        catch (Throwable throwable) {
            Throwable $this$readJournal_u24lambda_u242 = throwable;
            thrown$iv$iv = throwable;
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv$iv) {
                void var3_5;
                ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)var3_5);
            }
        }
        catch (Throwable throwable) {
            try {
                FileSystem fileSystem3 = fileSystem2;
                if (fileSystem3 != null) {
                    fileSystem3.close();
                }
            }
            catch (Throwable throwable2) {}
            throw throwable;
        }
        void v8 = var2_2;
        if (v8 != null) {
            throw v8;
        }
    }

    private final BufferedSink newJournalWriter() throws FileNotFoundException {
        FaultHidingSink faultHidingSink2;
        Sink fileSink = this.fileSystem.appendingSink(this.journalFile);
        faultHidingSink2 = new FaultHidingSink((Sink)faultHidingSink2, (Function1<? super IOException, Unit>)((Function1)new Function1<IOException, Unit>(this){
            final /* synthetic */ DiskLruCache this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(IOException it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                DiskLruCache $this$assertThreadHoldsLock$iv = this.this$0;
                if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                    void var1_1;
                    throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + var1_1));
                }
                DiskLruCache.access$setHasJournalErrors$p(this.this$0, true);
            }
        }));
        return Okio.buffer((Sink)((Sink)faultHidingSink2));
    }

    /*
     * WARNING - void declaration
     */
    private final void readJournalLine(String line) throws IOException {
        void var2_2;
        void var1_1;
        Entry entry;
        String key22;
        int firstSpace = StringsKt.indexOf$default((CharSequence)((CharSequence)line), (char)' ', (int)0, (boolean)false, (int)6, null);
        if (firstSpace == -1) {
            throw new IOException("unexpected journal line: " + (String)line);
        }
        int keyBegin = firstSpace + 1;
        int secondSpace = StringsKt.indexOf$default((CharSequence)((CharSequence)line), (char)' ', (int)keyBegin, (boolean)false, (int)4, null);
        if (secondSpace == -1) {
            String string = ((String)line).substring(keyBegin);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key22 = string;
            if (firstSpace == REMOVE.length() && StringsKt.startsWith$default((String)line, (String)REMOVE, (boolean)false, (int)2, null)) {
                this.lruEntries.remove(key22);
                return;
            }
        } else {
            void key22;
            String string = ((String)line).substring((int)key22, secondSpace);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            key22 = string;
        }
        if ((entry = this.lruEntries.get(key22)) == null) {
            void var3_4;
            entry = new Entry(key22);
            ((Map)this.lruEntries).put(var3_4, entry);
        }
        if (secondSpace != -1 && firstSpace == CLEAN.length() && StringsKt.startsWith$default((String)line, (String)CLEAN, (boolean)false, (int)2, null)) {
            String string = ((String)line).substring(secondSpace + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[1];
            line = cArray;
            cArray[0] = 32;
            List parts = StringsKt.split$default((CharSequence)string, (char[])line, (boolean)false, (int)0, (int)6, null);
            entry.setReadable$okhttp(true);
            entry.setCurrentEditor$okhttp(null);
            entry.setLengths$okhttp((List<String>)var1_1);
            return;
        }
        if (secondSpace == -1 && firstSpace == DIRTY.length() && StringsKt.startsWith$default((String)var1_1, (String)DIRTY, (boolean)false, (int)2, null)) {
            entry.setCurrentEditor$okhttp(new Editor(this, entry));
            return;
        }
        if (secondSpace != -1 || var2_2 != READ.length() || !StringsKt.startsWith$default((String)var1_1, (String)READ, (boolean)false, (int)2, null)) {
            throw new IOException("unexpected journal line: " + (String)var1_1);
        }
    }

    private final void processJournal() throws IOException {
        _UtilCommonKt.deleteIfExists(this.fileSystem, this.journalFileTmp);
        Iterator<Entry> i = this.lruEntries.values().iterator();
        while (i.hasNext()) {
            int t;
            int n;
            Entry entry;
            Intrinsics.checkNotNullExpressionValue((Object)i.next(), (String)"next(...)");
            if (entry.getCurrentEditor$okhttp() == null) {
                n = this.valueCount;
                for (t = 0; t < n; ++t) {
                    this.size += entry.getLengths$okhttp()[t];
                }
                continue;
            }
            entry.setCurrentEditor$okhttp(null);
            n = this.valueCount;
            for (t = 0; t < n; ++t) {
                _UtilCommonKt.deleteIfExists(this.fileSystem, entry.getCleanFiles$okhttp().get(t));
                _UtilCommonKt.deleteIfExists(this.fileSystem, entry.getDirtyFiles$okhttp().get(t));
            }
            i.remove();
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final synchronized void rebuildJournal$okhttp() throws IOException {
        void var2_2;
        block18: {
            Object $this$rebuildJournal_u24lambda_u2432222;
            void $this$iv;
            BufferedSink bufferedSink = this.journalWriter;
            if (bufferedSink != null) {
                bufferedSink.close();
            }
            FileSystem fileSystem2 = this.fileSystem;
            Path file$iv = this.journalFileTmp;
            Closeable $this$use$iv$iv = (Closeable)Okio.buffer((Sink)$this$iv.sink(file$iv, false));
            Throwable thrown$iv$iv = null;
            try {
                BufferedSink bufferedSink2;
                $this$rebuildJournal_u24lambda_u2432222 = bufferedSink2 = (BufferedSink)$this$use$iv$iv;
                bufferedSink2.writeUtf8(MAGIC).writeByte(10);
                $this$rebuildJournal_u24lambda_u2432222.writeUtf8(VERSION_1).writeByte(10);
                $this$rebuildJournal_u24lambda_u2432222.writeDecimalLong((long)this.appVersion).writeByte(10);
                $this$rebuildJournal_u24lambda_u2432222.writeDecimalLong((long)this.valueCount).writeByte(10);
                $this$rebuildJournal_u24lambda_u2432222.writeByte(10);
                for (Entry entry : this.lruEntries.values()) {
                    if (entry.getCurrentEditor$okhttp() != null) {
                        $this$rebuildJournal_u24lambda_u2432222.writeUtf8(DIRTY).writeByte(32);
                        $this$rebuildJournal_u24lambda_u2432222.writeUtf8(entry.getKey$okhttp());
                        $this$rebuildJournal_u24lambda_u2432222.writeByte(10);
                        continue;
                    }
                    $this$rebuildJournal_u24lambda_u2432222.writeUtf8(CLEAN).writeByte(32);
                    $this$rebuildJournal_u24lambda_u2432222.writeUtf8(entry.getKey$okhttp());
                    entry.writeLengths$okhttp((BufferedSink)$this$rebuildJournal_u24lambda_u2432222);
                    $this$rebuildJournal_u24lambda_u2432222.writeByte(10);
                }
            }
            catch (Throwable throwable) {
                Throwable $this$rebuildJournal_u24lambda_u2432222 = throwable;
                thrown$iv$iv = throwable;
                try {
                    Closeable closeable = $this$use$iv$iv;
                    if (closeable != null) {
                        closeable.close();
                    }
                    break block18;
                }
                catch (Throwable t$iv$iv) {
                    void var3_5;
                    ExceptionsKt.addSuppressed((Throwable)thrown$iv$iv, (Throwable)var3_5);
                }
                break block18;
            }
            catch (Throwable throwable) {
                try {
                    FileSystem fileSystem3 = fileSystem2;
                    if (fileSystem3 == null) throw throwable;
                    fileSystem3.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {}
                throw throwable;
            }
            try {
                Closeable closeable = $this$use$iv$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable throwable) {
                $this$rebuildJournal_u24lambda_u2432222 = throwable;
                thrown$iv$iv = throwable;
            }
        }
        void v7 = var2_2;
        if (v7 != null) {
            throw v7;
        }
        if (this.fileSystem.exists(this.journalFile)) {
            this.fileSystem.atomicMove(this.journalFile, this.journalFileBackup);
            this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
            _UtilCommonKt.deleteIfExists(this.fileSystem, this.journalFileBackup);
        } else {
            this.fileSystem.atomicMove(this.journalFileTmp, this.journalFile);
        }
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            _UtilCommonKt.closeQuietly((Closeable)bufferedSink);
        }
        this.journalWriter = this.newJournalWriter();
        this.hasJournalErrors = false;
        this.mostRecentRebuildFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized Snapshot get(String key) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return null;
        }
        Entry entry2 = entry;
        Snapshot snapshot = entry.snapshot$okhttp();
        if (snapshot == null) {
            return null;
        }
        Snapshot snapshot2 = snapshot;
        int n = this.redundantOpCount;
        this.redundantOpCount = n + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.writeUtf8(READ).writeByte(32).writeUtf8((String)var1_1).writeByte(10);
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
        return entry2;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final synchronized Editor edit(String key, long expectedSequenceNumber) throws IOException {
        void var1_1;
        void var2_3;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (expectedSequenceNumber != ANY_SEQUENCE_NUMBER && (entry == null || entry.getSequenceNumber$okhttp() != expectedSequenceNumber)) {
            return null;
        }
        Entry entry2 = entry;
        if ((entry2 != null ? entry2.getCurrentEditor$okhttp() : null) != null) {
            return null;
        }
        if (entry != null && entry.getLockingSourceCount$okhttp() != 0) {
            return null;
        }
        if (this.mostRecentTrimFailed || this.mostRecentRebuildFailed) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
            return null;
        }
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink journalWriter = bufferedSink;
        bufferedSink.writeUtf8(DIRTY).writeByte(32).writeUtf8(key).writeByte(10);
        var2_3.flush();
        if (this.hasJournalErrors) {
            return null;
        }
        if (entry == null) {
            entry = new Entry(key);
            ((Map)this.lruEntries).put(key, entry);
        }
        Editor editor = new Editor(this, entry);
        entry.setCurrentEditor$okhttp(editor);
        return var1_1;
    }

    public static /* synthetic */ Editor edit$default(DiskLruCache diskLruCache, String string, long l, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            l = ANY_SEQUENCE_NUMBER;
        }
        return diskLruCache.edit(string, l);
    }

    public final synchronized long size() throws IOException {
        this.initialize();
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void completeEdit$okhttp(Editor editor, boolean success) throws IOException {
        int i;
        int n;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Entry entry = editor.getEntry$okhttp();
        if (!Intrinsics.areEqual((Object)entry.getCurrentEditor$okhttp(), (Object)editor)) {
            String string = "Check failed.";
            throw new IllegalStateException(string.toString());
        }
        if (success && !entry.getReadable$okhttp()) {
            n = this.valueCount;
            for (i = 0; i < n; ++i) {
                boolean[] blArray = editor.getWritten$okhttp();
                Intrinsics.checkNotNull((Object)blArray);
                if (!blArray[i]) {
                    editor.abort();
                    throw new IllegalStateException("Newly created entry didn't create value for index " + i);
                }
                if (this.fileSystem.exists(entry.getDirtyFiles$okhttp().get(i))) continue;
                editor.abort();
                return;
            }
        }
        n = this.valueCount;
        for (i = 0; i < n; ++i) {
            void var1_1;
            Path dirty = entry.getDirtyFiles$okhttp().get(i);
            if (success && !entry.getZombie$okhttp()) {
                long newLength;
                if (!this.fileSystem.exists(dirty)) continue;
                Path clean = entry.getCleanFiles$okhttp().get(i);
                this.fileSystem.atomicMove(dirty, clean);
                long oldLength = entry.getLengths$okhttp()[i];
                Long l = this.fileSystem.metadata(clean).getSize();
                entry.getLengths$okhttp()[i] = newLength = l != null ? l : 0L;
                this.size = this.size - oldLength + newLength;
                continue;
            }
            _UtilCommonKt.deleteIfExists(this.fileSystem, (Path)var1_1);
        }
        entry.setCurrentEditor$okhttp(null);
        if (entry.getZombie$okhttp()) {
            this.removeEntry$okhttp(entry);
            return;
        }
        int n2 = this.redundantOpCount;
        this.redundantOpCount = n2 + 1;
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        BufferedSink bufferedSink2 = bufferedSink;
        BufferedSink $this$completeEdit_u24lambda_u244 = bufferedSink;
        if (entry.getReadable$okhttp() || success) {
            void var2_2;
            entry.setReadable$okhttp(true);
            $this$completeEdit_u24lambda_u244.writeUtf8(CLEAN).writeByte(32);
            $this$completeEdit_u24lambda_u244.writeUtf8(entry.getKey$okhttp());
            entry.writeLengths$okhttp($this$completeEdit_u24lambda_u244);
            $this$completeEdit_u24lambda_u244.writeByte(10);
            if (var2_2 != false) {
                long l = this.nextSequenceNumber;
                this.nextSequenceNumber = l + 1L;
                entry.setSequenceNumber$okhttp(l);
            }
        } else {
            void var3_3;
            this.lruEntries.remove(entry.getKey$okhttp());
            $this$completeEdit_u24lambda_u244.writeUtf8(REMOVE).writeByte(32);
            $this$completeEdit_u24lambda_u244.writeUtf8(var3_3.getKey$okhttp());
            $this$completeEdit_u24lambda_u244.writeByte(10);
        }
        $this$completeEdit_u24lambda_u244.flush();
        if (this.size > this.maxSize || this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
    }

    private final boolean journalRebuildRequired() {
        return this.redundantOpCount >= 2000 && this.redundantOpCount >= this.lruEntries.size();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized boolean remove(String key) throws IOException {
        void var1_2;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.initialize();
        this.checkNotClosed();
        this.validateKey(key);
        Entry entry = this.lruEntries.get(key);
        if (entry == null) {
            return false;
        }
        Entry entry2 = entry;
        boolean removed = this.removeEntry$okhttp(entry2);
        if (removed && this.size <= this.maxSize) {
            this.mostRecentTrimFailed = false;
        }
        return (boolean)var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean removeEntry$okhttp(Entry entry) throws IOException {
        void var1_1;
        int i;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (!this.civilizedFileSystem) {
            if (entry.getLockingSourceCount$okhttp() > 0) {
                BufferedSink bufferedSink = this.journalWriter;
                if (bufferedSink != null) {
                    BufferedSink it = bufferedSink;
                    bufferedSink.writeUtf8(DIRTY);
                    it.writeByte(32);
                    it.writeUtf8(entry.getKey$okhttp());
                    it.writeByte(10);
                    it.flush();
                }
            }
            if (entry.getLockingSourceCount$okhttp() > 0 || entry.getCurrentEditor$okhttp() != null) {
                entry.setZombie$okhttp(true);
                return true;
            }
        }
        Editor editor = entry.getCurrentEditor$okhttp();
        if (editor != null) {
            editor.detach$okhttp();
        }
        int n = this.valueCount;
        for (i = 0; i < n; ++i) {
            _UtilCommonKt.deleteIfExists(this.fileSystem, entry.getCleanFiles$okhttp().get(i));
            this.size -= entry.getLengths$okhttp()[i];
            entry.getLengths$okhttp()[i] = 0L;
        }
        i = this.redundantOpCount;
        this.redundantOpCount = i + 1;
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            void var2_4;
            BufferedSink it = bufferedSink;
            bufferedSink.writeUtf8(REMOVE);
            it.writeByte(32);
            it.writeUtf8(entry.getKey$okhttp());
            var2_4.writeByte(10);
        }
        this.lruEntries.remove(var1_1.getKey$okhttp());
        if (this.journalRebuildRequired()) {
            TaskQueue.schedule$default(this.cleanupQueue, this.cleanupTask, 0L, 2, null);
        }
        return true;
    }

    private final synchronized void checkNotClosed() {
        if (!(!this.closed)) {
            String string = "cache is closed";
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public final synchronized void flush() throws IOException {
        if (!this.initialized) {
            return;
        }
        this.checkNotClosed();
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        Intrinsics.checkNotNull((Object)bufferedSink);
        bufferedSink.flush();
    }

    public final synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public final synchronized void close() throws IOException {
        if (!this.initialized || this.closed) {
            this.closed = true;
            return;
        }
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<Entry> collection2 = collection;
        Collection<Entry> collection3 = collection;
        for (Entry entry : collection.toArray(new Entry[0])) {
            if (entry.getCurrentEditor$okhttp() == null) continue;
            Editor editor = entry.getCurrentEditor$okhttp();
            if (editor == null) continue;
            editor.detach$okhttp();
        }
        this.trimToSize();
        BufferedSink bufferedSink = this.journalWriter;
        if (bufferedSink != null) {
            _UtilCommonKt.closeQuietly((Closeable)bufferedSink);
        }
        this.journalWriter = null;
        this.closed = true;
    }

    public final void trimToSize() throws IOException {
        while (this.size > this.maxSize) {
            if (this.removeOldestEntry()) continue;
            return;
        }
        this.mostRecentTrimFailed = false;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean removeOldestEntry() {
        for (Entry toEvict : this.lruEntries.values()) {
            void var2_2;
            if (toEvict.getZombie$okhttp()) continue;
            Intrinsics.checkNotNull((Object)toEvict);
            this.removeEntry$okhttp((Entry)var2_2);
            return true;
        }
        return false;
    }

    public final void delete() throws IOException {
        this.close();
        _UtilCommonKt.deleteContents(this.fileSystem, this.directory);
    }

    public final synchronized void evictAll() throws IOException {
        this.initialize();
        Collection<Entry> collection = this.lruEntries.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        Collection<Entry> collection2 = collection;
        Collection<Entry> collection3 = collection;
        for (Entry entry : collection.toArray(new Entry[0])) {
            Intrinsics.checkNotNull((Object)entry);
            this.removeEntry$okhttp(entry);
        }
        this.mostRecentTrimFailed = false;
    }

    private final void validateKey(String key) {
        if (!LEGAL_KEY_PATTERN.matches((CharSequence)key)) {
            String string;
            string = "keys must match regex [a-z0-9_-]{1,120}: \"" + string + '\"';
            throw new IllegalArgumentException(string.toString());
        }
    }

    public final synchronized Iterator<Snapshot> snapshots() throws IOException {
        this.initialize();
        return new Iterator<Snapshot>(this){
            private final Iterator<Entry> delegate;
            private Snapshot nextSnapshot;
            private Snapshot removeSnapshot;
            final /* synthetic */ DiskLruCache this$0;
            {
                void var1_1;
                this.this$0 = $receiver;
                Iterator<Entry> iterator = new ArrayList<Entry>(var1_1.getLruEntries$okhttp().values()).iterator();
                Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
                this.delegate = iterator;
            }

            public final boolean hasNext() {
                if (this.nextSnapshot != null) {
                    return true;
                }
                DiskLruCache diskLruCache = this.this$0;
                DiskLruCache diskLruCache2 = this.this$0;
                synchronized (diskLruCache) {
                    block7: {
                        if (!diskLruCache2.getClosed$okhttp()) break block7;
                        return false;
                    }
                    while (this.delegate.hasNext()) {
                        Object object = this.delegate.next();
                        if (object == null || (object = ((Entry)object).snapshot$okhttp()) == null) continue;
                        this.nextSnapshot = object;
                        return true;
                    }
                }
                return false;
            }

            public final Snapshot next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.removeSnapshot = this.nextSnapshot;
                this.nextSnapshot = null;
                Snapshot snapshot = this.removeSnapshot;
                Intrinsics.checkNotNull((Object)snapshot);
                return snapshot;
            }

            /*
             * WARNING - void declaration
             */
            public final void remove() {
                Object removeSnapshot = this.removeSnapshot;
                if (removeSnapshot == null) {
                    removeSnapshot = "remove() before next()";
                    throw new IllegalStateException(removeSnapshot.toString());
                }
                try {
                    void var1_1;
                    this.this$0.remove(var1_1.key());
                    return;
                }
                catch (IOException iOException) {
                    return;
                }
                finally {
                    this.removeSnapshot = null;
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final Editor edit(String key) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return DiskLruCache.edit$default(this, (String)var1_1, 0L, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setHasJournalErrors$p(DiskLruCache $this, boolean bl) {
        void var1_1;
        $this.hasJournalErrors = var1_1;
    }

    public static final /* synthetic */ boolean access$getInitialized$p(DiskLruCache $this) {
        return $this.initialized;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setMostRecentTrimFailed$p(DiskLruCache $this, boolean bl) {
        void var1_1;
        $this.mostRecentTrimFailed = var1_1;
    }

    public static final /* synthetic */ boolean access$journalRebuildRequired(DiskLruCache $this) {
        return $this.journalRebuildRequired();
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setRedundantOpCount$p(DiskLruCache $this, int n) {
        void var1_1;
        $this.redundantOpCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setMostRecentRebuildFailed$p(DiskLruCache $this, boolean bl) {
        void var1_1;
        $this.mostRecentRebuildFailed = var1_1;
    }

    public static final /* synthetic */ BufferedSink access$getJournalWriter$p(DiskLruCache $this) {
        return $this.journalWriter;
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$setJournalWriter$p(DiskLruCache $this, BufferedSink bufferedSink) {
        void var1_1;
        $this.journalWriter = var1_1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00068\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/internal/cache/DiskLruCache$Companion;", "", "()V", "ANY_SEQUENCE_NUMBER", "", "CLEAN", "", "DIRTY", "JOURNAL_FILE", "JOURNAL_FILE_BACKUP", "JOURNAL_FILE_TEMP", "LEGAL_KEY_PATTERN", "Lkotlin/text/Regex;", "MAGIC", "READ", "REMOVE", "VERSION_1", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0013\b\u0000\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u0010\u001a\u00020\u000fJ\r\u0010\u0011\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lokhttp3/internal/cache/DiskLruCache$Editor;", "", "entry", "Lokhttp3/internal/cache/DiskLruCache$Entry;", "Lokhttp3/internal/cache/DiskLruCache;", "(Lokhttp3/internal/cache/DiskLruCache;Lokhttp3/internal/cache/DiskLruCache$Entry;)V", "done", "", "getEntry$okhttp", "()Lokhttp3/internal/cache/DiskLruCache$Entry;", "written", "", "getWritten$okhttp", "()[Z", "abort", "", "commit", "detach", "detach$okhttp", "newSink", "Lokio/Sink;", "index", "", "newSource", "Lokio/Source;", "okhttp"})
    public final class Editor {
        private final Entry entry;
        private final boolean[] written;
        private boolean done;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Editor(DiskLruCache this$0, Entry entry) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
            this.this$0 = var1_1;
            this.entry = var2_2;
            this.written = this.entry.getReadable$okhttp() ? null : new boolean[this.this$0.getValueCount$okhttp()];
        }

        public final Entry getEntry$okhttp() {
            return this.entry;
        }

        public final boolean[] getWritten$okhttp() {
            return this.written;
        }

        public final void detach$okhttp() {
            if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) {
                if (this.this$0.civilizedFileSystem) {
                    this.this$0.completeEdit$okhttp(this, false);
                    return;
                }
                this.entry.setZombie$okhttp(true);
            }
        }

        /*
         * WARNING - void declaration
         */
        public final Source newSource(int index2) {
            DiskLruCache diskLruCache = this.this$0;
            DiskLruCache diskLruCache2 = this.this$0;
            synchronized (diskLruCache) {
                Source source;
                block7: {
                    if (!(!this.done)) {
                        String index2 = "Check failed.";
                        throw new IllegalStateException(index2.toString());
                    }
                    if (this.entry.getReadable$okhttp() && Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this) && !this.entry.getZombie$okhttp()) break block7;
                    return null;
                }
                try {
                    void var1_1;
                    source = diskLruCache2.getFileSystem$okhttp().source(this.entry.getCleanFiles$okhttp().get((int)var1_1));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    source = null;
                }
                return source;
            }
        }

        public final Sink newSink(int index22) {
            DiskLruCache diskLruCache = this.this$0;
            DiskLruCache diskLruCache2 = this.this$0;
            synchronized (diskLruCache) {
                Sink sink;
                Sink sink2;
                int index22;
                block9: {
                    if (!(!this.done)) {
                        String index22 = "Check failed.";
                        throw new IllegalStateException(index22.toString());
                    }
                    if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) break block9;
                    Sink index22 = Okio.blackhole();
                    return index22;
                }
                if (!this.entry.getReadable$okhttp()) {
                    Intrinsics.checkNotNull((Object)this.written);
                    this.written[index22] = true;
                }
                Path dirtyFile = this.entry.getDirtyFiles$okhttp().get(index22);
                try {
                    sink2 = diskLruCache2.getFileSystem$okhttp().sink(dirtyFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    sink2 = Okio.blackhole();
                    return sink2;
                }
                sink = (Sink)new FaultHidingSink(sink, (Function1<? super IOException, Unit>)((Function1)new Function1<IOException, Unit>(diskLruCache2, this){
                    final /* synthetic */ DiskLruCache this$0;
                    final /* synthetic */ Editor this$1;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        this.this$1 = var2_2;
                        super(1);
                    }

                    public final void invoke(IOException it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        DiskLruCache diskLruCache = this.this$0;
                        Editor editor = this.this$1;
                        synchronized (diskLruCache) {
                            editor.detach$okhttp();
                            return;
                        }
                    }
                }));
                return sink;
            }
        }

        public final void commit() throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            Object object = this.this$0;
            synchronized (diskLruCache) {
                if (!(!this.done)) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) {
                    ((DiskLruCache)object).completeEdit$okhttp(this, true);
                }
                this.done = true;
                return;
            }
        }

        public final void abort() throws IOException {
            DiskLruCache diskLruCache = this.this$0;
            Object object = this.this$0;
            synchronized (diskLruCache) {
                if (!(!this.done)) {
                    object = "Check failed.";
                    throw new IllegalStateException(object.toString());
                }
                if (Intrinsics.areEqual((Object)this.entry.getCurrentEditor$okhttp(), (Object)this)) {
                    ((DiskLruCache)object).completeEdit$okhttp(this, false);
                }
                this.done = true;
                return;
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0016\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\u0004\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301H\u0002J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u001aH\u0002J\u001b\u00105\u001a\u0002062\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000301H\u0000\u00a2\u0006\u0002\b7J\u0013\u00108\u001a\b\u0018\u000109R\u00020\fH\u0000\u00a2\u0006\u0002\b:J\u0015\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020=H\u0000\u00a2\u0006\u0002\b>R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0018\u00010\u000bR\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u0016X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u001a\u0010\u0019\u001a\u00020\u001aX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020 X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010\"\"\u0004\b-\u0010$\u00a8\u0006?"}, d2={"Lokhttp3/internal/cache/DiskLruCache$Entry;", "", "key", "", "(Lokhttp3/internal/cache/DiskLruCache;Ljava/lang/String;)V", "cleanFiles", "", "Lokio/Path;", "getCleanFiles$okhttp", "()Ljava/util/List;", "currentEditor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Lokhttp3/internal/cache/DiskLruCache;", "getCurrentEditor$okhttp", "()Lokhttp3/internal/cache/DiskLruCache$Editor;", "setCurrentEditor$okhttp", "(Lokhttp3/internal/cache/DiskLruCache$Editor;)V", "dirtyFiles", "getDirtyFiles$okhttp", "getKey$okhttp", "()Ljava/lang/String;", "lengths", "", "getLengths$okhttp", "()[J", "lockingSourceCount", "", "getLockingSourceCount$okhttp", "()I", "setLockingSourceCount$okhttp", "(I)V", "readable", "", "getReadable$okhttp", "()Z", "setReadable$okhttp", "(Z)V", "sequenceNumber", "", "getSequenceNumber$okhttp", "()J", "setSequenceNumber$okhttp", "(J)V", "zombie", "getZombie$okhttp", "setZombie$okhttp", "invalidLengths", "", "strings", "", "newSource", "Lokio/Source;", "index", "setLengths", "", "setLengths$okhttp", "snapshot", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "snapshot$okhttp", "writeLengths", "writer", "Lokio/BufferedSink;", "writeLengths$okhttp", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nDiskLruCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache$Entry\n+ 2 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n1#1,1114:1\n353#2,4:1115\n*S KotlinDebug\n*F\n+ 1 DiskLruCache.kt\nokhttp3/internal/cache/DiskLruCache$Entry\n*L\n1039#1:1115,4\n*E\n"})
    public final class Entry {
        private final String key;
        private final long[] lengths;
        private final List<Path> cleanFiles;
        private final List<Path> dirtyFiles;
        private boolean readable;
        private boolean zombie;
        private Editor currentEditor;
        private int lockingSourceCount;
        private long sequenceNumber;

        public Entry(String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            this.key = key;
            this.lengths = new long[DiskLruCache.this.getValueCount$okhttp()];
            this.cleanFiles = new ArrayList();
            this.dirtyFiles = new ArrayList();
            StringBuilder fileBuilder = new StringBuilder(this.key).append('.');
            int truncateTo = fileBuilder.length();
            int n = DiskLruCache.this.getValueCount$okhttp();
            for (int i = 0; i < n; ++i) {
                fileBuilder.append(i);
                Collection collection = this.cleanFiles;
                Path path = DiskLruCache.this.getDirectory();
                String string = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
                collection.add(path.resolve(string));
                fileBuilder.append(".tmp");
                collection = this.dirtyFiles;
                Path path2 = DiskLruCache.this.getDirectory();
                String string2 = fileBuilder.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                collection.add(path2.resolve(string2));
                fileBuilder.setLength(truncateTo);
            }
        }

        public final String getKey$okhttp() {
            return this.key;
        }

        public final long[] getLengths$okhttp() {
            return this.lengths;
        }

        public final List<Path> getCleanFiles$okhttp() {
            return this.cleanFiles;
        }

        public final List<Path> getDirtyFiles$okhttp() {
            return this.dirtyFiles;
        }

        public final boolean getReadable$okhttp() {
            return this.readable;
        }

        /*
         * WARNING - void declaration
         */
        public final void setReadable$okhttp(boolean bl) {
            void var1_1;
            this.readable = var1_1;
        }

        public final boolean getZombie$okhttp() {
            return this.zombie;
        }

        /*
         * WARNING - void declaration
         */
        public final void setZombie$okhttp(boolean bl) {
            void var1_1;
            this.zombie = var1_1;
        }

        public final Editor getCurrentEditor$okhttp() {
            return this.currentEditor;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCurrentEditor$okhttp(Editor editor) {
            void var1_1;
            this.currentEditor = var1_1;
        }

        public final int getLockingSourceCount$okhttp() {
            return this.lockingSourceCount;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLockingSourceCount$okhttp(int n) {
            void var1_1;
            this.lockingSourceCount = var1_1;
        }

        public final long getSequenceNumber$okhttp() {
            return this.sequenceNumber;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSequenceNumber$okhttp(long l) {
            void var1_1;
            this.sequenceNumber = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setLengths$okhttp(List<String> strings) throws IOException {
            Intrinsics.checkNotNullParameter(strings, (String)"strings");
            if (strings.size() != DiskLruCache.this.getValueCount$okhttp()) {
                this.invalidLengths(strings);
                throw new KotlinNothingValueException();
            }
            try {
                int n = strings.size();
                for (int i = 0; i < n; ++i) {
                    this.lengths[i] = Long.parseLong(strings.get(i));
                }
            }
            catch (NumberFormatException numberFormatException) {
                void var1_1;
                this.invalidLengths((List<String>)var1_1);
                throw new KotlinNothingValueException();
            }
        }

        public final void writeLengths$okhttp(BufferedSink writer) throws IOException {
            Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
            for (long length : this.lengths) {
                writer.writeByte(32).writeDecimalLong(length);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Void invalidLengths(List<String> strings) throws IOException {
            void var1_1;
            throw new IOException("unexpected journal line: " + var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final Snapshot snapshot$okhttp() {
            DiskLruCache $this$assertThreadHoldsLock$iv = DiskLruCache.this;
            if (_UtilJvmKt.assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock$iv)) {
                throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + $this$assertThreadHoldsLock$iv));
            }
            if (!this.readable) {
                return null;
            }
            if (!DiskLruCache.this.civilizedFileSystem && (this.currentEditor != null || this.zombie)) {
                return null;
            }
            List sources = new ArrayList();
            long[] lengths = (long[])this.lengths.clone();
            try {
                void var2_2;
                int n = DiskLruCache.this.getValueCount$okhttp();
                for (int i = 0; i < n; ++i) {
                    ((Collection)sources).add(this.newSource(i));
                }
                return new Snapshot(DiskLruCache.this, this.key, this.sequenceNumber, sources, (long[])var2_2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                for (Source source : source) {
                    _UtilCommonKt.closeQuietly((Closeable)source);
                }
                try {
                    DiskLruCache.this.removeEntry$okhttp(this);
                }
                catch (IOException iOException) {}
                return null;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final Source newSource(int index) {
            void var1_2;
            Source fileSource = DiskLruCache.this.getFileSystem$okhttp().source(this.cleanFiles.get(index));
            if (DiskLruCache.this.civilizedFileSystem) {
                return fileSource;
            }
            int n = this.lockingSourceCount;
            this.lockingSourceCount = n + 1;
            return (Source)new ForwardingSource((Source)var1_2, DiskLruCache.this, this){
                private boolean closed;
                final /* synthetic */ DiskLruCache this$0;
                final /* synthetic */ Entry this$1;
                {
                    void var1_1;
                    void var3_3;
                    void var2_2;
                    this.this$0 = var2_2;
                    this.this$1 = var3_3;
                    super((Source)var1_1);
                }

                public final void close() {
                    super.close();
                    if (!this.closed) {
                        this.closed = true;
                        DiskLruCache diskLruCache = this.this$0;
                        Entry entry = this.this$1;
                        DiskLruCache diskLruCache2 = this.this$0;
                        synchronized (diskLruCache) {
                            int n = entry.getLockingSourceCount$okhttp();
                            entry.setLockingSourceCount$okhttp(n + -1);
                            if (entry.getLockingSourceCount$okhttp() == 0 && entry.getZombie$okhttp()) {
                                diskLruCache2.removeEntry$okhttp(entry);
                            }
                            return;
                        }
                    }
                }
            };
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0016\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B-\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\rH\u0016J\f\u0010\u000e\u001a\b\u0018\u00010\u000fR\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0002\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "Ljava/io/Closeable;", "key", "", "sequenceNumber", "", "sources", "", "Lokio/Source;", "lengths", "", "(Lokhttp3/internal/cache/DiskLruCache;Ljava/lang/String;JLjava/util/List;[J)V", "close", "", "edit", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Lokhttp3/internal/cache/DiskLruCache;", "getLength", "index", "", "getSource", "okhttp"})
    public final class Snapshot
    implements Closeable {
        private final String key;
        private final long sequenceNumber;
        private final List<Source> sources;
        private final long[] lengths;
        final /* synthetic */ DiskLruCache this$0;

        /*
         * WARNING - void declaration
         */
        public Snapshot(DiskLruCache this$0, String key, long sequenceNumber, List<? extends Source> sources, long[] lengths) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter(sources, (String)"sources");
            Intrinsics.checkNotNullParameter((Object)lengths, (String)"lengths");
            this.this$0 = var1_1;
            this.key = var2_2;
            this.sequenceNumber = var3_3;
            this.sources = sources;
            this.lengths = lengths;
        }

        public final String key() {
            return this.key;
        }

        public final Editor edit() throws IOException {
            return this.this$0.edit(this.key, this.sequenceNumber);
        }

        /*
         * WARNING - void declaration
         */
        public final Source getSource(int index) {
            void var1_1;
            return this.sources.get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final long getLength(int index) {
            void var1_1;
            return this.lengths[var1_1];
        }

        @Override
        public final void close() {
            for (Source source : this.sources) {
                _UtilCommonKt.closeQuietly((Closeable)source);
            }
        }
    }
}

