/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal.cache;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.internal._ResponseCommonKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.cache.CacheInterceptorKt;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.connection.RealCall;
import okhttp3.internal.http.HttpHeaders;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.RealResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;
import okio.Source;
import okio.Timeout;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\u0010\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0016\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lokhttp3/internal/cache/CacheInterceptor;", "Lokhttp3/Interceptor;", "cache", "Lokhttp3/Cache;", "(Lokhttp3/Cache;)V", "getCache$okhttp", "()Lokhttp3/Cache;", "cacheWritingResponse", "Lokhttp3/Response;", "cacheRequest", "Lokhttp3/internal/cache/CacheRequest;", "response", "intercept", "chain", "Lokhttp3/Interceptor$Chain;", "Companion", "okhttp"})
public final class CacheInterceptor
implements Interceptor {
    public static final Companion Companion = new Companion(null);
    private final Cache cache;

    /*
     * WARNING - void declaration
     */
    public CacheInterceptor(Cache cache) {
        void var1_1;
        this.cache = var1_1;
    }

    public final Cache getCache$okhttp() {
        return this.cache;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Response intercept(Interceptor.Chain chain) throws IOException {
        Response networkResponse;
        Object listener;
        Response cacheResponse;
        Request networkRequest;
        Call call;
        block15: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
            call = chain.call();
            Cache cache = this.cache;
            Response cacheCandidate = cache != null ? cache.get$okhttp(CacheInterceptorKt.access$requestForCache(chain.request())) : null;
            long now = System.currentTimeMillis();
            CacheStrategy strategy = new CacheStrategy.Factory(now, chain.request(), cacheCandidate).compute();
            networkRequest = strategy.getNetworkRequest();
            cacheResponse = strategy.getCacheResponse();
            Cache cache2 = this.cache;
            if (cache2 != null) {
                cache2.trackResponse$okhttp(strategy);
            }
            if ((object = call instanceof RealCall ? (RealCall)call : null) == null || (object = ((RealCall)object).getEventListener$okhttp()) == null) {
                object = listener = EventListener.NONE;
            }
            if (cacheCandidate != null && cacheResponse == null) {
                _UtilCommonKt.closeQuietly(cacheCandidate.body());
            }
            if (networkRequest == null && cacheResponse == null) {
                chain = new Response.Builder().request(chain.request()).protocol(Protocol.HTTP_1_1).code(504).message("Unsatisfiable Request (only-if-cached)").sentRequestAtMillis(-1L).receivedResponseAtMillis(System.currentTimeMillis()).build();
                Response it = chain;
                ((EventListener)listener).satisfactionFailure(call, it);
                return chain;
            }
            if (networkRequest == null) {
                Response response = cacheResponse;
                Intrinsics.checkNotNull((Object)response);
                chain = response.newBuilder().cacheResponse(_ResponseCommonKt.stripBody(cacheResponse)).build();
                Response it = chain;
                ((EventListener)listener).cacheHit(call, it);
                return chain;
            }
            if (cacheResponse != null) {
                ((EventListener)listener).cacheConditionalHit(call, cacheResponse);
            } else if (this.cache != null) {
                ((EventListener)listener).cacheMiss(call);
            }
            try {
                networkResponse = chain.proceed(networkRequest);
                if (networkResponse != null || cacheCandidate == null) break block15;
            }
            catch (Throwable it) {
                if (cacheCandidate == null) throw it;
                _UtilCommonKt.closeQuietly(cacheCandidate.body());
                throw it;
            }
            _UtilCommonKt.closeQuietly(cacheCandidate.body());
        }
        if (cacheResponse != null) {
            Response response = networkResponse;
            boolean bl = response != null ? response.code() == 304 : false;
            if (bl) {
                Response response2 = cacheResponse.newBuilder().headers(okhttp3.internal.cache.CacheInterceptor$Companion.access$combine(Companion, cacheResponse.headers(), networkResponse.headers())).sentRequestAtMillis(networkResponse.sentRequestAtMillis()).receivedResponseAtMillis(networkResponse.receivedResponseAtMillis()).cacheResponse(_ResponseCommonKt.stripBody(cacheResponse)).networkResponse(_ResponseCommonKt.stripBody(networkResponse)).build();
                networkResponse.body().close();
                Cache cache = this.cache;
                Intrinsics.checkNotNull((Object)cache);
                cache.trackConditionalCacheHit$okhttp();
                this.cache.update$okhttp(cacheResponse, response2);
                Response it = networkResponse = response2;
                ((EventListener)listener).cacheHit(call, it);
                return networkResponse;
            }
            _UtilCommonKt.closeQuietly(cacheResponse.body());
        }
        Response response = networkResponse;
        Intrinsics.checkNotNull((Object)response);
        Response response3 = cacheResponse;
        Response response4 = response.newBuilder().cacheResponse(response3 != null ? _ResponseCommonKt.stripBody(response3) : null).networkResponse(_ResponseCommonKt.stripBody(networkResponse)).build();
        if (this.cache == null) return response4;
        Request cacheNetworkRequest = CacheInterceptorKt.access$requestForCache(networkRequest);
        if (HttpHeaders.promisesBody(response4) && CacheStrategy.Companion.isCacheable(response4, cacheNetworkRequest)) {
            void var2_2;
            void var3_3;
            Response response5;
            CacheRequest cacheRequest = this.cache.put$okhttp(response4.newBuilder().request((Request)((Object)response5)).build());
            response5 = this.cacheWritingResponse((CacheRequest)var3_3, response4);
            if (cacheResponse == null) return response5;
            ((EventListener)listener).cacheMiss((Call)var2_2);
            return response5;
        }
        if (!HttpMethod.invalidatesCache(networkRequest.method())) return response4;
        try {
            this.cache.remove$okhttp(networkRequest);
            return response4;
        }
        catch (IOException iOException) {}
        return response4;
    }

    /*
     * WARNING - void declaration
     */
    private final Response cacheWritingResponse(CacheRequest cacheRequest, Response response) throws IOException {
        void var1_1;
        void var3_3;
        void var2_2;
        if (cacheRequest == null) {
            return response;
        }
        Sink cacheBodyUnbuffered = cacheRequest.body();
        BufferedSource source = response.body().source();
        BufferedSink cacheBody = Okio.buffer((Sink)cacheBodyUnbuffered);
        Source cacheWritingSource2 = new Source(source, cacheRequest, cacheBody){
            private boolean cacheRequestClosed;
            final /* synthetic */ BufferedSource $source;
            final /* synthetic */ CacheRequest $cacheRequest;
            final /* synthetic */ BufferedSink $cacheBody;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$source = var1_1;
                this.$cacheRequest = var2_2;
                this.$cacheBody = var3_3;
            }

            /*
             * WARNING - void declaration
             */
            public final long read(Buffer sink, long byteCount) throws IOException {
                void var1_1;
                long bytesRead;
                Intrinsics.checkNotNullParameter((Object)sink, (String)"sink");
                try {
                    void var2_3;
                    bytesRead = this.$source.read(sink, (long)var2_3);
                }
                catch (IOException e) {
                    void var1_2;
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheRequest.abort();
                    }
                    throw var1_2;
                }
                if (bytesRead == -1L) {
                    if (!this.cacheRequestClosed) {
                        this.cacheRequestClosed = true;
                        this.$cacheBody.close();
                    }
                    return -1L;
                }
                var1_1.copyTo(this.$cacheBody.getBuffer(), var1_1.size() - bytesRead, bytesRead);
                this.$cacheBody.emitCompleteSegments();
                return bytesRead;
            }

            public final Timeout timeout() {
                return this.$source.timeout();
            }

            public final void close() throws IOException {
                if (!this.cacheRequestClosed && !_UtilJvmKt.discard(this, 100, TimeUnit.MILLISECONDS)) {
                    this.cacheRequestClosed = true;
                    this.$cacheRequest.abort();
                }
                this.$source.close();
            }
        };
        String contentType = Response.header$default(response, "Content-Type", null, 2, null);
        long contentLength = response.body().contentLength();
        return var2_2.newBuilder().body(new RealResponseBody((String)var3_3, contentLength, Okio.buffer((Source)((Source)var1_1)))).build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\f"}, d2={"Lokhttp3/internal/cache/CacheInterceptor$Companion;", "", "()V", "combine", "Lokhttp3/Headers;", "cachedHeaders", "networkHeaders", "isContentSpecificHeader", "", "fieldName", "", "isEndToEnd", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final Headers combine(Headers cachedHeaders, Headers networkHeaders) {
            void var3_3;
            String fieldName;
            int index;
            Headers.Builder result = new Headers.Builder();
            int n = cachedHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = cachedHeaders.name(index);
                String value = cachedHeaders.value(index);
                if (StringsKt.equals((String)"Warning", (String)fieldName, (boolean)true) && StringsKt.startsWith$default((String)value, (String)"1", (boolean)false, (int)2, null) || !this.isContentSpecificHeader(fieldName) && this.isEndToEnd(fieldName) && networkHeaders.get(fieldName) != null) continue;
                result.addLenient$okhttp(fieldName, value);
            }
            n = networkHeaders.size();
            for (index = 0; index < n; ++index) {
                fieldName = networkHeaders.name(index);
                if (this.isContentSpecificHeader(fieldName) || !this.isEndToEnd(fieldName)) continue;
                result.addLenient$okhttp(fieldName, networkHeaders.value(index));
            }
            return var3_3.build();
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isEndToEnd(String fieldName) {
            void var1_1;
            return !StringsKt.equals((String)"Connection", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Keep-Alive", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authenticate", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Proxy-Authorization", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"TE", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Trailers", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Transfer-Encoding", (String)fieldName, (boolean)true) && !StringsKt.equals((String)"Upgrade", (String)var1_1, (boolean)true);
        }

        /*
         * WARNING - void declaration
         */
        private final boolean isContentSpecificHeader(String fieldName) {
            void var1_1;
            return StringsKt.equals((String)"Content-Length", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Encoding", (String)fieldName, (boolean)true) || StringsKt.equals((String)"Content-Type", (String)var1_1, (boolean)true);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ Headers access$combine(Companion $this, Headers cachedHeaders, Headers networkHeaders) {
            void var2_2;
            void var1_1;
            return $this.combine((Headers)var1_1, (Headers)var2_2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

