/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin.time.Duration;
import okhttp3.Call;
import okhttp3.EventListener;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.http2.Header;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Source;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u00bc\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u001a\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0013H\u0000\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0015\u001a)\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0012\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u0018\"\u00020\u0019H\u0000\u00a2\u0006\u0002\u0010\u001a\u001a-\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\u0004\b\u0000\u0010\u001d2\u0012\u0010\u001e\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u001d0\u0018\"\u0002H\u001dH\u0001\u00a2\u0006\u0002\u0010\u001f\u001a3\u0010 \u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010!\u001a\u00020\u00192\f\u0010\"\u001a\b\u0012\u0004\u0012\u0002H\u001d0#2\u0006\u0010$\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\u0010%\u001a\u0018\u0010&\u001a\u00020'2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\tH\u0000\u001a\"\u0010)\u001a\u00020*2\u0006\u0010\u000e\u001a\u00020\u000b2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,H\u0080\b\u00f8\u0001\u0001\u001a\f\u0010-\u001a\u00020.*\u00020/H\u0000\u001a\r\u00100\u001a\u00020**\u000201H\u0080\b\u001a\r\u00102\u001a\u00020**\u000201H\u0080\b\u001a\r\u00103\u001a\u00020**\u00020\u0019H\u0080\b\u001a\r\u00104\u001a\u00020**\u00020\u0019H\u0080\b\u001a\u0014\u00105\u001a\u00020\t*\u0002062\u0006\u00107\u001a\u000206H\u0000\u001a\f\u00108\u001a\u00020**\u000209H\u0000\u001a\f\u00108\u001a\u00020**\u00020:H\u0000\u001a\u001c\u0010;\u001a\u00020\t*\u00020<2\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u0012H\u0000\u001a\f\u0010?\u001a\u00020\u0010*\u00020@H\u0000\u001a\u0014\u0010A\u001a\u00020\t*\u00020:2\u0006\u0010B\u001a\u00020CH\u0000\u001a\r\u0010D\u001a\u00020**\u00020\u0019H\u0080\b\u001a\r\u0010E\u001a\u00020**\u00020\u0019H\u0080\b\u001a\f\u0010F\u001a\u00020\u000b*\u00020:H\u0000\u001a\u0014\u0010G\u001a\u00020H*\u00020C2\u0006\u0010I\u001a\u00020HH\u0000\u001a\u001c\u0010J\u001a\u00020\t*\u00020<2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010>\u001a\u00020\u0012H\u0000\u001a\u0012\u0010K\u001a\b\u0012\u0004\u0012\u00020L0\u001c*\u00020\u0001H\u0000\u001a\u0012\u0010M\u001a\u00020\u0001*\b\u0012\u0004\u0012\u00020L0\u001cH\u0000\u001a\f\u0010N\u001a\u00020\u000b*\u00020\rH\u0000\u001a\f\u0010N\u001a\u00020\u000b*\u00020\u0010H\u0000\u001a\u0016\u0010O\u001a\u00020\u000b*\u0002062\b\b\u0002\u0010P\u001a\u00020\tH\u0000\u001a\u001e\u0010Q\u001a\b\u0012\u0004\u0012\u0002H\u001d0\u001c\"\u0004\b\u0000\u0010\u001d*\b\u0012\u0004\u0012\u0002H\u001d0\u001cH\u0000\u001a\r\u0010R\u001a\u00020**\u00020\u0019H\u0080\b\"\u0010\u0010\u0000\u001a\u00020\u00018\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0002\u001a\u00020\u00038\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0004\u001a\u00020\u00058\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0006\u001a\u00020\u00078\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\b\u001a\u00020\t8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\n\u001a\u00020\u000b8\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000e\n\u0005\b\u00a1\u001e0\u0001\n\u0005\b\u009920\u0001\u00a8\u0006S"}, d2={"EMPTY_HEADERS", "Lokhttp3/Headers;", "EMPTY_REQUEST", "Lokhttp3/RequestBody;", "EMPTY_RESPONSE", "Lokhttp3/ResponseBody;", "UTC", "Ljava/util/TimeZone;", "assertionsEnabled", "", "okHttpName", "", "checkDuration", "", "name", "duration", "", "unit", "Ljava/util/concurrent/TimeUnit;", "Lkotlin/time/Duration;", "checkDuration-HG0u8IE", "(Ljava/lang/String;J)I", "format", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "immutableListOf", "", "T", "elements", "([Ljava/lang/Object;)Ljava/util/List;", "readFieldOrNull", "instance", "fieldType", "Ljava/lang/Class;", "fieldName", "(Ljava/lang/Object;Ljava/lang/Class;Ljava/lang/String;)Ljava/lang/Object;", "threadFactory", "Ljava/util/concurrent/ThreadFactory;", "daemon", "threadName", "", "block", "Lkotlin/Function0;", "asFactory", "Lokhttp3/EventListener$Factory;", "Lokhttp3/EventListener;", "assertHeld", "Ljava/util/concurrent/locks/ReentrantLock;", "assertNotHeld", "assertThreadDoesntHoldLock", "assertThreadHoldsLock", "canReuseConnectionFor", "Lokhttp3/HttpUrl;", "other", "closeQuietly", "Ljava/net/ServerSocket;", "Ljava/net/Socket;", "discard", "Lokio/Source;", "timeout", "timeUnit", "headersContentLength", "Lokhttp3/Response;", "isHealthy", "source", "Lokio/BufferedSource;", "notify", "notifyAll", "peerName", "readBomAsCharset", "Ljava/nio/charset/Charset;", "default", "skipAll", "toHeaderList", "Lokhttp3/internal/http2/Header;", "toHeaders", "toHexString", "toHostHeader", "includeDefaultPort", "toImmutableList", "wait", "okhttp"})
@SourceDebugExtension(value={"SMAP\n-UtilJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,371:1\n1#2:372\n1549#3:373\n1620#3,3:374\n*S KotlinDebug\n*F\n+ 1 -UtilJvm.kt\nokhttp3/internal/_UtilJvmKt\n*L\n142#1:373\n142#1:374,3\n*E\n"})
public final class _UtilJvmKt {
    @JvmField
    public static final Headers EMPTY_HEADERS = _UtilCommonKt.getCommonEmptyHeaders();
    @JvmField
    public static final RequestBody EMPTY_REQUEST = _UtilCommonKt.getCommonEmptyRequestBody();
    @JvmField
    public static final ResponseBody EMPTY_RESPONSE = _UtilCommonKt.getCommonEmptyResponse();
    @JvmField
    public static final TimeZone UTC;
    @JvmField
    public static final boolean assertionsEnabled;
    @JvmField
    public static final String okHttpName;

    /*
     * WARNING - void declaration
     */
    public static final ThreadFactory threadFactory(String name, boolean daemon) {
        void var1_1;
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return arg_0 -> _UtilJvmKt.threadFactory$lambda$1(string, (boolean)var1_1, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    public static final String toHostHeader(HttpUrl $this$toHostHeader, boolean includeDefaultPort) {
        void var2_2;
        void var1_1;
        String host;
        Intrinsics.checkNotNullParameter((Object)$this$toHostHeader, (String)"<this>");
        String string = host = StringsKt.contains$default((CharSequence)$this$toHostHeader.host(), (CharSequence)":", (boolean)false, (int)2, null) ? "[" + $this$toHostHeader.host() + ']' : $this$toHostHeader.host();
        if (var1_1 != false || $this$toHostHeader.port() != HttpUrl.Companion.defaultPort($this$toHostHeader.scheme())) {
            HttpUrl httpUrl;
            return host + ':' + httpUrl.port();
        }
        return var2_2;
    }

    public static /* synthetic */ String toHostHeader$default(HttpUrl httpUrl, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return _UtilJvmKt.toHostHeader(httpUrl, bl);
    }

    public static final String format(String format, Object ... args) {
        String string;
        T[] TArray;
        Intrinsics.checkNotNullParameter((Object)format, (String)"format");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Locale locale = Locale.US;
        void v0 = TArray;
        TArray = Arrays.copyOf(v0, ((void)v0).length);
        String string2 = String.format(locale, string, (Object[])Arrays.copyOf(TArray, TArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    public static final Charset readBomAsCharset(BufferedSource $this$readBomAsCharset, Charset charset) throws IOException {
        BufferedSource bufferedSource;
        Intrinsics.checkNotNullParameter((Object)$this$readBomAsCharset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"default");
        switch (bufferedSource.select(_UtilCommonKt.getUNICODE_BOMS())) {
            case 0: {
                return Charsets.UTF_8;
            }
            case 1: {
                return Charsets.UTF_16BE;
            }
            case 2: {
                return Charsets.UTF_16LE;
            }
            case 3: {
                return Charsets.INSTANCE.UTF32_BE();
            }
            case 4: {
                return Charsets.INSTANCE.UTF32_LE();
            }
            case -1: {
                void var1_1;
                return var1_1;
            }
        }
        throw new AssertionError();
    }

    /*
     * WARNING - void declaration
     */
    public static final int checkDuration(String name, long duration, TimeUnit unit) {
        void var1_1;
        void var3_2;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        if (!(duration >= 0L)) {
            String string = name + " < 0";
            throw new IllegalStateException(string.toString());
        }
        long millis = var3_2.toMillis(duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            name = name + " too large";
            throw new IllegalArgumentException(name.toString());
        }
        if (!(millis != 0L || var1_1 <= 0L)) {
            String string;
            string = string + " too small";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)millis;
    }

    /*
     * WARNING - void declaration
     */
    public static final int checkDuration-HG0u8IE(String name, long duration) {
        void var3_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!(!Duration.isNegative-impl((long)duration))) {
            String string = name + " < 0";
            throw new IllegalStateException(string.toString());
        }
        long millis = Duration.getInWholeMilliseconds-impl((long)duration);
        if (!(millis <= Integer.MAX_VALUE)) {
            name = name + " too large";
            throw new IllegalArgumentException(name.toString());
        }
        if (!(millis != 0L || !Duration.isPositive-impl((long)var1_1))) {
            String string;
            string = string + " too small";
            throw new IllegalArgumentException(string.toString());
        }
        return (int)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final Headers toHeaders(List<Header> $this$toHeaders) {
        void var1_1;
        Iterator<Header> iterator;
        Intrinsics.checkNotNullParameter($this$toHeaders, (String)"<this>");
        Headers.Builder builder = new Headers.Builder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Header header = (Header)iterator.next();
            ByteString name = header.component1();
            ByteString value = header.component2();
            builder.addLenient$okhttp(var3_3.utf8(), header.utf8());
        }
        return var1_1.build();
    }

    /*
     * WARNING - void declaration
     */
    public static final List<Header> toHeaderList(Headers $this$toHeaderList) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$toHeaderList, (String)"<this>");
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)$this$toHeaderList.size());
        Object object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            void var3_3;
            void it;
            int item$iv$iv = ((IntIterator)object).nextInt();
            Collection collection = destination$iv$iv;
            collection.add(new Header($this$toHeaderList.name((int)it), $this$toHeaderList.value((int)var3_3)));
        }
        return (List)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canReuseConnectionFor(HttpUrl $this$canReuseConnectionFor, HttpUrl other) {
        void var1_1;
        HttpUrl httpUrl;
        Intrinsics.checkNotNullParameter((Object)$this$canReuseConnectionFor, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return Intrinsics.areEqual((Object)$this$canReuseConnectionFor.host(), (Object)other.host()) && $this$canReuseConnectionFor.port() == other.port() && Intrinsics.areEqual((Object)httpUrl.scheme(), (Object)var1_1.scheme());
    }

    public static final EventListener.Factory asFactory(EventListener $this$asFactory) {
        EventListener eventListener;
        Intrinsics.checkNotNullParameter((Object)$this$asFactory, (String)"<this>");
        return arg_0 -> _UtilJvmKt.asFactory$lambda$9(eventListener, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean skipAll(Source $this$skipAll, int duration, TimeUnit timeUnit) throws IOException {
        boolean bl;
        block9: {
            long originalDurationNs;
            long nowNs;
            block8: {
                void var2_4;
                Intrinsics.checkNotNullParameter((Object)$this$skipAll, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
                nowNs = System.nanoTime();
                originalDurationNs = $this$skipAll.timeout().hasDeadline() ? $this$skipAll.timeout().deadlineNanoTime() - nowNs : Long.MAX_VALUE;
                $this$skipAll.timeout().deadlineNanoTime(nowNs + Math.min(originalDurationNs, var2_4.toNanos(duration)));
                try {
                    Buffer skipBuffer = new Buffer();
                    while ($this$skipAll.read(skipBuffer, 8192L) != -1L) {
                        skipBuffer.clear();
                    }
                    bl = true;
                    if (originalDurationNs != Long.MAX_VALUE) break block8;
                }
                catch (InterruptedIOException interruptedIOException) {
                    bl = false;
                    if (originalDurationNs == Long.MAX_VALUE) {
                        $this$skipAll.timeout().clearDeadline();
                    } else {
                        $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
                    }
                }
                catch (Throwable throwable) {
                    if (originalDurationNs == Long.MAX_VALUE) {
                        $this$skipAll.timeout().clearDeadline();
                    } else {
                        void var3_5;
                        Source source;
                        source.timeout().deadlineNanoTime((long)(var3_5 + originalDurationNs));
                    }
                    throw throwable;
                }
                $this$skipAll.timeout().clearDeadline();
                break block9;
            }
            $this$skipAll.timeout().deadlineNanoTime(nowNs + originalDurationNs);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean discard(Source $this$discard, int timeout2, TimeUnit timeUnit) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$discard, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        try {
            void var2_3;
            void var1_2;
            Source source;
            bl = _UtilJvmKt.skipAll(source, (int)var1_2, (TimeUnit)var2_3);
        }
        catch (IOException iOException) {
            bl = false;
        }
        return bl;
    }

    public static final String peerName(Socket $this$peerName) {
        SocketAddress socketAddress;
        Intrinsics.checkNotNullParameter((Object)$this$peerName, (String)"<this>");
        SocketAddress address = $this$peerName.getRemoteSocketAddress();
        if (address instanceof InetSocketAddress) {
            String string = ((InetSocketAddress)address).getHostName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
            return string;
        }
        return socketAddress.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isHealthy(Socket $this$isHealthy, BufferedSource source) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$isHealthy, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        try {
            int n2;
            int readTimeout = $this$isHealthy.getSoTimeout();
            try {
                void var1_1;
                $this$isHealthy.setSoTimeout(1);
                n2 = !var1_1.exhausted() ? 1 : 0;
            }
            catch (Throwable throwable) {
                Socket socket;
                socket.setSoTimeout(n);
                throw throwable;
            }
            $this$isHealthy.setSoTimeout(readTimeout);
            n = n2;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            n = 1;
        }
        catch (IOException iOException) {
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - void declaration
     */
    public static final void threadName(String name, Function0<Unit> block) {
        String string;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        Thread currentThread = Thread.currentThread();
        String oldName = currentThread.getName();
        currentThread.setName(string);
        try {
            void var1_2;
            var1_2.invoke();
        }
        catch (Throwable throwable) {
            void var3_4;
            void var2_3;
            InlineMarker.finallyStart((int)1);
            var2_3.setName((String)var3_4);
            InlineMarker.finallyEnd((int)1);
            throw throwable;
        }
        InlineMarker.finallyStart((int)1);
        currentThread.setName(oldName);
        InlineMarker.finallyEnd((int)1);
    }

    public static final long headersContentLength(Response $this$headersContentLength) {
        Response response;
        Intrinsics.checkNotNullParameter((Object)$this$headersContentLength, (String)"<this>");
        String string = response.headers().get("Content-Length");
        if (string != null) {
            return _UtilCommonKt.toLongOrDefault(string, -1L);
        }
        return -1L;
    }

    public static final <T> List<T> toImmutableList(List<? extends T> $this$toImmutableList) {
        List<? extends T> list;
        Intrinsics.checkNotNullParameter($this$toImmutableList, (String)"<this>");
        List list2 = Collections.unmodifiableList(CollectionsKt.toMutableList((Collection)list));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"unmodifiableList(...)");
        return list2;
    }

    @SafeVarargs
    public static final <T> List<T> immutableListOf(T ... elements) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        objectArray = (Object[])objectArray.clone();
        List list = Collections.unmodifiableList(CollectionsKt.listOf((Object[])Arrays.copyOf(objectArray, objectArray.length)));
        Intrinsics.checkNotNullExpressionValue(list, (String)"unmodifiableList(...)");
        return list;
    }

    public static final void closeQuietly(Socket $this$closeQuietly) {
        Intrinsics.checkNotNullParameter((Object)$this$closeQuietly, (String)"<this>");
        try {
            ((Socket)$this$closeQuietly).close();
            return;
        }
        catch (AssertionError assertionError) {
            $this$closeQuietly = assertionError;
            throw assertionError;
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException2;
            RuntimeException rethrown = runtimeException;
            if (Intrinsics.areEqual((Object)runtimeException.getMessage(), (Object)"bio == null")) {
                return;
            }
            throw runtimeException2;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final void closeQuietly(ServerSocket $this$closeQuietly) {
        RuntimeException runtimeException;
        Intrinsics.checkNotNullParameter((Object)$this$closeQuietly, (String)"<this>");
        try {
            ((ServerSocket)((Object)runtimeException)).close();
            return;
        }
        catch (RuntimeException runtimeException2) {
            runtimeException = runtimeException2;
            throw runtimeException2;
        }
        catch (Exception exception) {
            return;
        }
    }

    public static final String toHexString(long $this$toHexString) {
        String string = Long.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    public static final String toHexString(int $this$toHexString) {
        String string = Integer.toHexString($this$toHexString);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHexString(...)");
        return string;
    }

    public static final void wait(Object $this$wait) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$wait, (String)"<this>");
        object.wait();
    }

    public static final void notify(Object $this$notify) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$notify, (String)"<this>");
        object.notify();
    }

    public static final void notifyAll(Object $this$notifyAll) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$notifyAll, (String)"<this>");
        object.notifyAll();
    }

    public static final <T> T readFieldOrNull(Object instance, Class<T> fieldType, String fieldName) {
        while (true) {
            Object delegate;
            Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
            Intrinsics.checkNotNullParameter(fieldType, (String)"fieldType");
            Intrinsics.checkNotNullParameter((Object)fieldName, (String)"fieldName");
            Class<?> c = instance.getClass();
            while (!Intrinsics.areEqual(c, Object.class)) {
                try {
                    Field field = c.getDeclaredField(fieldName);
                    field.setAccessible(true);
                    Object value = field.get(instance);
                    if (!fieldType.isInstance(value)) {
                        return null;
                    }
                    return fieldType.cast(value);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    Intrinsics.checkNotNullExpressionValue(c.getSuperclass(), (String)"getSuperclass(...)");
                }
            }
            if (Intrinsics.areEqual((Object)fieldName, (Object)"delegate") || (delegate = _UtilJvmKt.readFieldOrNull(instance, Object.class, "delegate")) == null) break;
            instance = delegate;
        }
        return null;
    }

    public static final void assertHeld(ReentrantLock $this$assertHeld) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHeld, (String)"<this>");
        if (assertionsEnabled && !$this$assertHeld.isHeldByCurrentThread()) {
            ReentrantLock reentrantLock;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + reentrantLock));
        }
    }

    public static final void assertThreadHoldsLock(Object $this$assertThreadHoldsLock) {
        Intrinsics.checkNotNullParameter((Object)$this$assertThreadHoldsLock, (String)"<this>");
        if (assertionsEnabled && !Thread.holdsLock($this$assertThreadHoldsLock)) {
            Object object;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST hold lock on " + object));
        }
    }

    public static final void assertNotHeld(ReentrantLock $this$assertNotHeld) {
        Intrinsics.checkNotNullParameter((Object)$this$assertNotHeld, (String)"<this>");
        if (assertionsEnabled && $this$assertNotHeld.isHeldByCurrentThread()) {
            ReentrantLock reentrantLock;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + reentrantLock));
        }
    }

    public static final void assertThreadDoesntHoldLock(Object $this$assertThreadDoesntHoldLock) {
        Intrinsics.checkNotNullParameter((Object)$this$assertThreadDoesntHoldLock, (String)"<this>");
        if (assertionsEnabled && Thread.holdsLock($this$assertThreadDoesntHoldLock)) {
            Object object;
            throw new AssertionError((Object)("Thread " + Thread.currentThread().getName() + " MUST NOT hold lock on " + object));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Thread threadFactory$lambda$1(String $name, boolean $daemon, Runnable runnable2) {
        void var1_1;
        Thread thread;
        Thread thread2;
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        thread = new Thread((Runnable)thread2, (String)((Object)thread));
        thread2 = thread;
        thread.setDaemon((boolean)var1_1);
        return thread;
    }

    /*
     * WARNING - void declaration
     */
    private static final EventListener asFactory$lambda$9(EventListener $this_asFactory, Call it) {
        EventListener eventListener;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this_asFactory, (String)"$this_asFactory");
        Intrinsics.checkNotNullParameter((Object)var1_1, (String)"it");
        return eventListener;
    }

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNull((Object)timeZone);
        UTC = timeZone;
        assertionsEnabled = OkHttpClient.class.desiredAssertionStatus();
        String string = OkHttpClient.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        okHttpName = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)string, (CharSequence)"okhttp3."), (CharSequence)"Client");
    }
}

