/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.http.HttpMethod;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001H\u0000\u001a\u001a\u0010\u0003\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\n\u0010\u0007\u001a\u00020\b*\u00020\t\u001a\u0012\u0010\u0007\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\n\u001a\u00020\b\u001a\u0014\u0010\u000b\u001a\u00020\u0004*\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\n\u0010\u000e\u001a\u00020\u0004*\u00020\u0004\u001a\n\u0010\u000f\u001a\u00020\u0004*\u00020\u0004\u001a\u0014\u0010\u0010\u001a\u0004\u0018\u00010\u0001*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u001a\u0010\u0010\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012*\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0001\u001a\u0012\u0010\u0011\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014\u001a\u001c\u0010\u0015\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00012\b\u0010\f\u001a\u0004\u0018\u00010\r\u001a\n\u0010\u0017\u001a\u00020\u0004*\u00020\t\u001a\u0012\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u0019\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001a\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u001b\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a1\u0010\u001c\u001a\u00020\u0004\"\b\b\u0000\u0010\u001d*\u00020\u001e*\u00020\u00042\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001d0 2\b\u0010!\u001a\u0004\u0018\u0001H\u001d\u00a2\u0006\u0002\u0010\"\u001a\n\u0010#\u001a\u00020\u0001*\u00020\t\u00a8\u0006$"}, d2={"canonicalUrl", "", "url", "commonAddHeader", "Lokhttp3/Request$Builder;", "name", "value", "commonCacheControl", "Lokhttp3/CacheControl;", "Lokhttp3/Request;", "cacheControl", "commonDelete", "body", "Lokhttp3/RequestBody;", "commonGet", "commonHead", "commonHeader", "commonHeaders", "", "headers", "Lokhttp3/Headers;", "commonMethod", "method", "commonNewBuilder", "commonPatch", "commonPost", "commonPut", "commonRemoveHeader", "commonTag", "T", "", "type", "Lkotlin/reflect/KClass;", "tag", "(Lokhttp3/Request$Builder;Lkotlin/reflect/KClass;Ljava/lang/Object;)Lokhttp3/Request$Builder;", "commonToString", "okhttp"})
@SourceDebugExtension(value={"SMAP\n-RequestCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -RequestCommon.kt\nokhttp3/internal/_RequestCommonKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1#2:163\n1864#3,3:164\n*S KotlinDebug\n*F\n+ 1 -RequestCommon.kt\nokhttp3/internal/_RequestCommonKt\n*L\n146#1:164,3\n*E\n"})
public final class _RequestCommonKt {
    /*
     * WARNING - void declaration
     */
    public static final String commonHeader(Request $this$commonHeader, String name) {
        void var1_1;
        Request request;
        Intrinsics.checkNotNullParameter((Object)$this$commonHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return request.headers().get((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final List<String> commonHeaders(Request $this$commonHeaders, String name) {
        void var1_1;
        Request request;
        Intrinsics.checkNotNullParameter((Object)$this$commonHeaders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return request.headers().values((String)var1_1);
    }

    public static final Request.Builder commonNewBuilder(Request $this$commonNewBuilder) {
        Request request;
        Intrinsics.checkNotNullParameter((Object)$this$commonNewBuilder, (String)"<this>");
        return new Request.Builder(request);
    }

    /*
     * WARNING - void declaration
     */
    public static final CacheControl commonCacheControl(Request $this$commonCacheControl) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$commonCacheControl, (String)"<this>");
        CacheControl result = $this$commonCacheControl.getLazyCacheControl$okhttp();
        if (result == null) {
            Request request;
            result = CacheControl.Companion.parse($this$commonCacheControl.headers());
            request.setLazyCacheControl$okhttp(result);
        }
        return var1_1;
    }

    public static final String canonicalUrl(String url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (StringsKt.startsWith((String)url, (String)"ws:", (boolean)true)) {
            StringBuilder stringBuilder = new StringBuilder("http:");
            String string2 = url.substring(3);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            return stringBuilder.append(string2).toString();
        }
        if (StringsKt.startsWith((String)url, (String)"wss:", (boolean)true)) {
            StringBuilder stringBuilder = new StringBuilder("https:");
            String string3 = url.substring(4);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            return stringBuilder.append(string3).toString();
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonHeader(Request.Builder $this$commonHeader, String name, String value) {
        void var2_2;
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Request.Builder builder2 = builder;
        builder.getHeaders$okhttp().set((String)var1_1, (String)var2_2);
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonAddHeader(Request.Builder $this$commonAddHeader, String name, String value) {
        void var2_2;
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonAddHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Request.Builder builder2 = builder;
        builder.getHeaders$okhttp().add((String)var1_1, (String)var2_2);
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonRemoveHeader(Request.Builder $this$commonRemoveHeader, String name) {
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonRemoveHeader, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Request.Builder builder2 = builder;
        builder.getHeaders$okhttp().removeAll((String)var1_1);
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonHeaders(Request.Builder $this$commonHeaders, Headers headers2) {
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonHeaders, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        Request.Builder builder2 = builder;
        builder.setHeaders$okhttp(var1_1.newBuilder());
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonCacheControl(Request.Builder $this$commonCacheControl, CacheControl cacheControl) {
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonCacheControl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)cacheControl, (String)"cacheControl");
        String value = cacheControl.toString();
        if (((CharSequence)value).length() == 0) {
            return $this$commonCacheControl.removeHeader("Cache-Control");
        }
        return builder.header("Cache-Control", (String)var1_1);
    }

    public static final Request.Builder commonGet(Request.Builder $this$commonGet) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonGet, (String)"<this>");
        return builder.method("GET", null);
    }

    public static final Request.Builder commonHead(Request.Builder $this$commonHead) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonHead, (String)"<this>");
        return builder.method("HEAD", null);
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonPost(Request.Builder $this$commonPost, RequestBody body) {
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonPost, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return builder.method("POST", (RequestBody)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonDelete(Request.Builder $this$commonDelete, RequestBody body) {
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonDelete, (String)"<this>");
        return builder.method("DELETE", (RequestBody)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonPut(Request.Builder $this$commonPut, RequestBody body) {
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonPut, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return builder.method("PUT", (RequestBody)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonPatch(Request.Builder $this$commonPatch, RequestBody body) {
        void var1_1;
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonPatch, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)body, (String)"body");
        return builder.method("PATCH", (RequestBody)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static final Request.Builder commonMethod(Request.Builder $this$commonMethod, String method, RequestBody body) {
        void var2_2;
        void var3_3;
        void var1_1;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$commonMethod, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Request.Builder $this$commonMethod_u24lambda_u247 = object;
        if (!(((CharSequence)method).length() > 0)) {
            object = "method.isEmpty() == true";
            throw new IllegalArgumentException(object.toString());
        }
        if (body == null) {
            if (!(!HttpMethod.requiresRequestBody(method))) {
                object = "method " + method + " must have a request body.";
                throw new IllegalArgumentException(object.toString());
            }
        } else if (!HttpMethod.permitsRequestBody(method)) {
            object = "method " + method + " must not have a request body.";
            throw new IllegalArgumentException(object.toString());
        }
        $this$commonMethod_u24lambda_u247.setMethod$okhttp((String)var1_1);
        var3_3.setBody$okhttp((RequestBody)var2_2);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public static final <T> Request.Builder commonTag(Request.Builder $this$commonTag, KClass<T> type, T tag) {
        Request.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonTag, (String)"<this>");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Request.Builder $this$commonTag_u24lambda_u249 = builder;
        if (tag == null) {
            if (!$this$commonTag_u24lambda_u249.getTags$okhttp().isEmpty()) {
                Map<KClass<?>, Object> map = $this$commonTag_u24lambda_u249.getTags$okhttp();
                Intrinsics.checkNotNull(map, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.reflect.KClass<*>, kotlin.Any>");
                TypeIntrinsics.asMutableMap(map).remove(type);
            }
        } else {
            void var2_2;
            void var1_1;
            Map map;
            Map map2;
            if ($this$commonTag_u24lambda_u249.getTags$okhttp().isEmpty()) {
                Map map3;
                Map it = map3 = (Map)new LinkedHashMap();
                $this$commonTag_u24lambda_u249.setTags$okhttp(it);
                map2 = map3;
            } else {
                Map<KClass<?>, Object> map4 = ((Request.Builder)((Object)map)).getTags$okhttp();
                Intrinsics.checkNotNull(map4, (String)"null cannot be cast to non-null type kotlin.collections.MutableMap<kotlin.reflect.KClass<*>, kotlin.Any>");
                map2 = TypeIntrinsics.asMutableMap(map4);
            }
            map = map2;
            map2.put(var1_1, var2_2);
        }
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public static final String commonToString(Request $this$commonToString) {
        void var2_2;
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        StringBuilder $this$commonToString_u24lambda_u2411 = stringBuilder = new StringBuilder();
        stringBuilder.append("Request{method=");
        $this$commonToString_u24lambda_u2411.append($this$commonToString.method());
        $this$commonToString_u24lambda_u2411.append(", url=");
        $this$commonToString_u24lambda_u2411.append($this$commonToString.url());
        if ($this$commonToString.headers().size() != 0) {
            Iterator iterator;
            $this$commonToString_u24lambda_u2411.append(", headers=[");
            Iterable $this$forEachIndexed$iv = $this$commonToString.headers();
            int index$iv = 0;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                int n;
                Object item$iv = iterator.next();
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                item$iv = (Pair)item$iv;
                int index = n;
                String name = (String)item$iv.component1();
                String value = (String)item$iv.component2();
                if (index > 0) {
                    $this$commonToString_u24lambda_u2411.append(", ");
                }
                $this$commonToString_u24lambda_u2411.append(name);
                $this$commonToString_u24lambda_u2411.append(':');
                $this$commonToString_u24lambda_u2411.append(_UtilCommonKt.isSensitiveHeader(name) ? "\u2588\u2588" : value);
            }
            $this$commonToString_u24lambda_u2411.append(']');
        }
        if (!$this$commonToString.getTags$okhttp().isEmpty()) {
            Request request;
            $this$commonToString_u24lambda_u2411.append(", tags=");
            $this$commonToString_u24lambda_u2411.append(request.getTags$okhttp());
        }
        var2_2.append('}');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }
}

