/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.MediaType;
import okhttp3.internal._UtilCommonKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u001a\u0016\u0010\u0006\u001a\u00020\u0007*\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\bH\u0000\u001a\u0016\u0010\r\u001a\u0004\u0018\u00010\u0003*\u00020\b2\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000f\u001a\u00020\b*\u00020\u0003H\u0000\u001a\f\u0010\u0010\u001a\u0004\u0018\u00010\b*\u00020\u0003\u001a\f\u0010\u0011\u001a\u00020\u0003*\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"PARAMETER", "Lkotlin/text/Regex;", "QUOTED", "", "TOKEN", "TYPE_SUBTYPE", "commonEquals", "", "Lokhttp3/MediaType;", "other", "", "commonHashCode", "", "commonParameter", "name", "commonToMediaType", "commonToMediaTypeOrNull", "commonToString", "okhttp"})
@SourceDebugExtension(value={"SMAP\n-MediaTypeCommon.kt\nKotlin\n*S Kotlin\n*F\n+ 1 -MediaTypeCommon.kt\nokhttp3/internal/_MediaTypeCommonKt\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,98:1\n37#2,2:99\n*S KotlinDebug\n*F\n+ 1 -MediaTypeCommon.kt\nokhttp3/internal/_MediaTypeCommonKt\n*L\n87#1:99,2\n*E\n"})
public final class _MediaTypeCommonKt {
    private static final String TOKEN = "([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)";
    private static final String QUOTED = "\"([^\"]*)\"";
    private static final Regex TYPE_SUBTYPE = new Regex("([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)/([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)");
    private static final Regex PARAMETER = new Regex(";\\s*(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)=(?:([a-zA-Z0-9-!#$%&'*+.^_`{|}~]+)|\"([^\"]*)\"))?");

    public static final String commonParameter(MediaType $this$commonParameter, String name) {
        Intrinsics.checkNotNullParameter((Object)$this$commonParameter, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        int n = $this$commonParameter.getParameterNamesAndValues$okhttp().length + -1;
        int i = 0;
        n = ProgressionUtilKt.getProgressionLastElement((int)0, (int)n, (int)2);
        if (n >= 0) {
            while (true) {
                if (StringsKt.equals((String)$this$commonParameter.getParameterNamesAndValues$okhttp()[i], (String)name, (boolean)true)) {
                    return $this$commonParameter.getParameterNamesAndValues$okhttp()[i + 1];
                }
                if (i == n) break;
                i += 2;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean commonEquals(MediaType $this$commonEquals, Object other) {
        MediaType mediaType;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$commonEquals, (String)"<this>");
        return other instanceof MediaType && Intrinsics.areEqual((Object)((MediaType)var1_1).getMediaType$okhttp(), (Object)mediaType.getMediaType$okhttp());
    }

    public static final String commonToString(MediaType $this$commonToString) {
        MediaType mediaType;
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        return mediaType.getMediaType$okhttp();
    }

    public static final int commonHashCode(MediaType $this$commonHashCode) {
        MediaType mediaType;
        Intrinsics.checkNotNullParameter((Object)$this$commonHashCode, (String)"<this>");
        return mediaType.getMediaType$okhttp().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public static final MediaType commonToMediaType(String $this$commonToMediaType) {
        void var3_5;
        void var2_4;
        String string;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$commonToMediaType, (String)"<this>");
        MatchResult matchResult = _UtilCommonKt.matchAtPolyfill(TYPE_SUBTYPE, $this$commonToMediaType, 0);
        if (matchResult == null) {
            throw new IllegalArgumentException("No subtype found for: \"" + $this$commonToMediaType + '\"');
        }
        MatchResult typeSubtype = matchResult;
        String string2 = ((String)matchResult.getGroupValues().get(1)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String type = string2;
        String string3 = ((String)typeSubtype.getGroupValues().get(2)).toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        String subtype = string3;
        List parameterNamesAndValues = new ArrayList();
        int s = typeSubtype.getRange().getLast() + 1;
        while (s < $this$commonToMediaType.length()) {
            void var1_3;
            String string4;
            MatchResult parameter = _UtilCommonKt.matchAtPolyfill(PARAMETER, $this$commonToMediaType, s);
            if (!(parameter != null)) {
                StringBuilder stringBuilder = new StringBuilder("Parameter is not formatted correctly: \"");
                String string5 = $this$commonToMediaType.substring(s);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"substring(...)");
                object = stringBuilder.append(string5).append("\" for: \"").append($this$commonToMediaType).append('\"').toString();
                throw new IllegalArgumentException(object.toString());
            }
            MatchGroup matchGroup = parameter.getGroups().get(1);
            String name2 = matchGroup != null ? matchGroup.getValue() : null;
            if (name2 == null) {
                int name2 = parameter.getRange().getLast() + 1;
                continue;
            }
            MatchGroup matchGroup2 = parameter.getGroups().get(2);
            String token = matchGroup2 != null ? matchGroup2.getValue() : null;
            if (token == null) {
                MatchGroup matchGroup3 = parameter.getGroups().get(3);
                Intrinsics.checkNotNull((Object)matchGroup3);
                string4 = matchGroup3.getValue();
            } else if (StringsKt.startsWith$default((String)token, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)token, (String)"'", (boolean)false, (int)2, null) && token.length() > 2) {
                String string6 = token.substring(1, token.length() - 1);
                string4 = string6;
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            } else {
                string4 = token;
            }
            String value = string4;
            ((Collection)parameterNamesAndValues).add(var1_3);
            ((Collection)parameterNamesAndValues).add(value);
            int n = parameter.getRange().getLast() + 1;
        }
        Collection collection = parameterNamesAndValues;
        object = collection;
        return new MediaType(string, (String)var2_4, (String)var3_5, collection.toArray(new String[0]));
    }

    public static final MediaType commonToMediaTypeOrNull(String $this$commonToMediaTypeOrNull) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$commonToMediaTypeOrNull, (String)"<this>");
        try {
            object = _MediaTypeCommonKt.commonToMediaType((String)object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            object = null;
        }
        return object;
    }
}

