/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.internal._NormalizeJvmKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal.idn.IdnaMappingTableInstanceKt;
import okhttp3.internal.idn.Punycode;
import okio.Buffer;
import okio.BufferedSink;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\r\u001a\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a0\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\nH\u0000\u001a\"\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nH\u0000\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000f\u001a\u00020\bH\u0000\u001a\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0004\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u001a\n\u0010\u0013\u001a\u00020\u0006*\u00020\b\u001a\f\u0010\u0014\u001a\u00020\u0006*\u00020\bH\u0000\u001a\f\u0010\u0015\u001a\u00020\u0006*\u00020\bH\u0000\u001a\u000e\u0010\u0016\u001a\u0004\u0018\u00010\b*\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"VERIFY_AS_IP_ADDRESS", "Lkotlin/text/Regex;", "canonicalizeInetAddress", "", "address", "decodeIpv4Suffix", "", "input", "", "pos", "", "limit", "addressOffset", "decodeIpv6", "idnToAscii", "host", "inet4AddressToAscii", "inet6AddressToAscii", "isMappedIpv4Address", "canParseAsIpAddress", "containsInvalidHostnameAsciiCodes", "containsInvalidLabelLengths", "toCanonicalHost", "okhttp"})
public final class _HostnamesCommonKt {
    private static final Regex VERIFY_AS_IP_ADDRESS = new Regex("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");

    public static final boolean canParseAsIpAddress(String $this$canParseAsIpAddress) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$canParseAsIpAddress, (String)"<this>");
        return VERIFY_AS_IP_ADDRESS.matches((CharSequence)string);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean containsInvalidLabelLengths(String $this$containsInvalidLabelLengths) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInvalidLabelLengths, (String)"<this>");
        int n = $this$containsInvalidLabelLengths.length();
        if (!(n > 0 ? n < 254 : false)) {
            return true;
        }
        int labelStart = 0;
        while (true) {
            void var2_2;
            int dot;
            int labelLength;
            int n2 = labelLength = (dot = StringsKt.indexOf$default((CharSequence)$this$containsInvalidLabelLengths, (char)'.', (int)labelStart, (boolean)false, (int)4, null)) == -1 ? $this$containsInvalidLabelLengths.length() - labelStart : dot - labelStart;
            if (!(labelLength > 0 ? n < 64 : false)) {
                return true;
            }
            if (dot == -1 || dot == $this$containsInvalidLabelLengths.length() - 1) break;
            n = var2_2 + true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean containsInvalidHostnameAsciiCodes(String $this$containsInvalidHostnameAsciiCodes) {
        Intrinsics.checkNotNullParameter((Object)$this$containsInvalidHostnameAsciiCodes, (String)"<this>");
        int n = $this$containsInvalidHostnameAsciiCodes.length();
        for (int i = 0; i < n; ++i) {
            void var3_3;
            char c = $this$containsInvalidHostnameAsciiCodes.charAt(i);
            if (Intrinsics.compare((int)c, (int)31) <= 0 || Intrinsics.compare((int)c, (int)127) >= 0) {
                return true;
            }
            if (StringsKt.indexOf$default((CharSequence)" #%/:?@[\\]", (char)var3_3, (int)0, (boolean)false, (int)6, null) == -1) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final byte[] decodeIpv6(String input, int pos, int limit) {
        void var3_3;
        void i;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        byte[] address = new byte[16];
        int b = 0;
        int compress = -1;
        int groupOffset = -1;
        while (i < limit) {
            int hexDigit;
            if (b == address.length) {
                return null;
            }
            if (i + 2 <= limit && StringsKt.startsWith$default((String)input, (String)"::", (int)i, (boolean)false, (int)4, null)) {
                if (compress != -1) {
                    return null;
                }
                compress = b += 2;
                if ((i += 2) == limit) {
                    break;
                }
            } else if (b != 0 && !StringsKt.startsWith$default((String)input, (String)":", (int)i, (boolean)false, (int)4, null)) {
                if (StringsKt.startsWith$default((String)input, (String)".", (int)i, (boolean)false, (int)4, null)) {
                    if (!_HostnamesCommonKt.decodeIpv4Suffix(input, groupOffset, limit, address, b - 2)) {
                        return null;
                    }
                    b += 2;
                    break;
                }
                return null;
            }
            int value = 0;
            groupOffset = ++i;
            while (i < limit && (hexDigit = _UtilCommonKt.parseHexDigit(input.charAt((int)i))) != -1) {
                value = (value << 4) + hexDigit;
                ++i;
            }
            void groupLength = i - groupOffset;
            if (groupLength == false || groupLength > 4) {
                return null;
            }
            address[b++] = (byte)(value >>> 8);
            address[b++] = (byte)value;
        }
        if (b != address.length) {
            if (compress == -1) {
                return null;
            }
            ArraysKt.copyInto((byte[])address, (byte[])address, (int)(address.length - (b - compress)), (int)compress, (int)b);
            int n = compress;
            ArraysKt.fill((byte[])address, (byte)0, (int)n, (int)(n + (address.length - b)));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean decodeIpv4Suffix(String input, int pos, int limit, byte[] address, int addressOffset) {
        void i;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int b = addressOffset;
        while (i < limit) {
            char c;
            if (b == address.length) {
                return false;
            }
            if (b != addressOffset && input.charAt((int)i) != '.') {
                return false;
            }
            int value = 0;
            void groupOffset = ++i;
            while (i < limit && Intrinsics.compare((int)(c = input.charAt((int)i)), (int)48) >= 0 && Intrinsics.compare((int)c, (int)57) <= 0) {
                if (value == 0 && groupOffset != i) {
                    return false;
                }
                if ((value = value * 10 + c - 48) > 255) {
                    return false;
                }
                ++i;
            }
            void var8_8 = i - groupOffset;
            if (var8_8 == false) {
                return false;
            }
            address[b++] = (byte)value;
        }
        return b == addressOffset + 4;
    }

    /*
     * WARNING - void declaration
     */
    public static final String inet6AddressToAscii(byte[] address) {
        void var3_5;
        int i;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        int longestRunOffset = -1;
        int longestRunLength = 0;
        for (i = 0; i < address.length; i += 2) {
            int currentRunOffset = i;
            while (i < 16 && address[i] == 0 && address[i + 1] == 0) {
                i += 2;
            }
            int currentRunLength = i - currentRunOffset;
            if (currentRunLength <= longestRunLength || currentRunLength < 4) continue;
            longestRunOffset = currentRunOffset;
            longestRunLength = currentRunLength;
        }
        Buffer result = new Buffer();
        i = 0;
        while (i < address.length) {
            if (i == longestRunOffset) {
                result.writeByte(58);
                if ((i += longestRunLength) != 16) continue;
                result.writeByte(58);
                continue;
            }
            if (i > 0) {
                result.writeByte(58);
            }
            int group = _UtilCommonKt.and(address[i], 255) << 8 | _UtilCommonKt.and(address[i + 1], 255);
            result.writeHexadecimalUnsignedLong((long)group);
            i += 2;
        }
        return var3_5.readUtf8();
    }

    public static final byte[] canonicalizeInetAddress(byte[] address) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (_HostnamesCommonKt.isMappedIpv4Address(address)) {
            return ArraysKt.sliceArray((byte[])address, (IntRange)RangesKt.until((int)12, (int)16));
        }
        return byArray;
    }

    private static final boolean isMappedIpv4Address(byte[] address) {
        byte[] byArray;
        if (address.length != 16) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            if (address[i] == 0) continue;
            return false;
        }
        if (address[10] != -1) {
            return false;
        }
        return byArray[11] == -1;
    }

    public static final String inet4AddressToAscii(byte[] address) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        if (!(((byte[])address).length == 4)) {
            address = "Failed requirement.";
            throw new IllegalArgumentException(address.toString());
        }
        return new Buffer().writeDecimalLong((long)_UtilCommonKt.and((byte)address[0], 255)).writeByte(46).writeDecimalLong((long)_UtilCommonKt.and((byte)address[1], 255)).writeByte(46).writeDecimalLong((long)_UtilCommonKt.and((byte)address[2], 255)).writeByte(46).writeDecimalLong((long)_UtilCommonKt.and(byArray[3], 255)).readUtf8();
    }

    /*
     * WARNING - void declaration
     */
    public static final String toCanonicalHost(String $this$toCanonicalHost) {
        void var1_2;
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$toCanonicalHost, (String)"<this>");
        String host = $this$toCanonicalHost;
        if (StringsKt.contains$default((CharSequence)host, (CharSequence)":", (boolean)false, (int)2, null)) {
            byte[] byArray = StringsKt.startsWith$default((String)host, (String)"[", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)host, (String)"]", (boolean)false, (int)2, null) ? _HostnamesCommonKt.decodeIpv6(host, 1, host.length() - 1) : _HostnamesCommonKt.decodeIpv6(host, 0, host.length());
            if (byArray == null) {
                return null;
            }
            byte[] byArray2 = byArray;
            byte[] address = _HostnamesCommonKt.canonicalizeInetAddress(byArray);
            if (address.length == 16) {
                return _HostnamesCommonKt.inet6AddressToAscii(address);
            }
            if (address.length == 4) {
                return _HostnamesCommonKt.inet4AddressToAscii(address);
            }
            throw new AssertionError((Object)("Invalid IPv6 address: '" + host + '\''));
        }
        String string2 = _HostnamesCommonKt.idnToAscii(string);
        if (string2 == null) {
            return null;
        }
        String result = string2;
        if (((CharSequence)string2).length() == 0) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidHostnameAsciiCodes(result)) {
            return null;
        }
        if (_HostnamesCommonKt.containsInvalidLabelLengths(result)) {
            return null;
        }
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final String idnToAscii(String host) {
        String string;
        void var2_3;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        String bufferA = new Buffer().writeUtf8(host);
        Buffer bufferB = new Buffer();
        while (!bufferA.exhausted()) {
            int codePoint = bufferA.readUtf8CodePoint();
            if (IdnaMappingTableInstanceKt.getIDNA_MAPPING_TABLE().map(codePoint, (BufferedSink)bufferB)) continue;
            return null;
        }
        String normalized = _NormalizeJvmKt.normalizeNfc(var1_1.readUtf8());
        bufferA.writeUtf8((String)var2_3);
        String string2 = Punycode.INSTANCE.decode(bufferA.readUtf8());
        if (string2 == null) {
            return null;
        }
        String decoded = string2;
        if (!Intrinsics.areEqual((Object)string2, (Object)_NormalizeJvmKt.normalizeNfc(decoded))) {
            return null;
        }
        return Punycode.INSTANCE.encode(string);
    }
}

