/*
 * Decompiled with CFR 0.152.
 */
package okhttp3.internal;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import okhttp3.CacheControl;
import okhttp3.Headers;
import okhttp3.internal._UtilCommonKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0007H\u0000\u001a\f\u0010\t\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\n\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\u000b\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\f\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\f\u0010\r\u001a\u00020\u0002*\u00020\u0002H\u0000\u001a\u0014\u0010\u000e\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0000\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0001H\u0000\u001a\u001e\u0010\u0013\u001a\u00020\u0004*\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00122\b\b\u0002\u0010\u0015\u001a\u00020\u0004H\u0002\u00a8\u0006\u0016"}, d2={"commonBuild", "Lokhttp3/CacheControl;", "Lokhttp3/CacheControl$Builder;", "commonClampToInt", "", "", "commonForceCache", "Lokhttp3/CacheControl$Companion;", "commonForceNetwork", "commonImmutable", "commonNoCache", "commonNoStore", "commonNoTransform", "commonOnlyIfCached", "commonParse", "headers", "Lokhttp3/Headers;", "commonToString", "", "indexOfElement", "characters", "startIndex", "okhttp"})
public final class _CacheControlCommonKt {
    /*
     * WARNING - void declaration
     */
    public static final String commonToString(CacheControl $this$commonToString) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)$this$commonToString, (String)"<this>");
        CharSequence result = $this$commonToString.getHeaderValue$okhttp();
        if (result == null) {
            CacheControl cacheControl;
            void var2_2;
            result = new StringBuilder();
            StringBuilder $this$commonToString_u24lambda_u240 = result;
            if ($this$commonToString.noCache()) {
                $this$commonToString_u24lambda_u240.append("no-cache, ");
            }
            if ($this$commonToString.noStore()) {
                $this$commonToString_u24lambda_u240.append("no-store, ");
            }
            if ($this$commonToString.maxAgeSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("max-age=").append($this$commonToString.maxAgeSeconds()).append(", ");
            }
            if ($this$commonToString.sMaxAgeSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("s-maxage=").append($this$commonToString.sMaxAgeSeconds()).append(", ");
            }
            if ($this$commonToString.isPrivate()) {
                $this$commonToString_u24lambda_u240.append("private, ");
            }
            if ($this$commonToString.isPublic()) {
                $this$commonToString_u24lambda_u240.append("public, ");
            }
            if ($this$commonToString.mustRevalidate()) {
                $this$commonToString_u24lambda_u240.append("must-revalidate, ");
            }
            if ($this$commonToString.maxStaleSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("max-stale=").append($this$commonToString.maxStaleSeconds()).append(", ");
            }
            if ($this$commonToString.minFreshSeconds() != -1) {
                $this$commonToString_u24lambda_u240.append("min-fresh=").append($this$commonToString.minFreshSeconds()).append(", ");
            }
            if ($this$commonToString.onlyIfCached()) {
                $this$commonToString_u24lambda_u240.append("only-if-cached, ");
            }
            if ($this$commonToString.noTransform()) {
                $this$commonToString_u24lambda_u240.append("no-transform, ");
            }
            if ($this$commonToString.immutable()) {
                $this$commonToString_u24lambda_u240.append("immutable, ");
            }
            if (((CharSequence)$this$commonToString_u24lambda_u240).length() == 0) {
                return "";
            }
            StringBuilder stringBuilder = $this$commonToString_u24lambda_u240;
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.delete(stringBuilder.length() - 2, var2_2.length()), (String)"delete(...)");
            String string = ((StringBuilder)result).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            result = string;
            cacheControl.setHeaderValue$okhttp((String)result);
        }
        return var1_1;
    }

    public static final int commonClampToInt(long $this$commonClampToInt) {
        long l;
        if ($this$commonClampToInt > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public static final CacheControl commonForceNetwork(CacheControl.Companion $this$commonForceNetwork) {
        Intrinsics.checkNotNullParameter((Object)$this$commonForceNetwork, (String)"<this>");
        return new CacheControl.Builder().noCache().build();
    }

    public static final CacheControl commonForceCache(CacheControl.Companion $this$commonForceCache) {
        Intrinsics.checkNotNullParameter((Object)$this$commonForceCache, (String)"<this>");
        return new CacheControl.Builder().onlyIfCached().maxStale-LRDsOJo(DurationKt.toDuration((int)Integer.MAX_VALUE, (DurationUnit)DurationUnit.SECONDS)).build();
    }

    public static final CacheControl commonBuild(CacheControl.Builder $this$commonBuild) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonBuild, (String)"<this>");
        return new CacheControl($this$commonBuild.getNoCache$okhttp(), $this$commonBuild.getNoStore$okhttp(), $this$commonBuild.getMaxAgeSeconds$okhttp(), -1, false, false, false, $this$commonBuild.getMaxStaleSeconds$okhttp(), $this$commonBuild.getMinFreshSeconds$okhttp(), $this$commonBuild.getOnlyIfCached$okhttp(), $this$commonBuild.getNoTransform$okhttp(), builder.getImmutable$okhttp(), null);
    }

    public static final CacheControl.Builder commonNoCache(CacheControl.Builder $this$commonNoCache) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonNoCache, (String)"<this>");
        CacheControl.Builder builder2 = builder;
        builder.setNoCache$okhttp(true);
        return builder;
    }

    public static final CacheControl.Builder commonNoStore(CacheControl.Builder $this$commonNoStore) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonNoStore, (String)"<this>");
        CacheControl.Builder builder2 = builder;
        builder.setNoStore$okhttp(true);
        return builder;
    }

    public static final CacheControl.Builder commonOnlyIfCached(CacheControl.Builder $this$commonOnlyIfCached) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonOnlyIfCached, (String)"<this>");
        CacheControl.Builder builder2 = builder;
        builder.setOnlyIfCached$okhttp(true);
        return builder;
    }

    public static final CacheControl.Builder commonNoTransform(CacheControl.Builder $this$commonNoTransform) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonNoTransform, (String)"<this>");
        CacheControl.Builder builder2 = builder;
        builder.setNoTransform$okhttp(true);
        return builder;
    }

    public static final CacheControl.Builder commonImmutable(CacheControl.Builder $this$commonImmutable) {
        CacheControl.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$commonImmutable, (String)"<this>");
        CacheControl.Builder builder2 = builder;
        builder.setImmutable$okhttp(true);
        return builder;
    }

    /*
     * WARNING - void declaration
     */
    public static final CacheControl commonParse(CacheControl.Companion $this$commonParse, Headers headers2) {
        void var3_4;
        void var2_3;
        void var0_1;
        Intrinsics.checkNotNullParameter((Object)$this$commonParse, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
        boolean noCache = false;
        boolean noStore = false;
        int maxAgeSeconds = -1;
        int sMaxAgeSeconds = -1;
        boolean isPrivate = false;
        boolean isPublic = false;
        boolean mustRevalidate = false;
        int maxStaleSeconds = -1;
        int minFreshSeconds = -1;
        boolean onlyIfCached = false;
        boolean noTransform = false;
        boolean immutable = false;
        boolean canUseHeaderValue = true;
        String headerValue = null;
        int n = headers2.size();
        for (int i = 0; i < n; ++i) {
            String name = headers2.name(i);
            String value = headers2.value(i);
            if (StringsKt.equals((String)name, (String)"Cache-Control", (boolean)true)) {
                if (headerValue != null) {
                    canUseHeaderValue = false;
                } else {
                    headerValue = value;
                }
            } else {
                if (!StringsKt.equals((String)name, (String)"Pragma", (boolean)true)) continue;
                canUseHeaderValue = false;
            }
            int pos = 0;
            while (pos < value.length()) {
                String string;
                int tokenStart = pos;
                pos = _CacheControlCommonKt.indexOfElement(value, "=,;", pos);
                String string2 = value.substring(tokenStart, pos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                String directive = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                if (pos == value.length() || value.charAt(pos) == ',' || value.charAt(pos) == ';') {
                    ++pos;
                    Object parameter = null;
                } else {
                    ++pos;
                    if ((pos = _UtilCommonKt.indexOfNonWhitespace(value, pos)) < value.length() && value.charAt(pos) == '\"') {
                        int parameterStart = ++pos;
                        pos = StringsKt.indexOf$default((CharSequence)value, (char)'\"', (int)pos, (boolean)false, (int)4, null);
                        Intrinsics.checkNotNullExpressionValue((Object)value.substring(parameterStart, pos), (String)"substring(...)");
                        ++pos;
                    } else {
                        int parameterStart = pos;
                        pos = _CacheControlCommonKt.indexOfElement(value, ",;", pos);
                        String string3 = value.substring(parameterStart, pos);
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                        string = ((Object)StringsKt.trim((CharSequence)string3)).toString();
                    }
                }
                if (StringsKt.equals((String)"no-cache", (String)directive, (boolean)true)) {
                    noCache = true;
                    continue;
                }
                if (StringsKt.equals((String)"no-store", (String)directive, (boolean)true)) {
                    noStore = true;
                    continue;
                }
                if (StringsKt.equals((String)"max-age", (String)directive, (boolean)true)) {
                    maxAgeSeconds = _UtilCommonKt.toNonNegativeInt(string, -1);
                    continue;
                }
                if (StringsKt.equals((String)"s-maxage", (String)directive, (boolean)true)) {
                    sMaxAgeSeconds = _UtilCommonKt.toNonNegativeInt(string, -1);
                    continue;
                }
                if (StringsKt.equals((String)"private", (String)directive, (boolean)true)) {
                    isPrivate = true;
                    continue;
                }
                if (StringsKt.equals((String)"public", (String)directive, (boolean)true)) {
                    isPublic = true;
                    continue;
                }
                if (StringsKt.equals((String)"must-revalidate", (String)directive, (boolean)true)) {
                    mustRevalidate = true;
                    continue;
                }
                if (StringsKt.equals((String)"max-stale", (String)directive, (boolean)true)) {
                    maxStaleSeconds = _UtilCommonKt.toNonNegativeInt(string, Integer.MAX_VALUE);
                    continue;
                }
                if (StringsKt.equals((String)"min-fresh", (String)directive, (boolean)true)) {
                    minFreshSeconds = _UtilCommonKt.toNonNegativeInt(string, -1);
                    continue;
                }
                if (StringsKt.equals((String)"only-if-cached", (String)directive, (boolean)true)) {
                    onlyIfCached = true;
                    continue;
                }
                if (StringsKt.equals((String)"no-transform", (String)directive, (boolean)true)) {
                    noTransform = true;
                    continue;
                }
                if (!StringsKt.equals((String)"immutable", (String)directive, (boolean)true)) continue;
                immutable = true;
            }
        }
        if (!canUseHeaderValue) {
            headerValue = null;
        }
        return new CacheControl((boolean)var0_1, (boolean)var2_3, (int)var3_4, sMaxAgeSeconds, isPrivate, isPublic, mustRevalidate, maxStaleSeconds, minFreshSeconds, onlyIfCached, noTransform, immutable, headerValue);
    }

    private static final int indexOfElement(String $this$indexOfElement, String characters, int startIndex) {
        String string;
        int n = $this$indexOfElement.length();
        for (int i = startIndex; i < n; ++i) {
            if (!StringsKt.contains$default((CharSequence)characters, (char)$this$indexOfElement.charAt(i), (boolean)false, (int)2, null)) continue;
            return i;
        }
        return string.length();
    }

    static /* synthetic */ int indexOfElement$default(String string, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        return _CacheControlCommonKt.indexOfElement(string, string2, n);
    }
}

