/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.internal._HostnamesCommonKt;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.http.DateFormattingKt;
import okhttp3.internal.publicsuffix.PublicSuffixDatabase;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 )2\u00020\u0001:\u0002()BY\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\n\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u000fJ\r\u0010\u0007\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u0013J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\r\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\b\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0017J\r\u0010\r\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u0019J\r\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\u001aJ\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dJ\r\u0010\u0002\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\u001eJ\u0006\u0010\u001f\u001a\u00020 J\r\u0010\b\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b!J\r\u0010\f\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b\"J\r\u0010\t\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u0003H\u0016J\u0015\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b&J\r\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b'R\u0013\u0010\u0007\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0010R\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0011R\u0013\u0010\r\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0012R\u0013\u0010\u000b\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0012R\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0010R\u0013\u0010\b\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0010R\u0013\u0010\f\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0012R\u0015\u0010\u000e\u001a\u0004\u0018\u00010\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0013\u0010\t\u001a\u00020\n8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0012R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0010\u00a8\u0006*"}, d2={"Lokhttp3/Cookie;", "", "name", "", "value", "expiresAt", "", "domain", "path", "secure", "", "httpOnly", "persistent", "hostOnly", "sameSite", "(Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;ZZZZLjava/lang/String;)V", "()Ljava/lang/String;", "()J", "()Z", "-deprecated_domain", "equals", "other", "-deprecated_expiresAt", "hashCode", "", "-deprecated_hostOnly", "-deprecated_httpOnly", "matches", "url", "Lokhttp3/HttpUrl;", "-deprecated_name", "newBuilder", "Lokhttp3/Cookie$Builder;", "-deprecated_path", "-deprecated_persistent", "-deprecated_secure", "toString", "forObsoleteRfc2965", "toString$okhttp", "-deprecated_value", "Builder", "Companion", "okhttp"})
public final class Cookie {
    public static final Companion Companion = new Companion(null);
    private final String name;
    private final String value;
    private final long expiresAt;
    private final String domain;
    private final String path;
    private final boolean secure;
    private final boolean httpOnly;
    private final boolean persistent;
    private final boolean hostOnly;
    private final String sameSite;
    private static final Pattern YEAR_PATTERN = Pattern.compile("(\\d{2,4})[^\\d]*");
    private static final Pattern MONTH_PATTERN = Pattern.compile("(?i)(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec).*");
    private static final Pattern DAY_OF_MONTH_PATTERN = Pattern.compile("(\\d{1,2})[^\\d]*");
    private static final Pattern TIME_PATTERN = Pattern.compile("(\\d{1,2}):(\\d{1,2}):(\\d{1,2})[^\\d]*");

    /*
     * WARNING - void declaration
     */
    private Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly, String sameSite) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.name = var1_1;
        this.value = var2_2;
        this.expiresAt = var3_3;
        this.domain = domain;
        this.path = path;
        this.secure = secure;
        this.httpOnly = httpOnly;
        this.persistent = persistent;
        this.hostOnly = hostOnly;
        this.sameSite = sameSite;
    }

    @JvmName(name="name")
    public final String name() {
        return this.name;
    }

    @JvmName(name="value")
    public final String value() {
        return this.value;
    }

    @JvmName(name="expiresAt")
    public final long expiresAt() {
        return this.expiresAt;
    }

    @JvmName(name="domain")
    public final String domain() {
        return this.domain;
    }

    @JvmName(name="path")
    public final String path() {
        return this.path;
    }

    @JvmName(name="secure")
    public final boolean secure() {
        return this.secure;
    }

    @JvmName(name="httpOnly")
    public final boolean httpOnly() {
        return this.httpOnly;
    }

    @JvmName(name="persistent")
    public final boolean persistent() {
        return this.persistent;
    }

    @JvmName(name="hostOnly")
    public final boolean hostOnly() {
        return this.hostOnly;
    }

    @JvmName(name="sameSite")
    public final String sameSite() {
        return this.sameSite;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean matches(HttpUrl url) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        boolean bl = this.hostOnly ? Intrinsics.areEqual((Object)url.host(), (Object)this.domain) : okhttp3.Cookie$Companion.access$domainMatch(Companion, url.host(), this.domain);
        if (!bl) {
            return false;
        }
        if (!okhttp3.Cookie$Companion.access$pathMatch(Companion, url, this.path)) {
            return false;
        }
        return !this.secure || var1_1.isHttps();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        void var1_1;
        return other instanceof Cookie && Intrinsics.areEqual((Object)((Cookie)other).name, (Object)this.name) && Intrinsics.areEqual((Object)((Cookie)other).value, (Object)this.value) && ((Cookie)other).expiresAt == this.expiresAt && Intrinsics.areEqual((Object)((Cookie)other).domain, (Object)this.domain) && Intrinsics.areEqual((Object)((Cookie)other).path, (Object)this.path) && ((Cookie)other).secure == this.secure && ((Cookie)other).httpOnly == this.httpOnly && ((Cookie)other).persistent == this.persistent && ((Cookie)other).hostOnly == this.hostOnly && Intrinsics.areEqual((Object)((Cookie)var1_1).sameSite, (Object)this.sameSite);
    }

    /*
     * WARNING - void declaration
     */
    @IgnoreJRERequirement
    public final int hashCode() {
        void var1_1;
        int result = 527 + this.name.hashCode();
        result = result * 31 + this.value.hashCode();
        result = result * 31 + Long.hashCode(this.expiresAt);
        result = result * 31 + this.domain.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + Boolean.hashCode(this.secure);
        result = result * 31 + Boolean.hashCode(this.httpOnly);
        result = result * 31 + Boolean.hashCode(this.persistent);
        result = result * 31 + Boolean.hashCode(this.hostOnly);
        String string = this.sameSite;
        var1_1 = var1_1 * 31 + (string != null ? string.hashCode() : 0);
        return (int)var1_1;
    }

    public final String toString() {
        return this.toString$okhttp(false);
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="name", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_name")
    public final String -deprecated_name() {
        return this.name;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="value", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_value")
    public final String -deprecated_value() {
        return this.value;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="persistent", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_persistent")
    public final boolean -deprecated_persistent() {
        return this.persistent;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="expiresAt", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_expiresAt")
    public final long -deprecated_expiresAt() {
        return this.expiresAt;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="hostOnly", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_hostOnly")
    public final boolean -deprecated_hostOnly() {
        return this.hostOnly;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="domain", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_domain")
    public final String -deprecated_domain() {
        return this.domain;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="path", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_path")
    public final String -deprecated_path() {
        return this.path;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="httpOnly", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_httpOnly")
    public final boolean -deprecated_httpOnly() {
        return this.httpOnly;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="secure", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_secure")
    public final boolean -deprecated_secure() {
        return this.secure;
    }

    /*
     * WARNING - void declaration
     */
    public final String toString$okhttp(boolean forObsoleteRfc2965) {
        void var2_2;
        StringBuilder $this$toString_u24lambda_u240 = new StringBuilder();
        $this$toString_u24lambda_u240.append(this.name);
        $this$toString_u24lambda_u240.append('=');
        $this$toString_u24lambda_u240.append(this.value);
        if (this.persistent) {
            if (this.expiresAt == Long.MIN_VALUE) {
                $this$toString_u24lambda_u240.append("; max-age=0");
            } else {
                $this$toString_u24lambda_u240.append("; expires=").append(DateFormattingKt.toHttpDateString(new Date(this.expiresAt)));
            }
        }
        if (!this.hostOnly) {
            void var1_1;
            $this$toString_u24lambda_u240.append("; domain=");
            if (var1_1 != false) {
                $this$toString_u24lambda_u240.append(".");
            }
            $this$toString_u24lambda_u240.append(this.domain);
        }
        $this$toString_u24lambda_u240.append("; path=").append(this.path);
        if (this.secure) {
            $this$toString_u24lambda_u240.append("; secure");
        }
        if (this.httpOnly) {
            $this$toString_u24lambda_u240.append("; httponly");
        }
        if (this.sameSite != null) {
            $this$toString_u24lambda_u240.append("; samesite=").append(this.sameSite);
        }
        String string = var2_2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    public final Builder newBuilder() {
        return new Builder(this);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final Cookie parse(HttpUrl url, String setCookie) {
        void var1_1;
        HttpUrl httpUrl;
        return Companion.parse(httpUrl, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final List<Cookie> parseAll(HttpUrl url, Headers headers2) {
        void var1_1;
        HttpUrl httpUrl;
        return Companion.parseAll(httpUrl, (Headers)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ Cookie(String name, String value, long expiresAt, String domain, String path, boolean secure, boolean httpOnly, boolean persistent, boolean hostOnly, String sameSite, DefaultConstructorMarker $constructor_marker) {
        this((String)var1_1, (String)var2_2, (long)var3_3, domain, path, secure, httpOnly, persistent, hostOnly, sameSite);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u0006\u0010\f\u001a\u00020\u0000J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0007J\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0007J\u0006\u0010\u0011\u001a\u00020\u0000J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0007R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lokhttp3/Cookie$Builder;", "", "cookie", "Lokhttp3/Cookie;", "(Lokhttp3/Cookie;)V", "()V", "domain", "", "expiresAt", "", "hostOnly", "", "httpOnly", "name", "path", "persistent", "sameSite", "secure", "value", "build", "hostOnlyDomain", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nCookie.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cookie.kt\nokhttp3/Cookie$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,723:1\n1#2:724\n*E\n"})
    public static final class Builder {
        private String name;
        private String value;
        private long expiresAt;
        private String domain;
        private String path;
        private boolean secure;
        private boolean httpOnly;
        private boolean persistent;
        private boolean hostOnly;
        private String sameSite;

        public Builder() {
            this.expiresAt = 253402300799999L;
            this.path = "/";
        }

        /*
         * WARNING - void declaration
         */
        public Builder(Cookie cookie) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
            this();
            this.name = cookie.name();
            this.value = cookie.value();
            this.expiresAt = cookie.expiresAt();
            this.domain = cookie.domain();
            this.path = cookie.path();
            this.secure = cookie.secure();
            this.httpOnly = cookie.httpOnly();
            this.persistent = cookie.persistent();
            this.hostOnly = cookie.hostOnly();
            this.sameSite = var1_1.sameSite();
        }

        /*
         * WARNING - void declaration
         */
        public final Builder name(String name) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Builder $this$name_u24lambda_u241 = builder = this;
            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)name)).toString(), (Object)name)) {
                name = "name is not trimmed";
                throw new IllegalArgumentException(name.toString());
            }
            var3_3.name = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder value(String value) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Builder $this$value_u24lambda_u243 = builder = this;
            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)value)).toString(), (Object)value)) {
                value = "value is not trimmed";
                throw new IllegalArgumentException(value.toString());
            }
            var3_3.value = var1_1;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder expiresAt(long expiresAt) {
            void var1_1;
            Builder builder;
            Builder $this$expiresAt_u24lambda_u244 = builder = this;
            long expiresAt2 = var1_1;
            if (expiresAt2 <= 0L) {
                expiresAt2 = Long.MIN_VALUE;
            }
            if (expiresAt2 > 253402300799999L) {
                expiresAt2 = 253402300799999L;
            }
            $this$expiresAt_u24lambda_u244.expiresAt = expiresAt2;
            $this$expiresAt_u24lambda_u244.persistent = true;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder domain(String domain) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            return this.domain((String)var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder hostOnlyDomain(String domain) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
            return this.domain((String)var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        private final Builder domain(String domain, boolean hostOnly) {
            void var2_2;
            void var1_1;
            Builder builder;
            Builder $this$domain_u24lambda_u245 = builder = this;
            String string = _HostnamesCommonKt.toCanonicalHost(domain);
            if (string == null) {
                throw new IllegalArgumentException("unexpected domain: " + domain);
            }
            String canonicalDomain = string;
            $this$domain_u24lambda_u245.domain = var1_1;
            $this$domain_u24lambda_u245.hostOnly = var2_2;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder path(String path) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Builder $this$path_u24lambda_u247 = builder = this;
            if (!StringsKt.startsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                path = "path must start with '/'";
                throw new IllegalArgumentException(path.toString());
            }
            var3_3.path = var1_1;
            return builder;
        }

        public final Builder secure() {
            Builder builder;
            Builder builder2 = builder = this;
            builder.secure = true;
            return builder;
        }

        public final Builder httpOnly() {
            Builder builder;
            Builder builder2 = builder = this;
            builder.httpOnly = true;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder sameSite(String sameSite) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)sameSite, (String)"sameSite");
            Builder $this$sameSite_u24lambda_u2411 = builder = this;
            if (!Intrinsics.areEqual((Object)((Object)StringsKt.trim((CharSequence)sameSite)).toString(), (Object)sameSite)) {
                sameSite = "sameSite is not trimmed";
                throw new IllegalArgumentException(sameSite.toString());
            }
            var3_3.sameSite = var1_1;
            return builder;
        }

        public final Cookie build() {
            String string = this.name;
            if (string == null) {
                throw new NullPointerException("builder.name == null");
            }
            String string2 = this.value;
            if (string2 == null) {
                throw new NullPointerException("builder.value == null");
            }
            String string3 = this.domain;
            if (string3 == null) {
                throw new NullPointerException("builder.domain == null");
            }
            return new Cookie(string, string2, this.expiresAt, string3, this.path, this.secure, this.httpOnly, this.persistent, this.hostOnly, this.sameSite, null);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0002J'\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u001bJ\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\fH\u0007J\u001e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0010\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\fH\u0002J \u0010\"\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0002J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010!\u001a\u00020\fH\u0002J\u0018\u0010$\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\fH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lokhttp3/Cookie$Companion;", "", "()V", "DAY_OF_MONTH_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "MONTH_PATTERN", "TIME_PATTERN", "YEAR_PATTERN", "dateCharacterOffset", "", "input", "", "pos", "limit", "invert", "", "domainMatch", "urlHost", "domain", "parse", "Lokhttp3/Cookie;", "currentTimeMillis", "", "url", "Lokhttp3/HttpUrl;", "setCookie", "parse$okhttp", "parseAll", "", "headers", "Lokhttp3/Headers;", "parseDomain", "s", "parseExpires", "parseMaxAge", "pathMatch", "path", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final boolean domainMatch(String urlHost, String domain) {
            if (Intrinsics.areEqual((Object)urlHost, (Object)domain)) {
                return true;
            }
            if (StringsKt.endsWith$default((String)urlHost, (String)domain, (boolean)false, (int)2, null)) {
                void var1_1;
                void var2_2;
                String string = urlHost;
                if (string.charAt(string.length() - var2_2.length() - 1) == '.' && !_HostnamesCommonKt.canParseAsIpAddress((String)var1_1)) {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        private final boolean pathMatch(HttpUrl url, String path) {
            String urlPath = url.encodedPath();
            if (Intrinsics.areEqual((Object)urlPath, (Object)path)) {
                return true;
            }
            if (StringsKt.startsWith$default((String)urlPath, (String)path, (boolean)false, (int)2, null)) {
                void var2_2;
                void var1_1;
                if (StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
                    return true;
                }
                if (var1_1.charAt(var2_2.length()) == '/') {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Cookie parse(HttpUrl url, String setCookie) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)setCookie, (String)"setCookie");
            return this.parse$okhttp(System.currentTimeMillis(), (HttpUrl)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public final Cookie parse$okhttp(long currentTimeMillis, HttpUrl url, String setCookie) {
            void var1_1;
            long deltaMilliseconds;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)setCookie, (String)"setCookie");
            int cookiePairEnd = _UtilCommonKt.delimiterOffset$default(setCookie, ';', 0, 0, 6, null);
            int pairEqualsSign = _UtilCommonKt.delimiterOffset$default(setCookie, '=', 0, cookiePairEnd, 2, null);
            if (pairEqualsSign == cookiePairEnd) {
                return null;
            }
            String cookieName = _UtilCommonKt.trimSubstring$default(setCookie, 0, pairEqualsSign, 1, null);
            if (((CharSequence)cookieName).length() == 0 || _UtilCommonKt.indexOfControlOrNonAscii(cookieName) != -1) {
                return null;
            }
            String cookieValue = _UtilCommonKt.trimSubstring(setCookie, pairEqualsSign + 1, cookiePairEnd);
            if (_UtilCommonKt.indexOfControlOrNonAscii(cookieValue) != -1) {
                return null;
            }
            long expiresAt = 253402300799999L;
            long deltaSeconds = -1L;
            String domain = null;
            String path = null;
            boolean secureOnly = false;
            boolean httpOnly = false;
            boolean hostOnly = true;
            boolean persistent = false;
            String sameSite = null;
            int pos = cookiePairEnd + 1;
            int limit = setCookie.length();
            while (pos < limit) {
                String attributeValue;
                int attributePairEnd = _UtilCommonKt.delimiterOffset(setCookie, ';', pos, limit);
                int attributeEqualsSign = _UtilCommonKt.delimiterOffset(setCookie, '=', pos, attributePairEnd);
                String attributeName22 = _UtilCommonKt.trimSubstring(setCookie, pos, attributeEqualsSign);
                String string = attributeValue = attributeEqualsSign < attributePairEnd ? _UtilCommonKt.trimSubstring(setCookie, attributeEqualsSign + 1, attributePairEnd) : "";
                if (StringsKt.equals((String)attributeName22, (String)"expires", (boolean)true)) {
                    try {
                        expiresAt = this.parseExpires(attributeValue, 0, attributeValue.length());
                        persistent = true;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals((String)attributeName22, (String)"max-age", (boolean)true)) {
                    try {
                        deltaSeconds = this.parseMaxAge(attributeValue);
                        persistent = true;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (StringsKt.equals((String)attributeName22, (String)"domain", (boolean)true)) {
                    try {
                        domain = this.parseDomain(attributeValue);
                        hostOnly = false;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                } else if (StringsKt.equals((String)attributeName22, (String)"path", (boolean)true)) {
                    path = attributeValue;
                } else if (StringsKt.equals((String)attributeName22, (String)"secure", (boolean)true)) {
                    secureOnly = true;
                } else if (StringsKt.equals((String)attributeName22, (String)"httponly", (boolean)true)) {
                    httpOnly = true;
                } else if (StringsKt.equals((String)attributeName22, (String)"samesite", (boolean)true)) {
                    sameSite = attributeValue;
                }
                int attributeName22 = attributePairEnd + 1;
            }
            if (deltaSeconds == Long.MIN_VALUE) {
                expiresAt = Long.MIN_VALUE;
            } else if (deltaSeconds != -1L && ((expiresAt = currentTimeMillis + (deltaMilliseconds = deltaSeconds <= 9223372036854775L ? deltaSeconds * 1000L : Long.MAX_VALUE)) < var1_1 || expiresAt > 253402300799999L)) {
                expiresAt = 253402300799999L;
            }
            String urlHost = url.host();
            if (domain == null) {
                domain = urlHost;
            } else if (!this.domainMatch(urlHost, domain)) {
                return null;
            }
            if (urlHost.length() != domain.length() && PublicSuffixDatabase.Companion.get().getEffectiveTldPlusOne(domain) == null) {
                return null;
            }
            if (path == null || !StringsKt.startsWith$default(path, (String)"/", (boolean)false, (int)2, null)) {
                String string;
                void var3_2;
                String encodedPath = var3_2.encodedPath();
                int lastSlash = StringsKt.lastIndexOf$default((CharSequence)encodedPath, (char)'/', (int)0, (boolean)false, (int)6, null);
                if (lastSlash != 0) {
                    String string2 = encodedPath.substring(0, lastSlash);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                } else {
                    string = "/";
                }
                path = string;
            }
            return new Cookie(cookieName, cookieValue, expiresAt, domain, path, secureOnly, httpOnly, persistent, hostOnly, sameSite, null);
        }

        /*
         * WARNING - void declaration
         */
        private final long parseExpires(String s, int pos, int limit) {
            void var2_10;
            pos = this.dateCharacterOffset(s, pos, limit, false);
            int hour = -1;
            int minute = -1;
            int second = -1;
            int dayOfMonth = -1;
            int month = -1;
            int year = -1;
            Matcher matcher = TIME_PATTERN.matcher(s);
            while (pos < limit) {
                int end = this.dateCharacterOffset(s, pos + 1, limit, true);
                matcher.region(pos, end);
                if (hour == -1 && matcher.usePattern(TIME_PATTERN).matches()) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    hour = Integer.parseInt(string);
                    String string2 = matcher.group(2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
                    minute = Integer.parseInt(string2);
                    String string3 = matcher.group(3);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"group(...)");
                    second = Integer.parseInt(string3);
                } else if (dayOfMonth == -1 && matcher.usePattern(DAY_OF_MONTH_PATTERN).matches()) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    dayOfMonth = Integer.parseInt(string);
                } else if (month == -1 && matcher.usePattern(MONTH_PATTERN).matches()) {
                    String monthString;
                    Intrinsics.checkNotNullExpressionValue((Object)matcher.group(1), (String)"group(...)");
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"US");
                    Intrinsics.checkNotNullExpressionValue((Object)pos.toLowerCase(locale), (String)"toLowerCase(...)");
                    String string = MONTH_PATTERN.pattern();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"pattern(...)");
                    month = StringsKt.indexOf$default((CharSequence)string, (String)monthString, (int)0, (boolean)false, (int)6, null) / 4;
                } else if (year == -1 && matcher.usePattern(YEAR_PATTERN).matches()) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    year = Integer.parseInt(string);
                }
                int monthString = this.dateCharacterOffset(s, end + 1, limit, false);
            }
            boolean bl = 70 <= year ? year < 100 : false;
            if (bl) {
                year += 1900;
            }
            boolean bl2 = year >= 0 ? year < 70 : false;
            if (bl2) {
                year += 2000;
            }
            if (!(year >= 1601)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(month != -1)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(dayOfMonth > 0 ? dayOfMonth < 32 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(hour >= 0 ? hour < 24 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(minute >= 0 ? minute < 60 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            if (!(second >= 0 ? second < 60 : false)) {
                String monthString = "Failed requirement.";
                throw new IllegalArgumentException(monthString.toString());
            }
            GregorianCalendar $this$parseExpires_u24lambda_u240 = new GregorianCalendar(_UtilJvmKt.UTC);
            $this$parseExpires_u24lambda_u240.setLenient(false);
            $this$parseExpires_u24lambda_u240.set(1, year);
            $this$parseExpires_u24lambda_u240.set(2, month - 1);
            $this$parseExpires_u24lambda_u240.set(5, dayOfMonth);
            $this$parseExpires_u24lambda_u240.set(11, hour);
            $this$parseExpires_u24lambda_u240.set(12, minute);
            $this$parseExpires_u24lambda_u240.set(13, second);
            $this$parseExpires_u24lambda_u240.set(14, 0);
            return var2_10.getTimeInMillis();
        }

        /*
         * Unable to fully structure code
         */
        private final int dateCharacterOffset(String input, int pos, int limit, boolean invert) {
            for (i = pos; i < limit; ++i) {
                c = input.charAt(i);
                if (c < ' ' && c != '\t' || c >= '\u007f') ** GOTO lbl-1000
                if ('0' <= c ? c < ':' : false) ** GOTO lbl-1000
                if ('a' <= c ? c < '{' : false) ** GOTO lbl-1000
                v0 = 'A' <= c ? c < '[' : false;
                if (v0 || c == ':') lbl-1000:
                // 4 sources

                {
                    v1 = true;
                } else {
                    v1 = var5_5 = false;
                }
                if (v1 != (invert == false)) continue;
                return i;
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        private final long parseMaxAge(String s) {
            try {
                long parsed = Long.parseLong(s);
                if (parsed <= 0L) {
                    return Long.MIN_VALUE;
                }
                return parsed;
            }
            catch (NumberFormatException e) {
                void var2_3;
                CharSequence charSequence = s;
                if (new Regex("-?\\d+").matches(charSequence)) {
                    void var1_1;
                    if (StringsKt.startsWith$default((String)var1_1, (String)"-", (boolean)false, (int)2, null)) {
                        return Long.MIN_VALUE;
                    }
                    return Long.MAX_VALUE;
                }
                throw var2_3;
            }
        }

        /*
         * WARNING - void declaration
         */
        private final String parseDomain(String s) {
            void var1_1;
            if (!(!StringsKt.endsWith$default((String)s, (String)".", (boolean)false, (int)2, null))) {
                s = "Failed requirement.";
                throw new IllegalArgumentException(s.toString());
            }
            String string = _HostnamesCommonKt.toCanonicalHost(StringsKt.removePrefix((String)var1_1, (CharSequence)"."));
            if (string == null) {
                throw new IllegalArgumentException();
            }
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final List<Cookie> parseAll(HttpUrl url, Headers headers2) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)headers2, (String)"headers");
            List<String> cookieStrings = headers2.values("Set-Cookie");
            List cookies = null;
            int n = cookieStrings.size();
            for (int i = 0; i < n; ++i) {
                Cookie cookie;
                if (this.parse(url, cookieStrings.get(i)) == null) continue;
                if (cookies == null) {
                    cookies = new ArrayList();
                }
                cookies.add(cookie);
            }
            if (cookies != null) {
                void var3_3;
                List<Cookie> list = Collections.unmodifiableList(var3_3);
                Intrinsics.checkNotNull(list);
                return list;
            }
            return CollectionsKt.emptyList();
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$domainMatch(Companion $this, String urlHost, String domain) {
            void var2_2;
            void var1_1;
            return $this.domainMatch((String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public static final /* synthetic */ boolean access$pathMatch(Companion $this, HttpUrl url, String path) {
            void var2_2;
            void var1_1;
            return $this.pathMatch((HttpUrl)var1_1, (String)var2_2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

