/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.net.ssl.SSLSocket;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.CipherSuite;
import okhttp3.TlsVersion;
import okhttp3.internal.Internal;
import okhttp3.internal._UtilCommonKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\u0018\u0000 &2\u00020\u0001:\u0002%&B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\tJ\u001d\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0019J\u0015\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\b\u001aJ\u0013\u0010\u001b\u001a\u00020\u00032\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u000e\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u0017J\u0018\u0010!\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0003H\u0002J\r\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0002\b\"J\u0015\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000bH\u0007\u00a2\u0006\u0002\b#J\b\u0010$\u001a\u00020\u0007H\u0016R\u0019\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\rR\u001e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0080\u0004\u00a2\u0006\n\n\u0002\u0010\u0010\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0002\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0011R\u0013\u0010\u0004\u001a\u00020\u00038\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0011R\u0019\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u000b8G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\rR\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006'"}, d2={"Lokhttp3/ConnectionSpec;", "", "isTls", "", "supportsTlsExtensions", "cipherSuitesAsString", "", "", "tlsVersionsAsString", "(ZZ[Ljava/lang/String;[Ljava/lang/String;)V", "cipherSuites", "", "Lokhttp3/CipherSuite;", "()Ljava/util/List;", "getCipherSuitesAsString$okhttp", "()[Ljava/lang/String;", "[Ljava/lang/String;", "()Z", "tlsVersions", "Lokhttp3/TlsVersion;", "apply", "", "sslSocket", "Ljavax/net/ssl/SSLSocket;", "isFallback", "apply$okhttp", "-deprecated_cipherSuites", "equals", "other", "hashCode", "", "isCompatible", "socket", "supportedSpec", "-deprecated_supportsTlsExtensions", "-deprecated_tlsVersions", "toString", "Builder", "Companion", "okhttp"})
@SourceDebugExtension(value={"SMAP\nConnectionSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,384:1\n11065#2:385\n11400#2,3:386\n11065#2:389\n11400#2,3:390\n37#3,2:393\n37#3,2:395\n37#3,2:397\n*S KotlinDebug\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec\n*L\n60#1:385\n60#1:386,3\n78#1:389\n78#1:390,3\n349#1:393,2\n361#1:395,2\n374#1:397,2\n*E\n"})
public final class ConnectionSpec {
    public static final Companion Companion = new Companion(null);
    private final boolean isTls;
    private final boolean supportsTlsExtensions;
    private final String[] cipherSuitesAsString;
    private final String[] tlsVersionsAsString;
    private static final List<CipherSuite> RESTRICTED_CIPHER_SUITES;
    private static final List<CipherSuite> APPROVED_CIPHER_SUITES;
    @JvmField
    public static final ConnectionSpec RESTRICTED_TLS;
    @JvmField
    public static final ConnectionSpec MODERN_TLS;
    @JvmField
    public static final ConnectionSpec COMPATIBLE_TLS;
    @JvmField
    public static final ConnectionSpec CLEARTEXT;

    /*
     * WARNING - void declaration
     */
    public ConnectionSpec(boolean isTls, boolean supportsTlsExtensions, String[] cipherSuitesAsString, String[] tlsVersionsAsString) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.isTls = var1_1;
        this.supportsTlsExtensions = var2_2;
        this.cipherSuitesAsString = var3_3;
        this.tlsVersionsAsString = tlsVersionsAsString;
    }

    @JvmName(name="isTls")
    public final boolean isTls() {
        return this.isTls;
    }

    @JvmName(name="supportsTlsExtensions")
    public final boolean supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    public final String[] getCipherSuitesAsString$okhttp() {
        return this.cipherSuitesAsString;
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="cipherSuites")
    public final List<CipherSuite> cipherSuites() {
        if (this.cipherSuitesAsString != null) {
            void var1_1;
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = this.cipherSuitesAsString;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(CipherSuite.Companion.forJavaName((String)it));
            }
            return (List)var1_1;
        }
        return null;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="cipherSuites", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_cipherSuites")
    public final List<CipherSuite> -deprecated_cipherSuites() {
        return this.cipherSuites();
    }

    /*
     * WARNING - void declaration
     */
    @JvmName(name="tlsVersions")
    public final List<TlsVersion> tlsVersions() {
        if (this.tlsVersionsAsString != null) {
            void var1_1;
            void $this$mapTo$iv$iv;
            String[] $this$map$iv = this.tlsVersionsAsString;
            String[] stringArray = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(TlsVersion.Companion.forJavaName((String)it));
            }
            return (List)var1_1;
        }
        return null;
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="tlsVersions", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_tlsVersions")
    public final List<TlsVersion> -deprecated_tlsVersions() {
        return this.tlsVersions();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="supportsTlsExtensions", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_supportsTlsExtensions")
    public final boolean -deprecated_supportsTlsExtensions() {
        return this.supportsTlsExtensions;
    }

    /*
     * WARNING - void declaration
     */
    public final void apply$okhttp(SSLSocket sslSocket, boolean isFallback) {
        Intrinsics.checkNotNullParameter((Object)sslSocket, (String)"sslSocket");
        ConnectionSpec specToApply = this.supportedSpec(sslSocket, isFallback);
        if (specToApply.tlsVersions() != null) {
            sslSocket.setEnabledProtocols(specToApply.tlsVersionsAsString);
        }
        if (specToApply.cipherSuites() != null) {
            void var2_3;
            void var1_1;
            var1_1.setEnabledCipherSuites(var2_3.cipherSuitesAsString);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ConnectionSpec supportedSpec(SSLSocket sslSocket, boolean isFallback) {
        void var3_3;
        String[] stringArray;
        void var2_2;
        String[] stringArray2;
        String[] socketEnabledCipherSuites = sslSocket.getEnabledCipherSuites();
        Intrinsics.checkNotNull((Object)socketEnabledCipherSuites);
        String[] cipherSuitesIntersection = Internal.effectiveCipherSuites(this, socketEnabledCipherSuites);
        if (this.tlsVersionsAsString != null) {
            String[] stringArray3 = sslSocket.getEnabledProtocols();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray3, (String)"getEnabledProtocols(...)");
            stringArray2 = _UtilCommonKt.intersect(stringArray3, this.tlsVersionsAsString, ComparisonsKt.naturalOrder());
        } else {
            stringArray2 = sslSocket.getEnabledProtocols();
        }
        String[] tlsVersionsIntersection = stringArray2;
        String[] supportedCipherSuites = sslSocket.getSupportedCipherSuites();
        Intrinsics.checkNotNull((Object)supportedCipherSuites);
        int indexOfFallbackScsv = _UtilCommonKt.indexOf(supportedCipherSuites, "TLS_FALLBACK_SCSV", CipherSuite.Companion.getORDER_BY_NAME$okhttp());
        if (var2_2 != false && indexOfFallbackScsv != -1) {
            void v2 = stringArray[indexOfFallbackScsv];
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"get(...)");
            cipherSuitesIntersection = _UtilCommonKt.concat(cipherSuitesIntersection, (String)v2);
        }
        void v3 = var3_3;
        Builder builder = new Builder(this).cipherSuites((String[])Arrays.copyOf(v3, ((void)v3).length));
        Intrinsics.checkNotNull((Object)tlsVersionsIntersection);
        stringArray = tlsVersionsIntersection;
        return builder.tlsVersions(Arrays.copyOf(tlsVersionsIntersection, stringArray.length)).build();
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isCompatible(SSLSocket socket) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
        if (!this.isTls) {
            return false;
        }
        if (this.tlsVersionsAsString != null && !_UtilCommonKt.hasIntersection(this.tlsVersionsAsString, socket.getEnabledProtocols(), ComparisonsKt.naturalOrder())) {
            return false;
        }
        return this.cipherSuitesAsString == null || _UtilCommonKt.hasIntersection(this.cipherSuitesAsString, var1_1.getEnabledCipherSuites(), CipherSuite.Companion.getORDER_BY_NAME$okhttp());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object other) {
        if (!(other instanceof ConnectionSpec)) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.isTls != ((ConnectionSpec)other).isTls) {
            return false;
        }
        if (this.isTls) {
            void var1_1;
            if (!Arrays.equals(this.cipherSuitesAsString, ((ConnectionSpec)other).cipherSuitesAsString)) {
                return false;
            }
            if (!Arrays.equals(this.tlsVersionsAsString, ((ConnectionSpec)other).tlsVersionsAsString)) {
                return false;
            }
            if (this.supportsTlsExtensions != ((ConnectionSpec)var1_1).supportsTlsExtensions) {
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var1_1;
        int result = 17;
        if (this.isTls) {
            result = 527 + (this.cipherSuitesAsString != null ? Arrays.hashCode(this.cipherSuitesAsString) : 0);
            result = result * 31 + (this.tlsVersionsAsString != null ? Arrays.hashCode(this.tlsVersionsAsString) : 0);
            result = result * 31 + (this.supportsTlsExtensions ? 0 : 1);
        }
        return (int)var1_1;
    }

    public final String toString() {
        if (!this.isTls) {
            return "ConnectionSpec()";
        }
        return "ConnectionSpec(cipherSuites=" + Objects.toString(this.cipherSuites(), "[all enabled]") + ", tlsVersions=" + Objects.toString(this.tlsVersions(), "[all enabled]") + ", supportsTlsExtensions=" + this.supportsTlsExtensions + ')';
    }

    static {
        Object[] objectArray = new CipherSuite[9];
        Object object = objectArray;
        objectArray[0] = CipherSuite.TLS_AES_128_GCM_SHA256;
        object[1] = CipherSuite.TLS_AES_256_GCM_SHA384;
        object[2] = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        object[3] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        object[4] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        object[5] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        object[6] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        object[7] = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        object[8] = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        RESTRICTED_CIPHER_SUITES = CollectionsKt.listOf((Object[])object);
        CipherSuite[] cipherSuiteArray = new CipherSuite[16];
        object = cipherSuiteArray;
        cipherSuiteArray[0] = CipherSuite.TLS_AES_128_GCM_SHA256;
        object[1] = CipherSuite.TLS_AES_256_GCM_SHA384;
        object[2] = CipherSuite.TLS_CHACHA20_POLY1305_SHA256;
        object[3] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256;
        object[4] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256;
        object[5] = CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384;
        object[6] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384;
        object[7] = CipherSuite.TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305_SHA256;
        object[8] = CipherSuite.TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305_SHA256;
        object[9] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA;
        object[10] = CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA;
        object[11] = CipherSuite.TLS_RSA_WITH_AES_128_GCM_SHA256;
        object[12] = CipherSuite.TLS_RSA_WITH_AES_256_GCM_SHA384;
        object[13] = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
        object[14] = CipherSuite.TLS_RSA_WITH_AES_256_CBC_SHA;
        object[15] = CipherSuite.TLS_RSA_WITH_3DES_EDE_CBC_SHA;
        APPROVED_CIPHER_SUITES = CollectionsKt.listOf((Object[])object);
        Collection collection = RESTRICTED_CIPHER_SUITES;
        object = collection;
        object = collection;
        object = collection.toArray(new CipherSuite[0]);
        Builder builder = new Builder(true).cipherSuites(Arrays.copyOf(object, ((Object[])object).length));
        TlsVersion[] tlsVersionArray = new TlsVersion[2];
        object = tlsVersionArray;
        tlsVersionArray[0] = TlsVersion.TLS_1_3;
        object[1] = TlsVersion.TLS_1_2;
        RESTRICTED_TLS = builder.tlsVersions((TlsVersion[])object).supportsTlsExtensions(true).build();
        Collection collection2 = APPROVED_CIPHER_SUITES;
        object = collection2;
        object = collection2;
        object = collection2.toArray(new CipherSuite[0]);
        Builder builder2 = new Builder(true).cipherSuites(Arrays.copyOf(object, ((Object[])object).length));
        TlsVersion[] tlsVersionArray2 = new TlsVersion[2];
        object = tlsVersionArray2;
        tlsVersionArray2[0] = TlsVersion.TLS_1_3;
        object[1] = TlsVersion.TLS_1_2;
        MODERN_TLS = builder2.tlsVersions((TlsVersion[])object).supportsTlsExtensions(true).build();
        Collection collection3 = APPROVED_CIPHER_SUITES;
        object = collection3;
        object = collection3;
        object = collection3.toArray(new CipherSuite[0]);
        Builder builder3 = new Builder(true).cipherSuites(Arrays.copyOf(object, ((Object[])object).length));
        TlsVersion[] tlsVersionArray3 = new TlsVersion[4];
        object = tlsVersionArray3;
        tlsVersionArray3[0] = TlsVersion.TLS_1_3;
        object[1] = TlsVersion.TLS_1_2;
        object[2] = TlsVersion.TLS_1_1;
        object[3] = TlsVersion.TLS_1_0;
        COMPATIBLE_TLS = builder3.tlsVersions((TlsVersion[])object).supportsTlsExtensions(true).build();
        CLEARTEXT = new Builder(false).build();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\u0019\u001a\u00020\u0000J\u0006\u0010\u001a\u001a\u00020\u0000J\u0006\u0010\u001b\u001a\u00020\u0006J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001d0\t\"\u00020\u001d\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0003H\u0007J\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n0\t\"\u00020\n\u00a2\u0006\u0002\u0010\u001cJ\u001f\u0010\u0016\u001a\u00020\u00002\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\t\"\u00020\u001f\u00a2\u0006\u0002\u0010 R$\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0012\"\u0004\b\u0015\u0010\u0004R$\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0080\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u0017\u0010\f\"\u0004\b\u0018\u0010\u000e\u00a8\u0006!"}, d2={"Lokhttp3/ConnectionSpec$Builder;", "", "tls", "", "(Z)V", "connectionSpec", "Lokhttp3/ConnectionSpec;", "(Lokhttp3/ConnectionSpec;)V", "cipherSuites", "", "", "getCipherSuites$okhttp", "()[Ljava/lang/String;", "setCipherSuites$okhttp", "([Ljava/lang/String;)V", "[Ljava/lang/String;", "supportsTlsExtensions", "getSupportsTlsExtensions$okhttp", "()Z", "setSupportsTlsExtensions$okhttp", "getTls$okhttp", "setTls$okhttp", "tlsVersions", "getTlsVersions$okhttp", "setTlsVersions$okhttp", "allEnabledCipherSuites", "allEnabledTlsVersions", "build", "([Ljava/lang/String;)Lokhttp3/ConnectionSpec$Builder;", "Lokhttp3/CipherSuite;", "([Lokhttp3/CipherSuite;)Lokhttp3/ConnectionSpec$Builder;", "Lokhttp3/TlsVersion;", "([Lokhttp3/TlsVersion;)Lokhttp3/ConnectionSpec$Builder;", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nConnectionSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,384:1\n1#2:385\n11065#3:386\n11400#3,3:387\n11065#3:392\n11400#3,3:393\n37#4,2:390\n37#4,2:396\n*S KotlinDebug\n*F\n+ 1 ConnectionSpec.kt\nokhttp3/ConnectionSpec$Builder\n*L\n247#1:386\n247#1:387,3\n269#1:392\n269#1:393,3\n247#1:390,2\n269#1:396,2\n*E\n"})
    public static final class Builder {
        private boolean tls;
        private String[] cipherSuites;
        private String[] tlsVersions;
        private boolean supportsTlsExtensions;

        public final boolean getTls$okhttp() {
            return this.tls;
        }

        /*
         * WARNING - void declaration
         */
        public final void setTls$okhttp(boolean bl) {
            void var1_1;
            this.tls = var1_1;
        }

        public final String[] getCipherSuites$okhttp() {
            return this.cipherSuites;
        }

        /*
         * WARNING - void declaration
         */
        public final void setCipherSuites$okhttp(String[] stringArray) {
            void var1_1;
            this.cipherSuites = var1_1;
        }

        public final String[] getTlsVersions$okhttp() {
            return this.tlsVersions;
        }

        /*
         * WARNING - void declaration
         */
        public final void setTlsVersions$okhttp(String[] stringArray) {
            void var1_1;
            this.tlsVersions = var1_1;
        }

        public final boolean getSupportsTlsExtensions$okhttp() {
            return this.supportsTlsExtensions;
        }

        /*
         * WARNING - void declaration
         */
        public final void setSupportsTlsExtensions$okhttp(boolean bl) {
            void var1_1;
            this.supportsTlsExtensions = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(boolean tls) {
            void var1_1;
            this.tls = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder(ConnectionSpec connectionSpec) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)connectionSpec, (String)"connectionSpec");
            this.tls = connectionSpec.isTls();
            this.cipherSuites = connectionSpec.getCipherSuitesAsString$okhttp();
            this.tlsVersions = connectionSpec.tlsVersionsAsString;
            this.supportsTlsExtensions = var1_1.supportsTlsExtensions();
        }

        public final Builder allEnabledCipherSuites() {
            Object object = this;
            Builder $this$allEnabledCipherSuites_u24lambda_u241 = object;
            if (!((Builder)object).tls) {
                object = "no cipher suites for cleartext connections";
                throw new IllegalArgumentException(object.toString());
            }
            var2_2.cipherSuites = null;
            return (Builder)object;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cipherSuites(CipherSuite ... cipherSuites) {
            void var2_2;
            void var1_1;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)cipherSuites, (String)"cipherSuites");
            Builder $this$cipherSuites_u24lambda_u244 = this;
            if (!$this$cipherSuites_u24lambda_u244.tls) {
                cipherSuites = "no cipher suites for cleartext connections";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            CipherSuite[] $this$map$iv = cipherSuites;
            Object object = cipherSuites;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(it.javaName());
            }
            destination$iv$iv = (List)destination$iv$iv;
            object = destination$iv$iv;
            String[] strings = destination$iv$iv.toArray(new String[0]);
            void v0 = var1_1;
            return var2_2.cipherSuites((String[])Arrays.copyOf(v0, ((void)v0).length));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder cipherSuites(String ... cipherSuites) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)cipherSuites, (String)"cipherSuites");
            Builder $this$cipherSuites_u24lambda_u247 = builder = this;
            if (!builder.tls) {
                cipherSuites = "no cipher suites for cleartext connections";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            if (!(!(((String[])cipherSuites).length == 0))) {
                cipherSuites = "At least one cipher suite is required";
                throw new IllegalArgumentException(cipherSuites.toString());
            }
            void v0 = var1_1;
            T[] TArray = Arrays.copyOf(v0, ((void)v0).length);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
            var3_3.cipherSuites = (String[])TArray;
            return builder;
        }

        public final Builder allEnabledTlsVersions() {
            Object object = this;
            Builder $this$allEnabledTlsVersions_u24lambda_u249 = object;
            if (!((Builder)object).tls) {
                object = "no TLS versions for cleartext connections";
                throw new IllegalArgumentException(object.toString());
            }
            var2_2.tlsVersions = null;
            return (Builder)object;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder tlsVersions(TlsVersion ... tlsVersions) {
            void var2_2;
            void var1_1;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)tlsVersions, (String)"tlsVersions");
            Builder $this$tlsVersions_u24lambda_u2412 = this;
            if (!$this$tlsVersions_u24lambda_u2412.tls) {
                tlsVersions = "no TLS versions for cleartext connections";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            TlsVersion[] $this$map$iv = tlsVersions;
            Object object = tlsVersions;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Collection collection = destination$iv$iv;
                collection.add(it.javaName());
            }
            destination$iv$iv = (List)destination$iv$iv;
            object = destination$iv$iv;
            String[] strings = destination$iv$iv.toArray(new String[0]);
            void v0 = var1_1;
            return var2_2.tlsVersions((String[])Arrays.copyOf(v0, ((void)v0).length));
        }

        /*
         * WARNING - void declaration
         */
        public final Builder tlsVersions(String ... tlsVersions) {
            void var1_1;
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)tlsVersions, (String)"tlsVersions");
            Builder $this$tlsVersions_u24lambda_u2415 = builder = this;
            if (!builder.tls) {
                tlsVersions = "no TLS versions for cleartext connections";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            if (!(!(((String[])tlsVersions).length == 0))) {
                tlsVersions = "At least one TLS version is required";
                throw new IllegalArgumentException(tlsVersions.toString());
            }
            void v0 = var1_1;
            T[] TArray = Arrays.copyOf(v0, ((void)v0).length);
            Intrinsics.checkNotNullExpressionValue(TArray, (String)"copyOf(...)");
            var3_3.tlsVersions = (String[])TArray;
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @Deprecated(message="since OkHttp 3.13 all TLS-connections are expected to support TLS extensions.\nIn a future release setting this to true will be unnecessary and setting it to false\nwill have no effect.")
        public final Builder supportsTlsExtensions(boolean supportsTlsExtensions2) {
            void var1_1;
            Builder builder;
            Builder $this$supportsTlsExtensions_u24lambda_u2417 = builder = this;
            if (!builder.tls) {
                String supportsTlsExtensions2 = "no TLS extensions for cleartext connections";
                throw new IllegalArgumentException(supportsTlsExtensions2.toString());
            }
            var3_4.supportsTlsExtensions = var1_1;
            return builder;
        }

        public final ConnectionSpec build() {
            return new ConnectionSpec(this.tls, this.supportsTlsExtensions, this.cipherSuites, this.tlsVersions);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lokhttp3/ConnectionSpec$Companion;", "", "()V", "APPROVED_CIPHER_SUITES", "", "Lokhttp3/CipherSuite;", "CLEARTEXT", "Lokhttp3/ConnectionSpec;", "COMPATIBLE_TLS", "MODERN_TLS", "RESTRICTED_CIPHER_SUITES", "RESTRICTED_TLS", "okhttp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

