/*
 * Decompiled with CFR 0.152.
 */
package okhttp3;

import java.io.Closeable;
import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import okhttp3.CipherSuite;
import okhttp3.Handshake;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okhttp3.TlsVersion;
import okhttp3.internal._UtilCommonKt;
import okhttp3.internal._UtilJvmKt;
import okhttp3.internal.cache.CacheRequest;
import okhttp3.internal.cache.CacheStrategy;
import okhttp3.internal.cache.DiskLruCache;
import okhttp3.internal.concurrent.TaskRunner;
import okhttp3.internal.http.HttpMethod;
import okhttp3.internal.http.StatusLine;
import okhttp3.internal.platform.Platform;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.ByteString;
import okio.FileSystem;
import okio.ForwardingSink;
import okio.ForwardingSource;
import okio.Okio;
import okio.Path;
import okio.Sink;
import okio.Source;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010)\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 I2\u00020\u00012\u00020\u0002:\u0004HIJKB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\n\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bB'\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0016\u0010%\u001a\u00020&2\f\u0010'\u001a\b\u0018\u00010(R\u00020\u0010H\u0002J\b\u0010)\u001a\u00020&H\u0016J\u0006\u0010*\u001a\u00020&J\r\u0010\u0005\u001a\u00020\nH\u0007\u00a2\u0006\u0002\b+J\u0006\u0010,\u001a\u00020&J\b\u0010-\u001a\u00020&H\u0016J\u0017\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b2J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u00103\u001a\u00020&J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\u001b\u001a\u00020\u0017J\u0017\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u00020/H\u0000\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020&2\u0006\u00100\u001a\u000201H\u0000\u00a2\u0006\u0002\b9J\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010:\u001a\u00020\bJ\r\u0010;\u001a\u00020&H\u0000\u00a2\u0006\u0002\b<J\u0015\u0010=\u001a\u00020&2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b@J\u001d\u0010A\u001a\u00020&2\u0006\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020/H\u0000\u00a2\u0006\u0002\bDJ\f\u0010E\u001a\b\u0012\u0004\u0012\u00020G0FJ\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\"\u001a\u00020\u0017R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\n8G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00068G\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0017X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u001f\"\u0004\b$\u0010!\u00a8\u0006L"}, d2={"Lokhttp3/Cache;", "Ljava/io/Closeable;", "Ljava/io/Flushable;", "fileSystem", "Lokio/FileSystem;", "directory", "Lokio/Path;", "maxSize", "", "(Lokio/FileSystem;Lokio/Path;J)V", "Ljava/io/File;", "(Ljava/io/File;J)V", "taskRunner", "Lokhttp3/internal/concurrent/TaskRunner;", "(Lokio/Path;JLokio/FileSystem;Lokhttp3/internal/concurrent/TaskRunner;)V", "cache", "Lokhttp3/internal/cache/DiskLruCache;", "getCache$okhttp", "()Lokhttp3/internal/cache/DiskLruCache;", "()Ljava/io/File;", "directoryPath", "()Lokio/Path;", "hitCount", "", "isClosed", "", "()Z", "networkCount", "requestCount", "writeAbortCount", "getWriteAbortCount$okhttp", "()I", "setWriteAbortCount$okhttp", "(I)V", "writeSuccessCount", "getWriteSuccessCount$okhttp", "setWriteSuccessCount$okhttp", "abortQuietly", "", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "close", "delete", "-deprecated_directory", "evictAll", "flush", "get", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "get$okhttp", "initialize", "put", "Lokhttp3/internal/cache/CacheRequest;", "response", "put$okhttp", "remove", "remove$okhttp", "size", "trackConditionalCacheHit", "trackConditionalCacheHit$okhttp", "trackResponse", "cacheStrategy", "Lokhttp3/internal/cache/CacheStrategy;", "trackResponse$okhttp", "update", "cached", "network", "update$okhttp", "urls", "", "", "CacheResponseBody", "Companion", "Entry", "RealCacheRequest", "okhttp"})
public final class Cache
implements Closeable,
Flushable {
    public static final Companion Companion = new Companion(null);
    private final DiskLruCache cache;
    private int writeSuccessCount;
    private int writeAbortCount;
    private int networkCount;
    private int hitCount;
    private int requestCount;
    private static final int VERSION = 201105;
    private static final int ENTRY_METADATA = 0;
    private static final int ENTRY_BODY = 1;
    private static final int ENTRY_COUNT = 2;

    /*
     * WARNING - void declaration
     */
    public Cache(Path directory, long maxSize, FileSystem fileSystem2, TaskRunner taskRunner) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)taskRunner, (String)"taskRunner");
        this.cache = new DiskLruCache(fileSystem2, (Path)var1_1, 201105, 2, (long)var2_2, taskRunner);
    }

    /*
     * WARNING - void declaration
     */
    public Cache(FileSystem fileSystem2, Path directory, long maxSize) {
        void var1_1;
        void var3_3;
        void var2_2;
        Intrinsics.checkNotNullParameter((Object)fileSystem2, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this((Path)var2_2, (long)var3_3, (FileSystem)var1_1, TaskRunner.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    public Cache(File directory, long maxSize) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        this(FileSystem.SYSTEM, Path.Companion.get$default((Path.Companion)Path.Companion, (File)var1_1, (boolean)false, (int)1, null), (long)var2_2);
    }

    public final DiskLruCache getCache$okhttp() {
        return this.cache;
    }

    public final int getWriteSuccessCount$okhttp() {
        return this.writeSuccessCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWriteSuccessCount$okhttp(int n) {
        void var1_1;
        this.writeSuccessCount = var1_1;
    }

    public final int getWriteAbortCount$okhttp() {
        return this.writeAbortCount;
    }

    /*
     * WARNING - void declaration
     */
    public final void setWriteAbortCount$okhttp(int n) {
        void var1_1;
        this.writeAbortCount = var1_1;
    }

    public final boolean isClosed() {
        return this.cache.isClosed();
    }

    /*
     * WARNING - void declaration
     */
    public final Response get$okhttp(Request request) {
        void var1_1;
        void var2_2;
        Entry entry;
        DiskLruCache.Snapshot snapshot;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String key = Companion.key(request.url());
        try {
            DiskLruCache.Snapshot snapshot2 = this.cache.get(key);
            if (snapshot2 == null) {
                return null;
            }
            snapshot = snapshot2;
        }
        catch (IOException iOException) {
            return null;
        }
        DiskLruCache.Snapshot snapshot3 = snapshot;
        try {
            entry = new Entry(snapshot3.getSource(0));
        }
        catch (IOException iOException) {
            _UtilCommonKt.closeQuietly(snapshot3);
            return null;
        }
        Entry entry2 = entry;
        Response response = entry2.response((DiskLruCache.Snapshot)var2_2);
        if (!((Entry)((Object)snapshot)).matches((Request)var1_1, response)) {
            _UtilCommonKt.closeQuietly(response.body());
            return null;
        }
        return response;
    }

    /*
     * WARNING - void declaration
     */
    public final CacheRequest put$okhttp(Response response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String requestMethod = response.request().method();
        if (HttpMethod.invalidatesCache(response.request().method())) {
            try {
                this.remove$okhttp(response.request());
            }
            catch (IOException iOException) {}
            return null;
        }
        if (!Intrinsics.areEqual((Object)requestMethod, (Object)"GET")) {
            return null;
        }
        if (Companion.hasVaryAll(response)) {
            return null;
        }
        Entry entry = new Entry(response);
        DiskLruCache.Editor editor = null;
        try {
            void var2_2;
            void var1_1;
            DiskLruCache.Editor editor2 = DiskLruCache.edit$default(this.cache, Companion.key(var1_1.request().url()), 0L, 2, null);
            if (editor2 == null) {
                return null;
            }
            editor = editor2;
            var2_2.writeTo(editor);
            return new RealCacheRequest(this, editor);
        }
        catch (IOException iOException) {
            void var3_3;
            this.abortQuietly((DiskLruCache.Editor)var3_3);
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void remove$okhttp(Request request) throws IOException {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.cache.remove(Companion.key(var1_1.url()));
    }

    /*
     * WARNING - void declaration
     */
    public final void update$okhttp(Response cached, Response network) {
        Intrinsics.checkNotNullParameter((Object)cached, (String)"cached");
        Intrinsics.checkNotNullParameter((Object)network, (String)"network");
        Entry entry = new Entry(network);
        ResponseBody responseBody = cached.body();
        Intrinsics.checkNotNull((Object)responseBody, (String)"null cannot be cast to non-null type okhttp3.Cache.CacheResponseBody");
        DiskLruCache.Snapshot snapshot = ((CacheResponseBody)responseBody).getSnapshot();
        DiskLruCache.Editor editor = null;
        try {
            void var2_2;
            void var1_1;
            DiskLruCache.Editor editor2 = var1_1.edit();
            if (editor2 == null) {
                return;
            }
            editor = editor2;
            var2_2.writeTo(editor);
            editor.commit();
            return;
        }
        catch (IOException iOException) {
            void var3_3;
            this.abortQuietly((DiskLruCache.Editor)var3_3);
            return;
        }
    }

    private final void abortQuietly(DiskLruCache.Editor editor) {
        try {
            DiskLruCache.Editor editor2 = editor;
            if (editor2 != null) {
                editor2.abort();
                return;
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public final void initialize() throws IOException {
        this.cache.initialize();
    }

    public final void delete() throws IOException {
        this.cache.delete();
    }

    public final void evictAll() throws IOException {
        this.cache.evictAll();
    }

    public final Iterator<String> urls() throws IOException {
        return new Iterator<String>(this){
            private final Iterator<DiskLruCache.Snapshot> delegate;
            private String nextUrl;
            private boolean canRemove;
            {
                void var1_1;
                this.delegate = var1_1.getCache$okhttp().snapshots();
            }

            public final boolean hasNext() {
                if (this.nextUrl != null) {
                    return true;
                }
                this.canRemove = false;
                while (this.delegate.hasNext()) {
                    try {
                        Closeable closeable = this.delegate.next();
                        Throwable throwable = null;
                        try {
                            DiskLruCache.Snapshot snapshot = (DiskLruCache.Snapshot)closeable;
                            BufferedSource metadata = Okio.buffer((Source)snapshot.getSource(0));
                            this.nextUrl = snapshot.readUtf8LineStrict();
                        }
                        catch (Throwable throwable2) {
                            try {
                                Throwable throwable3 = throwable2;
                                throwable = throwable2;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                throw throwable4;
                            }
                        }
                        CloseableKt.closeFinally((Closeable)closeable, null);
                        return true;
                    }
                    catch (IOException iOException) {
                    }
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            public final String next() {
                void var1_1;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                String string = this.nextUrl;
                Intrinsics.checkNotNull((Object)string);
                String result = string;
                this.nextUrl = null;
                this.canRemove = true;
                return var1_1;
            }

            public final void remove() {
                if (!this.canRemove) {
                    String string = "remove() before next()";
                    throw new IllegalStateException(string.toString());
                }
                this.delegate.remove();
            }
        };
    }

    public final synchronized int writeAbortCount() {
        return this.writeAbortCount;
    }

    public final synchronized int writeSuccessCount() {
        return this.writeSuccessCount;
    }

    public final long size() throws IOException {
        return this.cache.size();
    }

    public final long maxSize() {
        return this.cache.getMaxSize();
    }

    @Override
    public final void flush() throws IOException {
        this.cache.flush();
    }

    @Override
    public final void close() throws IOException {
        this.cache.close();
    }

    @JvmName(name="directory")
    public final File directory() {
        return this.cache.getDirectory().toFile();
    }

    @JvmName(name="directoryPath")
    public final Path directoryPath() {
        return this.cache.getDirectory();
    }

    @Deprecated(message="moved to val", replaceWith=@ReplaceWith(expression="directory", imports={}), level=DeprecationLevel.ERROR)
    @JvmName(name="-deprecated_directory")
    public final File -deprecated_directory() {
        return this.cache.getDirectory().toFile();
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void trackResponse$okhttp(CacheStrategy cacheStrategy) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)cacheStrategy, (String)"cacheStrategy");
        int n = this.requestCount;
        this.requestCount = n + 1;
        if (cacheStrategy.getNetworkRequest() != null) {
            n = this.networkCount;
            this.networkCount = n + 1;
            return;
        }
        if (var1_1.getCacheResponse() != null) {
            n = this.hitCount;
            this.hitCount = n + 1;
        }
    }

    public final synchronized void trackConditionalCacheHit$okhttp() {
        int n = this.hitCount;
        this.hitCount = n + 1;
    }

    public final synchronized int networkCount() {
        return this.networkCount;
    }

    public final synchronized int hitCount() {
        return this.hitCount;
    }

    public final synchronized int requestCount() {
        return this.requestCount;
    }

    @JvmStatic
    public static final String key(HttpUrl url) {
        HttpUrl httpUrl;
        return Companion.key(httpUrl);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0007\u001a\u00020\rH\u0016J\n\u0010\u0005\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\nH\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lokhttp3/Cache$CacheResponseBody;", "Lokhttp3/ResponseBody;", "snapshot", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "Lokhttp3/internal/cache/DiskLruCache;", "contentType", "", "contentLength", "(Lokhttp3/internal/cache/DiskLruCache$Snapshot;Ljava/lang/String;Ljava/lang/String;)V", "bodySource", "Lokio/BufferedSource;", "getSnapshot", "()Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "", "Lokhttp3/MediaType;", "source", "okhttp"})
    private static final class CacheResponseBody
    extends ResponseBody {
        private final DiskLruCache.Snapshot snapshot;
        private final String contentType;
        private final String contentLength;
        private final BufferedSource bodySource;

        /*
         * WARNING - void declaration
         */
        public CacheResponseBody(DiskLruCache.Snapshot snapshot, String contentType, String contentLength) {
            void var1_1;
            void var3_3;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            this.snapshot = snapshot;
            this.contentType = var2_2;
            this.contentLength = var3_3;
            Source source = this.snapshot.getSource(1);
            this.bodySource = Okio.buffer((Source)((Source)new ForwardingSource((Source)var1_1, this){
                final /* synthetic */ CacheResponseBody this$0;
                {
                    void var1_1;
                    void var2_2;
                    this.this$0 = var2_2;
                    super((Source)var1_1);
                }

                public final void close() throws IOException {
                    this.this$0.getSnapshot().close();
                    super.close();
                }
            }));
        }

        public final DiskLruCache.Snapshot getSnapshot() {
            return this.snapshot;
        }

        @Override
        public final MediaType contentType() {
            String string = this.contentType;
            if (string != null) {
                return MediaType.Companion.parse(string);
            }
            return null;
        }

        @Override
        public final long contentLength() {
            String string = this.contentLength;
            if (string != null) {
                return _UtilCommonKt.toLongOrDefault(string, -1L);
            }
            return -1L;
        }

        @Override
        public final BufferedSource source() {
            return this.bodySource;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aJ\n\u0010\u001b\u001a\u00020\u0015*\u00020\u0017J\u0012\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\t0\u001d*\u00020\u0011H\u0002J\n\u0010\u0010\u001a\u00020\u0011*\u00020\u0017R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lokhttp3/Cache$Companion;", "", "()V", "ENTRY_BODY", "", "ENTRY_COUNT", "ENTRY_METADATA", "VERSION", "key", "", "url", "Lokhttp3/HttpUrl;", "readInt", "source", "Lokio/BufferedSource;", "readInt$okhttp", "varyHeaders", "Lokhttp3/Headers;", "requestHeaders", "responseHeaders", "varyMatches", "", "cachedResponse", "Lokhttp3/Response;", "cachedRequest", "newRequest", "Lokhttp3/Request;", "hasVaryAll", "varyFields", "", "okhttp"})
    @SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,830:1\n2624#2,3:831\n*S KotlinDebug\n*F\n+ 1 Cache.kt\nokhttp3/Cache$Companion\n*L\n768#1:831,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final String key(HttpUrl url) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            return ByteString.Companion.encodeUtf8(var1_1.toString()).md5().hex();
        }

        /*
         * WARNING - void declaration
         */
        public final int readInt$okhttp(BufferedSource source) throws IOException {
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            try {
                long result = source.readDecimalLong();
                String line = source.readUtf8LineStrict();
                if (result < 0L || result > Integer.MAX_VALUE || ((CharSequence)line).length() > 0) {
                    void var1_1;
                    throw new IOException("expected an int but was \"" + result + (String)var1_1 + '\"');
                }
                return (int)result;
            }
            catch (NumberFormatException e) {
                void var2_3;
                throw new IOException(var2_3.getMessage());
            }
        }

        public final boolean varyMatches(Response cachedResponse, Headers cachedRequest, Request newRequest) {
            Intrinsics.checkNotNullParameter((Object)cachedResponse, (String)"cachedResponse");
            Intrinsics.checkNotNullParameter((Object)cachedRequest, (String)"cachedRequest");
            Intrinsics.checkNotNullParameter((Object)newRequest, (String)"newRequest");
            Iterable $this$none$iv = this.varyFields(cachedResponse.headers());
            if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) {
                Iterator iterator;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object t = iterator.next();
                    String it = (String)t;
                    if (!(!Intrinsics.areEqual(cachedRequest.values(it), newRequest.headers(it)))) continue;
                    return false;
                }
            }
            return true;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean hasVaryAll(Response $this$hasVaryAll) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)$this$hasVaryAll, (String)"<this>");
            return this.varyFields(var1_1.headers()).contains("*");
        }

        /*
         * WARNING - void declaration
         */
        private final Set<String> varyFields(Headers $this$varyFields) {
            void var2_2;
            Set result = null;
            int n = $this$varyFields.size();
            for (int i = 0; i < n; ++i) {
                if (!StringsKt.equals((String)"Vary", (String)$this$varyFields.name(i), (boolean)true)) continue;
                String value = $this$varyFields.value(i);
                if (result == null) {
                    result = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                }
                char[] cArray = new char[1];
                char[] cArray2 = cArray;
                cArray[0] = 44;
                for (String varyField : StringsKt.split$default((CharSequence)value, (char[])cArray2, (boolean)false, (int)0, (int)6, null)) {
                    result.add(((Object)StringsKt.trim((CharSequence)varyField)).toString());
                }
            }
            Set set = var2_2;
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        /*
         * WARNING - void declaration
         */
        public final Headers varyHeaders(Response $this$varyHeaders) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)$this$varyHeaders, (String)"<this>");
            Response response = $this$varyHeaders.networkResponse();
            Intrinsics.checkNotNull((Object)response);
            Headers requestHeaders = response.request().headers();
            Headers responseHeaders = $this$varyHeaders.headers();
            return this.varyHeaders((Headers)var2_2, (Headers)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private final Headers varyHeaders(Headers requestHeaders, Headers responseHeaders) {
            void var3_3;
            Set<String> varyFields = this.varyFields(responseHeaders);
            if (varyFields.isEmpty()) {
                return _UtilJvmKt.EMPTY_HEADERS;
            }
            Headers.Builder result = new Headers.Builder();
            int n = requestHeaders.size();
            for (int i = 0; i < n; ++i) {
                String fieldName = requestHeaders.name(i);
                if (!varyFields.contains(fieldName)) continue;
                result.add(fieldName, requestHeaders.value(i));
            }
            return var3_3.build();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\u0012\u0010\u0005\u001a\u00020\u00062\n\u0010\"\u001a\u00060#R\u00020$J\u001e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0012\u0010*\u001a\u00020&2\n\u0010+\u001a\u00060,R\u00020$R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lokhttp3/Cache$Entry;", "", "rawSource", "Lokio/Source;", "(Lokio/Source;)V", "response", "Lokhttp3/Response;", "(Lokhttp3/Response;)V", "code", "", "handshake", "Lokhttp3/Handshake;", "message", "", "protocol", "Lokhttp3/Protocol;", "receivedResponseMillis", "", "requestMethod", "responseHeaders", "Lokhttp3/Headers;", "sentRequestMillis", "url", "Lokhttp3/HttpUrl;", "varyHeaders", "matches", "", "request", "Lokhttp3/Request;", "readCertificateList", "", "Ljava/security/cert/Certificate;", "source", "Lokio/BufferedSource;", "snapshot", "Lokhttp3/internal/cache/DiskLruCache$Snapshot;", "Lokhttp3/internal/cache/DiskLruCache;", "writeCertList", "", "sink", "Lokio/BufferedSink;", "certificates", "writeTo", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Companion", "okhttp"})
    private static final class Entry {
        public static final Companion Companion = new Companion(null);
        private final HttpUrl url;
        private final Headers varyHeaders;
        private final String requestMethod;
        private final Protocol protocol;
        private final int code;
        private final String message;
        private final Headers responseHeaders;
        private final Handshake handshake;
        private final long sentRequestMillis;
        private final long receivedResponseMillis;
        private static final String SENT_MILLIS = Platform.Companion.get().getPrefix() + "-Sent-Millis";
        private static final String RECEIVED_MILLIS = Platform.Companion.get().getPrefix() + "-Received-Millis";

        /*
         * WARNING - void declaration
         */
        public Entry(Source rawSource) throws IOException {
            Closeable closeable;
            block9: {
                Throwable throwable;
                Intrinsics.checkNotNullParameter((Object)rawSource, (String)"rawSource");
                closeable = (Closeable)rawSource;
                Throwable throwable2 = null;
                try {
                    Source cfr_ignored_0 = (Source)closeable;
                    BufferedSource source = Okio.buffer((Source)rawSource);
                    Object urlLine = source.readUtf8LineStrict();
                    HttpUrl httpUrl = HttpUrl.Companion.parse((String)urlLine);
                    if (httpUrl == null) {
                        void it;
                        urlLine = new IOException("Cache corruption for " + (String)urlLine);
                        IOException iOException = urlLine;
                        Platform.Companion.get().log("cache corruption", 5, (Throwable)it);
                        throw (Throwable)urlLine;
                    }
                    this.url = httpUrl;
                    this.requestMethod = source.readUtf8LineStrict();
                    Headers.Builder varyHeadersBuilder = new Headers.Builder();
                    int varyRequestHeaderLineCount = Companion.readInt$okhttp(source);
                    for (int i = 0; i < varyRequestHeaderLineCount; ++i) {
                        varyHeadersBuilder.addLenient$okhttp(source.readUtf8LineStrict());
                    }
                    this.varyHeaders = varyHeadersBuilder.build();
                    StatusLine statusLine = StatusLine.Companion.parse(source.readUtf8LineStrict());
                    this.protocol = statusLine.protocol;
                    this.code = statusLine.code;
                    this.message = statusLine.message;
                    Headers.Builder responseHeadersBuilder = new Headers.Builder();
                    int responseHeaderLineCount = Companion.readInt$okhttp(source);
                    for (int i = 0; i < responseHeaderLineCount; ++i) {
                        responseHeadersBuilder.addLenient$okhttp(source.readUtf8LineStrict());
                    }
                    String sendRequestMillisString = responseHeadersBuilder.get(SENT_MILLIS);
                    String receivedResponseMillisString = responseHeadersBuilder.get(RECEIVED_MILLIS);
                    responseHeadersBuilder.removeAll(SENT_MILLIS);
                    responseHeadersBuilder.removeAll(RECEIVED_MILLIS);
                    String string = sendRequestMillisString;
                    this.sentRequestMillis = string != null ? Long.parseLong(string) : 0L;
                    String string2 = receivedResponseMillisString;
                    this.receivedResponseMillis = string2 != null ? Long.parseLong(string2) : 0L;
                    this.responseHeaders = responseHeadersBuilder.build();
                    if (this.url.isHttps()) {
                        String blank = source.readUtf8LineStrict();
                        if (((CharSequence)blank).length() > 0) {
                            throw new IOException("expected \"\" but was \"" + blank + '\"');
                        }
                        String cipherSuiteString = source.readUtf8LineStrict();
                        CipherSuite cipherSuite = CipherSuite.Companion.forJavaName(cipherSuiteString);
                        List<Certificate> peerCertificates2 = this.readCertificateList(source);
                        List<Certificate> localCertificates = this.readCertificateList(source);
                        TlsVersion tlsVersion = !source.exhausted() ? TlsVersion.Companion.forJavaName(source.readUtf8LineStrict()) : TlsVersion.SSL_3_0;
                        this.handshake = Handshake.Companion.get((TlsVersion)((Object)throwable), cipherSuite, peerCertificates2, localCertificates);
                        break block9;
                    }
                    this.handshake = null;
                }
                catch (Throwable throwable3) {
                    try {
                        throwable = throwable3;
                        throwable2 = throwable3;
                        throw throwable;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                        throw throwable4;
                    }
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }

        /*
         * WARNING - void declaration
         */
        public Entry(Response response) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            this.url = response.request().url();
            this.varyHeaders = Companion.varyHeaders(response);
            this.requestMethod = response.request().method();
            this.protocol = response.protocol();
            this.code = response.code();
            this.message = response.message();
            this.responseHeaders = response.headers();
            this.handshake = response.handshake();
            this.sentRequestMillis = response.sentRequestAtMillis();
            this.receivedResponseMillis = var1_1.receivedResponseAtMillis();
        }

        /*
         * WARNING - void declaration
         */
        public final void writeTo(DiskLruCache.Editor editor) throws IOException {
            Closeable closeable;
            block6: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                closeable = (Closeable)Okio.buffer((Sink)((DiskLruCache.Editor)((Object)closeable)).newSink(0));
                Throwable throwable = null;
                try {
                    void var3_3;
                    int i;
                    BufferedSink sink = (BufferedSink)closeable;
                    sink.writeUtf8(this.url.toString()).writeByte(10);
                    sink.writeUtf8(this.requestMethod).writeByte(10);
                    sink.writeDecimalLong((long)this.varyHeaders.size()).writeByte(10);
                    int n = this.varyHeaders.size();
                    for (i = 0; i < n; ++i) {
                        sink.writeUtf8(this.varyHeaders.name(i)).writeUtf8(": ").writeUtf8(this.varyHeaders.value(i)).writeByte(10);
                    }
                    sink.writeUtf8(new StatusLine(this.protocol, this.code, this.message).toString()).writeByte(10);
                    sink.writeDecimalLong((long)(this.responseHeaders.size() + 2)).writeByte(10);
                    n = this.responseHeaders.size();
                    for (i = 0; i < n; ++i) {
                        sink.writeUtf8(this.responseHeaders.name(i)).writeUtf8(": ").writeUtf8(this.responseHeaders.value(i)).writeByte(10);
                    }
                    sink.writeUtf8(SENT_MILLIS).writeUtf8(": ").writeDecimalLong(this.sentRequestMillis).writeByte(10);
                    sink.writeUtf8(RECEIVED_MILLIS).writeUtf8(": ").writeDecimalLong(this.receivedResponseMillis).writeByte(10);
                    if (!this.url.isHttps()) break block6;
                    sink.writeByte(10);
                    Handshake handshake2 = this.handshake;
                    Intrinsics.checkNotNull((Object)handshake2);
                    sink.writeUtf8(handshake2.cipherSuite().javaName()).writeByte(10);
                    this.writeCertList(sink, this.handshake.peerCertificates());
                    this.writeCertList(sink, this.handshake.localCertificates());
                    var3_3.writeUtf8(this.handshake.tlsVersion().javaName()).writeByte(10);
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                        throw throwable4;
                    }
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }

        /*
         * WARNING - void declaration
         */
        private final List<Certificate> readCertificateList(BufferedSource source) throws IOException {
            int length = Companion.readInt$okhttp(source);
            if (length == -1) {
                return CollectionsKt.emptyList();
            }
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                ArrayList<Certificate> result = new ArrayList<Certificate>(length);
                for (int i = 0; i < length; ++i) {
                    ByteString certificateBytes;
                    String line = source.readUtf8LineStrict();
                    Buffer bytes = new Buffer();
                    if (ByteString.Companion.decodeBase64(line) == null) {
                        throw new IOException("Corrupt certificate in cache entry");
                    }
                    bytes.write(certificateBytes);
                    result.add(certificateFactory.generateCertificate(bytes.inputStream()));
                }
                return result;
            }
            catch (CertificateException e) {
                void var3_4;
                throw new IOException(var3_4.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void writeCertList(BufferedSink sink, List<? extends Certificate> certificates) throws IOException {
            try {
                sink.writeDecimalLong((long)certificates.size()).writeByte(10);
                certificates = certificates.iterator();
                while (certificates.hasNext()) {
                    Certificate certificate = (Certificate)certificates.next();
                    byte[] bytes = certificate.getEncoded();
                    Intrinsics.checkNotNull((Object)bytes);
                    String line = ByteString.Companion.of$default((ByteString.Companion)ByteString.Companion, (byte[])bytes, (int)0, (int)0, (int)3, null).base64();
                    sink.writeUtf8((String)((Object)certificate)).writeByte(10);
                }
            }
            catch (CertificateEncodingException e) {
                void var2_3;
                throw new IOException(var2_3.getMessage());
            }
        }

        /*
         * WARNING - void declaration
         */
        public final boolean matches(Request request, Response response) {
            void var1_1;
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)response, (String)"response");
            return Intrinsics.areEqual((Object)this.url, (Object)request.url()) && Intrinsics.areEqual((Object)this.requestMethod, (Object)request.method()) && Companion.varyMatches((Response)var2_2, this.varyHeaders, (Request)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final Response response(DiskLruCache.Snapshot snapshot) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)snapshot, (String)"snapshot");
            String contentType = this.responseHeaders.get("Content-Type");
            String contentLength = this.responseHeaders.get("Content-Length");
            Request cacheRequest = new Request(this.url, this.varyHeaders, this.requestMethod, null, 8, null);
            return new Response.Builder().request(cacheRequest).protocol(this.protocol).code(this.code).message(this.message).headers(this.responseHeaders).body(new CacheResponseBody((DiskLruCache.Snapshot)var1_1, (String)var2_2, (String)var3_3)).handshake(this.handshake).sentRequestAtMillis(this.sentRequestMillis).receivedResponseAtMillis(this.receivedResponseMillis).build();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lokhttp3/Cache$Entry$Companion;", "", "()V", "RECEIVED_MILLIS", "", "SENT_MILLIS", "okhttp"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0006\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0012\u0010\u0002\u001a\u00060\u0003R\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lokhttp3/Cache$RealCacheRequest;", "Lokhttp3/internal/cache/CacheRequest;", "editor", "Lokhttp3/internal/cache/DiskLruCache$Editor;", "Lokhttp3/internal/cache/DiskLruCache;", "(Lokhttp3/Cache;Lokhttp3/internal/cache/DiskLruCache$Editor;)V", "body", "Lokio/Sink;", "cacheOut", "done", "", "getDone", "()Z", "setDone", "(Z)V", "abort", "", "okhttp"})
    private final class RealCacheRequest
    implements CacheRequest {
        private final DiskLruCache.Editor editor;
        private final Sink cacheOut;
        private final Sink body;
        private boolean done;
        final /* synthetic */ Cache this$0;

        /*
         * WARNING - void declaration
         */
        public RealCacheRequest(Cache this$0, DiskLruCache.Editor editor) {
            void var2_2;
            Sink sink;
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            this.this$0 = sink;
            this.editor = var2_2;
            sink = this.cacheOut = this.editor.newSink(1);
            this.body = (Sink)new ForwardingSink(this.this$0, this, sink){
                final /* synthetic */ Cache this$0;
                final /* synthetic */ RealCacheRequest this$1;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    this.this$1 = var2_2;
                    super((Sink)var3_3);
                }

                public final void close() throws IOException {
                    Cache cache = this.this$0;
                    RealCacheRequest realCacheRequest = this.this$1;
                    Cache cache2 = this.this$0;
                    synchronized (cache) {
                        if (realCacheRequest.getDone()) {
                            return;
                        }
                        realCacheRequest.setDone(true);
                        int n = cache2.getWriteSuccessCount$okhttp();
                        cache2.setWriteSuccessCount$okhttp(n + 1);
                    }
                    super.close();
                    this.this$1.editor.commit();
                }
            };
        }

        public final boolean getDone() {
            return this.done;
        }

        /*
         * WARNING - void declaration
         */
        public final void setDone(boolean bl) {
            void var1_1;
            this.done = var1_1;
        }

        @Override
        public final void abort() {
            Cache cache = this.this$0;
            Cache cache2 = this.this$0;
            synchronized (cache) {
                if (this.done) {
                    return;
                }
                this.done = true;
                int n = cache2.getWriteAbortCount$okhttp();
                cache2.setWriteAbortCount$okhttp(n + 1);
            }
            _UtilCommonKt.closeQuietly((Closeable)this.cacheOut);
            try {
                this.editor.abort();
                return;
            }
            catch (IOException iOException) {
                return;
            }
        }

        @Override
        public final Sink body() {
            return this.body;
        }
    }
}

