/*
 * Decompiled with CFR 0.152.
 */
package kotlin.test;

import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.test.Asserter;
import kotlin.test.AssertionsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a4\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u001a4\u0010\u000b\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\f2\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0000\u001a\u0012\u0010\r\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0000\u001a\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0001\u00a8\u0006\u0011"}, d2={"checkAbsoluteTolerance", "", "absoluteTolerance", "", "checkDoublesAreEqual", "expected", "actual", "message", "", "shouldFail", "", "checkFloatsAreEqual", "", "messagePrefix", "overrideAsserter", "Lkotlin/test/Asserter;", "value", "kotlin-test"})
@SourceDebugExtension(value={"SMAP\nUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Utils.kt\nkotlin/test/UtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n1#2:53\n*E\n"})
public final class UtilsKt {
    public static final String messagePrefix(String message) {
        String string;
        if (message == null) {
            return "";
        }
        return string + ". ";
    }

    @PublishedApi
    public static final Asserter overrideAsserter(Asserter value) {
        Asserter asserter;
        Asserter asserter2 = AssertionsKt.get_asserter();
        AssertionsKt.set_asserter(asserter);
        return asserter2;
    }

    private static final void checkAbsoluteTolerance(double absoluteTolerance22) {
        double absoluteTolerance22;
        if (!(absoluteTolerance22 >= 0.0)) {
            String absoluteTolerance22 = "Illegal negative absolute tolerance <" + absoluteTolerance22 + ">.";
            throw new IllegalArgumentException(absoluteTolerance22.toString());
        }
        if (!(!Double.isNaN(absoluteTolerance22))) {
            double d;
            String string = "Illegal NaN absolute tolerance <" + d + ">.";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkDoublesAreEqual(double expected, double actual, double absoluteTolerance, String message, boolean shouldFail) {
        void var2_1;
        double d;
        UtilsKt.checkAbsoluteTolerance(absoluteTolerance);
        boolean equal = Double.doubleToLongBits(expected) == Double.doubleToLongBits(actual) || Math.abs(expected - actual) <= absoluteTolerance;
        AssertionsKt.getAsserter().assertTrue((Function0<String>)((Function0)new Function0<String>(message, d, absoluteTolerance, (double)var2_1){
            final /* synthetic */ String $message;
            final /* synthetic */ double $expected;
            final /* synthetic */ double $absoluteTolerance;
            final /* synthetic */ double $actual;
            {
                void var2_2;
                void var1_1;
                this.$message = var1_1;
                this.$expected = var2_2;
                this.$absoluteTolerance = $absoluteTolerance;
                this.$actual = $actual;
                super(0);
            }

            public final String invoke() {
                return UtilsKt.messagePrefix(this.$message) + "Expected <" + this.$expected + "> with absolute tolerance <" + this.$absoluteTolerance + ">, actual <" + this.$actual + ">.";
            }
        }), equal != shouldFail);
    }

    public static /* synthetic */ void checkDoublesAreEqual$default(double d, double d2, double d3, String string, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        UtilsKt.checkDoublesAreEqual(d, d2, d3, string, bl);
    }

    /*
     * WARNING - void declaration
     */
    public static final void checkFloatsAreEqual(float expected, float actual, float absoluteTolerance, String message, boolean shouldFail) {
        void var1_1;
        void var2_2;
        float f;
        void var3_3;
        UtilsKt.checkAbsoluteTolerance(absoluteTolerance);
        boolean equal = Float.floatToIntBits(expected) == Float.floatToIntBits(actual) || Math.abs(expected - actual) <= absoluteTolerance;
        AssertionsKt.getAsserter().assertTrue((Function0<String>)((Function0)new Function0<String>((String)var3_3, f, (float)var2_2, (float)var1_1){
            final /* synthetic */ String $message;
            final /* synthetic */ float $expected;
            final /* synthetic */ float $absoluteTolerance;
            final /* synthetic */ float $actual;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.$message = var1_1;
                this.$expected = var2_2;
                this.$absoluteTolerance = var3_3;
                this.$actual = $actual;
                super(0);
            }

            public final String invoke() {
                return UtilsKt.messagePrefix(this.$message) + "Expected <" + this.$expected + "> with absolute tolerance <" + this.$absoluteTolerance + ">, actual <" + this.$actual + ">.";
            }
        }), equal != shouldFail);
    }

    public static /* synthetic */ void checkFloatsAreEqual$default(float f, float f2, float f3, String string, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = false;
        }
        UtilsKt.checkFloatsAreEqual(f, f2, f3, string, bl);
    }
}

