/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.InetNameResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RoundRobinInetAddressResolver
extends InetNameResolver {
    private final NameResolver<InetAddress> nameResolver;

    /*
     * WARNING - void declaration
     */
    public RoundRobinInetAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super((EventExecutor)var1_1);
        void var2_2;
        void var1_1;
        this.nameResolver = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doResolve(String inetHost, Promise<InetAddress> promise) throws Exception {
        void var1_1;
        void var2_2;
        this.nameResolver.resolveAll(inetHost).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(this, (Promise)var2_2, (String)var1_1){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ String val$inetHost;
            final /* synthetic */ RoundRobinInetAddressResolver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = promise;
                this.val$inetHost = string;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                void var1_1;
                if (!future.isSuccess()) {
                    this.val$promise.setFailure(var1_1.cause());
                    return;
                }
                List inetAddresses = (List)future.getNow();
                int numAddresses = inetAddresses.size();
                if (numAddresses > 0) {
                    void var2_2;
                    this.val$promise.setSuccess(var1_1.get(RoundRobinInetAddressResolver.randomIndex((int)var2_2)));
                    return;
                }
                this.val$promise.setFailure((Throwable)new UnknownHostException(this.val$inetHost));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doResolveAll(String inetHost, Promise<List<InetAddress>> promise) throws Exception {
        void var2_2;
        void var1_1;
        this.nameResolver.resolveAll((String)var1_1).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(this, (Promise)var2_2){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ RoundRobinInetAddressResolver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = promise;
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                void var1_1;
                if (!future.isSuccess()) {
                    this.val$promise.setFailure(var1_1.cause());
                    return;
                }
                List inetAddresses = (List)future.getNow();
                if (!inetAddresses.isEmpty()) {
                    void var2_2;
                    ArrayList result = new ArrayList(inetAddresses);
                    Collections.rotate(result, RoundRobinInetAddressResolver.randomIndex(inetAddresses.size()));
                    this.val$promise.setSuccess((Object)var2_2);
                    return;
                }
                this.val$promise.setSuccess((Object)var1_1);
            }
        });
    }

    private static int randomIndex(int numAddresses) {
        int n;
        if (numAddresses == 1) {
            return 0;
        }
        return PlatformDependent.threadLocalRandom().nextInt(n);
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

