/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.AbstractAddressResolver;
import io.netty.resolver.NameResolver;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class InetSocketAddressResolver
extends AbstractAddressResolver<InetSocketAddress> {
    final NameResolver<InetAddress> nameResolver;

    /*
     * WARNING - void declaration
     */
    public InetSocketAddressResolver(EventExecutor executor, NameResolver<InetAddress> nameResolver) {
        super((EventExecutor)var1_1, InetSocketAddress.class);
        void var2_2;
        void var1_1;
        this.nameResolver = var2_2;
    }

    @Override
    protected boolean doIsResolved(InetSocketAddress address) {
        return !address.isUnresolved();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doResolve(InetSocketAddress unresolvedAddress, Promise<InetSocketAddress> promise) throws Exception {
        void var1_1;
        void var2_2;
        this.nameResolver.resolve(unresolvedAddress.getHostName()).addListener((GenericFutureListener)new FutureListener<InetAddress>(this, (Promise)var2_2, (InetSocketAddress)var1_1){
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ InetSocketAddress val$unresolvedAddress;
            final /* synthetic */ InetSocketAddressResolver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$promise = promise;
                this.val$unresolvedAddress = inetSocketAddress;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(Future<InetAddress> future) throws Exception {
                void var1_1;
                if (future.isSuccess()) {
                    this.val$promise.setSuccess((Object)new InetSocketAddress((InetAddress)future.getNow(), this.val$unresolvedAddress.getPort()));
                    return;
                }
                this.val$promise.setFailure(var1_1.cause());
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doResolveAll(InetSocketAddress unresolvedAddress, Promise<List<InetSocketAddress>> promise) throws Exception {
        void var2_2;
        void var1_1;
        this.nameResolver.resolveAll(unresolvedAddress.getHostName()).addListener((GenericFutureListener)new FutureListener<List<InetAddress>>(this, (InetSocketAddress)var1_1, (Promise)var2_2){
            final /* synthetic */ InetSocketAddress val$unresolvedAddress;
            final /* synthetic */ Promise val$promise;
            final /* synthetic */ InetSocketAddressResolver this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$unresolvedAddress = inetSocketAddress;
                this.val$promise = promise;
            }

            /*
             * WARNING - void declaration
             */
            public void operationComplete(Future<List<InetAddress>> future) throws Exception {
                Iterator iterator;
                if (future.isSuccess()) {
                    void var2_2;
                    List inetAddresses = (List)future.getNow();
                    ArrayList<InetSocketAddress> socketAddresses = new ArrayList<InetSocketAddress>(inetAddresses.size());
                    iterator = iterator.iterator();
                    while (iterator.hasNext()) {
                        void var3_3;
                        InetAddress inetAddress = (InetAddress)iterator.next();
                        socketAddresses.add(new InetSocketAddress((InetAddress)var3_3, this.val$unresolvedAddress.getPort()));
                    }
                    this.val$promise.setSuccess((Object)var2_2);
                    return;
                }
                this.val$promise.setFailure(iterator.cause());
            }
        });
    }

    @Override
    public void close() {
        this.nameResolver.close();
    }
}

