/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.util.NetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;

public final class HostsFileEntriesProvider {
    static final HostsFileEntriesProvider EMPTY = new HostsFileEntriesProvider(Collections.<String, List<InetAddress>>emptyMap(), Collections.<String, List<InetAddress>>emptyMap());
    private final Map<String, List<InetAddress>> ipv4Entries;
    private final Map<String, List<InetAddress>> ipv6Entries;

    public static Parser parser() {
        return ParserImpl.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    HostsFileEntriesProvider(Map<String, List<InetAddress>> ipv4Entries, Map<String, List<InetAddress>> ipv6Entries) {
        void var2_2;
        void var1_1;
        this.ipv4Entries = Collections.unmodifiableMap(new HashMap(var1_1));
        this.ipv6Entries = Collections.unmodifiableMap(new HashMap(var2_2));
    }

    public final Map<String, List<InetAddress>> ipv4Entries() {
        return this.ipv4Entries;
    }

    public final Map<String, List<InetAddress>> ipv6Entries() {
        return this.ipv6Entries;
    }

    private static final class ParserImpl
    implements Parser {
        private static final String WINDOWS_DEFAULT_SYSTEM_ROOT = "C:\\Windows";
        private static final String WINDOWS_HOSTS_FILE_RELATIVE_PATH = "\\system32\\drivers\\etc\\hosts";
        private static final String X_PLATFORMS_HOSTS_FILE_PATH = "/etc/hosts";
        private static final Pattern WHITESPACES = Pattern.compile("[ \t]+");
        private static final InternalLogger logger = InternalLoggerFactory.getInstance(Parser.class);
        static final ParserImpl INSTANCE = new ParserImpl();

        private ParserImpl() {
        }

        @Override
        public final HostsFileEntriesProvider parse() throws IOException {
            return this.parse(ParserImpl.locateHostsFile(), Charset.defaultCharset());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final HostsFileEntriesProvider parse(Charset ... charsets) throws IOException {
            void var1_1;
            return this.parse(ParserImpl.locateHostsFile(), (Charset[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final HostsFileEntriesProvider parse(File file, Charset ... charsets) throws IOException {
            ObjectUtil.checkNotNull((Object)file, (String)"file");
            ObjectUtil.checkNotNull((Object)charsets, (String)"charsets");
            if (charsets.length == 0) {
                charsets = new Charset[]{Charset.defaultCharset()};
            }
            if (((File)file).exists() && ((File)file).isFile()) {
                void var2_3;
                for (void charset : var2_3) {
                    BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream((File)file), (Charset)charset));
                    try {
                        HostsFileEntriesProvider entries = this.parse(reader);
                        if (entries == EMPTY) continue;
                        file = entries;
                        return file;
                    }
                    finally {
                        reader.close();
                    }
                }
            }
            return EMPTY;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final HostsFileEntriesProvider parse(Reader reader) throws IOException {
            ObjectUtil.checkNotNull((Object)reader, (String)"reader");
            BufferedReader buff = new BufferedReader(reader);
            try {
                void var3_5;
                void var2_3;
                String[] line;
                HashMap<String, ArrayList<InetAddress>> ipv4Entries = new HashMap<String, ArrayList<InetAddress>>();
                HashMap<String, ArrayList<InetAddress>> ipv6Entries = new HashMap<String, ArrayList<InetAddress>>();
                while ((line = buff.readLine()) != null) {
                    byte[] ipBytes;
                    int commentPosition = line.indexOf(35);
                    if (commentPosition != -1) {
                        line = line.substring(0, commentPosition);
                    }
                    if ((line = line.trim()).isEmpty()) continue;
                    ArrayList<String> lineParts = new ArrayList<String>();
                    line = WHITESPACES.split((CharSequence)line);
                    commentPosition = line.length;
                    for (int i = 0; i < commentPosition; ++i) {
                        String s = line[i];
                        if (s.isEmpty()) continue;
                        lineParts.add(s);
                    }
                    if (lineParts.size() < 2 || (ipBytes = NetUtil.createByteArrayFromIpAddressString((String)((String)lineParts.get(0)))) == null) continue;
                    for (int i = 1; i < lineParts.size(); ++i) {
                        List<InetAddress> addresses;
                        String hostname = (String)lineParts.get(i);
                        String hostnameLower = hostname.toLowerCase(Locale.ENGLISH);
                        InetAddress address = InetAddress.getByAddress(hostname, ipBytes);
                        if (address instanceof Inet4Address) {
                            addresses = (ArrayList<InetAddress>)ipv4Entries.get(hostnameLower);
                            if (addresses == null) {
                                addresses = new ArrayList<InetAddress>();
                                ipv4Entries.put(hostnameLower, (ArrayList<InetAddress>)addresses);
                            }
                        } else {
                            addresses = (List)ipv6Entries.get(hostnameLower);
                            if (addresses == null) {
                                addresses = new ArrayList();
                                ipv6Entries.put(hostnameLower, (ArrayList<InetAddress>)addresses);
                            }
                        }
                        addresses.add(address);
                    }
                }
                HostsFileEntriesProvider hostsFileEntriesProvider = ipv4Entries.isEmpty() && ipv6Entries.isEmpty() ? EMPTY : new HostsFileEntriesProvider((Map<String, List<InetAddress>>)var2_3, (Map<String, List<InetAddress>>)var3_5);
                return hostsFileEntriesProvider;
            }
            finally {
                try {
                    buff.close();
                }
                catch (IOException e) {
                    logger.warn("Failed to close a reader", (Throwable)e);
                }
            }
        }

        @Override
        public final HostsFileEntriesProvider parseSilently() {
            return this.parseSilently(ParserImpl.locateHostsFile(), Charset.defaultCharset());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final HostsFileEntriesProvider parseSilently(Charset ... charsets) {
            void var1_1;
            return this.parseSilently(ParserImpl.locateHostsFile(), (Charset[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final HostsFileEntriesProvider parseSilently(File file, Charset ... charsets) {
            try {
                return this.parse(file, charsets);
            }
            catch (IOException e) {
                if (logger.isWarnEnabled()) {
                    void var2_3;
                    void var1_1;
                    logger.warn("Failed to load and parse hosts file at " + var1_1.getPath(), (Throwable)var2_3);
                }
                return EMPTY;
            }
        }

        /*
         * WARNING - void declaration
         */
        private static File locateHostsFile() {
            void var0;
            File hostsFile;
            if (PlatformDependent.isWindows()) {
                hostsFile = new File(System.getenv("SystemRoot") + WINDOWS_HOSTS_FILE_RELATIVE_PATH);
                if (!hostsFile.exists()) {
                    hostsFile = new File("C:\\Windows\\system32\\drivers\\etc\\hosts");
                }
            } else {
                hostsFile = new File(X_PLATFORMS_HOSTS_FILE_PATH);
            }
            return var0;
        }
    }

    public static interface Parser {
        public HostsFileEntriesProvider parse() throws IOException;

        public HostsFileEntriesProvider parse(Charset ... var1) throws IOException;

        public HostsFileEntriesProvider parse(File var1, Charset ... var2) throws IOException;

        public HostsFileEntriesProvider parse(Reader var1) throws IOException;

        public HostsFileEntriesProvider parseSilently();

        public HostsFileEntriesProvider parseSilently(Charset ... var1);

        public HostsFileEntriesProvider parseSilently(File var1, Charset ... var2);
    }
}

