/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver;

import io.netty.resolver.HostsFileEntriesProvider;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public final class DefaultHostsFileEntriesResolver
implements HostsFileEntriesResolver {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(DefaultHostsFileEntriesResolver.class);
    private static final long DEFAULT_REFRESH_INTERVAL = SystemPropertyUtil.getLong((String)"io.netty.hostsFileRefreshInterval", (long)0L);
    private final long refreshInterval;
    private final AtomicLong lastRefresh = new AtomicLong(System.nanoTime());
    private final HostsFileEntriesProvider.Parser hostsFileParser;
    private volatile Map<String, List<InetAddress>> inet4Entries;
    private volatile Map<String, List<InetAddress>> inet6Entries;

    public DefaultHostsFileEntriesResolver() {
        this(HostsFileEntriesProvider.parser(), DEFAULT_REFRESH_INTERVAL);
    }

    /*
     * WARNING - void declaration
     */
    DefaultHostsFileEntriesResolver(HostsFileEntriesProvider.Parser hostsFileParser, long refreshInterval) {
        void var1_1;
        void var2_2;
        this.hostsFileParser = hostsFileParser;
        this.refreshInterval = ObjectUtil.checkPositiveOrZero((long)var2_2, (String)"refreshInterval");
        HostsFileEntriesProvider entries = DefaultHostsFileEntriesResolver.parseEntries(hostsFileParser);
        this.inet4Entries = entries.ipv4Entries();
        this.inet6Entries = var1_1.ipv6Entries();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final InetAddress address(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        void var2_2;
        void var1_1;
        return DefaultHostsFileEntriesResolver.firstAddress(this.addresses((String)var1_1, (ResolvedAddressTypes)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final List<InetAddress> addresses(String inetHost, ResolvedAddressTypes resolvedAddressTypes) {
        void var2_2;
        String normalized = this.normalize(inetHost);
        this.ensureHostsFileEntriesAreFresh();
        switch (resolvedAddressTypes) {
            case IPV4_ONLY: {
                return this.inet4Entries.get(normalized);
            }
            case IPV6_ONLY: {
                return this.inet6Entries.get(normalized);
            }
            case IPV4_PREFERRED: {
                List<InetAddress> allInet4Addresses = this.inet4Entries.get(normalized);
                if (allInet4Addresses != null) {
                    return DefaultHostsFileEntriesResolver.allAddresses(allInet4Addresses, this.inet6Entries.get(normalized));
                }
                return this.inet6Entries.get(normalized);
            }
            case IPV6_PREFERRED: {
                void var1_1;
                List<InetAddress> allInet6Addresses = this.inet6Entries.get(normalized);
                if (allInet6Addresses != null) {
                    return DefaultHostsFileEntriesResolver.allAddresses((List<InetAddress>)var2_2, this.inet4Entries.get(normalized));
                }
                return this.inet4Entries.get(var1_1);
            }
        }
        throw new IllegalArgumentException("Unknown ResolvedAddressTypes " + var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void ensureHostsFileEntriesAreFresh() {
        void var3_3;
        long interval = this.refreshInterval;
        if (interval == 0L) {
            return;
        }
        long last = this.lastRefresh.get();
        long currentTime = System.nanoTime();
        if (currentTime - last > interval && this.lastRefresh.compareAndSet((long)var3_3, currentTime)) {
            void var1_2;
            HostsFileEntriesProvider entries = DefaultHostsFileEntriesResolver.parseEntries(this.hostsFileParser);
            this.inet4Entries = entries.ipv4Entries();
            this.inet6Entries = var1_2.ipv6Entries();
        }
    }

    final String normalize(String inetHost) {
        return inetHost.toLowerCase(Locale.ENGLISH);
    }

    /*
     * WARNING - void declaration
     */
    private static List<InetAddress> allAddresses(List<InetAddress> a, List<InetAddress> b) {
        void var2_2;
        List<InetAddress> list;
        ArrayList<InetAddress> result = new ArrayList<InetAddress>(a.size() + (b == null ? 0 : b.size()));
        result.addAll(list);
        if (b != null) {
            void var1_1;
            result.addAll((Collection<InetAddress>)var1_1);
        }
        return var2_2;
    }

    private static InetAddress firstAddress(List<InetAddress> addresses) {
        if (addresses != null && !addresses.isEmpty()) {
            List<InetAddress> list;
            return list.get(0);
        }
        return null;
    }

    private static HostsFileEntriesProvider parseEntries(HostsFileEntriesProvider.Parser parser) {
        HostsFileEntriesProvider.Parser parser2;
        if (PlatformDependent.isWindows()) {
            return parser.parseSilently(Charset.defaultCharset(), CharsetUtil.UTF_16, CharsetUtil.UTF_8);
        }
        return parser2.parseSilently();
    }

    static {
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.hostsFileRefreshInterval: {}", (Object)DEFAULT_REFRESH_INTERVAL);
        }
    }
}

